/*
 * Decompiled with CFR 0.152.
 */
package ec.tstoolkit.arima.special;

import ec.tstoolkit.information.InformationSet;
import ec.tstoolkit.information.InformationSetSerializable;
import ec.tstoolkit.modelling.arima.tramo.EasterSpec;
import ec.tstoolkit.timeseries.TsException;
import java.util.Map;

public class EasterSpec
implements Cloneable,
InformationSetSerializable {
    public static final String DURATION = "duration";
    public static final String TYPE = "type";
    public static final String JULIAN = "julian";
    private int duration_ = 6;
    private EasterSpec.Type type_ = EasterSpec.Type.Unused;
    private boolean julian = DEF_JULIAN;
    public static final int DEF_IDUR = 6;
    public static boolean DEF_JULIAN = false;

    public static void fillDictionary(String prefix, Map<String, Class> dic) {
        dic.put(InformationSet.item(prefix, TYPE), String.class);
        dic.put(InformationSet.item(prefix, DURATION), Integer.class);
        dic.put(InformationSet.item(prefix, JULIAN), Boolean.class);
    }

    public void reset() {
        this.duration_ = 6;
        this.type_ = EasterSpec.Type.Unused;
        this.julian = DEF_JULIAN;
    }

    public int getDuration() {
        return this.duration_;
    }

    public void setDuration(int value) {
        if (value <= 0 || value > 15) {
            throw new TsException("Duration", "Should be inside [1, 15]");
        }
        this.duration_ = value;
    }

    public EasterSpec.Type getOption() {
        return this.type_;
    }

    public boolean isUsed() {
        return this.type_ != EasterSpec.Type.Unused;
    }

    public void setOption(EasterSpec.Type type) {
        this.type_ = type;
    }

    public boolean isJulian() {
        return this.julian;
    }

    public void setJulian(boolean julian) {
        this.julian = julian;
    }

    public boolean isDefault() {
        return this.type_ == EasterSpec.Type.Unused;
    }

    public EasterSpec clone() {
        try {
            EasterSpec spec = (EasterSpec)super.clone();
            return spec;
        }
        catch (CloneNotSupportedException ex) {
            throw new AssertionError();
        }
    }

    public boolean equals(Object obj) {
        return this == obj || obj instanceof EasterSpec && this.equals((EasterSpec)obj);
    }

    private boolean equals(EasterSpec other) {
        return this.duration_ == other.duration_ && this.type_ == other.type_ && this.julian == other.julian;
    }

    public int hashCode() {
        int hash = 7;
        hash = 67 * hash + this.duration_;
        hash = 67 * hash + this.type_.hashCode();
        return hash;
    }

    @Override
    public InformationSet write(boolean verbose) {
        if (!verbose && this.isDefault()) {
            return null;
        }
        InformationSet info = new InformationSet();
        if (verbose || this.duration_ != 6) {
            info.add(DURATION, Integer.valueOf(this.duration_));
        }
        if (verbose || this.type_ != EasterSpec.Type.Unused) {
            info.add(TYPE, this.type_.name());
        }
        if (verbose || this.julian != DEF_JULIAN) {
            info.add(JULIAN, Boolean.valueOf(this.julian));
        }
        return info;
    }

    @Override
    public boolean read(InformationSet info) {
        try {
            Boolean jul;
            String type;
            this.reset();
            Integer d = info.get(DURATION, Integer.class);
            if (d != null) {
                this.duration_ = d;
            }
            if ((type = info.get(TYPE, String.class)) != null) {
                this.type_ = EasterSpec.Type.valueOf(type);
            }
            if ((jul = info.get(JULIAN, Boolean.class)) != null) {
                this.julian = jul;
            }
            return true;
        }
        catch (Exception err) {
            return false;
        }
    }
}

