/*
 * Decompiled with CFR 0.152.
 */
package ec.satoolkit.x11;

import ec.tstoolkit.data.DataBlock;
import ec.tstoolkit.timeseries.simplets.PeriodIterator;
import ec.tstoolkit.timeseries.simplets.TsData;
import ec.tstoolkit.timeseries.simplets.TsDomain;

public class SeriesEvolution {
    public static double[] calcAbsMeanVariations(TsData s, TsDomain domain, boolean mul, boolean[] valid) {
        int iend;
        int istart;
        int freq = s.getFrequency().intValue();
        double[] mean = new double[freq];
        double[] x = s.internalStorage();
        if (domain != null) {
            istart = s.getDomain().search(domain.getStart());
            iend = s.getDomain().search(domain.getLast()) + 1;
        } else {
            istart = 0;
            iend = s.getLength();
        }
        for (int lag = 1; lag <= freq; ++lag) {
            double sum = 0.0;
            int n = 0;
            for (int i = istart + lag; i < iend; ++i) {
                if (valid != null && !valid[i - lag]) continue;
                double x0 = x[i - lag];
                double x1 = x[i];
                double d = x1 - x0;
                if (mul) {
                    d *= 100.0 / x0;
                }
                sum += Math.abs(d);
                ++n;
            }
            mean[lag - 1] = sum / (double)n;
        }
        return mean;
    }

    public static double calcAbsMeanVariations(TsData s, TsDomain domain, int lag, boolean mul, boolean[] valid) {
        int iend;
        int istart;
        double[] x = s.internalStorage();
        if (domain != null) {
            istart = s.getDomain().search(domain.getStart());
            iend = s.getDomain().search(domain.getLast()) + 1;
        } else {
            istart = 0;
            iend = s.getLength();
        }
        double sum = 0.0;
        int n = 0;
        for (int i = istart + lag; i < iend; ++i) {
            if (valid != null && !valid[i - lag]) continue;
            double x1 = x[i];
            double x0 = x[i - lag];
            double d = Math.abs(x1 - x0);
            if (mul) {
                d *= 100.0 / x0;
            }
            sum += d;
            ++n;
        }
        return sum / (double)n;
    }

    public static double[] calcAbsMeanVariationsByPeriod(TsData s, TsDomain domain, boolean mul) {
        int freq = s.getFrequency().intValue();
        double[] pmean = new double[freq];
        PeriodIterator bi = domain == null ? new PeriodIterator(s) : new PeriodIterator(s, domain);
        int tell = 0;
        while (bi.hasMoreElements()) {
            double cc = 0.0;
            DataBlock bd = bi.nextElement().data;
            int nc = bd.getLength();
            int n = 0;
            for (int i = 1; i < nc; ++i) {
                double x0 = bd.get(i - 1);
                double x1 = bd.get(i);
                if (mul && !(x0 > 0.0)) continue;
                double d = x1 - x0;
                if (mul) {
                    d *= 100.0 / x0;
                }
                cc += Math.abs(d);
                ++n;
            }
            pmean[tell++] = cc / (double)n;
        }
        return pmean;
    }

    public static double[] calcMeanVariations(TsData s, TsDomain domain, boolean mul, boolean[] valid) {
        int iend;
        int istart;
        int freq = s.getFrequency().intValue();
        double[] mean = new double[freq];
        double[] x = s.internalStorage();
        if (domain != null) {
            istart = s.getDomain().search(domain.getStart());
            iend = s.getDomain().search(domain.getLast()) + 1;
        } else {
            istart = 0;
            iend = s.getLength();
        }
        for (int lag = 1; lag <= freq; ++lag) {
            double sum = 0.0;
            int n = 0;
            for (int i = istart + lag; i < iend; ++i) {
                if (valid != null && !valid[i - lag]) continue;
                double x1 = x[i];
                double x0 = x[i - lag];
                double d = x1 - x0;
                if (mul) {
                    d *= 100.0 / x0;
                }
                sum += d;
                ++n;
            }
            mean[lag - 1] = sum / (double)n;
        }
        return mean;
    }

    public static double[][] calcVariations(TsData s, TsDomain domain, boolean mul, boolean[] valid) {
        int iend;
        int istart;
        int freq = s.getFrequency().intValue();
        double[] mean = new double[freq];
        double[] std = new double[freq];
        double[] x = s.internalStorage();
        if (domain != null) {
            istart = s.getDomain().search(domain.getStart());
            iend = s.getDomain().search(domain.getLast()) + 1;
        } else {
            istart = 0;
            iend = s.getLength();
        }
        for (int l = 1; l <= freq; ++l) {
            double sum = 0.0;
            double sum2 = 0.0;
            for (int i = istart + l; i < iend; ++i) {
                if (valid != null && !valid[i - l]) continue;
                double x1 = x[i];
                double x0 = x[i - l];
                double d = x1 - x0;
                if (mul) {
                    d *= 100.0 / x0;
                }
                sum += d;
                sum2 += d * d;
            }
            int n = iend - istart - l;
            mean[l - 1] = sum / (double)n;
            std[l - 1] = Math.sqrt((sum2 - sum * sum / (double)n) / (double)n);
        }
        return new double[][]{mean, std};
    }

    public static double Adr(TsData ts, boolean mul) {
        if (ts == null) {
            return 0.0;
        }
        TsData del = mul ? ts.pctVariation(1) : ts.delta(1);
        int n = del.getLength();
        double[] x = del.internalStorage();
        int c = 0;
        int s = 0;
        for (int i = 0; i < n; ++i) {
            int cur = SeriesEvolution.sign(x[i]);
            if (s == cur || cur == 0) continue;
            ++c;
            s = cur;
        }
        double N = n;
        return N / (double)c;
    }

    private static int sign(double val) {
        if (val < 0.0) {
            return -1;
        }
        if (val > 0.0) {
            return 1;
        }
        return 0;
    }
}

