/*
 * Decompiled with CFR 0.152.
 */
package cc.mallet.util;

import java.io.File;
import java.net.URI;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class UriUtils {
    static Pattern schemeRegex = Pattern.compile("\\p{Alpha}[\\p{Alnum}\\+\\.-]*:");

    private static String defaultFileSchema(String string) {
        Matcher matcher = schemeRegex.matcher(string);
        if (!matcher.lookingAt()) {
            string = "file:" + string;
        }
        return string;
    }

    public static URI objectToUri(Object obj) {
        try {
            if (obj instanceof String) {
                return new URI(UriUtils.defaultFileSchema((String)obj));
            }
            if (obj instanceof File) {
                return new URI("file:" + ((File)obj).getAbsolutePath());
            }
            return new URI(obj.toString());
        }
        catch (Exception e) {
            throw new IllegalArgumentException("UriUtils.objectToUri: " + e.toString());
        }
    }

    public static String uriStringToFilename(String uri) {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < uri.length(); ++i) {
            char c = uri.charAt(i);
            if (c == File.pathSeparatorChar) {
                sb.append('+');
                continue;
            }
            if (c == '+') {
                sb.append("++");
                continue;
            }
            sb.append(c);
        }
        return sb.toString();
    }

    public static String filenameToUriString(String filename) {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < filename.length(); ++i) {
            char c = filename.charAt(i);
            if (c == '+') {
                if (i < filename.length() && filename.charAt(i + 1) == '+') {
                    sb.append('+');
                    ++i;
                    continue;
                }
                sb.append(File.pathSeparator);
                continue;
            }
            sb.append(c);
        }
        return sb.toString();
    }
}

