## ----include = FALSE----------------------------------------------------------
knitr::opts_chunk$set(
  collapse = TRUE,
  comment = "#>"
)
library(ggplot2)
library(emphatic)

## ----setup--------------------------------------------------------------------
library(ggplot2)
library(emphatic)

## -----------------------------------------------------------------------------
test_df <- head(mtcars, 10)

## -----------------------------------------------------------------------------
test_df |>
  hl('skyblue')

## -----------------------------------------------------------------------------
test_df |>
  hl('skyblue', rows = NULL)

## -----------------------------------------------------------------------------
test_df |>
  hl('skyblue', rows = all())

## -----------------------------------------------------------------------------
test_df |>
  hl('skyblue', rows = 2:5)

## -----------------------------------------------------------------------------
test_df |>
  hl('skyblue', rows = c('Mazda RX4', 'Datsun 710'))

## -----------------------------------------------------------------------------
test_df |>
  hl('skyblue', rows = Valiant)

## -----------------------------------------------------------------------------
test_df |>
  hl('skyblue', rows = mpg > 22)

## -----------------------------------------------------------------------------
test_df |>
  hl('skyblue', rows = row_number() > n()/2)

## -----------------------------------------------------------------------------
test_df |>
  hl('skyblue', rows = contains('hornet'))

## -----------------------------------------------------------------------------
test_df |>
  hl('skyblue', rows = starts_with('m'))

## -----------------------------------------------------------------------------
test_df |>
  hl('skyblue', rows = any_of(c('Valiant', 'Herbie', 'Datsun 710')))

