*-------------------------------------------------------------------------*
 |                                                                         
 |                    SAS SETUP FILE FOR ICPSR 03306
 |                     MULTIPLE CAUSE OF DEATH, 1998
 |                      (DATASET 0005:  GUAM, 1998)
 |
 |
 | SAS setup sections are provided for the ASCII version of this data
 | collection.  These sections are listed below:
 |
 | PROC FORMAT:  creates user-defined formats for the variables. Formats
 | replace original value codes with value code descriptions. Only
 | variables with user-defined formats are included in this section.
 |
 | DATA:  begins a SAS data step and names an output SAS data set.
 |
 | INFILE:  identifies the input file to be read with the input statement.
 | Users must replace the "data-filename" with a filename specifying the
 | directory on the user's computer system in which the downloaded and
 | unzipped data file is physically located (e.g.,
 | "c:\temp\03306-0005-data.txt").
 |
 | INPUT:  assigns the name, type, decimal specification (if any), and
 | specifies the beginning and ending column locations for each variable
 | in the data file.
 |
 | LABEL:  assigns descriptive labels to all variables. Variable labels
 | and variable names may be identical for some variables.
 |
 | MISSING VALUE RECODES:  sets user-defined numeric missing values to
 | missing as interpreted by the SAS system. Only variables with
 | user-defined missing values are included in this section.
 |
 | FORMAT:  associates the formats created by the PROC FORMAT step with
 | the variables named in the INPUT statement.
 |
 | NOTE:  Users should modify this setup file to suit their specific needs.
 | Sections for PROC FORMAT, FORMAT, and MISSING VALUE RECODES have been
 | commented out (i.e., '/*'). To include these sections in the final SAS
 | setup, users should remove the SAS comment indicators from the desired
 | section(s).
 |
 *------------------------------------------------------------------------;

* SAS PROC FORMAT;

/*
PROC FORMAT;
  VALUE rectype   1='(1) RESIDENTS' 2='(2) NONRESIDENTS' ;
  VALUE resistat  1='(1) RESIDENTS' 2='(2) INTRASTATE NONRESIDENTS'
                  3='(3) INTERSTATE NONRESIDENTS' 4='(4) FOREIGN RESIDENTS' ;
  VALUE stateocc  1='(1) Alabama' 2='(2) Alaska' 3='(3) Arizona' 4='(4) Arkansas'
                  5='(5) California' 6='(6) Colorado' 7='(7) Connecticut' 8='(8) Delaware'
                  9='(9) District of Columbia' 10='(10) Florida' 11='(11) Georgia'
                  12='(12) Hawaii' 13='(13) Idaho' 14='(14) Illinois' 15='(15) Indiana' 16='(16) Iowa'
                  17='(17) Kansas' 18='(18) Kentucky' 19='(19) Louisiana' 20='(20) Maine'
                  21='(21) Maryland' 22='(22) Massachusetts' 23='(23) Michigan'
                  24='(24) Minnesota' 25='(25) Mississippi' 26='(26) Missouri' 27='(27) Montana'
                  28='(28) Nebraska' 29='(29) Nevada' 30='(30) New Hampshire'
                  31='(31) New Jersey' 32='(32) New Mexico' 33='(33) New York'
                  34='(34) North Carolina' 35='(35) North Dakota' 36='(36) Ohio'
                  37='(37) Oklahoma' 38='(38) Oregon' 39='(39) Pennsylvania'
                  40='(40) Rhode Island' 41='(41) South Carolina' 42='(42) South Dakota'
                  43='(43) Tennessee' 44='(44) Texas' 45='(45) Utah' 46='(46) Vermont'
                  47='(47) Virginia' 48='(48) Washington' 49='(49) West Virginia'
                  50='(50) Wisconsin' 51='(51) Wyoming' 52='(52) Puerto Rico'
                  53='(53) Virgin Islands' 54='(54) Guam' 61='(61) American Samoa'
                  62='(62) Northern Marianas' ;
  VALUE contyocc  999='(999) County of less than 100,000 population' ;
  VALUE region    0='(0) Not applicable' 1='(1) Northeast' 2='(2) Midwest' 3='(3) South'
                  4='(4) West' ;
  VALUE division  0='(0) Not applicable' 1='(1) New England' 2='(2) Middle Atlantic'
                  3='(3) East North Central' 4='(4) West North Central'
                  5='(5) South Atlantic' 6='(6) Eath South Central'
                  7='(7) West South Central' 8='(8) Mountain' 9='(9) Pacific' ;
  VALUE statesub  0='(0) Not applicable' ;
  VALUE exp_occ   1='(1) Alabama' 2='(2) Alaska' 3='(3) Arizona' 4='(4) Arkansas'
                  5='(5) California' 6='(6) Colorado' 7='(7) Connecticut' 8='(8) Delaware'
                  9='(9) District of Columbia' 10='(10) Florida' 11='(11) Georgia'
                  12='(12) Hawaii' 13='(13) Idaho' 14='(14) Illinois' 15='(15) Indiana' 16='(16) Iowa'
                  17='(17) Kansas' 18='(18) Kentucky' 19='(19) Louisiana' 20='(20) Maine'
                  21='(21) Maryland' 22='(22) Massachusetts' 23='(23) Michigan'
                  24='(24) Minnesota' 25='(25) Mississippi' 26='(26) Missouri' 27='(27) Montana'
                  28='(28) Nebraska' 29='(29) Nevada' 30='(30) New Hampshire'
                  31='(31) New Jersey' 32='(32) New Mexico' 33='(33) New York'
                  34='(34) New York City' 35='(35) North Carolina' 36='(36) North Dakota'
                  37='(37) Ohio' 38='(38) Oklahoma' 39='(39) Oregon' 40='(40) Pennsylvania'
                  41='(41) Rhode Island' 42='(42) South Carolina' 43='(43) South Dakota'
                  44='(44) Tennessee' 45='(45) Texas' 46='(46) Utah' 47='(47) Vermont'
                  48='(48) Virginia' 49='(49) Washington' 50='(50) West Virginia'
                  51='(51) Wisconsin' 52='(52) Wyoming' 53='(53) Puerto Rico'
                  54='(54) Virgin Islands' 55='(55) Guam' 62='(62) American Samoa'
                  63='(63) Northern Marianas' ;
  VALUE residst   1='(1) Alabama' 2='(2) Alaska' 3='(3) Arizona' 4='(4) Arkansas'
                  5='(5) California' 6='(6) Colorado' 7='(7) Connecticut' 8='(8) Delaware'
                  9='(9) District of Columbia' 10='(10) Florida' 11='(11) Georgia'
                  12='(12) Hawaii' 13='(13) Idaho' 14='(14) Illinois' 15='(15) Indiana' 16='(16) Iowa'
                  17='(17) Kansas' 18='(18) Kentucky' 19='(19) Louisiana' 20='(20) Maine'
                  21='(21) Maryland' 22='(22) Massachusetts' 23='(23) Michigan'
                  24='(24) Minnesota' 25='(25) Mississippi' 26='(26) Missouri' 27='(27) Montana'
                  28='(28) Nebraska' 29='(29) Nevada' 30='(30) New Hampshire'
                  31='(31) New Jersey' 32='(32) New Mexico' 33='(33) New York'
                  34='(34) North Carolina' 35='(35) North Dakota' 36='(36) Ohio'
                  37='(37) Oklahoma' 38='(38) Oregon' 39='(39) Pennsylvania'
                  40='(40) Rhode Island' 41='(41) South Carolina' 42='(42) South Dakota'
                  43='(43) Tennessee' 44='(44) Texas' 45='(45) Utah' 46='(46) Vermont'
                  47='(47) Virginia' 48='(48) Washington' 49='(49) West Virginia'
                  50='(50) Wisconsin' 51='(51) Wyoming' 52='(52) Puerto Rico'
                  53='(53) Virgin Islands' 54='(54) Guam' 55='(55) Canada' 56='(56) Cuba'
                  57='(57) Mexico' 59='(59) Remainder of the world' 61='(61) American Samoa'
                  62='(62) Northern Marianas' ;
  VALUE $cntyrsf  '999'='(999) county less than 100,000 population'
                  'ZZZ'='(ZZZ) foreign residents' ;
  VALUE $cityrsf  '999'='(999) bal of county;or city of less 100,000 population'
                  'ZZZ'='(ZZZ) foreign residents' ;
  VALUE $popsize  '0'='(0) Place of 1,000,000 or more'
                  '1'='(1) Place of 500,000 to 1,000,000'
                  '2'='(2) Place of 250,000 to 500,000'
                  '3'='(3) Place of 100,000 to 250,000'
                  '9'='(9) AII other areas in the U.S.' 'Z'='(Z) Foreign residents' ;
  VALUE $metro    '1'='(1) Metropolitan county' '2'='(2) NonmetropoIitan county'
                  'Z'='(Z) Foreign residents' ;
  VALUE regnres   0='(0) Not applicable' 1='(1) Northeast' 2='(2) Midwest' 3='(3) South'
                  4='(4) West' ;
  VALUE divisres  0='(0) Not applicable' 1='(1) New England' 2='(2) Middle Atlantic'
                  3='(3) East North Central' 4='(4) West North Central'
                  5='(5) South Atlantic' 6='(6) Eath South Central'
                  7='(7) West South Central' 8='(8) Mountain' 9='(9) Pacific' ;
  VALUE stsub     0='(0) Not applicable' ;
  VALUE exp_res   1='(1) Alabama' 2='(2) Alaska' 3='(3) Arizona' 4='(4) Arkansas'
                  5='(5) California' 6='(6) Colorado' 7='(7) Connecticut' 8='(8) Delaware'
                  9='(9) District of Columbia' 10='(10) Florida' 11='(11) Georgia'
                  12='(12) Hawaii' 13='(13) Idaho' 14='(14) Illinois' 15='(15) Indiana' 16='(16) Iowa'
                  17='(17) Kansas' 18='(18) Kentucky' 19='(19) Louisiana' 20='(20) Maine'
                  21='(21) Maryland' 22='(22) Massachusetts' 23='(23) Michigan'
                  24='(24) Minnesota' 25='(25) Mississippi' 26='(26) Missouri' 27='(27) Montana'
                  28='(28) Nebraska' 29='(29) Nevada' 30='(30) New Hampshire'
                  31='(31) New Jersey' 32='(32) New Mexico' 33='(33) New York'
                  34='(34) New York City' 35='(35) North Carolina' 36='(36) North Dakota'
                  37='(37) Ohio' 38='(38) Oklahoma' 39='(39) Oregon' 40='(40) Pennsylvania'
                  41='(41) Rhode Island' 42='(42) South Carolina' 43='(43) South Dakota'
                  44='(44) Tennessee' 45='(45) Texas' 46='(46) Utah' 47='(47) Vermont'
                  48='(48) Virginia' 49='(49) Washington' 50='(50) West Virginia'
                  51='(51) Wisconsin' 52='(52) Wyoming' 53='(53) Puerto Rico'
                  54='(54) Virgin Islands' 55='(55) Guam' 56='(56) Canada' 57='(57) Cuba'
                  58='(58) Mexico' 60='(60) Remainder of the world' 62='(62) American Samoa' ;
  VALUE $pmsa_rf  '000'='(000) Non metropolitan counties'
                  '999'='(999) Area of less than 100,000 population'
                  'ZZZ'='(ZZZ) Foreign residents' ;
  VALUE popcntyo  0='(0) County of 1,000,000 or more'
                  1='(1) County of 500,000 to 1,000,000'
                  2='(2) County of 250,000 to 500,000'
                  3='(3) County of 100,000 to 250,000'
                  9='(9) County of less than 100,000' ;
  VALUE $popcntf  '0'='(0) County of 1,000,000 or more'
                  '1'='(1) County of 500,000 to 1,000,000'
                  '2'='(2) County of 250,000 to 500,000'
                  '3'='(3) County of 100,000 to 250,000'
                  '9'='(9) County of less than 100,000' 'Z'='(Z) Foreign residents' ;
  VALUE $pmsasif  '1'='(1) Area of 250,000 or more'
                  '2'='(2) Area of 100,000 to 250,000'
                  '9'='(9) Area of less than 100,000 or nonmetropolitan area'
                  'Z'='(Z) Foreign residents' ;
  VALUE educatn   0='(0) No formal education' 9='(9) 1 year of high school'
                  10='(10) 2 years of high school' 11='(11) 3 years of high school'
                  12='(12) 4 years of high school' 13='(13) 1 year of college'
                  14='(14) 2 years of college' 15='(15) 3 years of college'
                  16='(16) 4 years of college' 17='(17) 5 or more years of college'
                  99='(99) Not stated' ;
  VALUE educ_r    1='(1) 0-8 years' 2='(2) 9-11 years' 3='(3) 12 years' 4='(4) 13-15 years'
                  5='(5) 16 years or more' 6='(6) Not stated' ;
  VALUE deathmo   1='(1) January' 2='(2) February' 3='(3) March' 4='(4) April' 5='(5) May'
                  6='(6) June' 7='(7) July' 8='(8) August' 9='(9) September' 10='(10) October'
                  11='(11) November' 12='(12) December' ;
  VALUE sex       1='(1) Male' 2='(2) Female' ;
  VALUE race_det  0='(0) Other races' 1='(1) White' 2='(2) Black'
                  3='(3) American Indian (includes Aleuts and Eskimos)'
                  4='(4) Chinese' 5='(5) Japanese'
                  6='(6) Hawaiian (includes Part Hawaiian)' 7='(7) Filipino'
                  8='(8) Additional Asian or Pacific Islander' 18='(18) Asian Indian'
                  28='(28) Korean' 38='(38) Samoan' 48='(48) Vietnamese' 58='(58) Guamanian'
                  68='(68) Othr Asian, Pacific Isl in areas reporting codes 18 to 58'
                  78='(78) Combined othr Asian,Pacific Isl,includes codes 18 to 68' ;
  VALUE race_r3f  1='(1) White' 2='(2) Races other than White or Black' 3='(3) Black' ;
  VALUE race_r2f  1='(1) White' 2='(2) All other races' ;
  VALUE ageunit   0='(0) Years less than 100' 1='(1) Years 100 or more' 2='(2) Months'
                  3='(3) Weeks' 4='(4) Days' 5='(5) Hours' 6='(6) Minutes' 9='(9) Age not stated' ;
  VALUE agerec5f  1='(1) Under 1 hour (includes not stated hours and minutes)'
                  2='(2) 1-23 hours' 3='(3) 1 day (includes not stated days)'
                  4='(4) 2 days' 5='(5) 3 days' 6='(6) 4 days' 7='(7) 5 days' 8='(8) 6 days'
                  9='(9) 7-13 days (includes not stated weeks)' 10='(10) 14-20 days'
                  11='(11) 21-27 days' 12='(12) 1 month (includes not stated months)'
                  13='(13) 2 months' 14='(14) 3 months' 15='(15) 4 months' 16='(16) 5 months'
                  17='(17) 6 months' 18='(18) 7 months' 19='(19) 8 months' 20='(20) 9 months'
                  21='(21) 10 months' 22='(22) 11 months' 23='(23) 1 year' 24='(24) 2 years'
                  25='(25) 3 years' 26='(26) 4 years' 27='(27) 5-9 years' 28='(28) 10-14 years'
                  29='(29) 15-19 years' 30='(30) 20-24 years' 31='(31) 25-29 years'
                  32='(32) 30-34 years' 33='(33) 35-39 years' 34='(34) 40-44 years'
                  35='(35) 45-49 years' 36='(36) 50-54 years' 37='(37) 55-59 years'
                  38='(38) 60-64 years' 39='(39) 65-69 years' 40='(40) 70-74 years'
                  41='(41) 75-79 years' 42='(42) 80-84 years' 43='(43) 85-89 years'
                  44='(44) 90-94 years' 45='(45) 95-99 years' 46='(46) 100-104 years'
                  47='(47) 105-109 years' 48='(48) 110- 114 years' 49='(49) 115- 119 years'
                  50='(50) 120-124 years' 51='(51) 125 years and over'
                  52='(52) Age not stated' ;
  VALUE agerec2f  1='(1) Under 1 mo (incl not stated wks, days, hours, and mins)'
                  2='(2) 1 to 11 mos (includes not stated months)' 3='(3) 1 years'
                  4='(4) 2 years' 5='(5) 3 years' 6='(6) 4 years' 7='(7) 5-9 years'
                  8='(8) 10-14 years' 9='(9) 15-19 years' 10='(10) 20-24 years'
                  11='(11) 25-29 years' 12='(12) 30-34 years' 13='(13) 35-39 years'
                  14='(14) 40-44 years' 15='(15) 45-49 years' 16='(16) 50-54 years'
                  17='(17) 55-59 years' 18='(18) 60-64 years' 19='(19) 65-69 years'
                  20='(20) 70-74 years' 21='(21) 75-79 years' 22='(22) 80-84 years'
                  23='(23) 05-89 years' 24='(24) 90-94 years' 25='(25) 95-99 years'
                  26='(26) 100 years and over' 27='(27) Age not stated' ;
  VALUE agerec1f  1='(1) Under 1 year (includes not stated infant ages)'
                  2='(2) 1-4 years' 3='(3) 5-14 years' 4='(4) 15-24 years'
                  5='(5) 25-34 years' 6='(6) 35-44 years' 7='(7) 45-54 years'
                  8='(8) 55-64 years' 9='(9) 65-74 years' 10='(10) 75-84 years'
                  11='(11) 85 years and over' 12='(12) Age not stated' ;
  VALUE $infntaf  '01'='(01) Under 1 hour (includes not stated hours and minutes)'
                  '02'='(02) 1-23 hours' '03'='(03) 1 day (includes not stated days)'
                  '04'='(04) 2 days' '05'='(05) 3 days' '06'='(06) 4 days' '07'='(07) 5 days'
                  '08'='(08) 6 days' '09'='(09) 7 days (includes not stated weeks)'
                  '10'='(10) 14-20 days' '11'='(11) 21-27 days'
                  '12'='(12) 1 month (includes not stated months)' '13'='(13) 2 months'
                  '14'='(14) 3 months' '15'='(15) 4 months' '16'='(16) 5 months'
                  '17'='(17) 6 months' '18'='(18) 7 months' '19'='(19) 8 months'
                  '20'='(20) 9 monThs' '21'='(21) 10 months' '22'='(22) 11 months'
                  ' '='( ) blank: Age 1 year and over or not stated"' ;
  VALUE placedth  1='(1) Hospital, clinic or Medical Center - Inpatient'
                  2='(2) Hospital, Clinic or Med Ctr Outpat or adm to Emergency Room'
                  3='(3) Hospital, Clinic or Medical Center - Dead on Arrival'
                  4='(4) Hospital, Clinic or Medical Center- Patient status unknown'
                  5='(5) Nursing home' 6='(6) Residence' 7='(7) Other'
                  9='(9) Place of death unknown' ;
  VALUE marstat   1='(1) Never married, single' 2='(2) Married' 3='(3) Widowed'
                  4='(4) Divorced' 8='(8) Marital Status not on certificate'
                  9='(9) Marital Status not stated' ;
  VALUE birth_st  1='(1) Alabama' 2='(2) Alaska' 3='(3) Arizona' 4='(4) Arkansas'
                  5='(5) California' 6='(6) Colorado' 7='(7) Connecticut' 8='(8) Delaware'
                  9='(9) District of Columbia' 10='(10) Florida' 11='(11) Georgia'
                  12='(12) Hawaii' 13='(13) Idaho' 14='(14) Illinois' 15='(15) Indiana' 16='(16) Iowa'
                  17='(17) Kansas' 18='(18) Kentucky' 19='(19) Louisiana' 20='(20) Maine'
                  21='(21) Maryland' 22='(22) Massachusetts' 23='(23) Michigan'
                  24='(24) Minnesota' 25='(25) Mississippi' 26='(26) Missouri' 27='(27) Montana'
                  28='(28) Nebraska' 29='(29) Nevada' 30='(30) New Hampshire'
                  31='(31) New Jersey' 32='(32) New Mexico' 33='(33) New York'
                  34='(34) North Carolina' 35='(35) North Dakota' 36='(36) Ohio'
                  37='(37) Oklahoma' 38='(38) Oregon' 39='(39) Pennsylvania'
                  40='(40) Rhode Island' 41='(41) South Carolina' 42='(42) South Dakota'
                  43='(43) Tennessee' 44='(44) Texas' 45='(45) Utah' 46='(46) Vermont'
                  47='(47) Virginia' 48='(48) Washington' 49='(49) West Virginia'
                  50='(50) Wisconsin' 51='(51) Wyoming' 52='(52) Puerto Rico'
                  53='(53) Virgin Islands' 54='(54) Guam' 55='(55) Canada' 56='(56) Cuba'
                  57='(57) Mexico' 59='(59) Remainder of the world' 61='(61) American Samoa'
                  62='(62) Northern Marianas' 99='(99) State of birth unknown' ;
  VALUE hispanic  0='(0) Non - Hispanic' 1='(1) Mexican' 2='(2) Puerto Rican' 3='(3) Cuban'
                  4='(4) Central or South American' 5='(5) Other or unknown Hispanic'
                  99='(99) Unknown' ;
  VALUE hisp_rec  1='(1) Mexican' 2='(2) Puerto Rican' 3='(3) Cuban'
                  4='(4) Central or South American' 5='(5) Other or unknown Hispanic'
                  6='(6) Non - Hispanic white' 7='(7) Non - Hispanic black'
                  8='(8) Non - Hispanic other races' 9='(9) Hispanic origin unknown' ;
  VALUE daydeath  1='(1) Sunday' 2='(2) Monday' 3='(3) Tuesday' 4='(4) Wednesday'
                  5='(5) Thursday' 6='(6) Friday' 7='(7) Saturday' 9='(9) Unknown' ;
  VALUE kindbuss  961='(961) Own home/At home'
                  970='(970) Retired; with no other industry reported'
                  990='(990) Blank, Unknownr NA' ;
  VALUE usualocc  913='(913) Retired; with no other occupation reported'
                  914='(914) Housewife/Homemaker' 915='(915) Student' 916='(916) Volunteer'
                  917='(917) Unemployed, never worked, disabled, child, infant'
                  999='(999) Blank, Unknown, NA' ;
  VALUE icd52fff  10='(10) 050-Tuberculosis, including late effects (010-018,137)'
                  20='(20) 016-Septicemia (038)'
                  30='(30) 089-Malignant neoplasms, including neoplasms of lymphatic an'
                  40='(40) 064-Malignant neoplasms of lip, oral cavity, and pharynx (14'
                  50='(50) 039-Malignant neoplasm of esophagus (150)'
                  60='(60) 037-Malignant neoplasm of stomach (151)'
                  70='(70) 035-Malignant neoplasm of colon (153)'
                  80='(80) 070-Malignant neoplasms of rectum, rectosigmoid junction, an'
                  90='(90) 064- Malignant neoplasms of liver and intrahepatic bile duct'
                  100='(100) 070-Malignant neoplasms of gallbladder and extrahepatic bile'
                  110='(110) 038-Malignant neoplasm of pancreas (157)'
                  120='(120) 036-Malignant neoplasm of larynx (161)'
                  130='(130) 058-Malignant neoplasms of trachea, bronchus, and lung (162)'
                  140='(140) 036-Malignant neoplasm of pleura (163)'
                  150='(150) 059-Malignant neoplasms of bone and articular cartilage (170'
                  160='(160) 063-Malignant neoplasms of connective and other soft tissue'
                  170='(170) 034-Malignant melanoma of skin (172)'
                  180='(180) 043-Malignant neoplasm of female breast (174)'
                  190='(190) 042-Malignant neoplasm of cervix uteri (180)'
                  200='(200) 044-Malignant neoplasm of body of uterus (182)'
                  210='(210) 061-Malignant neoplasms of ovary and other uterine adnexa (1'
                  220='(220) 038-Malignant neoplasm of prostate (185)'
                  230='(230) 036-Malignant neoplasm of testis (186)'
                  240='(240) 037-Malignant neoplasm of bladder (188)'
                  250='(250) 078-Malignant neoplasms of kidney and other and unspecified'
                  260='(260) 090-Malignant neoplasms of brain and other and unspecified p'
                  270='(270) 025-Hodgkin''s disease (201)'
                  280='(280) 059-Malignant lymphoma other than Hodgkin''s disease (200,202'
                  290='(290) 058-Multiple myeloma and immunoproliferative neoplasms (203)'
                  300='(300) 020-Leukemia (204-208)'
                  310='(310) 149-All other malignant neoplasms, including neoplasms of ly'
                  320='(320) 023-Diabetes mellitus (250)'
                  330='(330) 021-Aplastic anemia (284)'
                  340='(340) 039-Diseases of heart (390-398,402,404-429)'
                  350='(350) 034-Hypertensive heart disease (402)'
                  360='(360) 044-Hypertensive heart and renal disease (404)'
                  370='(370) 034-Ischemic heart disease (410-414)'
                  380='(380) 037-Acute myocardial infarction (410)'
                  390='(390) 046-All other ischemic heart disease (411-414)'
                  400='(400) 047-All other diseases of heart (390-398,415-429)'
                  410='(410) 052-Hypertension with or without renal disease (401,403)'
                  420='(420) 034-Cerebrovascular diseases (430-438)'
                  430='(430) 021-Atherosclerosis (440)'
                  440='(440) 033-Pneumonia and influenza (480-487)'
                  450='(450) 070-Chronic obstructive pulmonary diseases and allied condit'
                  460='(460) 072-Pneumoconioses and pneumopathy due to inhalation of othe'
                  470='(470) 039-Ulcer of stomach and duodenum (531-533)'
                  480='(480) 041-Chronic liver disease and cirrhosis (571)'
                  490='(490) 054-Nephritis, nephrotic syndrome, and nephrosis (580-589)'
                  500='(500) 041-Accidents and adverse effects (E800-E949)'
                  510='(510) 037-Motor vehicle accidents (E810-E825)'
                  520='(520) 079-Accidents mainly of industrial type (E846,E881-E882,E916'
                  530='(530) 099-Other accidents and adverse effects (E800-E807,E826-E845'
                  540='(540) 019-Suicide (E950-E959)'
                  550='(550) 043-Homicide and legal intervention (E960-E978)'
                  560='(560) 049-All other diseases and external causes (Residual)' ;
  VALUE cityfips  0='(0) Foreign residents'
                  99999='(99999) Balance of county; or city of less than 100,000 population' ;
  VALUE fipstocc  1='(1) Alabama' 2='(2) Alaska' 4='(4) Arizona' 5='(5) Arkansas'
                  6='(6) California' 8='(8) Colorado' 9='(9) Connecticut' 10='(10) Delaware'
                  11='(11) District of Columbia' 12='(12) Florida' 13='(13) Georgia'
                  15='(15) Hawaii' 16='(16) Idaho' 17='(17) Illinois' 18='(18) Indiana' 19='(19) Iowa'
                  20='(20) Kansas' 21='(21) Kentucky' 22='(22) Louisiana' 23='(23) Maine'
                  24='(24) Maryland' 25='(25) Massachusetts' 26='(26) Michigan'
                  27='(27) Minnesota' 28='(28) Mississippi' 29='(29) Missouri' 30='(30) Montana'
                  31='(31) Nebraska' 32='(32) Nevada' 33='(33) New Hampshire'
                  34='(34) New Jersey' 35='(35) New Mexico' 36='(36) New York'
                  37='(37) North Carolina' 38='(38) North Dakota' 39='(39) Ohio'
                  40='(40) Oklahoma' 41='(41) Oregon' 42='(42) Pennsylvania' 43='(43) Washington'
                  44='(44) Rhode Island' 45='(45) South Carolina' 46='(46) South Dakota'
                  47='(47) Tennessee' 48='(48) Texas' 49='(49) Utah' 50='(50) Vermont'
                  51='(51) Virginia' 54='(54) West Virginia' 55='(55) Wisconsin'
                  56='(56) Wyoming' 60='(60) American Samoa' 66='(66) Guam'
                  69='(69) Northern Marianas' 72='(72) Puerto Rico' 78='(78) Virgin Islands' ;
  VALUE fipsres   1='(1) Alabama' 2='(2) Alaska' 4='(4) Arizona' 5='(5) Arkansas'
                  6='(6) California' 8='(8) Colorado' 9='(9) Connecticut' 10='(10) Delaware'
                  11='(11) District of Columbia' 12='(12) Florida' 13='(13) Georgia'
                  15='(15) Hawaii' 16='(16) Idaho' 17='(17) Illinois' 18='(18) Indiana' 19='(19) Iowa'
                  20='(20) Kansas' 21='(21) Kentucky' 22='(22) Louisiana' 23='(23) Maine'
                  24='(24) Maryland' 25='(25) Massachusetts' 26='(26) Michigan'
                  27='(27) Minnesota' 28='(28) Mississippi' 29='(29) Missouri' 30='(30) Montana'
                  31='(31) Nebraska' 32='(32) Nevada' 33='(33) New Hampshire'
                  34='(34) New Jersey' 35='(35) New Mexico' 36='(36) New York'
                  37='(37) North Carolina' 38='(38) North Dakota' 39='(39) Ohio'
                  40='(40) Oklahoma' 41='(41) Oregon' 42='(42) Pennsylvania'
                  44='(44) Rhode Island' 45='(45) South Carolina' 46='(46) South Dakota'
                  47='(47) Tennessee' 48='(48) Texas' 49='(49) Utah' 50='(50) Vermont'
                  51='(51) Virginia' 53='(53) Washington' 54='(54) West Virginia'
                  55='(55) Wisconsin' 56='(56) Wyoming' 60='(60) American Samoa' 66='(66) Guam'
                  69='(69) Northern Marianas' 72='(72) Puerto Rico' 78='(78) Virgin Islands' ;
  VALUE fipcnres  0='(0) Foreign residents'
                  999='(999) County less than 100,000 population' ;
  VALUE msa_res   0='(0) Nonmetropolitan counties or foreign residents'
                  999='(999) County of less than 100,000 population' ;
  VALUE cmsa_res  0='(0) Not a CMSA'
                  7='(7) Boston - Worcester-Lawrence, MA-NH-ME-CT, CMSA'
                  14='(14) Chicago - Gary-Kenosha, IL-IN-WI, CMSA'
                  21='(21) Cincinnati - Hamilton, OH-KY-IN, CMSA'
                  28='(28) Cleveland - Akron, OH, CMSA'
                  31='(31) Dallas - Fort Worth, TX, CMSA'
                  34='(34) Denver - Boulder-Greeley, CO, CMSA'
                  35='(35) Detroit - Ann Arbor-Flint, MI, CMSA'
                  42='(42) Houston - Galveston-Brazoria, TX, CMSA'
                  49='(49) Los Angeles -Riverside- Orange County, CA, CMSA'
                  56='(56) Miami - Fort Lauderdale, FL, CMSA'
                  63='(63) Milwaukee - Racine, Wl, CMSA'
                  70='(70) New York -Noflhern New Jersey-Long Island, NY-NJ-CT-PA, CMSA'
                  77='(77) Philadelphia - Wilmington-Atlantic City, PA-NJ-DE-MD.CMSA'
                  79='(79) Portland - Salem, OR-WA, CMSA'
                  82='(82) Sacramento - Yolo, CA, CMSA'
                  84='(84) San Francisco -Oakland-San Jose, CA, CMSA'
                  87='(87) San Juan-Caguas-Arecibo, PR,CMSA'
                  91='(91) Seattle - Tacoma-Bremetton, WA, CMSA'
                  97='(97) Washington - Baltimore, DC-MD-VA-WV, CMSA' ;
  VALUE inj_work  1='(1) Yes' 2='(2) No' 9='(9) Unknown' ;
  VALUE $race_ff  '1'='(1) Unknown race is imputed'
                  '2'='(2) All other races, formerly code 09, is imputed'
                  ' '='( ) Race is not imputed' ;
  VALUE age_flg   1='(1) Calculated age is substituted for reported age' ;
  VALUE $placeif  '0'='(0) Home' '1'='(1) Residential Institution'
                  '2'='(2) School, other institution and public admin area'
                  '3'='(3) Sports and athletics area' '4'='(4) Street or Highway'
                  '5'='(5) Trade or service area'
                  '6'='(6) Industrial and construction area' '7'='(7) Farm'
                  '8'='(8) Other Specified Places' '9'='(9) Unspecified place'
                  ' '='( ) Blank-Causes other than E850-E869 and E880-E928"' ;
  VALUE icd282ff  100='(100) 057-I. Infectious and parasitic diseases (001-139)'
                  200='(200) 040-Intestinal infectious diseases (001-009)'
                  300='(300) 054-Cholera and typhoid and paratyphoid fevers (001-002)'
                  400='(400) 019-Shigellosis (004)'
                  500='(500) 076-Other salmonella infections and other food poisoning (b'
                  600='(600) 017-Amebiasis (006)'
                  700='(700) 066-Intestinal infections due to other specified organisms'
                  800='(800) 041-Ill-defined intestinal infections (009)'
                  900='(900) 022-Tuberculosis (010-018)'
                  1000='(1000) 046-Tuberculosis of respiratory system (010-012)'
                  1100='(1100) 030-Other tuberculosis (013-018)'
                  1200='(1200) 047-Zoonotic and other bacterial diseases (020-041)'
                  1300='(1300) 019-Brucellosis (023)' 1400='(1400) 018-Diphtheria (032)'
                  1500='(1500) 022-Whooping cough (033)'
                  1600='(1600) 065-Streptococcal sore throat, scarlatina, and erysipelas ('
                  1700='(1700) 031-Meningococcal infection (036)'
                  1800='(1800) 015-Tetanus (037)' 1900='(1900) 018-Septicemia (038)'
                  2000='(2000) 056-All other bacterial diseases (020-022,024-031,039-041)'
                  2100='(2100) 034-Viral diseases (*042-*044,045-079)'
                  2200='(2200) 027-Acute poliomyelitis (045)'
                  2300='(2300) 016-Smallpox (050)' 2400='(2400) 015-Measles (055)'
                  2500='(2500) 015-Rubella (056)'
                  2600='(2600) 040-Arthropod-borne encephalitis (062-064)'
                  2700='(2700) 023-Viral hepatitis (070)'
                  2800='(2800) 074-Other viral diseases (*042-*044,046-049,051-054,057-061'
                  2900='(2900) 058-Rickettsioses and other arthropod-borne diseases (080-'
                  3000='(3000) 042-Typhus and other rickettsioses (080-083)'
                  3100='(3100) 015-Malaria (084)'
                  3200='(3200) 046-All other arthropod-borne diseases (085-088)'
                  3300='(3300) 046-Syphilis and other venereal diseases (090-099)'
                  3400='(3400) 020- Syphilis (090-097)'
                  3500='(3500) 033- Cardiovascular syphilis (093)'
                  3600='(3600) 023- Neurosyphilis (094)'
                  3700='(3700) 040- All other syphilis (090-091,095-097)'
                  3800='(3800) 029- Gonococcal infections (098)'
                  3900='(3900) 031- Other venereal diseases (099)'
                  4000='(4000) 103-Other infectious and parasitic diseases and late effec'
                  4100='(4100) 019-Mycoses (110-118)'
                  4200='(4200) 025-Helminthiases (120-129)'
                  4300='(4300) 036-Late effects of tuberculosis (137)'
                  4400='(4400) 043-Late effects of acute poliomyelitis (138)'
                  4500='(4500) 127-All other infectious and parasitic diseases and late ef'
                  4600='(4600) 033-II. Neoplasms (140-239)'
                  4700='(4700) 089-Malignant neoplasms, including neoplasms of lymphatic'
                  4800='(4800) 064-Malignant neoplasms of lip, oral cavity, and pharynx ('
                  4900='(4900) 016-Of lip (140)' 5000='(5000) 019-Of tongue (141)'
                  5100='(5100) 026-Of pharynx (146-149.0)'
                  5200='(5200) 097-Of other and ill-defined sites within the lip, oral cav'
                  5300='(5300) 066-Malignant neoplasms of digestive organs and peritoneum'
                  5400='(5400) 022-Of esophagus (150)' 5500='(5500) 020-Of stomach (151)'
                  5600='(5600) 048-Of small intestine, including duodenum (152)'
                  5700='(5700) 018-Of colon (153)'
                  5800='(5800) 075-Hepatic and splenic flexures and transverse colon (153.'
                  5900='(5900) 030-Descending colon (153.2)'
                  6000='(6000) 027-Sigmoid colon (153.3)'
                  6100='(6100) 056-Cecum, appendix, and ascending colon (153.4-153.6)'
                  6200='(6200) 048-Other and colon, unspecified (153.8-153.9)'
                  6300='(6300) 052-Of rectum, rectosigmoid junction, and anus (154)'
                  6400='(6400) 046-Of liver and intrahepatic bile ducts (155)'
                  6500='(6500) 028-Liver, primary (155.0)'
                  6600='(6600) 037-Intrahepatic bile ducts (155.1)'
                  6700='(6700) 058-Liver, not specified as primary or secondary (155.2)'
                  6800='(6800) 052-Of gallbladder and extrahepatic bile ducts (156)'
                  6900='(6900) 021-Of pancreas (157)'
                  7000='(7000) 120-Of retroperitoneum, peritoneum, and other and ill-defin'
                  7100='(7100) 071-Malignant neoplasms of respiratory and intrathoracic o'
                  7200='(7200) 019-Of larynx (161)'
                  7300='(7300) 040-Of trachea, bronchus, and lung (162)'
                  7400='(7400) 107-Of all other and ill-defined sites within the respirato'
                  7500='(7500) 076-Malignant neoplasms of bone, connective tissue, skin,'
                  7600='(7600) 041-Of bone and articular cartilage (170)'
                  7700='(7700) 045-Of connective and other soft tissue (171)'
                  7800='(7800) 026-Melanoma of skin (172)'
                  7900='(7900) 043-Other malignant neoplasms of skin (173)'
                  8000='(8000) 026-Of female breast (174)'
                  8100='(8100) 024-Of male breast (175)'
                  8200='(8200) 049-Malignant neoplasms of genital organs (179-187)'
                  8300='(8300) 025-Of cervix uteri (180)'
                  8400='(8400) 042-Of other parts of uterus (179,181-182)'
                  8500='(8500) 043-Of ovary and other uterine adnexa (183)'
                  8600='(8600) 056-Of other and unspecified female genital organs (184)'
                  8700='(8700) 021-Of prostate (185)' 8800='(8800) 019-Of testis (186)'
                  8900='(8900) 048-Of penis and other male genital organs (187)'
                  9000='(9000) 049-Malignant neoplasms of urinary organs (188-189)'
                  9100='(9100) 020-Of bladder (188)'
                  9200='(9200) 060-Of kidney and other and unspecified urinary organs (189'
                  9300='(9300) 062-Malignant neoplasms of other and unspecified sites (19'
                  9400='(9400) 016-Of eye (190)' 9500='(9500) 018-Of brain (191)'
                  9600='(9600) 058-Of other and unspecified parts of nervous system (192)'
                  9700='(9700) 080-Of thyroid gland and other endocrine glands and related'
                  9800='(9800) 048-Of all other and unspecified sites (195-199)'
                  9900='(9900) 070-Malignant neoplasms of lymphatic and hematopoietic tis'
                  10000='(10000) 043-Lymphosarcoma and reticulosarcoma (200)'
                  10100='(10100) 027-Hodgkin''s disease (201)'
                  10200='(10200) 070-Other malignant neoplasms of lymphoid and histiocytic t'
                  10300='(10300) 060-Multiple myeloma and immunoproliferative neoplasms (203'
                  10400='(10400) 022-Leukemia (204-208)'
                  10500='(10500) 029-Lymphoid leukemia (204)'
                  10600='(10600) 028-Myeloid leukemia (205)'
                  10700='(10700) 030-Monocytic leukemia (206)'
                  10800='(10800) 046-Other and unspecified leukemia (207-208)'
                  10900='(10900) 108-Benign neoplasms, carcinoma in situ, and neoplasms of'
                  11000='(11000) 028-Benign neoplasms (210-229)'
                  11100='(11100) 038-Of female genital organs (218-221)'
                  11200='(11200) 062-Of eye, brain, and other parts of nervous system (224-2'
                  11300='(11300) 064-Of all other and unspecified sites (210-217,222-223,226'
                  11400='(11400) 029-Carcinoma in situ (230-234)'
                  11500='(11500) 044-Of breast and genitourinary system (233)'
                  11600='(11600) 052-Of all other and unspecified sites (230-232,234)'
                  11700='(11700) 043-Neoplasms of uncertain behavior (235-238)'
                  11800='(11800) 039-Neoplasms of unspecified nature (239)'
                  11900='(11900) 094-III. Endocrine, nutritional, and metabolic diseases an'
                  12000='(12000) 073-Endocrine and metabolic diseases and immunity disorder'
                  12100='(12100) 038-Disorders of thyroid gland (240-246)'
                  12200='(12200) 025-Diabetes mellitus (250)'
                  12300='(12300) 069-Disorders of the pituitary gland and its hypothalamic c'
                  12400='(12400) 032-Diseases of thymus gland (254)'
                  12500='(12500) 035-Disorders of adrenal glands (255)'
                  12600='(12600) 025-Cystic fibrosis (277.0)'
                  12700='(12700) 017-Obesity (278.0)'
                  12800='(12800) 115-All other endocrine and metabolic diseases and immunity'
                  12900='(12900) 034-Nutritional deficiencies (260-269)'
                  13000='(13000) 028-Nutritional marasmus (261)'
                  13100='(13100) 046-Other protein-calorie malnutrition (262-263)'
                  13200='(13200) 050-All other nutritional deficiencies (260,264-269)'
                  13300='(13300) 067-IV. Diseases of blood and blood-forming organs (280-28'
                  13400='(13400) 017-Anemias (280-285)'
                  13500='(13500) 030-Deficiency anemias (280-281)'
                  13600='(13600) 029-Hemolytic anemias (282-283)'
                  13700='(13700) 023-Aplastic anemia (284)'
                  13800='(13800) 037-Other and unspecified anemias (285)'
                  13900='(13900) 046-Purpura and other hemorrhagic conditions (287)'
                  14000='(14000) 066-All other diseases of blood and blood-forming organs (2'
                  14100='(14100) 040-V. Mental disorders (290-319)'
                  14200='(14200) 055-Senile and presenile organic psychotic conditions (290)'
                  14300='(14300) 025-Alcoholic psychoses (291)'
                  14400='(14400) 029-All other psychoses (292-299)'
                  14500='(14500) 033-Alcohol dependence syndrome (303)'
                  14600='(14600) 021-Drug dependence (304)'
                  14700='(14700) 080-Other neurotic, personality, and nonpsychotic mental di'
                  14800='(14800) 028-Mental retardation (317-319)'
                  14900='(14900) 072-VI. Diseases of the nervous system and sense organs (3'
                  15000='(15000) 040-Diseases of the nervous system (320-359)'
                  15100='(15100) 022-Meningitis (320-322)'
                  15200='(15200) 027-Parkinson''s disease (332)'
                  15300='(15300) 092-Other hereditary and degenerative diseases of the centr'
                  15400='(15400) 026-Multiple sclerosis (340)'
                  15500='(15500) 032-Infantile cerebral palsy (343)'
                  15600='(15600) 016-Epilepsy (345)'
                  15700='(15700) 068-Other diseases of the nervous system (323-326,341-342,3'
                  15800='(15800) 041-Disorders of the eye and adnexa (360-379)'
                  15900='(15900) 049-Diseases of the ear and mastoid process (380-389)'
                  16000='(16000) 060-VII. Diseases of the circulatory system (390-459)'
                  16100='(16100) 053-Rheumatic fever and rheumatic heart disease (390-398)'
                  16200='(16200) 033-Acute rheumatic fever (390-392)'
                  16300='(16300) 043-Chronic rheumatic heart disease (393-398)'
                  16400='(16400) 034-Diseases of mitral valve (394)'
                  16500='(16500) 034-Diseases of aortic valve (395)'
                  16600='(16600) 046-Diseases of mitral and aortic valves (396)'
                  16700='(16700) 059-All other chronic rheumatic heart disease (393,397-398)'
                  16800='(16800) 030-Hypertensive disease (401-404)'
                  16900='(16900) 030-Essential hypertension (401)'
                  17000='(17000) 034-Hypertensive heart disease (402)'
                  17100='(17100) 034-Hypertensive renal disease (403)'
                  17200='(17200) 044-Hypertensive heart and renal disease (404)'
                  17300='(17300) 032-Ischemic heart disease (410-414)'
                  17400='(17400) 035-Acute myocardial infarction (410)'
                  17500='(17500) 064-Other acute and subacute forms of ischemic heart diseas'
                  17600='(17600) 023-Angina pectoris (413)'
                  17700='(17700) 087-Old myocardial infarction and other forms of chronic is'
                  17800='(17800) 043-Diseases of pulmonary circulation (415-417)'
                  17900='(17900) 038-Other forms of heart disease (420-429)'
                  18000='(18000) 039-Acute and subacute endocarditis (421)'
                  18100='(18100) 088-Acute pericarditis, acute myocarditis, and other diseas'
                  18200='(18200) 037-Other diseases of endocardium (424)'
                  18300='(18300) 034-Mitral valve disorders (424.0)'
                  18400='(18400) 034-Aortic valve disorders (424.1)'
                  18500='(18500) 051-All other diseases of endocardium (424.2-424.9)'
                  18600='(18600) 021-Heart failure (428)'
                  18700='(18700) 068-Myocarditis, unspecified and myocardial degeneration (4'
                  18800='(18800) 072- All other and ill-defined forms of heart disease (425-4'
                  18900='(18900) 034-Cerebrovascular diseases (430-438)'
                  19000='(19000) 031-Subarachnoid hemorrhage (430)'
                  19100='(19100) 059-Intracerebral and other intracranial hemorrhage (431-43'
                  19200='(19200) 054-Occlusion and stenosis of precerebral arteries (433)'
                  19300='(19300) 082-Cerebral thrombosis and unspecified occlusion of cerebr'
                  19400='(19400) 027-Cerebral embolism (434.1)'
                  19500='(19500) 053-Acute but ill-defined cerebrovascular disease (436)'
                  19600='(19600) 066-Other and late effects of cerebrovascular diseases (435'
                  19700='(19700) 059-Diseases of arteries, arterioles, and capillaries (440'
                  19800='(19800) 023-Atherosclerosis (440)'
                  19900='(19900) 023-Aortic aneurysm (441)'
                  20000='(20000) 071-All other diseases of arteries, arterioles, and capilla'
                  20100='(20100) 084-Diseases of veins and lymphatics, and other diseases o'
                  20200='(20200) 075-Phlebitis, thrombophlebitis, and venous embolism and th'
                  20300='(20300) 095-Other diseases of veins and lymphatics and all other di'
                  20400='(20400) 061-VIII. Diseases of the respiratory system (460-519)'
                  20500='(20500) 057-Diseases of the upper respiratory tract (460-465,470-4'
                  20600='(20600) 046-Acute upper respiratory infections (460-465)'
                  20700='(20700) 053-Other diseases of upper respiratory tract (470-478)'
                  20800='(20800) 054-Other diseases of the respiratory system (466,480-519)'
                  20900='(20900) 042-Acute bronchitis and bronchiolitis (466)'
                  21000='(21000) 021-Pneumonia (480-486)'
                  21100='(21100) 025-Viral pneumonia (480)'
                  21200='(21200) 056-Pneumococcal and other bacterial pneumonia (481-482)'
                  21300='(21300) 048-Bronchopneumonia, organism unspecified (485)'
                  21400='(21400) 061-Pneumonia due to other and unspecified organism (483,48'
                  21500='(21500) 017-Influenza (487)'
                  21600='(21600) 072-Chronic obstructive pulmonary diseases and allied cond'
                  21700='(21700) 071-Bronchitis, chronic and unspecified, emphysema and ast'
                  21800='(21800) 057-Bronchitis, not specified as acute or chronic (490)'
                  21900='(21900) 030-Chronic bronchitis (491)'
                  22000='(22000) 021-Emphysema (492)' 22100='(22100) 018-Asthma (493)'
                  22200='(22200) 062-Bronchiectasis and extrinsic allergic alveolitis (494-4'
                  22300='(22300) 063-Chronic airways obstruction, not elsewhere classified ('
                  22400='(22400) 073-Pneumoconioses and other lung diseases due to external'
                  22500='(22500) 055-Empyema and abscess of lung and mediastinum (510,513)'
                  22600='(22600) 016-Pleurisy (511)'
                  22700='(22700) 056-All other diseases of respiratory system (512,514-519)'
                  22800='(22800) 057-IX. Diseases of the digestive system (520-579)'
                  22900='(22900) 060-Diseases of oral cavity, salivary glands, and jaws (520'
                  23000='(23000) 057-Diseases of other parts of the digestive system (530-5'
                  23100='(23100) 041-Ulcer of stomach and duodenum (531-533)'
                  23200='(23200) 023-Gastric ulcer (531)'
                  23300='(23300) 024-Duodenal ulcer (532)'
                  23400='(23400) 040-Peptic ulcer, site unspecified (533)'
                  23500='(23500) 032-Gastritis and duodenitis (535)'
                  23600='(23600) 024-Appendicitis (540-543)'
                  23700='(23700) 095-Hernia of abdominal cavity and intestinal obstruction w'
                  23800='(23800) 059-Regional enteritis and idiopathic proctocolitis (555-55'
                  23900='(23900) 062-All other noninfective gastroenteritis and colitis (557'
                  24000='(24000) 032-Diverticula of intestine (562)'
                  24100='(24100) 043-Chronic liver disease and cirrhosis (571)'
                  24200='(24200) 077-Chronic liver disease and cirrhosis, specified as alcoh'
                  24300='(24300) 057-Chronic hepatitis and biliary cirrhosis (571.4,571.6)'
                  24400='(24400) 117-Cirrhosis of liver and other and unspecified chronic li'
                  24500='(24500) 061-Cholelithiasis and other disorders of gallbladder (574-'
                  24600='(24600) 082-All other diseases of digestive system (530,534,536-537'
                  24700='(24700) 060-X. Diseases of the genitourinary system (580-629)'
                  24800='(24800) 036-Diseases of urinary system (580-599)'
                  24900='(24900) 056-Nephritis, nephrotic syndrome, and nephrosis (580-589)'
                  25000='(25000) 034-Acute glomerulonephritis (580)'
                  25100='(25100) 028-Nephrotic syndrome (581)'
                  25200='(25200) 140-Chronic glomerulonephritis, nephritis and nephropathy,'
                  25300='(25300) 120-Renal failure, disorders resulting from impaired renal'
                  25400='(25400) 028-Infections of kidney (590)'
                  25500='(25500) 028-Urinary calculus (592,594)'
                  25600='(25600) 056-All other diseases of urinary system (591,593,595-599)'
                  25700='(25700) 041-Diseases of male genital organs (600-608)'
                  25800='(25800) 031-Hyperplasia of prostate (600)'
                  25900='(25900) 049-Other diseases of male genital organs (601-608)'
                  26000='(26000) 029-Disorders of breast (610-611)'
                  26100='(26100) 057-Diseases of female genital organs except breast (614-6'
                  26200='(26200) 083-XI. Complications of pregnancy, childbirth, and the pu'
                  26300='(26300) 041-Pregnancy with abortive outcome (630-638)'
                  26400='(26400) 025-Ectopic pregnancy (633)'
                  26500='(26500) 028-Spontaneous abortion (634)'
                  26600='(26600) 032-Legally induced abortion (635)'
                  26700='(26700) 034-Illegally induced abortion (636)'
                  26800='(26800) 057-Other pregnancy with abortive outcome (630-632,637-638'
                  26900='(26900) 041-Direct obstetric causes (640-646,651-676)'
                  27000='(27000) 054-Hemorrhage of pregnancy and childbirth (640-641,666)'
                  27100='(27100) 040-Toxemia of pregnancy (642.4-642.9,643)'
                  27200='(27200) 024-Obstructed labor (660)'
                  27300='(27300) 043-Complications of the puerperium (670-676)'
                  27400='(27400) 077-Other direct obstetric causes (642.0-642.3,644-646,651'
                  27500='(27500) 035-Indirect obstetric causes (647-648)'
                  27600='(27600) 042-Delivery in a completely normal case (650)'
                  27700='(27700) 070-XII. Diseases of the skin and subcutaneous tissue (680'
                  27800='(27800) 052-Infections of skin and subcutaneous tissue (680-686)'
                  27900='(27900) 060-All other diseases of skin and subcutaneous tissue (690'
                  28000='(28000) 087-XIII. Diseases of the musculoskeletal system and conne'
                  28100='(28100) 067-Rheumatoid arthritis and other inflammatory polyarthrop'
                  28200='(28200) 059-Other arthropathies and related disorders (710-712,715-'
                  28300='(28300) 022-Dorsopathies (720-724)'
                  28400='(28400) 040-Rheumatism, excluding the back (725-729)'
                  28500='(28500) 080-Osteopathies, chondropathies, and acquired musculoskele'
                  28600='(28600) 046-XIV. Congenital anomalies (740-759)'
                  28700='(28700) 018-Spina bifida (741)'
                  28800='(28800) 058-All other congenital anomalies of nervous system (740,7'
                  28900='(28900) 039-Congenital anomalies of heart (745-746)'
                  29000='(29000) 054-Other congenital anomalies of circulatory system (747)'
                  29100='(29100) 048-All other congenital anomalies (743-744,748-759)'
                  29200='(29200) 079-XV. Certain conditions originating in the perinatal per'
                  29300='(29300) 018-Birth trauma (767)'
                  29400='(29400) 081-Intrauterine hypoxia, birth asphyxia, and respiratory d'
                  29500='(29500) 070-Other conditions originating in the perinatal period (7'
                  29600='(29600) 069-XVI. Symptoms, signs, and ill-defined conditions (780-'
                  29700='(29700) 043-Senility without mention of psychosis (797)'
                  29800='(29800) 067-Symptoms, signs, and other ill-defined conditions (780-'
                  29900='(29900) 093-Supplementary classification of external causes of inju'
                  30000='(30000) 041-Accidents and adverse effects (E800-E949)'
                  30100='(30100) 033-Transport accidents (E800-E848)'
                  30200='(30200) 033-Railway accidents (E800-E807)'
                  30300='(30300) 039-Motor vehicle accidents (E810-E825)'
                  30400='(30400) 049-Motor vehicle traffic accidents (E810-E819)'
                  30500='(30500) 045-Involving collision with train (E810)'
                  30600='(30600) 066-Involving collision with another motor vehicle (E811-E8'
                  30700='(30700) 050-Involving collision with pedestrian (E814)'
                  30800='(30800) 068-Involving collision with other vehicle or object (E813,'
                  30900='(30900) 054-Not involving collision on highway (E816-E818)'
                  31000='(31000) 067-Motor vehicle traffic accident of unspecified nature (E'
                  31100='(31100) 052-Motor vehicle nontraffic accidents (E820-E825)'
                  31200='(31200) 044-Other road vehicle accidents (E826-E829)'
                  31300='(31300) 041-Water transport accidents (E830-E838)'
                  31400='(31400) 049-Air and space transport accidents (E840-E845)'
                  31500='(31500) 060-Vehicle accidents not elsewhere classifiable (E846-E848'
                  31600='(31600) 034-Accidental poisoning (E850-E869)'
                  31700='(31700) 075-Accidental poisoning by drugs, medicaments, and biologi'
                  31800='(31800) 072-Accidental poisoning by other solid or liquid substance'
                  31900='(31900) 056-Accidental poisoning by gases and vapors (E867-E869)'
                  32000='(32000) 091-Misadventures during medical care, abnormal reactions,'
                  32100='(32100) 030-Accidental falls (E880-E888)'
                  32200='(32200) 046-Fall from one level to another (E880-E884)'
                  32300='(32300) 034-Fall on same level (E885-E886)'
                  32400='(32400) 076-Fracture, cause unspecified, and other and unspecified'
                  32500='(32500) 049-Accidents caused by fire and flames (E890-E899)'
                  32600='(32600) 053-Other accidents, including late effects (E900-E929)'
                  32700='(32700) 020-Lightning (E907)'
                  32800='(32800) 045-Accidental drowning and submersion (E910)'
                  32900='(32900) 120-Inhalation and ingestion of food or other object causin'
                  33000='(33000) 039-Accident caused by handgun (E922.0)'
                  33100='(33100) 074-Accidents caused by all other and unspecified firearms'
                  33200='(33200) 048-Accident caused by explosive material (E923)'
                  33300='(33300) 123-Accident caused by hot substance or object, caustic or'
                  33400='(33400) 046-Accident caused by electric current (E925)'
                  33500='(33500) 103-All other accidents and late effects of accidental inju'
                  33600='(33600) 102-Drugs, medicaments, and biological substances causing a'
                  33700='(33700) 019-Suicide (E950-E959)'
                  33800='(33800) 064-Suicide by drugs, medicaments, and biologicals (E950.0'
                  33900='(33900) 061-Suicide by other solid or liquid substances (E950.6-E9'
                  34000='(34000) 041-Suicide by gases and vapors (E951-E952)'
                  34100='(34100) 059-Suicide by hanging, strangulation, and suffocation (E9'
                  34200='(34200) 029-Suicide by handgun (E955.0)'
                  34300='(34300) 063-Suicide by all other and unspecified firearms (E955.1-'
                  34400='(34400) 089-Suicide by all other means and late effects of self-in'
                  34500='(34500) 043-Homicide and legal intervention (E960-E978)'
                  34600='(34600) 029-Assault by handgun (E965.0)'
                  34700='(34700) 063-Assault by all other and unspecified firearms (E965.1-E'
                  34800='(34800) 051-Assault by cutting and piercing instrument (E966)'
                  34900='(34900) 127-Assault by all other means and late effects of injury p'
                  35000='(35000) 024-Legal execution (E978)'
                  35100='(35100) 091-Other legal intervention and late effects of injury due'
                  35200='(35200) 075-Injury undetermined whether accidentally or purposely'
                  35300='(35300) 071-From poisoning by drugs, medicaments, and biologicals ('
                  35400='(35400) 068-From poisoning by other solid or liquid substances (E98'
                  35500='(35500) 033-From injury by handgun (E985.0)'
                  35600='(35600) 067-From injury by all other and unspecified firearms (E985'
                  35700='(35700) 141-From injury by all other means and late effects of inju'
                  35800='(35800) 051-Injury resulting from operations of war (E990-E999)' ;
  VALUE icd72fff  10='(10) 035-Shigellosis and amebiasis (004,006)'
                  20='(20) 045-Certain other intestinal infections (007-009)'
                  30='(30) 022-Tuberculosis (010-018)'
                  40='(40) 046-Tuberculosis of respiratory system (010-012)'
                  50='(50) 030-Other tuberculosis (013-018)'
                  60='(60) 020-Whooping cough (033)'
                  70='(70) 063-Streptococcal sore throat, scarlatina, and erysipelas (0'
                  80='(80) 029-Meningococcal infection (036)'
                  90='(90) 016-Septicemia (038)'
                  100='(100) 025-Acute poliomyelitis (045)' 110='(110) 013-Measles (055)'
                  120='(120) 021-Viral hepatitis (070)'
                  130='(130) 018-Syphilis (090-097)'
                  140='(140) 119-All other infectious and parasitic diseases (001-003,005'
                  150='(150) 089-Malignant neoplasms, including neoplasms of lymphatic a'
                  160='(160) 064-Malignant neoplasms of lip, oral cavity, and pharynx (14'
                  170='(170) 066-Malignant neoplasms of digestive organs and peritoneum ('
                  180='(180) 071-Malignant neoplasms of respiratory and intrathoracic org'
                  190='(190) 040-Malignant neoplasm of breast (174-175)'
                  200='(200) 049-Malignant neoplasms of genital organs (179-187)'
                  210='(210) 049-Malignant neoplasms of urinary organs (188-189)'
                  220='(220) 074-Malignant neoplasms of all other and unspecified sites ('
                  230='(230) 020-Leukemia (204-208)'
                  240='(240) 076-Other malignant neoplasms of lymphatic and hematopoietic'
                  250='(250) 108-Benign neoplasms, carcinoma in situ, and neoplasms of un'
                  260='(260) 023-Diabetes mellitus (250)'
                  270='(270) 034-Nutritional deficiencies (260-269)'
                  280='(280) 017-Anemias (280-285)' 290='(290) 020-Meningitis (320-322)'
                  300='(300) 039-Major cardiovascular diseases (390-448)'
                  310='(310) 041-Diseases of heart (390-398,402,404-429)'
                  320='(320) 057-Rheumatic fever and rheumatic heart disease (390-398)'
                  330='(330) 036-Hypertensive heart disease (402)'
                  340='(340) 046-Hypertensive heart and renal disease (404)'
                  350='(350) 036-Ischemic heart disease (410-414)'
                  360='(360) 039-Acute myocardial infarction (410)'
                  370='(370) 068-Other acute and subacute forms of ischemic heart disease'
                  380='(380) 027-Angina pectoris (413)'
                  390='(390) 091-Old myocardial infarction and other forms of chronic isc'
                  400='(400) 039-Other diseases of endocardium (424)'
                  410='(410) 054-All other forms of heart disease (415-423,425-429)'
                  420='(420) 054-Hypertension with or without renal disease (401,403)'
                  430='(430) 036-Cerebrovascular diseases (430-438)'
                  440='(440) 061-Intracerebral and other intracranial hemorrhage (431-432'
                  450='(450) 084-Cerebral thrombosis and unspecified occlusion of cerebra'
                  460='(460) 029-Cerebral embolism (434.1)'
                  470='(470) 076-All other and late effects of cerebrovascular diseases ('
                  480='(480) 023-Atherosclerosis (440)'
                  490='(490) 067-Other diseases of arteries, arterioles, and capillaries'
                  500='(500) 040-Acute bronchitis and bronchiolitis (466)'
                  510='(510) 033-Pneumonia and influenza (480-487)'
                  520='(520) 021-Pneumonia (480-486)' 530='(530) 017-Influenza (487)'
                  540='(540) 070-Chronic obstructive pulmonary diseases and allied condit'
                  550='(550) 047-Bronchitis, chronic and unspecified (490-491)'
                  560='(560) 017-Emphysema (492)' 570='(570) 014-Asthma (493)'
                  580='(580) 078-Other chronic obstructive pulmonary diseases and allied'
                  590='(590) 039-Ulcer of stomach and duodenum (531-533)'
                  600='(600) 022-Appendicitis (540-543)'
                  610='(610) 093-Hernia of abdominal cavity and intestinal obstruction wi'
                  620='(620) 041-Chronic liver disease and cirrhosis (571)'
                  630='(630) 059-Cholelithiasis and other disorders of gallbladder (574-5'
                  640='(640) 054-Nephritis, nephrotic syndrome, and nephrosis (580-589)'
                  650='(650) 059-Acute glomerulonephritis and nephrotic syndrome (580-581'
                  660='(660) 138-Chronic glomerulonephritis, nephritis and nephropathy, n'
                  670='(670) 118-Renal failure, disorders resulting from impaired renal f'
                  680='(680) 026-Infections of kidney (590)'
                  690='(690) 029-Hyperplasia of prostate (600)'
                  700='(700) 068-Complications of pregnancy, childbirth, and the puerperi'
                  710='(710) 043-Pregnancy with abortive outcome (630-638)'
                  720='(720) 076-Other complications of pregnancy, childbirth, and the pu'
                  730='(730) 030-Congenital anomalies (740-759)'
                  740='(740) 064-Certain conditions originating in the perinatal period ('
                  750='(750) 097-Birth trauma, intrauterine hypoxia, birth asphyxia, and'
                  760='(760) 072-Other conditions originating in the perinatal period (76'
                  770='(770) 053-Symptoms, signs, and ill-defined conditions (780-799)'
                  780='(780) 029-All other diseases (Residual)'
                  790='(790) 041-Accidents and adverse effects (E800-E949) 800 037 Motor' ;
  VALUE icd61fff  10='(10) 039-Certain intestinal infections (008-009)'
                  20='(20) 020-Whooping cough (033)'
                  30='(30) 029-Meningococcal infection (036)'
                  40='(40) 016-Septicemia (038)' 50='(50) 024-Viral diseases (045-079)'
                  60='(60) 025-Congenital syphilis (090)'
                  70='(70) 110-Remainder of infectious and parasitic diseases (001-007,'
                  80='(80) 089-Malignant neoplasms, including neoplasms of lymphatic an'
                  90='(90) 108-Benign neoplasms, carcinoma in situ, and neoplasms of un'
                  100='(100) 030-Diseases of thymus gland (254)'
                  110='(110) 023-Cystic fibrosis (277.0)'
                  120='(120) 052-Diseases of blood and blood-forming organs (280-289)'
                  130='(130) 020-Meningitis (320-322)'
                  140='(140) 059-Other diseases of nervous system and sense organs (323-3'
                  150='(150) 044-Acute upper respiratory infections (460-465)'
                  160='(160) 042-Bronchitis and bronchiolitis (466,490-491)'
                  170='(170) 033-Pneumonia and influenza (480-487)'
                  180='(180) 021-Pneumonia (480-486)' 190='(190) 017-Influenza (487)'
                  200='(200) 061-Remainder of diseases of respiratory system (470-478,492'
                  210='(210) 093-Hernia of abdominal cavity and intestinal obstruction wi'
                  220='(220) 075-Gastritis, duodenitis, and noninfective enteritis and co'
                  230='(230) 067-Remainder of diseases of digestive system (520-534,536-5'
                  240='(240) 030-Congenital anomalies (740-759)'
                  250='(250) 042-Anencephalus and similar anomalies (740)'
                  260='(260) 020-Spina bifida (741)'
                  270='(270) 034-Congenital hydrocephalus (742.3)'
                  280='(280) 092-Other congenital anomalies of central nervous system and'
                  290='(290) 041-Congenital anomalies of heart (745-746)'
                  300='(300) 056-Other congenital anomalies of circulatory system (747)'
                  310='(310) 050-Congenital anomalies of respiratory system (748)'
                  320='(320) 052-Congenital anomalies of digestive system (749-751)'
                  330='(330) 056-Congenital anomalies of genitourinary system (752-753)'
                  340='(340) 058-Congenital anomalies of musculoskeletal system (754-756)'
                  350='(350) 025-Down''s syndrome (758.0)'
                  360='(360) 043-Other chromosomal anomalies (758.1-758.9)'
                  370='(370) 062-All other and unspecified congenital anomalies (744,757,'
                  380='(380) 064-Certain conditions originating in the perinatal period ('
                  390='(390) 091-Newborn affected by maternal conditions which may be unr'
                  400='(400) 063-Newborn affected by maternal complications of pregnancy'
                  410='(410) 074-Newborn affected by complications of placenta, cord, and'
                  420='(420) 069-Newborn affected by other complications of labor and del'
                  430='(430) 048-Slow fetal growth and fetal malnutrition (764)'
                  440='(440) 077-Disorders relating to short gestation and unspecified lo'
                  450='(450) 065-Disorders relating to long gestation and high birthweigh'
                  460='(460) 020-Birth trauma (767)'
                  470='(470) 047-Intrauterine hypoxia and birth asphyxia (768)'
                  480='(480) 051-Fetal distress in liveborn infant (768.2-768.4)'
                  490='(490) 032-Birth asphyxia (768.5-768.9)'
                  500='(500) 037-Respiratory distress syndrome (769)'
                  510='(510) 047-Other respiratory conditions of newborn (770)'
                  520='(520) 051-Infections specific to the perinatal period (771)'
                  530='(530) 027-Neonatal hemorrhage (772)'
                  540='(540) 094-Hemolytic disease of newborn, due to isoimmunization, an'
                  550='(550) 088-Syndrome of infant of a diabetic mother and neonatal dia'
                  560='(560) 040-Hemorrhagic disease of newborn (776.0)'
                  570='(570) 098-All other and ill-defined conditions originating in the'
                  580='(580) 053-Symptoms, signs, and ill-defined conditions (780-799)'
                  590='(590) 038-Sudden infant death syndrome (798.0)'
                  600='(600) 075-Symptoms, signs, and all other ill-defined conditions (7'
                  610='(610) 041-Accidents and adverse effects (E800-E949)'
                  620='(620) 118-Inhalation and ingestion of food or other object causing'
                  630='(630) 042-Accidental mechanical suffocation (E913)'
                  640='(640) 067-Other accidental causes and adverse effects (E800-E910,E'
                  650='(650) 020-Homicide (E960-E969)'
                  660='(660) 047-Child battering and other maltreatment (E967)'
                  670='(670) 038-Other homicide (E960-E966,E968-E969)'
                  680='(680) 027-All other causes (Residual)' ;
  VALUE icd34fff  10='(10) 022-Tuberculosis (010-018)' 20='(20) 018-Syphilis (090-097)'
                  30='(30) 089-Residual of infectious and parasitic diseases (001-009,0'
                  40='(40) 089-Malignant neoplasms, including neoplasms of lymphatic an'
                  50='(50) 066-Malignant neoplasms of digestive organs and peritoneum ('
                  60='(60) 071-Malignant neoplasms of respiratory and intrathoracic org'
                  70='(70) 040-Malignant neoplasm of breast (174-175)'
                  80='(80) 049-Malignant neoplasms of genital organs (179-187)'
                  90='(90) 049-Malignant neoplasms of urinary organs (188-189)'
                  100='(100) 020-Leukemia (204-208)'
                  110='(110) 053-Other malignant neoplasms (140-149,170-173,190-203)'
                  120='(120) 023-Diabetes mellitus (250)'
                  130='(130) 039-Major cardiovascular diseases (390-448)'
                  140='(140) 041-Diseases of heart (390-398,402,404-429)'
                  150='(150) 057-Rheumatic fever and rheumatic heart disease (390-398)'
                  160='(160) 070-Hypertensive heart disease with or without renal disease'
                  170='(170) 036-Ischemic heart disease (410-414)'
                  180='(180) 034-Other heart diseases (415-429)'
                  190='(190) 054-Hypertension with or without renal disease (401,403)'
                  200='(200) 036-Cerebrovascular diseases (430-438)'
                  210='(210) 023-Atherosclerosis (440)'
                  220='(220) 067-Other diseases of arteries, arterioles, and capillaries'
                  230='(230) 033-Pneumonia and influenza (480-487)'
                  240='(240) 070-Chronic obstructive pulmonary diseases and allied condit'
                  250='(250) 039-Ulcer of stomach and duodenum (531-533)'
                  260='(260) 041-Chronic liver disease and cirrhosis (571)'
                  270='(270) 054-Nephritis, nephrotic syndrome, and nephrosis (580-589)'
                  280='(280) 068-Complications of pregnancy, childbirth, and the puerperi'
                  290='(290) 030-Congenital anomalies (740-759)'
                  300='(300) 064-Certain conditions originating in the perinatal period ('
                  310='(310) 053-Symptoms, signs, and ill-defined conditions (780-799)'
                  320='(320) 029-All other diseases (Residual)'
                  330='(330) 035-Motor vehicle accidents (E810-E825)'
                  340='(340) 061-All other accidents and adverse effects (E800-E807,E826-'
                  350='(350) 019-Suicide (E950-E959)'
                  360='(360) 043-Homicide and legal intervention (E960-E978)'
                  370='(370) 037-All other external causes (E980-E999)' ;
*/


* SAS DATA, INFILE, INPUT STATEMENTS;

DATA;
INFILE "data-filename" LRECL=422;
INPUT
        RESVD1 1-3              CERTNO 4-9
        RESVD2 10-11            SEQNUM 12-18            RECTYPE 19
        RESISTAT 20             STATEOCC 21-22          CONTYOCC 23-25
        REGION 26               DIVISION 27             STATESUB 28
        EXP_OCC 29-30           RESIDST 31-32           CNTYRSID $33-35
        CITYRSID $36-38         POPSIZE $39             METRO $40
        REGNRES 41              DIVISRES 42             STSUB 43
        EXP_RES 44-45           PMSA_RES $46-48         POPCNTYO 49
        POPCNTYR $50            PMSASIZE $51            EDUCATN 52-53
        EDUC_R 54               DEATHMO 55-56           RESVD3 57-58
        SEX 59                  RACE_DET 60-61          RACE_R3 62
        RACE_R2 63              AGEUNIT 64              AGENUMBR 65-66
        AGEREC52 67-68          AGEREC27 69-70          AGEREC12 71-72
        INFNTAGE $73-74         PLACEDTH 75             RESVD4 76
        MARSTAT 77              BIRTH_ST 78-79          HISPANIC 80-81
        HISP_REC 82             DAYDEATH 83             RESVD5 84
        KINDBUSS 85-87          USUALOCC 88-90          ICD52 91-93
        RESVD6 94-96            CITYFIPS 97-101         RESVD7 102-114
        DATAYR 115-118          FIPSTOCC 119-120        FIPCNOCC 121-123
        FIPSRES 124-125         FIPCNRES 126-128        MSA_RES 129-132
        RESVD8 133              CMSA_RES 134-135        INJ_WORK 136
        RACE_FLG $137           AGE_FLG 138             RESVD9 139-140
        PLACEINJ $141           ICDCODE $142-145        ICD282 146-150
        ICD72 151-153           ICD61 154-156           ICD34 157-159
        NUMAXIS 160-161         ACOND1 $162-168         ACOND2 $169-175
        ACOND3 $176-182         ACOND4 $183-189         ACOND5 $190-196
        ACOND6 $197-203         ACOND7 $204-210         ACOND8 $211-217
        ACOND9 $218-224         ACOND10 $225-231        ACOND11 $232-238
        ACOND12 $239-245        ACOND13 $246-252        ACOND14 $253-259
        ACOND15 $260-266        ACOND16 $267-273        ACOND17 $274-280
        ACOND18 $281-287        ACOND19 $288-294        ACOND20 $295-301
        RESVD11 302-319         NUMRECAX 320-321        TRANSX 322
        RCOND1 $323-327         RCOND2 $328-332         RCOND3 $333-337
        RCOND4 $338-342         RCOND5 $343-347         RCOND6 $348-352
        RCOND7 $353-357         RCOND8 $358-362         RCOND9 $363-367
        RCOND10 $368-372        RCOND11 $373-377        RCOND12 $378-382
        RCOND13 $383-387        RCOND14 $388-392        RCOND15 $393-397
        RCOND16 $398-402        RCOND17 $403-407        RCOND18 $408-412
        RCOND19 $413-417        RCOND20 $418-422        ;


* SAS LABEL STATEMENT;

LABEL
   RESVD1  = 'RESERVED POSITIONS'
   CERTNO  = 'CERTIFICATE NUMBER'
   RESVD2  = 'RESERVED POSITIONS'
   SEQNUM  = 'SEQUENCE NUMBER'
   RECTYPE = 'RECORD TYPE'
   RESISTAT= 'RESIDENT STATUS'
   STATEOCC= 'STATE OF OCCURRENCE'
   CONTYOCC= 'COUNTY OF OCCURRENCE'
   REGION  = 'REGION'
   DIVISION= 'DIVISION OF OCCURRENCE'
   STATESUB= 'STATE SUBCODE OF OCCURRENCE'''
   EXP_OCC = 'EXPANDED STATE OF OCCURRENCE FOR NY CITY'
   RESIDST = 'STATE OF RESIDENCE'
   CNTYRSID= 'COUNTY OF RESIDENCE'
   CITYRSID= 'CITY OF RESIDENCE'
   POPSIZE = 'POPULATION SIZE CITY OF RESIDENCE'
   METRO   = 'METROPOLITAN NONMETROPOLITAN COUNTY OF RESIDENCE'
   REGNRES = 'REGION OF RESIDENCE'
   DIVISRES= 'DIVISION OF RESIDENCE'
   STSUB   = 'STATE SUBCODE OF RESIDENCE'
   EXP_RES = 'EXPANDED STATE OF RESIDENCE NY CITY'
   PMSA_RES= 'PMSA,MSA OF RESIDENCE'
   POPCNTYO= 'POPULATION SIZE OF COUNTY OF OCCURRENCE'
   POPCNTYR= 'POPULATION SIZE OF COUNTY OF RESIDENCE'
   PMSASIZE= 'PMSA,MSA POPULATION SIZE'
   EDUCATN = 'EDUCATION'
   EDUC_R  = 'EDUCATION RECODE'
   DEATHMO = 'MONTH OF DEATH'
   RESVD3  = 'RESERVED POSITIONS'
   SEX     = 'SEX'
   RACE_DET= 'RACE DETAIL'
   RACE_R3 = 'RACE RECODE 3'
   RACE_R2 = 'RACE RECODE 2'
   AGEUNIT = 'AGE UNIT'
   AGENUMBR= 'AGE NUMBER'
   AGEREC52= 'AGE RECODE 52'
   AGEREC27= 'AGE RECODE 27'
   AGEREC12= 'AGE RECODE 12'
   INFNTAGE= 'INFANT AGE RECODE'
   PLACEDTH= 'PLACE OF DEATH'
   RESVD4  = 'RESERVED POSITIONS'
   MARSTAT = 'MARITAL STATUS'
   BIRTH_ST= 'STATE OF BIRTH'
   HISPANIC= 'HISPANIC ORIGIN'
   HISP_REC= 'HISPANIC ORIGIN RACE RECODE'
   DAYDEATH= 'DAY OF WEEK OF DEATH'
   RESVD5  = 'RESERVED POSITIONS'
   KINDBUSS= 'KIND OF BUSINESS OR INDUSTRY'
   USUALOCC= 'USUAL OCCUPATION'
   ICD52   = 'ICD CODE, 52 CAUSE LIST'
   RESVD6  = 'RESERVED POSITIONS'
   CITYFIPS= 'FIPS, CITY OF RESIDENCE'
   RESVD7  = 'RESERVED POSITIONS'
   DATAYR  = 'CURRENT DATA YEAR'
   FIPSTOCC= 'FIPS, STATE OF OCCURRENCE'
   FIPCNOCC= 'FIPS, COUNTY OF OCCURRENCE'
   FIPSRES = 'FIPS, STATE OF RESIDENCE'
   FIPCNRES= 'FIPS, COUNTY OF RESIDENCE'
   MSA_RES = 'PMSA,MSA OF RESIDENCE'
   RESVD8  = 'RESERVED POSITIONS'
   CMSA_RES= 'CMSA OF RESIDENCE'
   INJ_WORK= 'INJURY AT WORK'
   RACE_FLG= 'RACE IMPUTATION FLAG'
   AGE_FLG = 'AGE SUBSTITUTION FLAG'
   RESVD9  = 'RESERVED POSITIONS'
   PLACEINJ= 'PLACE OF INJURY'
   ICDCODE = 'ICD CODE, 10TH REVISION'
   ICD282  = 'ICD CODE, 282 CAUSE LIST'
   ICD72   = 'ICD CODE, 72 CAUSE LIST'
   ICD61   = 'ICD CODE, 61 INFANT CAUSE LIST'
   ICD34   = 'ICD CODE, 34 CAUSE LIST'
   NUMAXIS = 'NUMBER OF ENTITY AXIS CONDITIONS'
   ACOND1  = 'ENTITY CONDITION'
   ACOND2  = 'ENTITY CONDITION'
   ACOND3  = 'ENTITY CONDITION'
   ACOND4  = 'ENTITY CONDITION'
   ACOND5  = 'ENTITY CONDITION'
   ACOND6  = 'ENTITY CONDITION'
   ACOND7  = 'ENTITY CONDITION'
   ACOND8  = 'ENTITY CONDITION'
   ACOND9  = 'ENTITY CONDITION'
   ACOND10 = 'ENTITY CONDITION'
   ACOND11 = 'ENTITY CONDITION'
   ACOND12 = 'ENTITY CONDITION'
   ACOND13 = 'ENTITY CONDITION'
   ACOND14 = 'ENTITY CONDITION'
   ACOND15 = 'ENTITY CONDITION'
   ACOND16 = 'ENTITY CONDITION'
   ACOND17 = 'ENTITY CONDITION'
   ACOND18 = 'ENTITY CONDITION'
   ACOND19 = 'ENTITY CONDITION'
   ACOND20 = 'ENTITY CONDITION'
   RESVD11 = 'RESERVED POSITIONS'
   NUMRECAX= 'NUMBER OF RECORD ENTITY CONDITIONS'
   TRANSX  = 'RESERVED POSITION, TRANSAX FLAG'
   RCOND1  = 'RECORD CONDITION'
   RCOND2  = 'RECORD CONDITION'
   RCOND3  = 'RECORD CONDITION'
   RCOND4  = 'RECORD CONDITION'
   RCOND5  = 'RECORD CONDITION'
   RCOND6  = 'RECORD CONDITION'
   RCOND7  = 'RECORD CONDITION'
   RCOND8  = 'RECORD CONDITION'
   RCOND9  = 'RECORD CONDITION'
   RCOND10 = 'RECORD CONDITION'
   RCOND11 = 'RECORD CONDITION'
   RCOND12 = 'RECORD CONDITION'
   RCOND13 = 'RECORD CONDITION'
   RCOND14 = 'RECORD CONDITION'
   RCOND15 = 'RECORD CONDITION'
   RCOND16 = 'RECORD CONDITION'
   RCOND17 = 'RECORD CONDITION'
   RCOND18 = 'RECORD CONDITION'
   RCOND19 = 'RECORD CONDITION'
   RCOND20 = 'RECORD CONDITION'
        ;


* SAS FORMAT STATEMENT;

/*
  FORMAT RECTYPE rectype. RESISTAT resistat. STATEOCC stateocc.
         CONTYOCC contyocc. REGION region. DIVISION division.
         STATESUB statesub. EXP_OCC exp_occ. RESIDST residst.
         CNTYRSID $cntyrsf. CITYRSID $cityrsf. POPSIZE $popsize.
         METRO $metro. REGNRES regnres. DIVISRES divisres.
         STSUB stsub. EXP_RES exp_res. PMSA_RES $pmsa_rf.
         POPCNTYO popcntyo. POPCNTYR $popcntf. PMSASIZE $pmsasif.
         EDUCATN educatn. EDUC_R educ_r. DEATHMO deathmo.
         SEX sex. RACE_DET race_det. RACE_R3 race_r3f.
         RACE_R2 race_r2f. AGEUNIT ageunit. AGEREC52 agerec5f.
         AGEREC27 agerec2f. AGEREC12 agerec1f. INFNTAGE $infntaf.
         PLACEDTH placedth. MARSTAT marstat. BIRTH_ST birth_st.
         HISPANIC hispanic. HISP_REC hisp_rec. DAYDEATH daydeath.
         KINDBUSS kindbuss. USUALOCC usualocc. ICD52 icd52fff.
         CITYFIPS cityfips. FIPSTOCC fipstocc. FIPSRES fipsres.
         FIPCNRES fipcnres. MSA_RES msa_res. CMSA_RES cmsa_res.
         INJ_WORK inj_work. RACE_FLG $race_ff. AGE_FLG age_flg.
         PLACEINJ $placeif. ICD282 icd282ff. ICD72 icd72fff.
         ICD61 icd61fff. ICD34 icd34fff.  ;
*/

RUN ;
