/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.matrix.tfloat.algo.solver;

import cern.colt.matrix.tfloat.FloatMatrix1D;
import cern.colt.matrix.tfloat.FloatMatrix2D;
import cern.colt.matrix.tfloat.algo.solver.AbstractFloatIterativeSolver;
import cern.colt.matrix.tfloat.algo.solver.IterativeSolverFloatNotConvergedException;
import cern.jet.math.tfloat.FloatFunctions;

public class FloatCG
extends AbstractFloatIterativeSolver {
    private FloatMatrix1D p;
    private FloatMatrix1D z;
    private FloatMatrix1D q;
    private FloatMatrix1D r;

    public FloatCG(FloatMatrix1D floatMatrix1D) {
        this.p = floatMatrix1D.copy();
        this.z = floatMatrix1D.copy();
        this.q = floatMatrix1D.copy();
        this.r = floatMatrix1D.copy();
    }

    public FloatMatrix1D solve(FloatMatrix2D floatMatrix2D, FloatMatrix1D floatMatrix1D, FloatMatrix1D floatMatrix1D2) throws IterativeSolverFloatNotConvergedException {
        this.checkSizes(floatMatrix2D, floatMatrix1D, floatMatrix1D2);
        float f = 0.0f;
        float f2 = 0.0f;
        float f3 = 0.0f;
        float f4 = 0.0f;
        floatMatrix2D.zMult(floatMatrix1D2, this.r.assign(floatMatrix1D), -1.0f, 1.0f, false);
        this.iter.setFirst();
        while (!this.iter.converged(this.r, floatMatrix1D2)) {
            this.M.apply(this.r, this.z);
            f3 = this.r.zDotProduct(this.z);
            if (this.iter.isFirst()) {
                this.p.assign(this.z);
            } else {
                f2 = f3 / f4;
                this.p.assign(this.z, FloatFunctions.plusMultFirst(f2));
            }
            floatMatrix2D.zMult(this.p, this.q);
            f = f3 / this.p.zDotProduct(this.q);
            floatMatrix1D2.assign(this.p, FloatFunctions.plusMultSecond(f));
            this.r.assign(this.q, FloatFunctions.plusMultSecond(-f));
            f4 = f3;
            this.iter.next();
        }
        return floatMatrix1D2;
    }
}

