/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.matrix.tfcomplex.impl;

import cern.colt.matrix.AbstractMatrix3D;
import cern.colt.matrix.tfcomplex.FComplexMatrix1D;
import cern.colt.matrix.tfcomplex.FComplexMatrix2D;
import cern.colt.matrix.tfcomplex.FComplexMatrix3D;
import cern.colt.matrix.tfcomplex.impl.DenseFComplexMatrix3D;
import cern.colt.matrix.tfcomplex.impl.SelectedDenseFComplexMatrix2D;
import cern.colt.matrix.tfloat.FloatMatrix3D;

class SelectedDenseFComplexMatrix3D
extends FComplexMatrix3D {
    private static final long serialVersionUID = 1L;
    protected float[] elements;
    protected int[] sliceOffsets;
    protected int[] rowOffsets;
    protected int[] columnOffsets;
    protected int offset;

    protected SelectedDenseFComplexMatrix3D(float[] fArray, int[] nArray, int[] nArray2, int[] nArray3, int n) {
        int n2 = nArray.length;
        int n3 = nArray2.length;
        int n4 = nArray3.length;
        this.setUp(n2, n3, n4);
        this.elements = fArray;
        this.sliceOffsets = nArray;
        this.rowOffsets = nArray2;
        this.columnOffsets = nArray3;
        this.offset = n;
        this.isNoView = false;
    }

    protected int _columnOffset(int n) {
        return this.columnOffsets[n];
    }

    protected int _rowOffset(int n) {
        return this.rowOffsets[n];
    }

    protected int _sliceOffset(int n) {
        return this.sliceOffsets[n];
    }

    public float[] getQuick(int n, int n2, int n3) {
        int n4 = this.sliceZero + n * this.sliceStride;
        int n5 = this.rowZero + n2 * this.rowStride;
        int n6 = this.columnZero + n3 * this.columnStride;
        return new float[]{this.elements[this.offset + this.sliceOffsets[n4] + this.rowOffsets[n5] + this.columnOffsets[n6]], this.elements[this.offset + this.sliceOffsets[n4] + this.rowOffsets[n5] + this.columnOffsets[n6] + 1]};
    }

    public float[] elements() {
        throw new IllegalAccessError("This method is not supported.");
    }

    protected boolean haveSharedCellsRaw(FComplexMatrix3D fComplexMatrix3D) {
        if (fComplexMatrix3D instanceof SelectedDenseFComplexMatrix3D) {
            SelectedDenseFComplexMatrix3D selectedDenseFComplexMatrix3D = (SelectedDenseFComplexMatrix3D)fComplexMatrix3D;
            return this.elements == selectedDenseFComplexMatrix3D.elements;
        }
        if (fComplexMatrix3D instanceof DenseFComplexMatrix3D) {
            DenseFComplexMatrix3D denseFComplexMatrix3D = (DenseFComplexMatrix3D)fComplexMatrix3D;
            return this.elements == denseFComplexMatrix3D.elements;
        }
        return false;
    }

    public long index(int n, int n2, int n3) {
        return this.offset + this.sliceOffsets[this.sliceZero + n * this.sliceStride] + this.rowOffsets[this.rowZero + n2 * this.rowStride] + this.columnOffsets[this.columnZero + n3 * this.columnStride];
    }

    public FComplexMatrix3D like(int n, int n2, int n3) {
        return new DenseFComplexMatrix3D(n, n2, n3);
    }

    protected FComplexMatrix2D like2D(int n, int n2, int n3, int n4, int n5, int n6) {
        throw new InternalError();
    }

    public FComplexMatrix2D like2D(int n, int n2) {
        throw new InternalError();
    }

    public void setQuick(int n, int n2, int n3, float[] fArray) {
        int n4 = this.sliceZero + n * this.sliceStride;
        int n5 = this.rowZero + n2 * this.rowStride;
        int n6 = this.columnZero + n3 * this.columnStride;
        this.elements[this.offset + this.sliceOffsets[n4] + this.rowOffsets[n5] + this.columnOffsets[n6]] = fArray[0];
        this.elements[this.offset + this.sliceOffsets[n4] + this.rowOffsets[n5] + this.columnOffsets[n6] + 1] = fArray[1];
    }

    public void setQuick(int n, int n2, int n3, float f, float f2) {
        int n4 = this.sliceZero + n * this.sliceStride;
        int n5 = this.rowZero + n2 * this.rowStride;
        int n6 = this.columnZero + n3 * this.columnStride;
        this.elements[this.offset + this.sliceOffsets[n4] + this.rowOffsets[n5] + this.columnOffsets[n6]] = f;
        this.elements[this.offset + this.sliceOffsets[n4] + this.rowOffsets[n5] + this.columnOffsets[n6] + 1] = f2;
    }

    protected void setUp(int n, int n2, int n3) {
        super.setUp(n, n2, n3);
        this.sliceStride = 1;
        this.rowStride = 1;
        this.columnStride = 1;
        this.offset = 0;
    }

    protected AbstractMatrix3D vDice(int n, int n2, int n3) {
        super.vDice(n, n2, n3);
        int[][] nArrayArray = new int[][]{this.sliceOffsets, this.rowOffsets, this.columnOffsets};
        this.sliceOffsets = nArrayArray[n];
        this.rowOffsets = nArrayArray[n2];
        this.columnOffsets = nArrayArray[n3];
        return this;
    }

    public FComplexMatrix2D viewColumn(int n) {
        this.checkColumn(n);
        int n2 = this.slices;
        int n3 = this.rows;
        int n4 = this.sliceZero;
        int n5 = this.rowZero;
        int n6 = this.offset + this._columnOffset(this._columnRank(n));
        int n7 = this.sliceStride;
        int n8 = this.rowStride;
        int[] nArray = this.sliceOffsets;
        int[] nArray2 = this.rowOffsets;
        return new SelectedDenseFComplexMatrix2D(n2, n3, this.elements, n4, n5, n7, n8, nArray, nArray2, n6);
    }

    public FComplexMatrix2D viewRow(int n) {
        this.checkRow(n);
        int n2 = this.slices;
        int n3 = this.columns;
        int n4 = this.sliceZero;
        int n5 = this.columnZero;
        int n6 = this.offset + this._rowOffset(this._rowRank(n));
        int n7 = this.sliceStride;
        int n8 = this.columnStride;
        int[] nArray = this.sliceOffsets;
        int[] nArray2 = this.columnOffsets;
        return new SelectedDenseFComplexMatrix2D(n2, n3, this.elements, n4, n5, n7, n8, nArray, nArray2, n6);
    }

    protected FComplexMatrix3D viewSelectionLike(int[] nArray, int[] nArray2, int[] nArray3) {
        return new SelectedDenseFComplexMatrix3D(this.elements, nArray, nArray2, nArray3, this.offset);
    }

    public FComplexMatrix2D viewSlice(int n) {
        this.checkSlice(n);
        int n2 = this.rows;
        int n3 = this.columns;
        int n4 = this.rowZero;
        int n5 = this.columnZero;
        int n6 = this.offset + this._sliceOffset(this._sliceRank(n));
        int n7 = this.rowStride;
        int n8 = this.columnStride;
        int[] nArray = this.rowOffsets;
        int[] nArray2 = this.columnOffsets;
        return new SelectedDenseFComplexMatrix2D(n2, n3, this.elements, n4, n5, n7, n8, nArray, nArray2, n6);
    }

    public FComplexMatrix1D vectorize() {
        throw new IllegalAccessError("This method is not supported.");
    }

    public FloatMatrix3D getImaginaryPart() {
        throw new IllegalAccessError("This method is not supported.");
    }

    public FloatMatrix3D getRealPart() {
        throw new IllegalAccessError("This method is not supported.");
    }
}

