/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.matrix.tdcomplex.impl;

import cern.colt.matrix.tdcomplex.DComplexMatrix1D;
import cern.colt.matrix.tdcomplex.DComplexMatrix2D;
import cern.colt.matrix.tdcomplex.impl.DenseDComplexMatrix1D;
import cern.colt.matrix.tdcomplex.impl.WrapperDComplexMatrix2D;
import edu.emory.mathcs.jtransforms.fft.DoubleFFT_1D;
import edu.emory.mathcs.jtransforms.fft.DoubleFFT_2D;
import edu.emory.mathcs.utils.ConcurrencyUtils;
import java.util.concurrent.Future;

public class DenseLargeDComplexMatrix2D
extends WrapperDComplexMatrix2D {
    private static final long serialVersionUID = 1L;
    private double[][] elements;
    private DoubleFFT_2D fft2;
    private DoubleFFT_1D fftRows;
    private DoubleFFT_1D fftColumns;

    public DenseLargeDComplexMatrix2D(int n, int n2) {
        block2: {
            super(null);
            try {
                this.setUp(n, n2);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                if ("matrix too large".equals(illegalArgumentException.getMessage())) break block2;
                throw illegalArgumentException;
            }
        }
        this.elements = new double[n][2 * n2];
        this.content = this;
    }

    public void fft2() {
        int n = ConcurrencyUtils.getNumberOfThreads();
        ConcurrencyUtils.setNumberOfThreads(ConcurrencyUtils.nextPow2(n));
        if (this.fft2 == null) {
            this.fft2 = new DoubleFFT_2D(this.rows, this.columns);
        }
        this.fft2.complexForward(this.elements);
        ConcurrencyUtils.setNumberOfThreads(n);
    }

    public void fftColumns() {
        int n;
        if (this.fftColumns == null) {
            this.fftColumns = new DoubleFFT_1D(this.rows);
        }
        if ((n = ConcurrencyUtils.getNumberOfThreads()) > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_2D()) {
            ConcurrencyUtils.setThreadsBeginN_1D_FFT_2Threads(Integer.MAX_VALUE);
            ConcurrencyUtils.setThreadsBeginN_1D_FFT_4Threads(Integer.MAX_VALUE);
            n = Math.min(n, this.columns);
            Future[] futureArray = new Future[n];
            int n2 = this.columns / n;
            for (int i = 0; i < n; ++i) {
                final int n3 = i * n2;
                final int n4 = i == n - 1 ? this.columns : n3 + n2;
                futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        for (int i = n3; i < n4; ++i) {
                            double[] dArray = (double[])DenseLargeDComplexMatrix2D.this.viewColumn(i).copy().elements();
                            DenseLargeDComplexMatrix2D.this.fftColumns.complexForward(dArray);
                            DenseLargeDComplexMatrix2D.this.viewColumn(i).assign(dArray);
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
            ConcurrencyUtils.resetThreadsBeginN_FFT();
            ConcurrencyUtils.resetThreadsBeginN_FFT();
        } else {
            for (int i = 0; i < this.columns; ++i) {
                double[] dArray = (double[])this.viewColumn(i).copy().elements();
                this.fftColumns.complexForward(dArray);
                this.viewColumn(i).assign(dArray);
            }
        }
    }

    public void fftRows() {
        int n;
        if (this.fftRows == null) {
            this.fftRows = new DoubleFFT_1D(this.columns);
        }
        if ((n = ConcurrencyUtils.getNumberOfThreads()) > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_2D()) {
            ConcurrencyUtils.setThreadsBeginN_1D_FFT_2Threads(Integer.MAX_VALUE);
            ConcurrencyUtils.setThreadsBeginN_1D_FFT_4Threads(Integer.MAX_VALUE);
            n = Math.min(n, this.rows);
            Future[] futureArray = new Future[n];
            int n2 = this.rows / n;
            for (int i = 0; i < n; ++i) {
                final int n3 = i * n2;
                final int n4 = i == n - 1 ? this.rows : n3 + n2;
                futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        for (int i = n3; i < n4; ++i) {
                            DenseLargeDComplexMatrix2D.this.fftRows.complexForward(DenseLargeDComplexMatrix2D.this.elements[i]);
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
            ConcurrencyUtils.resetThreadsBeginN_FFT();
        } else {
            for (int i = 0; i < this.rows; ++i) {
                this.fftRows.complexForward(this.elements[i]);
            }
        }
    }

    public void ifft2(boolean bl) {
        int n = ConcurrencyUtils.getNumberOfThreads();
        ConcurrencyUtils.setNumberOfThreads(ConcurrencyUtils.nextPow2(n));
        if (this.fft2 == null) {
            this.fft2 = new DoubleFFT_2D(this.rows, this.columns);
        }
        this.fft2.complexInverse(this.elements, bl);
        ConcurrencyUtils.setNumberOfThreads(n);
    }

    public void ifftColumns(final boolean bl) {
        int n;
        if (this.fftColumns == null) {
            this.fftColumns = new DoubleFFT_1D(this.rows);
        }
        if ((n = ConcurrencyUtils.getNumberOfThreads()) > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_2D()) {
            ConcurrencyUtils.setThreadsBeginN_1D_FFT_2Threads(Integer.MAX_VALUE);
            ConcurrencyUtils.setThreadsBeginN_1D_FFT_4Threads(Integer.MAX_VALUE);
            n = Math.min(n, this.columns);
            Future[] futureArray = new Future[n];
            int n2 = this.columns / n;
            for (int i = 0; i < n; ++i) {
                final int n3 = i * n2;
                final int n4 = i == n - 1 ? this.columns : n3 + n2;
                futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        for (int i = n3; i < n4; ++i) {
                            double[] dArray = (double[])DenseLargeDComplexMatrix2D.this.viewColumn(i).copy().elements();
                            DenseLargeDComplexMatrix2D.this.fftColumns.complexInverse(dArray, bl);
                            DenseLargeDComplexMatrix2D.this.viewColumn(i).assign(dArray);
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
            ConcurrencyUtils.resetThreadsBeginN_FFT();
        } else {
            for (int i = 0; i < this.columns; ++i) {
                double[] dArray = (double[])this.viewColumn(i).copy().elements();
                this.fftColumns.complexInverse(dArray, bl);
                this.viewColumn(i).assign(dArray);
            }
        }
    }

    public void ifftRows(final boolean bl) {
        int n;
        if (this.fftRows == null) {
            this.fftRows = new DoubleFFT_1D(this.columns);
        }
        if ((n = ConcurrencyUtils.getNumberOfThreads()) > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_2D()) {
            ConcurrencyUtils.setThreadsBeginN_1D_FFT_2Threads(Integer.MAX_VALUE);
            ConcurrencyUtils.setThreadsBeginN_1D_FFT_4Threads(Integer.MAX_VALUE);
            n = Math.min(n, this.rows);
            Future[] futureArray = new Future[n];
            int n2 = this.rows / n;
            for (int i = 0; i < n; ++i) {
                final int n3 = i * n2;
                final int n4 = i == n - 1 ? this.rows : n3 + n2;
                futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        for (int i = n3; i < n4; ++i) {
                            DenseLargeDComplexMatrix2D.this.fftRows.complexInverse(DenseLargeDComplexMatrix2D.this.elements[i], bl);
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
            ConcurrencyUtils.resetThreadsBeginN_FFT();
        } else {
            for (int i = 0; i < this.rows; ++i) {
                this.fftRows.complexInverse(this.elements[i], bl);
            }
        }
    }

    public double[] getQuick(int n, int n2) {
        return new double[]{this.elements[n][2 * n2], this.elements[n][2 * n2 + 1]};
    }

    public void setQuick(int n, int n2, double[] dArray) {
        this.elements[n][2 * n2] = dArray[0];
        this.elements[n][2 * n2 + 1] = dArray[1];
    }

    public void setQuick(int n, int n2, double d, double d2) {
        this.elements[n][2 * n2] = d;
        this.elements[n][2 * n2 + 1] = d2;
    }

    public double[][] elements() {
        return this.elements;
    }

    protected DComplexMatrix2D getContent() {
        return this;
    }

    public DComplexMatrix2D like(int n, int n2) {
        return new DenseLargeDComplexMatrix2D(n, n2);
    }

    public DComplexMatrix1D like1D(int n) {
        return new DenseDComplexMatrix1D(n);
    }
}

