/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.map.tfloat;

import cern.colt.GenericSorting;
import cern.colt.Swapper;
import cern.colt.function.tfloat.FloatFunction;
import cern.colt.function.tfloat.IntFloatProcedure;
import cern.colt.function.tint.IntComparator;
import cern.colt.function.tint.IntProcedure;
import cern.colt.list.tfloat.FloatArrayList;
import cern.colt.list.tint.IntArrayList;
import cern.colt.map.AbstractMap;

public abstract class AbstractIntFloatMap
extends AbstractMap {
    private static final long serialVersionUID = 1L;

    protected AbstractIntFloatMap() {
    }

    public void assign(final FloatFunction floatFunction) {
        this.copy().forEachPair(new IntFloatProcedure(){

            public boolean apply(int n, float f) {
                AbstractIntFloatMap.this.put(n, floatFunction.apply(f));
                return true;
            }
        });
    }

    public void assign(AbstractIntFloatMap abstractIntFloatMap) {
        this.clear();
        abstractIntFloatMap.forEachPair(new IntFloatProcedure(){

            public boolean apply(int n, float f) {
                AbstractIntFloatMap.this.put(n, f);
                return true;
            }
        });
    }

    public boolean containsKey(final int n) {
        return !this.forEachKey(new IntProcedure(){

            public boolean apply(int n2) {
                return n != n2;
            }
        });
    }

    public boolean containsValue(final float f) {
        return !this.forEachPair(new IntFloatProcedure(){

            public boolean apply(int n, float f2) {
                return f != f2;
            }
        });
    }

    public AbstractIntFloatMap copy() {
        return (AbstractIntFloatMap)this.clone();
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof AbstractIntFloatMap)) {
            return false;
        }
        final AbstractIntFloatMap abstractIntFloatMap = (AbstractIntFloatMap)object;
        if (abstractIntFloatMap.size() != this.size()) {
            return false;
        }
        return this.forEachPair(new IntFloatProcedure(){

            public boolean apply(int n, float f) {
                return abstractIntFloatMap.containsKey(n) && abstractIntFloatMap.get(n) == f;
            }
        }) && abstractIntFloatMap.forEachPair(new IntFloatProcedure(){

            public boolean apply(int n, float f) {
                return AbstractIntFloatMap.this.containsKey(n) && AbstractIntFloatMap.this.get(n) == f;
            }
        });
    }

    public abstract boolean forEachKey(IntProcedure var1);

    public boolean forEachPair(final IntFloatProcedure intFloatProcedure) {
        return this.forEachKey(new IntProcedure(){

            public boolean apply(int n) {
                return intFloatProcedure.apply(n, AbstractIntFloatMap.this.get(n));
            }
        });
    }

    public abstract float get(int var1);

    public int keyOf(final float f) {
        final int[] nArray = new int[1];
        boolean bl = this.forEachPair(new IntFloatProcedure(){

            public boolean apply(int n, float f2) {
                boolean bl;
                boolean bl2 = bl = f == f2;
                if (bl) {
                    nArray[0] = n;
                }
                return !bl;
            }
        });
        if (bl) {
            return Integer.MIN_VALUE;
        }
        return nArray[0];
    }

    public IntArrayList keys() {
        IntArrayList intArrayList = new IntArrayList(this.size());
        this.keys(intArrayList);
        return intArrayList;
    }

    public void keys(final IntArrayList intArrayList) {
        intArrayList.clear();
        this.forEachKey(new IntProcedure(){

            public boolean apply(int n) {
                intArrayList.add(n);
                return true;
            }
        });
    }

    public void keysSortedByValue(IntArrayList intArrayList) {
        this.pairsSortedByValue(intArrayList, new FloatArrayList(this.size()));
    }

    public void pairsMatching(final IntFloatProcedure intFloatProcedure, final IntArrayList intArrayList, final FloatArrayList floatArrayList) {
        intArrayList.clear();
        floatArrayList.clear();
        this.forEachPair(new IntFloatProcedure(){

            public boolean apply(int n, float f) {
                if (intFloatProcedure.apply(n, f)) {
                    intArrayList.add(n);
                    floatArrayList.add(f);
                }
                return true;
            }
        });
    }

    public void pairsSortedByKey(IntArrayList intArrayList, FloatArrayList floatArrayList) {
        this.keys(intArrayList);
        intArrayList.sort();
        floatArrayList.setSize(intArrayList.size());
        int n = intArrayList.size();
        while (--n >= 0) {
            floatArrayList.setQuick(n, this.get(intArrayList.getQuick(n)));
        }
    }

    public void pairsSortedByValue(IntArrayList intArrayList, FloatArrayList floatArrayList) {
        this.keys(intArrayList);
        this.values(floatArrayList);
        final int[] nArray = intArrayList.elements();
        final float[] fArray = floatArrayList.elements();
        Swapper swapper = new Swapper(){

            public void swap(int n, int n2) {
                float f = fArray[n];
                fArray[n] = fArray[n2];
                fArray[n2] = f;
                int n3 = nArray[n];
                nArray[n] = nArray[n2];
                nArray[n2] = n3;
            }
        };
        IntComparator intComparator = new IntComparator(){

            public int compare(int n, int n2) {
                return fArray[n] < fArray[n2] ? -1 : (fArray[n] > fArray[n2] ? 1 : (nArray[n] < nArray[n2] ? -1 : (nArray[n] == nArray[n2] ? 0 : 1)));
            }
        };
        GenericSorting.quickSort(0, intArrayList.size(), intComparator, swapper);
    }

    public abstract boolean put(int var1, float var2);

    public abstract boolean removeKey(int var1);

    public String toString() {
        IntArrayList intArrayList = this.keys();
        String string = intArrayList.toString() + "\n";
        intArrayList.sort();
        StringBuffer stringBuffer = new StringBuffer(string);
        stringBuffer.append("[");
        int n = intArrayList.size() - 1;
        for (int i = 0; i <= n; ++i) {
            int n2 = intArrayList.get(i);
            stringBuffer.append(String.valueOf(n2));
            stringBuffer.append("->");
            stringBuffer.append(String.valueOf(this.get(n2)));
            if (i >= n) continue;
            stringBuffer.append(", ");
        }
        stringBuffer.append("]");
        return stringBuffer.toString();
    }

    public String toStringByValue() {
        IntArrayList intArrayList = new IntArrayList();
        this.keysSortedByValue(intArrayList);
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("[");
        int n = intArrayList.size() - 1;
        for (int i = 0; i <= n; ++i) {
            int n2 = intArrayList.get(i);
            stringBuffer.append(String.valueOf(n2));
            stringBuffer.append("->");
            stringBuffer.append(String.valueOf(this.get(n2)));
            if (i >= n) continue;
            stringBuffer.append(", ");
        }
        stringBuffer.append("]");
        return stringBuffer.toString();
    }

    public FloatArrayList values() {
        FloatArrayList floatArrayList = new FloatArrayList(this.size());
        this.values(floatArrayList);
        return floatArrayList;
    }

    public void values(final FloatArrayList floatArrayList) {
        floatArrayList.clear();
        this.forEachKey(new IntProcedure(){

            public boolean apply(int n) {
                floatArrayList.add(AbstractIntFloatMap.this.get(n));
                return true;
            }
        });
    }
}

