/*
 * Decompiled with CFR 0.152.
 */
package org.ohdsi.circe.check.checkers;

import java.util.Objects;
import java.util.function.Consumer;
import org.ohdsi.circe.check.checkers.BaseCheckerFactory;
import org.ohdsi.circe.check.checkers.WarningReporter;
import org.ohdsi.circe.check.operations.Operations;
import org.ohdsi.circe.cohortdefinition.ConceptSetSelection;
import org.ohdsi.circe.cohortdefinition.Criteria;
import org.ohdsi.circe.cohortdefinition.DemographicCriteria;
import org.ohdsi.circe.cohortdefinition.VisitDetail;

public class ConceptSetSelectionCheckerFactory
extends BaseCheckerFactory {
    private static final String WARNING_EMPTY_VALUE = "%s in the %s has empty %s value";

    private ConceptSetSelectionCheckerFactory(WarningReporter reporter, String groupName) {
        super(reporter, groupName);
    }

    public static ConceptSetSelectionCheckerFactory getFactory(WarningReporter reporter, String groupName) {
        return new ConceptSetSelectionCheckerFactory(reporter, groupName);
    }

    @Override
    protected Consumer<Criteria> getCheck(Criteria criteria) {
        Consumer<Criteria> result = c -> {};
        if (criteria instanceof VisitDetail) {
            result = c -> {
                VisitDetail vd = (VisitDetail)c;
                this.checkConcept(vd.visitDetailTypeCS, "visit detail", "visit detail type");
                this.checkConcept(vd.genderCS, "visit detail", "gender");
                this.checkConcept(vd.providerSpecialtyCS, "visit detail", "provider speciality");
                this.checkConcept(vd.placeOfServiceCS, "visit detail", "place of service");
            };
        }
        return result;
    }

    @Override
    protected Consumer<DemographicCriteria> getCheck(DemographicCriteria criteria) {
        return c -> {};
    }

    private void checkConcept(ConceptSetSelection conceptSetSelection, String criteriaName, String attribute) {
        Consumer<String> warning = t -> this.reporter.add((String)t, this.groupName, criteriaName, attribute);
        Operations.match(conceptSetSelection).when(r -> Objects.nonNull(r) && Objects.isNull(r.codesetId)).then(() -> warning.accept(WARNING_EMPTY_VALUE));
    }
}

