/*
 * Decompiled with CFR 0.152.
 */
package jebl.evolution.align;

import java.util.ArrayList;
import java.util.List;
import jebl.evolution.align.AlignSimple;
import jebl.evolution.align.Traceback;
import jebl.evolution.align.TracebackSimple;
import jebl.evolution.align.scores.Scores;

public class NeedlemanWunsch
extends AlignSimple {
    private int prev = 0;
    private int curr = 1;
    private float maxScore = 0.0f;

    public NeedlemanWunsch(Scores sub, float d) {
        super(sub, d);
    }

    public void doAlignment(String sq1, String sq2) {
        this.prepareAlignment(sq1, sq2);
        char[] s1 = sq1.toCharArray();
        char[] s2 = sq2.toCharArray();
        int n = this.n;
        int m = this.m;
        float[][] score = this.sub.score;
        this.F[this.curr][0] = -this.d;
        for (int i = 1; i <= n; ++i) {
            this.B[i][0].setTraceback(i - 1, 0);
        }
        for (int j = 1; j <= m; ++j) {
            this.F[this.prev][j] = -this.d * (float)j;
            this.B[0][j].setTraceback(0, j - 1);
        }
        for (int i = 1; i <= n; ++i) {
            for (int j = 1; j <= m; ++j) {
                float val;
                float s = score[s1[i - 1]][s2[j - 1]];
                this.F[this.curr][j] = val = NeedlemanWunsch.max(this.F[this.prev][j - 1] + s, this.F[this.prev][j] - this.d, this.F[this.curr][j - 1] - this.d);
                if (val == this.F[this.prev][j - 1] + s) {
                    this.B[i][j].setTraceback(i - 1, j - 1);
                    continue;
                }
                if (val == this.F[this.prev][j] - this.d) {
                    this.B[i][j].setTraceback(i - 1, j);
                    continue;
                }
                if (val == this.F[this.curr][j - 1] - this.d) {
                    this.B[i][j].setTraceback(i, j - 1);
                    continue;
                }
                throw new Error("Error in Needleman-Wunch pairwise alignment.");
            }
            int temp = this.prev;
            this.prev = this.curr;
            this.curr = temp;
            this.F[this.curr][0] = -this.d * (float)(i + 1);
        }
        this.B0 = new TracebackSimple(n, m);
        this.maxScore = this.F[this.curr][m];
    }

    List tracebackList(int startx, int starty) {
        ArrayList<TracebackSimple> tracebacks = new ArrayList<TracebackSimple>();
        Traceback tb = this.B0;
        while (tb != null) {
            tracebacks.add(0, new TracebackSimple(tb.i + startx, tb.j + starty));
            tb = this.next(tb);
        }
        return tracebacks;
    }

    public float getScore() {
        return this.maxScore;
    }
}

