/*
 * Decompiled with CFR 0.152.
 */
package dr.util;

import dr.inference.model.Parameter;
import dr.inference.model.TransformedMultivariateParameter;
import dr.util.Transform;
import dr.xml.AbstractXMLObjectParser;
import dr.xml.XMLObject;
import dr.xml.XMLParseException;
import dr.xml.XMLSyntaxRule;

public class MultiplicativeProcessTransform
extends Transform.MultivariateTransform {
    private static final String MULTIPLICATIVE_PROCESS = "multiplicativeProcess";
    private final int dim;
    public static final AbstractXMLObjectParser PARSER = new AbstractXMLObjectParser(){

        @Override
        public TransformedMultivariateParameter parseXMLObject(XMLObject xMLObject) throws XMLParseException {
            String string = xMLObject.hasId() ? xMLObject.getId() : null;
            Parameter parameter = (Parameter)xMLObject.getChild(Parameter.class);
            int n = parameter.getDimension();
            MultiplicativeProcessTransform multiplicativeProcessTransform = new MultiplicativeProcessTransform(n);
            return new TransformedMultivariateParameter(parameter, multiplicativeProcessTransform);
        }

        @Override
        public XMLSyntaxRule[] getSyntaxRules() {
            return new XMLSyntaxRule[0];
        }

        @Override
        public String getParserDescription() {
            return null;
        }

        @Override
        public Class getReturnType() {
            return TransformedMultivariateParameter.class;
        }

        @Override
        public String getParserName() {
            return "multiplicativeParameter";
        }
    };

    public MultiplicativeProcessTransform(int n) {
        super(n);
        this.dim = n;
    }

    @Override
    public double[] inverse(double[] dArray, int n, int n2, double d) {
        throw new RuntimeException("not implemented");
    }

    @Override
    public double[] gradient(double[] dArray, int n, int n2) {
        throw new RuntimeException("not implemented");
    }

    @Override
    public double[] gradientInverse(double[] dArray, int n, int n2) {
        throw new RuntimeException("not implemented");
    }

    @Override
    public String getTransformName() {
        return MULTIPLICATIVE_PROCESS;
    }

    @Override
    protected double[] transform(double[] dArray) {
        double d = 1.0;
        double[] dArray2 = new double[this.dim];
        for (int i = 0; i < this.dim; ++i) {
            dArray2[i] = d *= dArray[i];
        }
        return dArray2;
    }

    @Override
    protected double[] inverse(double[] dArray) {
        double[] dArray2 = new double[this.dim];
        dArray2[0] = dArray[0];
        for (int i = 1; i < this.dim; ++i) {
            dArray2[i] = dArray[i] / dArray[i - 1];
        }
        return dArray2;
    }

    @Override
    protected double getLogJacobian(double[] dArray) {
        throw new RuntimeException("not implemented");
    }

    @Override
    protected double[] getGradientLogJacobianInverse(double[] dArray) {
        return new double[0];
    }

    @Override
    public double[][] computeJacobianMatrixInverse(double[] dArray) {
        return new double[0][];
    }

    @Override
    protected boolean isInInteriorDomain(double[] dArray) {
        return false;
    }
}

