/*
 * Decompiled with CFR 0.152.
 */
package dr.inference.smc;

import dr.inference.loggers.LogColumn;
import dr.inference.loggers.Loggable;
import dr.inference.loggers.Logger;
import dr.inference.markovchain.MarkovChain;
import dr.inference.markovchain.MarkovChainListener;
import dr.inference.mcmc.MCMCCriterion;
import dr.inference.model.Likelihood;
import dr.inference.model.Model;
import dr.inference.operators.OperatorSchedule;
import dr.inference.smc.SMCOptions;
import dr.inference.state.StateLoaderSaver;
import dr.util.Identifiable;
import dr.util.NumberFormatter;
import dr.util.Timer;
import dr.xml.Spawnable;
import java.util.ArrayList;
import java.util.List;

public class SMC
implements Identifiable,
Spawnable,
Loggable {
    private final MarkovChainListener chainListener = new MarkovChainListener(){

        @Override
        public void currentState(long l, MarkovChain markovChain, Model model) {
            SMC.this.currentState = l;
            if (SMC.this.loggers != null) {
                for (Logger logger : SMC.this.loggers) {
                    logger.log(l);
                }
            }
        }

        @Override
        public void bestState(long l, MarkovChain markovChain, Model model) {
        }

        @Override
        public void finished(long l, MarkovChain markovChain) {
            SMC.this.currentState = l;
            if (SMC.this.loggers != null) {
                for (Logger logger : SMC.this.loggers) {
                    logger.log(SMC.this.currentState);
                    logger.stopLogging();
                }
            }
        }
    };
    private boolean spawnable = true;
    private final Timer timer = new Timer();
    private long currentState = 0L;
    private final NumberFormatter formatter = new NumberFormatter(8);
    private MarkovChain mc;
    private SMCOptions options;
    private final List<StateLoaderSaver> particleStates = new ArrayList<StateLoaderSaver>();
    private Logger[] loggers;
    private OperatorSchedule schedule;
    private String id = null;

    public SMC(String string, List<StateLoaderSaver> list) {
        this.id = string;
        this.particleStates.addAll(list);
    }

    public void init(SMCOptions sMCOptions, Likelihood likelihood, OperatorSchedule operatorSchedule, Logger[] loggerArray) {
        MCMCCriterion mCMCCriterion = new MCMCCriterion();
        this.mc = new MarkovChain(likelihood, operatorSchedule, mCMCCriterion, 0L, 0, 0.0, false, false);
        this.options = sMCOptions;
        this.loggers = loggerArray;
        this.schedule = operatorSchedule;
        this.currentState = 0L;
    }

    public MarkovChain getMarkovChain() {
        return this.mc;
    }

    public Logger[] getLoggers() {
        return this.loggers;
    }

    public OperatorSchedule getOperatorSchedule() {
        return this.schedule;
    }

    @Override
    public void run() {
        this.chain();
    }

    public void chain() {
        this.currentState = 0L;
        this.timer.start();
        if (this.loggers != null) {
            for (Logger logger : this.loggers) {
                logger.startLogging();
            }
        }
        this.mc.addMarkovChainListener(this.chainListener);
        for (StateLoaderSaver stateLoaderSaver : this.particleStates) {
            stateLoaderSaver.loadState(this.mc, new double[1]);
            this.mc.setCurrentLength(0L);
            this.mc.runChain(this.options.getChainLength(), true);
            stateLoaderSaver.saveState(this.mc, this.mc.getCurrentLength(), this.mc.getCurrentScore());
        }
        this.mc.terminateChain();
        this.mc.removeMarkovChainListener(this.chainListener);
        this.timer.stop();
    }

    @Override
    public LogColumn[] getColumns() {
        return new LogColumn[]{new LogColumn(){

            @Override
            public void setLabel(String string) {
            }

            @Override
            public String getLabel() {
                return "time";
            }

            @Override
            public void setMinimumWidth(int n) {
            }

            @Override
            public int getMinimumWidth() {
                return 0;
            }

            @Override
            public String getFormatted() {
                return Double.toString(SMC.this.getTimer().toSeconds());
            }
        }};
    }

    public Likelihood getLikelihood() {
        return this.mc.getLikelihood();
    }

    public Timer getTimer() {
        return this.timer;
    }

    public final long getCurrentState() {
        return this.currentState;
    }

    public final double getProgress() {
        return (double)this.currentState / (double)this.options.getChainLength();
    }

    @Override
    public boolean getSpawnable() {
        return true;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public void setId(String string) {
        this.id = string;
    }
}

