/*
 * Decompiled with CFR 0.152.
 */
package dr.inference.distribution;

import dr.inference.distribution.ParametricDistributionModel;
import dr.inference.model.AbstractModel;
import dr.inference.model.Model;
import dr.inference.model.Parameter;
import dr.inference.model.Variable;
import dr.math.UnivariateFunction;
import dr.math.distributions.NegativeBinomialDistribution;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class NegativeBinomialDistributionModel
extends AbstractModel
implements ParametricDistributionModel {
    private final UnivariateFunction pdfFunction = new UnivariateFunction(){

        @Override
        public final double evaluate(double d) {
            return NegativeBinomialDistributionModel.this.pdf(d);
        }

        @Override
        public final double getLowerBound() {
            return 0.0;
        }

        @Override
        public final double getUpperBound() {
            return Double.POSITIVE_INFINITY;
        }
    };
    private final Variable<Double> mean;
    private final Variable<Double> alpha;

    public NegativeBinomialDistributionModel(Variable<Double> variable, Variable<Double> variable2) {
        super("negativeBinomialDistributionModel");
        this.mean = variable;
        this.addVariable(variable);
        variable.addBounds(new Parameter.DefaultBounds(Double.POSITIVE_INFINITY, 0.0, 1));
        this.alpha = variable2;
        this.addVariable(variable2);
        variable2.addBounds(new Parameter.DefaultBounds(Double.POSITIVE_INFINITY, 0.0, 1));
    }

    @Override
    public double pdf(double d) {
        return NegativeBinomialDistribution.pdf(d, this.mean(), this.alpha());
    }

    @Override
    public double logPdf(double d) {
        return NegativeBinomialDistribution.logPdf(d, this.mean(), this.alpha());
    }

    @Override
    public double cdf(double d) {
        return NegativeBinomialDistribution.cdf(d, this.mean(), this.alpha());
    }

    @Override
    public double quantile(double d) {
        throw new RuntimeException("Not implemented.");
    }

    @Override
    public double mean() {
        return this.mean.getValue(0);
    }

    public double alpha() {
        return this.alpha.getValue(0);
    }

    @Override
    public double variance() {
        throw new RuntimeException("Not implemented!");
    }

    @Override
    public final UnivariateFunction getProbabilityDensityFunction() {
        return this.pdfFunction;
    }

    @Override
    public double logPdf(double[] dArray) {
        return this.logPdf(dArray[0]);
    }

    @Override
    public Variable<Double> getLocationVariable() {
        return this.mean;
    }

    @Override
    public void handleModelChangedEvent(Model model, Object object, int n) {
    }

    @Override
    protected final void handleVariableChangedEvent(Variable variable, int n, Variable.ChangeType changeType) {
        this.fireModelChanged();
    }

    @Override
    protected void storeState() {
    }

    @Override
    protected void restoreState() {
    }

    @Override
    protected void acceptState() {
    }

    @Override
    public Element createElement(Document document) {
        throw new RuntimeException("Not implemented!");
    }
}

