/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.jinjava.loader;

import com.hubspot.jinjava.interpret.JinjavaInterpreter;
import com.hubspot.jinjava.loader.ResourceLocator;
import com.hubspot.jinjava.loader.ResourceNotFoundException;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.Arrays;

public class CascadingResourceLocator
implements ResourceLocator {
    private Iterable<ResourceLocator> locators;

    public CascadingResourceLocator(ResourceLocator ... locators) {
        this.locators = Arrays.asList(locators);
    }

    @Override
    public String getString(String fullName, Charset encoding, JinjavaInterpreter interpreter) throws IOException {
        for (ResourceLocator locator : this.locators) {
            try {
                return locator.getString(fullName, encoding, interpreter);
            }
            catch (ResourceNotFoundException resourceNotFoundException) {
            }
        }
        throw new ResourceNotFoundException("Couldn't find resource: " + fullName);
    }
}

