/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zeppelin.spark;

import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.spark.SparkContext;
import org.apache.spark.sql.AnalysisException;
import org.apache.spark.sql.SQLContext;
import org.apache.zeppelin.interpreter.AbstractInterpreter;
import org.apache.zeppelin.interpreter.Interpreter;
import org.apache.zeppelin.interpreter.InterpreterContext;
import org.apache.zeppelin.interpreter.InterpreterException;
import org.apache.zeppelin.interpreter.InterpreterResult;
import org.apache.zeppelin.interpreter.ZeppelinContext;
import org.apache.zeppelin.interpreter.util.SqlSplitter;
import org.apache.zeppelin.scheduler.Scheduler;
import org.apache.zeppelin.scheduler.SchedulerFactory;
import org.apache.zeppelin.spark.SparkInterpreter;
import org.apache.zeppelin.spark.Utils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SparkSqlInterpreter
extends AbstractInterpreter {
    private static final Logger LOGGER = LoggerFactory.getLogger(SparkSqlInterpreter.class);
    private SparkInterpreter sparkInterpreter;
    private SqlSplitter sqlSplitter;

    public SparkSqlInterpreter(Properties property) {
        super(property);
    }

    public void open() throws InterpreterException {
        this.sparkInterpreter = (SparkInterpreter)((Object)this.getInterpreterInTheSameSessionByClassName(SparkInterpreter.class));
        this.sqlSplitter = new SqlSplitter();
    }

    private boolean concurrentSQL() {
        return Boolean.parseBoolean(this.getProperty("zeppelin.spark.concurrentSQL"));
    }

    public void close() {
    }

    protected boolean isInterpolate() {
        return Boolean.parseBoolean(this.getProperty("zeppelin.spark.sql.interpolation", "false"));
    }

    public ZeppelinContext getZeppelinContext() {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InterpreterResult internalInterpret(String st, InterpreterContext context) throws InterpreterException {
        if (this.sparkInterpreter.isUnsupportedSparkVersion()) {
            return new InterpreterResult(InterpreterResult.Code.ERROR, "Spark " + this.sparkInterpreter.getSparkVersion().toString() + " is not supported");
        }
        Utils.printDeprecateMessage(this.sparkInterpreter.getSparkVersion(), context, this.properties);
        this.sparkInterpreter.getZeppelinContext().setInterpreterContext(context);
        SQLContext sqlContext = this.sparkInterpreter.getSQLContext();
        SparkContext sc = this.sparkInterpreter.getSparkContext();
        List sqls = this.sqlSplitter.splitSql(st);
        int maxResult = Integer.parseInt((String)((Object)context.getLocalProperties().getOrDefault("limit", "" + this.sparkInterpreter.getZeppelinContext().getMaxResult())));
        sc.setLocalProperty("spark.scheduler.pool", (String)context.getLocalProperties().get("pool"));
        sc.setJobGroup(Utils.buildJobGroupId(context), Utils.buildJobDesc(context), false);
        String curSql = null;
        ClassLoader originalClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(this.sparkInterpreter.getScalaShellClassLoader());
            Iterator iterator = sqls.iterator();
            while (iterator.hasNext()) {
                String sql;
                curSql = sql = (String)iterator.next();
                String result = this.sparkInterpreter.getZeppelinContext().showData((Object)sqlContext.sql(sql), maxResult);
                context.out.write(result);
            }
            context.out.flush();
        }
        catch (Exception e) {
            StringBuilder msgBuilder;
            try {
                if (e.getCause() instanceof AnalysisException) {
                    context.out.write(e.getCause().getMessage());
                    context.out.flush();
                    InterpreterResult sql = new InterpreterResult(InterpreterResult.Code.ERROR);
                    return sql;
                }
                LOGGER.error("Error happens in sql: {}", (Object)curSql, (Object)e);
            }
            catch (IOException ex) {
                LOGGER.error("Fail to write output", ex);
                InterpreterResult interpreterResult = new InterpreterResult(InterpreterResult.Code.ERROR);
                return interpreterResult;
            }
            context.out.write("\nError happens in sql: " + curSql + "\n");
            if (Boolean.parseBoolean(this.getProperty("zeppelin.spark.sql.stacktrace", "false"))) {
                if (e.getCause() != null) {
                    context.out.write(ExceptionUtils.getStackTrace(e.getCause()));
                } else {
                    context.out.write(ExceptionUtils.getStackTrace(e));
                }
            } else {
                msgBuilder = new StringBuilder();
                if (e.getCause() != null) {
                    msgBuilder.append(e.getCause().getMessage());
                } else {
                    msgBuilder.append(e.getMessage());
                }
                msgBuilder.append("\nset zeppelin.spark.sql.stacktrace = true to see full stacktrace");
                context.out.write(msgBuilder.toString());
            }
            context.out.flush();
            msgBuilder = new InterpreterResult(InterpreterResult.Code.ERROR);
            return msgBuilder;
        }
        finally {
            sc.clearJobGroup();
            Thread.currentThread().setContextClassLoader(originalClassLoader);
        }
        return new InterpreterResult(InterpreterResult.Code.SUCCESS);
    }

    public void cancel(InterpreterContext context) throws InterpreterException {
        SparkContext sc = this.sparkInterpreter.getSparkContext();
        sc.cancelJobGroup(Utils.buildJobGroupId(context));
    }

    public Interpreter.FormType getFormType() {
        return Interpreter.FormType.SIMPLE;
    }

    public int getProgress(InterpreterContext context) throws InterpreterException {
        return this.sparkInterpreter.getProgress(context);
    }

    public Scheduler getScheduler() {
        if (this.concurrentSQL()) {
            int maxConcurrency = Integer.parseInt(this.getProperty("zeppelin.spark.concurrentSQL.max", "10"));
            return SchedulerFactory.singleton().createOrGetParallelScheduler(SparkSqlInterpreter.class.getName() + ((Object)((Object)this)).hashCode(), maxConcurrency);
        }
        try {
            return ((SparkInterpreter)((Object)this.getInterpreterInTheSameSessionByClassName(SparkInterpreter.class, false))).getScheduler();
        }
        catch (InterpreterException e) {
            throw new RuntimeException("Fail to getScheduler", e);
        }
    }
}

