/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sisu.plexus;

import java.lang.annotation.Annotation;
import javax.inject.Inject;
import org.eclipse.sisu.inject.BeanLocator;
import org.eclipse.sisu.plexus.DefaultPlexusBeans;
import org.eclipse.sisu.plexus.HintedPlexusBeans;
import org.eclipse.sisu.plexus.PlexusBean;
import org.eclipse.sisu.plexus.PlexusBeanLocator;
import org.eclipse.sisu.plexus.RealmFilteredBeans;
import shaded.org.apache.zeppelin.com.google.inject.Key;
import shaded.org.apache.zeppelin.com.google.inject.Singleton;
import shaded.org.apache.zeppelin.com.google.inject.TypeLiteral;
import shaded.org.apache.zeppelin.com.google.inject.name.Named;
import shaded.org.apache.zeppelin.com.google.inject.name.Names;

@Singleton
public final class DefaultPlexusBeanLocator
implements PlexusBeanLocator {
    private final BeanLocator beanLocator;
    private final String visibility;

    @Inject
    public DefaultPlexusBeanLocator(BeanLocator beanLocator) {
        this(beanLocator, null);
    }

    public DefaultPlexusBeanLocator(BeanLocator beanLocator, String visibility) {
        this.beanLocator = beanLocator;
        this.visibility = visibility;
    }

    @Override
    public <T> Iterable<PlexusBean<T>> locate(TypeLiteral<T> role, String ... hints) {
        Key key = hints.length == 1 ? Key.get(role, (Annotation)Names.named((String)hints[0])) : Key.get(role, Named.class);
        Iterable beans = this.beanLocator.locate(key);
        if ("realm".equalsIgnoreCase(this.visibility)) {
            beans = new RealmFilteredBeans(beans);
        }
        return hints.length <= 1 ? new DefaultPlexusBeans(beans) : new HintedPlexusBeans(beans, role, hints);
    }
}

