/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sisu.launch;

import java.io.File;
import java.lang.annotation.Annotation;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import javax.inject.Inject;
import org.eclipse.sisu.inject.MutableBeanLocator;
import org.eclipse.sisu.space.BeanScanning;
import org.eclipse.sisu.space.ClassSpace;
import org.eclipse.sisu.space.SpaceModule;
import org.eclipse.sisu.space.URLClassSpace;
import org.eclipse.sisu.wire.ParameterKeys;
import org.eclipse.sisu.wire.WireModule;
import shaded.org.apache.zeppelin.com.google.inject.Binder;
import shaded.org.apache.zeppelin.com.google.inject.Guice;
import shaded.org.apache.zeppelin.com.google.inject.Key;
import shaded.org.apache.zeppelin.com.google.inject.Module;
import shaded.org.apache.zeppelin.com.google.inject.name.Names;
import shaded.org.apache.zeppelin.org.junit.After;
import shaded.org.apache.zeppelin.org.junit.Before;
import shaded.org.apache.zeppelin.org.testng.annotations.AfterMethod;
import shaded.org.apache.zeppelin.org.testng.annotations.BeforeMethod;

public abstract class InjectedTest
implements Module {
    private String basedir;
    @Inject
    private MutableBeanLocator locator;

    @Before
    @BeforeMethod
    public void setUp() throws Exception {
        Guice.createInjector((Module[])new Module[]{new WireModule(new SetUpModule(), this.spaceModule())});
    }

    @After
    @AfterMethod
    public void tearDown() throws Exception {
        this.locator.clear();
    }

    public SpaceModule spaceModule() {
        return new SpaceModule(this.space(), this.scanning());
    }

    public ClassSpace space() {
        return new URLClassSpace(this.getClass().getClassLoader());
    }

    public BeanScanning scanning() {
        return BeanScanning.CACHE;
    }

    public void configure(Binder binder) {
    }

    public void configure(Properties properties) {
    }

    public final <T> T lookup(Class<T> type) {
        return this.lookup(Key.get(type));
    }

    public final <T> T lookup(Class<T> type, String name) {
        return this.lookup(type, (Annotation)Names.named((String)name));
    }

    public final <T> T lookup(Class<T> type, Class<? extends Annotation> qualifier) {
        return this.lookup(Key.get(type, qualifier));
    }

    public final <T> T lookup(Class<T> type, Annotation qualifier) {
        return this.lookup(Key.get(type, (Annotation)qualifier));
    }

    public final String getBasedir() {
        if (this.basedir == null) {
            this.basedir = System.getProperty("basedir", new File("").getAbsolutePath());
        }
        return this.basedir;
    }

    private <T> T lookup(Key<T> key) {
        Iterator i = this.locator.locate(key).iterator();
        return i.hasNext() ? (T)((Map.Entry)i.next()).getValue() : null;
    }

    final class SetUpModule
    implements Module {
        SetUpModule() {
        }

        public void configure(Binder binder) {
            binder.install((Module)InjectedTest.this);
            Properties properties = new Properties();
            properties.put("basedir", InjectedTest.this.getBasedir());
            InjectedTest.this.configure(properties);
            binder.bind(ParameterKeys.PROPERTIES).toInstance((Object)properties);
            binder.requestInjection((Object)InjectedTest.this);
        }
    }
}

