/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sisu.inject;

import org.eclipse.sisu.Hidden;
import org.eclipse.sisu.inject.BindingPublisher;
import org.eclipse.sisu.inject.InjectorBindings;
import org.eclipse.sisu.inject.Logs;
import org.eclipse.sisu.inject.Sources;
import org.eclipse.sisu.inject.TypeArguments;
import shaded.org.apache.zeppelin.com.google.inject.Binding;
import shaded.org.apache.zeppelin.com.google.inject.Injector;
import shaded.org.apache.zeppelin.com.google.inject.Key;
import shaded.org.apache.zeppelin.com.google.inject.TypeLiteral;

final class ImplicitBindings {
    private final Iterable<BindingPublisher> publishers;

    ImplicitBindings(Iterable<BindingPublisher> publishers) {
        this.publishers = publishers;
    }

    public <T> Binding<T> get(TypeLiteral<T> type) {
        Key implicitKey = TypeArguments.implicitKey(type.getRawType());
        for (BindingPublisher p : this.publishers) {
            Injector i;
            Binding binding;
            if (!(p instanceof InjectorBindings) || (binding = (Binding)(i = ((InjectorBindings)p).getInjector()).getBindings().get(implicitKey)) == null) continue;
            Logs.trace("Using implicit binding: {} from: <>", binding, i);
            return binding;
        }
        Key justInTimeKey = Key.get(type);
        for (BindingPublisher p : this.publishers) {
            if (!(p instanceof InjectorBindings)) continue;
            Injector i = ((InjectorBindings)p).getInjector();
            try {
                Binding binding = i.getBinding(justInTimeKey);
                if (Sources.getAnnotation(binding, Hidden.class) != null) continue;
                Logs.trace("Using just-in-time binding: {} from: <>", binding, i);
                return binding;
            }
            catch (RuntimeException e) {
                Logs.trace("Problem with just-in-time binding: {}", justInTimeKey, e);
            }
            catch (LinkageError e) {
                Logs.trace("Problem with just-in-time binding: {}", justInTimeKey, e);
            }
        }
        return null;
    }
}

