/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zeppelin.interpreter.lifecycle;

import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.zeppelin.conf.ZeppelinConfiguration;
import org.apache.zeppelin.interpreter.LifecycleManager;
import org.apache.zeppelin.interpreter.remote.RemoteInterpreterServer;
import org.apache.zeppelin.scheduler.ExecutorFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import shaded.org.apache.zeppelin.org.apache.thrift.TException;

public class TimeoutLifecycleManager
extends LifecycleManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(TimeoutLifecycleManager.class);
    private long lastBusyTimeInMillis;

    public TimeoutLifecycleManager(ZeppelinConfiguration zConf, RemoteInterpreterServer remoteInterpreterServer) {
        super(zConf, remoteInterpreterServer);
        long checkInterval = zConf.getTime(ZeppelinConfiguration.ConfVars.ZEPPELIN_INTERPRETER_LIFECYCLE_MANAGER_TIMEOUT_CHECK_INTERVAL);
        long timeoutThreshold = zConf.getTime(ZeppelinConfiguration.ConfVars.ZEPPELIN_INTERPRETER_LIFECYCLE_MANAGER_TIMEOUT_THRESHOLD);
        ScheduledExecutorService checkScheduler = ExecutorFactory.singleton().createOrGetScheduled("TimeoutLifecycleManager", 1);
        checkScheduler.scheduleAtFixedRate(() -> {
            if (System.currentTimeMillis() - this.lastBusyTimeInMillis > timeoutThreshold) {
                LOGGER.info("Interpreter process idle time exceed threshold, try to stop it");
                try {
                    remoteInterpreterServer.shutdown();
                }
                catch (TException e) {
                    LOGGER.error("Fail to shutdown RemoteInterpreterServer", (Throwable)e);
                }
            } else {
                LOGGER.debug("Check idle time of interpreter");
            }
        }, checkInterval, checkInterval, TimeUnit.MILLISECONDS);
        LOGGER.info("TimeoutLifecycleManager is started with checkInterval: {}, timeoutThreshold: \u00b8{}", (Object)checkInterval, (Object)timeoutThreshold);
    }

    @Override
    public void onInterpreterProcessStarted(String interpreterGroupId) {
        LOGGER.info("Interpreter process: {} is started", (Object)interpreterGroupId);
        this.lastBusyTimeInMillis = System.currentTimeMillis();
    }

    @Override
    public void onInterpreterUse(String interpreterGroupId) {
        LOGGER.debug("Interpreter process: {} is used", (Object)interpreterGroupId);
        this.lastBusyTimeInMillis = System.currentTimeMillis();
    }
}

