/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zeppelin.notebook;

import com.google.gson.ExclusionStrategy;
import com.google.gson.FieldAttributes;
import java.util.HashSet;
import java.util.Set;
import org.apache.zeppelin.conf.ZeppelinConfiguration;
import org.apache.zeppelin.notebook.Paragraph;

public class NoteJsonExclusionStrategy
implements ExclusionStrategy {
    private Set<String> noteExcludeFields = new HashSet<String>();
    private Set<String> paragraphExcludeFields = new HashSet<String>();

    public NoteJsonExclusionStrategy(ZeppelinConfiguration zConf) {
        String[] excludeFields;
        for (String field : excludeFields = zConf.getNoteFileExcludedFields()) {
            if (field.startsWith("Paragraph")) {
                this.paragraphExcludeFields.add(field.substring(10));
                continue;
            }
            this.noteExcludeFields.add(field);
        }
    }

    public boolean shouldSkipField(FieldAttributes field) {
        if (field.getName().equals("path")) {
            return true;
        }
        if (field.getDeclaringClass().equals(Paragraph.class)) {
            return this.paragraphExcludeFields.contains(field.getName());
        }
        return this.noteExcludeFields.contains(field.getName());
    }

    public boolean shouldSkipClass(Class<?> aClass) {
        return false;
    }
}

