/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zeppelin.interpreter.launcher;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Properties;
import java.util.StringJoiner;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.zeppelin.conf.ZeppelinConfiguration;
import org.apache.zeppelin.interpreter.launcher.InterpreterLaunchContext;
import org.apache.zeppelin.interpreter.launcher.StandardInterpreterLauncher;
import org.apache.zeppelin.interpreter.recovery.RecoveryStorage;
import org.apache.zeppelin.interpreter.remote.RemoteInterpreterUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SparkInterpreterLauncher
extends StandardInterpreterLauncher {
    private static final Logger LOGGER = LoggerFactory.getLogger(SparkInterpreterLauncher.class);
    public static final String SPARK_MASTER_KEY = "spark.master";
    private static final String DEFAULT_MASTER = "local[*]";
    Optional<String> sparkMaster = Optional.empty();

    public SparkInterpreterLauncher(ZeppelinConfiguration zConf, RecoveryStorage recoveryStorage) {
        super(zConf, recoveryStorage);
    }

    @Override
    public Map<String, String> buildEnvFromProperties(InterpreterLaunchContext context) throws IOException {
        Map<String, String> env = super.buildEnvFromProperties(context);
        Properties sparkProperties = new Properties();
        String spMaster = this.getSparkMaster(context);
        if (spMaster != null) {
            sparkProperties.put(SPARK_MASTER_KEY, spMaster);
        }
        Properties properties = context.getProperties();
        for (String key : properties.stringPropertyNames()) {
            String propValue = properties.getProperty(key);
            if (RemoteInterpreterUtils.isEnvString((String)key) && !StringUtils.isBlank((CharSequence)propValue)) {
                env.put(key, propValue);
            }
            if (!this.isSparkConf(key, propValue)) continue;
            if (Objects.equals("spark.driver.extraJavaOptions", key)) {
                env.put("SPARK_DRIVER_EXTRAJAVAOPTIONS_CONF", (String)properties.remove(key));
                continue;
            }
            sparkProperties.setProperty(key, propValue);
        }
        if (!sparkProperties.containsKey("spark.app.name") || StringUtils.isBlank((CharSequence)sparkProperties.getProperty("spark.app.name"))) {
            sparkProperties.setProperty("spark.app.name", context.getInterpreterGroupId());
        }
        this.setupPropertiesForPySpark(sparkProperties, context);
        this.setupPropertiesForSparkR(sparkProperties, context);
        String condaEnvName = context.getProperties().getProperty("zeppelin.interpreter.conda.env.name");
        if (StringUtils.isNotBlank((CharSequence)condaEnvName)) {
            if (!this.isYarnCluster(context)) {
                throw new IOException("zeppelin.interpreter.conda.env.name only works for yarn-cluster mode");
            }
            sparkProperties.setProperty("spark.pyspark.python", condaEnvName + "/bin/python");
        }
        if (this.isYarnCluster(context)) {
            env.put("ZEPPELIN_SPARK_YARN_CLUSTER", "true");
            sparkProperties.setProperty("spark.yarn.submit.waitAppCompletion", "false");
            context.getProperties().put("zeppelin.interpreter.forceShutdown", "false");
        } else if (this.zConf.isOnlyYarnCluster()) {
            throw new IOException("Only yarn-cluster mode is allowed, please set " + ZeppelinConfiguration.ConfVars.ZEPPELIN_SPARK_ONLY_YARN_CLUSTER.getVarName() + " to false if you want to use other modes.");
        }
        if (this.isYarnMode(context) && this.getDeployMode(context).equals("cluster")) {
            if (sparkProperties.containsKey("spark.files")) {
                sparkProperties.put("spark.files", sparkProperties.getProperty("spark.files") + "," + this.zConf.getConfDir() + "/log4j_yarn_cluster.properties");
            } else {
                sparkProperties.put("spark.files", this.zConf.getConfDir() + "/log4j_yarn_cluster.properties");
            }
            sparkProperties.put("spark.yarn.maxAppAttempts", "1");
        }
        String scalaVersion = null;
        try {
            String sparkHome = this.getEnv("SPARK_HOME", context);
            LOGGER.info("SPARK_HOME: {}", (Object)sparkHome);
            scalaVersion = this.detectSparkScalaVersion(sparkHome, env);
            LOGGER.info("Scala version for Spark: {}", (Object)scalaVersion);
            context.getProperties().put("zeppelin.spark.scala.version", scalaVersion);
        }
        catch (Exception e) {
            throw new IOException("Fail to detect scala version, the reason is:" + e.getMessage());
        }
        if (this.isYarnMode(context) && this.getDeployMode(context).equals("cluster")) {
            try {
                Path scalaFolder;
                ArrayList additionalJars = new ArrayList();
                String[] localRepoPath = Paths.get(this.zConf.getInterpreterLocalRepoPath(), context.getInterpreterSettingId());
                if (Files.exists((Path)localRepoPath, new LinkOption[0]) && Files.isDirectory((Path)localRepoPath, new LinkOption[0])) {
                    try (DirectoryStream<Path> localRepoStream = Files.newDirectoryStream((Path)localRepoPath, x$0 -> Files.isRegularFile(x$0, new LinkOption[0]));){
                        List localRepoJars = StreamSupport.stream(localRepoStream.spliterator(), false).map(jar -> jar.toAbsolutePath().toString()).collect(Collectors.toList());
                        additionalJars.addAll(localRepoJars);
                    }
                }
                if (!(scalaFolder = Paths.get(this.zConf.getZeppelinHome(), "/interpreter/spark/scala-" + scalaVersion)).toFile().exists()) {
                    throw new IOException("spark scala folder " + scalaFolder.toFile() + " doesn't exist");
                }
                try (DirectoryStream<Path> scalaStream = Files.newDirectoryStream(scalaFolder, x$0 -> Files.isRegularFile(x$0, new LinkOption[0]));){
                    List scalaJars = StreamSupport.stream(scalaStream.spliterator(), false).map(jar -> jar.toAbsolutePath().toString()).collect(Collectors.toList());
                    additionalJars.addAll(scalaJars);
                }
                Path interpreterFolder = Paths.get(this.zConf.getZeppelinHome(), "/interpreter");
                try (DirectoryStream<Path> interpreterStream = Files.newDirectoryStream(interpreterFolder, x$0 -> Files.isRegularFile(x$0, new LinkOption[0]));){
                    List interpreterJars = StreamSupport.stream(interpreterStream.spliterator(), false).filter(jar -> jar.toFile().getName().startsWith("zeppelin-interpreter-shaded") && jar.toFile().getName().endsWith(".jar")).map(jar -> jar.toAbsolutePath().toString()).collect(Collectors.toList());
                    if (interpreterJars.isEmpty()) {
                        throw new IOException("zeppelin-interpreter-shaded jar is not found");
                    }
                    if (interpreterJars.size() > 1) {
                        throw new IOException("more than 1 zeppelin-interpreter-shaded jars are found: " + StringUtils.join(interpreterJars, (String)","));
                    }
                    additionalJars.addAll(interpreterJars);
                }
                if (sparkProperties.containsKey("spark.jars")) {
                    sparkProperties.put("spark.jars", sparkProperties.getProperty("spark.jars") + "," + StringUtils.join(additionalJars, (String)","));
                } else {
                    sparkProperties.put("spark.jars", StringUtils.join(additionalJars, (String)","));
                }
            }
            catch (Exception e) {
                throw new IOException("Fail to set additional jars for spark interpreter", e);
            }
        }
        StringJoiner sparkConfSJ = new StringJoiner("|");
        if (context.getOption().isUserImpersonate() && this.zConf.getZeppelinImpersonateSparkProxyUser()) {
            sparkConfSJ.add("--proxy-user");
            sparkConfSJ.add(context.getUserName());
            sparkProperties.remove("spark.yarn.keytab");
            sparkProperties.remove("spark.yarn.principal");
        }
        for (String name : sparkProperties.stringPropertyNames()) {
            sparkConfSJ.add("--conf");
            sparkConfSJ.add(name + "=" + sparkProperties.getProperty(name));
        }
        env.put("ZEPPELIN_SPARK_CONF", sparkConfSJ.toString());
        for (String envName : new String[]{"SPARK_HOME", "SPARK_CONF_DIR", "HADOOP_CONF_DIR"}) {
            String envValue = this.getEnv(envName, context);
            if (StringUtils.isBlank((CharSequence)envValue)) continue;
            env.put(envName, envValue);
        }
        String keytab = properties.getProperty("spark.yarn.keytab", this.zConf.getString(ZeppelinConfiguration.ConfVars.ZEPPELIN_SERVER_KERBEROS_KEYTAB));
        String principal = properties.getProperty("spark.yarn.principal", this.zConf.getString(ZeppelinConfiguration.ConfVars.ZEPPELIN_SERVER_KERBEROS_PRINCIPAL));
        if (!StringUtils.isBlank((CharSequence)keytab) && !StringUtils.isBlank((CharSequence)principal)) {
            env.put("ZEPPELIN_SERVER_KERBEROS_KEYTAB", keytab);
            env.put("ZEPPELIN_SERVER_KERBEROS_PRINCIPAL", principal);
            LOGGER.info("Run Spark under secure mode with keytab: {}, principal: {}", (Object)keytab, (Object)principal);
        } else {
            LOGGER.info("Run Spark under non-secure mode as no keytab and principal is specified");
        }
        env.put("PYSPARK_PIN_THREAD", "true");
        Object sparkConfDir = this.getEnv("SPARK_CONF_DIR", context);
        if (StringUtils.isBlank((CharSequence)sparkConfDir)) {
            String sparkHome = this.getEnv("SPARK_HOME", context);
            sparkConfDir = sparkHome + "/conf";
        }
        Properties sparkDefaultProperties = new Properties();
        File sparkDefaultFile = new File((String)sparkConfDir, "spark-defaults.conf");
        if (sparkDefaultFile.exists()) {
            sparkDefaultProperties.load(new FileInputStream(sparkDefaultFile));
            String driverExtraClassPath = sparkDefaultProperties.getProperty("spark.driver.extraClassPath");
            if (!StringUtils.isBlank((CharSequence)driverExtraClassPath)) {
                env.put("ZEPPELIN_INTP_CLASSPATH", driverExtraClassPath);
            }
        } else {
            LOGGER.warn("spark-defaults.conf doesn't exist: {}", (Object)sparkDefaultFile.getAbsolutePath());
        }
        if (this.isYarnMode(context)) {
            boolean runAsLoginUser = Boolean.parseBoolean(context.getProperties().getProperty("zeppelin.spark.run.asLoginUser", "true"));
            String userName = context.getUserName();
            if (runAsLoginUser && !"anonymous".equals(userName)) {
                env.put("HADOOP_USER_NAME", userName);
            }
        }
        LOGGER.info("buildEnvFromProperties: {}", env);
        return env;
    }

    private String detectSparkScalaVersion(String sparkHome, Map<String, String> env) throws Exception {
        LOGGER.info("Detect scala version from SPARK_HOME: {}", (Object)sparkHome);
        ProcessBuilder builder = new ProcessBuilder(sparkHome + "/bin/spark-submit", "--version");
        builder.environment().putAll(env);
        File processOutputFile = File.createTempFile("zeppelin-spark", ".out");
        builder.redirectError(processOutputFile);
        Process process = builder.start();
        process.waitFor();
        String processOutput = IOUtils.toString((InputStream)new FileInputStream(processOutputFile), (Charset)StandardCharsets.UTF_8);
        Pattern pattern = Pattern.compile(".*Using Scala version (.*),.*");
        Matcher matcher = pattern.matcher(processOutput);
        if (matcher.find()) {
            String scalaVersion = matcher.group(1);
            if (scalaVersion.startsWith("2.12")) {
                return "2.12";
            }
            if (scalaVersion.startsWith("2.13")) {
                return "2.13";
            }
            throw new Exception("Unsupported scala version: " + scalaVersion);
        }
        return this.detectSparkScalaVersionByReplClass(sparkHome);
    }

    private String detectSparkScalaVersionByReplClass(String sparkHome) throws Exception {
        File sparkJarsFolder = new File(sparkHome + "/jars");
        File[] sparkJarFiles = sparkJarsFolder.listFiles();
        long sparkReplFileNum = Stream.of(sparkJarFiles).filter(file -> file.getName().contains("spark-repl_")).count();
        if (sparkReplFileNum == 0L) {
            throw new Exception("No spark-repl jar found in SPARK_HOME: " + sparkHome);
        }
        if (sparkReplFileNum > 1L) {
            throw new Exception("Multiple spark-repl jar found in SPARK_HOME: " + sparkHome);
        }
        boolean sparkRepl212Exists = Stream.of(sparkJarFiles).anyMatch(file -> file.getName().contains("spark-repl_2.12"));
        boolean sparkRepl213Exists = Stream.of(sparkJarFiles).anyMatch(file -> file.getName().contains("spark-repl_2.13"));
        if (sparkRepl212Exists) {
            return "2.12";
        }
        if (sparkRepl213Exists) {
            return "2.13";
        }
        throw new Exception("Can not detect the scala version by spark-repl");
    }

    private String getEnv(String envName, InterpreterLaunchContext context) {
        String env = context.getProperties().getProperty(envName);
        if (StringUtils.isBlank((CharSequence)env)) {
            env = System.getenv(envName);
        }
        if (StringUtils.isBlank((CharSequence)env)) {
            LOGGER.warn("environment variable: {} is empty", (Object)envName);
        }
        return env;
    }

    private boolean isSparkConf(String key, String value) {
        return !StringUtils.isEmpty((CharSequence)key) && key.startsWith("spark.") && !StringUtils.isEmpty((CharSequence)value);
    }

    private void setupPropertiesForPySpark(Properties sparkProperties, InterpreterLaunchContext context) {
        if (this.isYarnMode(context)) {
            sparkProperties.setProperty("spark.yarn.isPython", "true");
        }
    }

    private void mergeSparkProperty(Properties sparkProperties, String propertyName, String propertyValue) {
        if (sparkProperties.containsKey(propertyName)) {
            String oldPropertyValue = sparkProperties.getProperty(propertyName);
            sparkProperties.setProperty(propertyName, oldPropertyValue + "," + propertyValue);
        } else {
            sparkProperties.setProperty(propertyName, propertyValue);
        }
    }

    private void setupPropertiesForSparkR(Properties sparkProperties, InterpreterLaunchContext context) {
        if (this.isYarnMode(context)) {
            String sparkHome = this.getEnv("SPARK_HOME", context);
            File sparkRBasePath = null;
            if (sparkHome == null) {
                if (!this.getSparkMaster(context).startsWith("local")) {
                    throw new RuntimeException("SPARK_HOME is not specified in interpreter-setting for non-local mode, if you specify it in zeppelin-env.sh, please move that into  interpreter setting");
                }
                String zeppelinHome = this.zConf.getString(ZeppelinConfiguration.ConfVars.ZEPPELIN_HOME);
                sparkRBasePath = new File(zeppelinHome, "interpreter" + File.separator + "spark" + File.separator + "R");
            } else {
                sparkRBasePath = new File(sparkHome, "R" + File.separator + "lib");
            }
            File sparkRPath = new File(sparkRBasePath, "sparkr.zip");
            if (sparkRPath.exists() && sparkRPath.isFile()) {
                this.mergeSparkProperty(sparkProperties, "spark.yarn.dist.archives", sparkRPath.getAbsolutePath() + "#sparkr");
            } else {
                LOGGER.warn("sparkr.zip is not found, SparkR may not work.");
            }
        }
    }

    private String getSparkMaster(InterpreterLaunchContext context) {
        if (!this.sparkMaster.isPresent()) {
            Properties properties = context.getProperties();
            String master = context.getProperties().getProperty(SPARK_MASTER_KEY);
            if (master == null) {
                master = properties.getProperty("master");
                if (master == null) {
                    String masterEnv = System.getenv("SPARK_MASTER");
                    master = masterEnv == null ? DEFAULT_MASTER : masterEnv;
                }
                properties.put(SPARK_MASTER_KEY, master);
            }
            this.sparkMaster = Optional.of(master);
        }
        return this.sparkMaster.get();
    }

    private String getDeployMode(InterpreterLaunchContext context) {
        if (this.getSparkMaster(context).equals("yarn-client")) {
            return "client";
        }
        if (this.getSparkMaster(context).equals("yarn-cluster")) {
            return "cluster";
        }
        if (this.getSparkMaster(context).startsWith("local")) {
            return "client";
        }
        String deployMode = context.getProperties().getProperty("spark.submit.deployMode");
        if (deployMode == null) {
            throw new RuntimeException("master is set as yarn, but spark.submit.deployMode is not specified");
        }
        if (!deployMode.equals("client") && !deployMode.equals("cluster")) {
            throw new RuntimeException("Invalid value for spark.submit.deployMode: " + deployMode);
        }
        return deployMode;
    }

    private boolean isYarnMode(InterpreterLaunchContext context) {
        return this.getSparkMaster(context).startsWith("yarn");
    }

    private boolean isYarnCluster(InterpreterLaunchContext context) {
        return this.isYarnMode(context) && "cluster".equalsIgnoreCase(this.getDeployMode(context));
    }
}

