/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zeppelin.scheduler;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import org.apache.zeppelin.scheduler.AbstractScheduler;
import org.apache.zeppelin.scheduler.Job;
import org.apache.zeppelin.scheduler.NamedThreadFactory;
import org.apache.zeppelin.util.ExecutorUtil;

public class FIFOScheduler
extends AbstractScheduler {
    private ExecutorService executor;

    FIFOScheduler(String name) {
        super(name);
        this.executor = Executors.newSingleThreadExecutor(new NamedThreadFactory("FIFOScheduler-" + name + "-Worker"));
    }

    @Override
    public void runJobInScheduler(Job<?> job) {
        this.executor.execute(() -> this.runJob(job));
    }

    @Override
    public void stop() {
        this.stop(2, TimeUnit.MINUTES);
    }

    @Override
    public void stop(int stopTimeoutVal, TimeUnit stopTimeoutUnit) {
        super.stop();
        ExecutorUtil.softShutdown(this.name, this.executor, stopTimeoutVal, stopTimeoutUnit);
    }
}

