/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zeppelin.flink.sql;

import java.util.ArrayList;
import java.util.List;
import org.apache.flink.streaming.api.scala.StreamExecutionEnvironment;
import org.apache.flink.table.api.TableEnvironment;
import org.apache.flink.types.Row;
import org.apache.zeppelin.flink.FlinkShims;
import org.apache.zeppelin.flink.JobManager;
import org.apache.zeppelin.flink.sql.AbstractStreamSqlJob;
import org.apache.zeppelin.interpreter.InterpreterContext;
import org.apache.zeppelin.interpreter.SingleRowInterpreterResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SingleRowStreamSqlJob
extends AbstractStreamSqlJob {
    private static final Logger LOGGER = LoggerFactory.getLogger(SingleRowStreamSqlJob.class);
    private Row latestRow;
    private String template;
    private boolean isFirstRefresh = true;

    public SingleRowStreamSqlJob(StreamExecutionEnvironment senv, TableEnvironment stenv, JobManager jobManager, InterpreterContext context, int defaultParallelism, FlinkShims flinkShims) {
        super(senv, stenv, jobManager, context, defaultParallelism, flinkShims);
        this.template = context.getLocalProperties().getOrDefault("template", "{0}");
    }

    @Override
    protected String getType() {
        return "single";
    }

    @Override
    protected void processInsert(Row row) {
        LOGGER.debug("processInsert: {}", (Object)row);
        this.latestRow = row;
    }

    @Override
    protected void processDelete(Row row) {
    }

    @Override
    protected String buildResult() {
        SingleRowInterpreterResult singleRowResult = new SingleRowInterpreterResult(this.rowToList(this.latestRow), this.template, this.context);
        singleRowResult.pushAngularObjects();
        return singleRowResult.toAngular();
    }

    @Override
    protected void refresh(InterpreterContext context) throws Exception {
        if (this.latestRow == null) {
            LOGGER.warn("Skip RefreshTask as no data available");
            return;
        }
        SingleRowInterpreterResult singleRowResult = new SingleRowInterpreterResult(this.rowToList(this.latestRow), this.template, context);
        if (this.isFirstRefresh) {
            context.out().clear(false);
            context.out.write(singleRowResult.toAngular());
            context.out.flush();
            context.getIntpEventClient().checkpointOutput(context.getNoteId(), context.getParagraphId());
            this.isFirstRefresh = false;
        }
        singleRowResult.pushAngularObjects();
    }

    private List<Object> rowToList(Row row) {
        ArrayList<Object> list = new ArrayList<Object>();
        for (int i = 0; i < row.getArity(); ++i) {
            list.add(row.getField(i));
        }
        return list;
    }
}

