/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zeppelin.flink;

import java.sql.Time;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.TimeZone;

public class TimestampStringUtils {
    private static final TimeZone LOCAL_TZ = TimeZone.getDefault();

    public static String timestampToString(LocalDateTime ldt, int precision) {
        String fraction = TimestampStringUtils.pad(9, ldt.getNano());
        while (fraction.length() > precision && fraction.endsWith("0")) {
            fraction = fraction.substring(0, fraction.length() - 1);
        }
        StringBuilder ymdhms = TimestampStringUtils.ymdhms(new StringBuilder(), ldt.getYear(), ldt.getMonthValue(), ldt.getDayOfMonth(), ldt.getHour(), ldt.getMinute(), ldt.getSecond());
        if (fraction.length() > 0) {
            ymdhms.append(".").append(fraction);
        }
        return ymdhms.toString();
    }

    private static String pad(int length, long v) {
        StringBuilder s2 = new StringBuilder(Long.toString(v));
        while (s2.length() < length) {
            s2.insert(0, "0");
        }
        return s2.toString();
    }

    private static StringBuilder hms(StringBuilder b, int h2, int m3, int s2) {
        TimestampStringUtils.int2(b, h2);
        b.append(':');
        TimestampStringUtils.int2(b, m3);
        b.append(':');
        TimestampStringUtils.int2(b, s2);
        return b;
    }

    private static StringBuilder ymdhms(StringBuilder b, int year, int month, int day, int h2, int m3, int s2) {
        TimestampStringUtils.ymd(b, year, month, day);
        b.append(' ');
        TimestampStringUtils.hms(b, h2, m3, s2);
        return b;
    }

    private static StringBuilder ymd(StringBuilder b, int year, int month, int day) {
        TimestampStringUtils.int4(b, year);
        b.append('-');
        TimestampStringUtils.int2(b, month);
        b.append('-');
        TimestampStringUtils.int2(b, day);
        return b;
    }

    private static void int4(StringBuilder buf, int i) {
        buf.append((char)(48 + i / 1000 % 10));
        buf.append((char)(48 + i / 100 % 10));
        buf.append((char)(48 + i / 10 % 10));
        buf.append((char)(48 + i % 10));
    }

    private static void int2(StringBuilder buf, int i) {
        buf.append((char)(48 + i / 10 % 10));
        buf.append((char)(48 + i % 10));
    }

    public static String unixTimeToString(int time) {
        StringBuilder buf = new StringBuilder(8);
        TimestampStringUtils.unixTimeToString(buf, time, 0);
        return buf.toString();
    }

    private static void unixTimeToString(StringBuilder buf, int time, int precision) {
        while (time < 0) {
            time = (int)((long)time + 86400000L);
        }
        int h2 = time / 3600000;
        int time2 = time % 3600000;
        int m3 = time2 / 60000;
        int time3 = time2 % 60000;
        int s2 = time3 / 1000;
        int ms = time3 % 1000;
        TimestampStringUtils.int2(buf, h2);
        buf.append(':');
        TimestampStringUtils.int2(buf, m3);
        buf.append(':');
        TimestampStringUtils.int2(buf, s2);
        if (precision > 0) {
            buf.append('.');
            while (precision > 0) {
                buf.append((char)(48 + ms / 100));
                ms %= 100;
                if ((ms *= 10) == 0) break;
                --precision;
            }
        }
    }

    public static int timeToInternal(Time time) {
        long ts = time.getTime() + (long)LOCAL_TZ.getOffset(time.getTime());
        return (int)(ts % 86400000L);
    }

    public static int localTimeToUnixDate(LocalTime time) {
        return time.getHour() * 3600000 + time.getMinute() * 60000 + time.getSecond() * 1000 + time.getNano() / 1000000;
    }
}

