/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zeppelin.flink;

import java.io.File;
import java.io.IOException;
import org.apache.flink.client.program.ClusterClient;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.ApplicationReport;
import org.apache.hadoop.yarn.client.api.YarnClient;
import org.apache.hadoop.yarn.conf.YarnConfiguration;
import org.apache.hadoop.yarn.exceptions.YarnException;
import org.apache.hadoop.yarn.util.ConverterUtils;
import org.apache.zeppelin.shaded.com.google.common.io.Files;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HadoopUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(HadoopUtils.class);

    public static String getYarnAppTrackingUrl(ClusterClient clusterClient) throws IOException, YarnException {
        ApplicationId yarnAppId = (ApplicationId)clusterClient.getClusterId();
        return HadoopUtils.getYarnAppTrackingUrl(yarnAppId);
    }

    public static String getYarnAppTrackingUrl(String yarnAppIdStr) throws IOException, YarnException {
        ApplicationId yarnAppId = ConverterUtils.toApplicationId((String)yarnAppIdStr);
        return HadoopUtils.getYarnAppTrackingUrl(yarnAppId);
    }

    public static String getYarnAppTrackingUrl(ApplicationId yarnAppId) throws IOException, YarnException {
        return HadoopUtils.getYarnApplicationReport(yarnAppId).getTrackingUrl();
    }

    public static String getYarnAppId(ClusterClient clusterClient) {
        return ((ApplicationId)clusterClient.getClusterId()).toString();
    }

    public static int getFlinkRestPort(String yarnAppId) throws IOException, YarnException {
        return HadoopUtils.getYarnApplicationReport(ConverterUtils.toApplicationId((String)yarnAppId)).getRpcPort();
    }

    private static ApplicationReport getYarnApplicationReport(ApplicationId yarnAppId) throws IOException, YarnException {
        YarnClient yarnClient = YarnClient.createYarnClient();
        YarnConfiguration yarnConf = new YarnConfiguration();
        yarnConf.set("yarn.timeline-service.enabled", "false");
        yarnClient.init((Configuration)yarnConf);
        yarnClient.start();
        return yarnClient.getApplicationReport(yarnAppId);
    }

    public static void cleanupStagingDirInternal(String yarnAppId) {
        try {
            FileSystem fs = FileSystem.get((Configuration)new Configuration());
            Path stagingDirPath = new Path(fs.getHomeDirectory(), ".flink/" + yarnAppId);
            if (fs.delete(stagingDirPath, true)) {
                LOGGER.info("Deleted staging directory " + stagingDirPath);
            }
        }
        catch (IOException e) {
            LOGGER.warn("Failed to cleanup staging dir", e);
        }
    }

    public static String downloadJar(String jarOnHdfs) throws IOException {
        Path sourcePath;
        File tmpDir = Files.createTempDir();
        FileSystem fs = FileSystem.get((Configuration)new Configuration());
        if (!fs.exists(sourcePath = fs.makeQualified(new Path(jarOnHdfs)))) {
            throw new IOException("jar file: " + jarOnHdfs + " doesn't exist.");
        }
        Path destPath = new Path(tmpDir.getAbsolutePath() + "/" + sourcePath.getName());
        fs.copyToLocalFile(sourcePath, destPath);
        LOGGER.info("Downloaded jar from {} to {}", (Object)jarOnHdfs, (Object)destPath);
        return new File(destPath.toString()).getAbsolutePath();
    }
}

