/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zeppelin.flink;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.flink.api.scala.ExecutionEnvironment;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.streaming.api.scala.StreamExecutionEnvironment;
import org.apache.flink.table.api.TableEnvironment;
import org.apache.zeppelin.conf.ZeppelinConfiguration;
import org.apache.zeppelin.flink.FlinkScalaInterpreter;
import org.apache.zeppelin.flink.FlinkShims;
import org.apache.zeppelin.flink.FlinkVersion;
import org.apache.zeppelin.flink.JobManager;
import org.apache.zeppelin.interpreter.Interpreter;
import org.apache.zeppelin.interpreter.InterpreterContext;
import org.apache.zeppelin.interpreter.InterpreterException;
import org.apache.zeppelin.interpreter.InterpreterResult;
import org.apache.zeppelin.interpreter.ZeppelinContext;
import org.apache.zeppelin.interpreter.thrift.InterpreterCompletion;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FlinkInterpreter
extends Interpreter {
    private static final Logger LOGGER = LoggerFactory.getLogger(FlinkInterpreter.class);
    private Map<String, String> innerInterpreterClassMap = new HashMap<String, String>();
    private FlinkScalaInterpreter innerIntp;
    private ZeppelinContext z;

    public FlinkInterpreter(Properties properties) {
        super(properties);
        this.innerInterpreterClassMap.put("2.11", "org.apache.zeppelin.flink.FlinkScala211Interpreter");
        this.innerInterpreterClassMap.put("2.12", "org.apache.zeppelin.flink.FlinkScala212Interpreter");
    }

    private String extractScalaVersion() throws InterpreterException {
        String scalaVersionString = scala.util.Properties.versionString();
        LOGGER.info("Using Scala: {}", (Object)scalaVersionString);
        if (scalaVersionString.contains("version 2.11")) {
            return "2.11";
        }
        if (scalaVersionString.contains("version 2.12")) {
            return "2.12";
        }
        throw new InterpreterException("Unsupported scala version: " + scalaVersionString + ", Only scala 2.11/2.12 is supported");
    }

    public void open() throws InterpreterException {
        try {
            this.innerIntp = this.loadFlinkScalaInterpreter();
            this.innerIntp.open();
            this.z = this.innerIntp.getZeppelinContext();
        }
        catch (InterpreterException e) {
            throw e;
        }
        catch (Exception e) {
            throw new InterpreterException("Fail to open FlinkInterpreter", (Throwable)e);
        }
    }

    private FlinkScalaInterpreter loadFlinkScalaInterpreter() throws Exception {
        String scalaVersion = this.extractScalaVersion();
        ClassLoader flinkScalaClassLoader = FlinkScalaInterpreter.class.getClassLoader();
        String innerIntpClassName = this.innerInterpreterClassMap.get(scalaVersion);
        Class<?> clazz = Class.forName(innerIntpClassName);
        return (FlinkScalaInterpreter)clazz.getConstructor(Properties.class, ClassLoader.class, ZeppelinConfiguration.class).newInstance(this.getProperties(), flinkScalaClassLoader, this.zConf);
    }

    public void close() throws InterpreterException {
        if (this.innerIntp != null) {
            this.innerIntp.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InterpreterResult interpret(String st, InterpreterContext context) throws InterpreterException {
        LOGGER.debug("Interpret code: {}", (Object)st);
        this.z.setInterpreterContext(context);
        this.z.setGui(context.getGui());
        this.z.setNoteGui(context.getNoteGui());
        ClassLoader originClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(this.getFlinkScalaShellLoader());
            this.createPlannerAgain();
            this.setParallelismIfNecessary(context);
            this.setSavepointPathIfNecessary(context);
            InterpreterResult interpreterResult = this.innerIntp.interpret(st, context);
            return interpreterResult;
        }
        finally {
            Thread.currentThread().setContextClassLoader(originClassLoader);
        }
    }

    public void cancel(InterpreterContext context) throws InterpreterException {
        this.innerIntp.cancel(context);
    }

    public Interpreter.FormType getFormType() throws InterpreterException {
        return Interpreter.FormType.SIMPLE;
    }

    public int getProgress(InterpreterContext context) throws InterpreterException {
        return this.innerIntp.getProgress(context);
    }

    public List<InterpreterCompletion> completion(String buf, int cursor, InterpreterContext interpreterContext) throws InterpreterException {
        return this.innerIntp.completion(buf, cursor, interpreterContext);
    }

    ExecutionEnvironment getExecutionEnvironment() {
        return this.innerIntp.getExecutionEnvironment();
    }

    StreamExecutionEnvironment getStreamExecutionEnvironment() {
        return this.innerIntp.getStreamExecutionEnvironment();
    }

    TableEnvironment getStreamTableEnvironment() {
        return this.innerIntp.getStreamTableEnvironment();
    }

    TableEnvironment getJavaBatchTableEnvironment(String planner) {
        return this.innerIntp.getJavaBatchTableEnvironment(planner);
    }

    TableEnvironment getJavaStreamTableEnvironment() {
        return this.innerIntp.getJavaStreamTableEnvironment();
    }

    TableEnvironment getBatchTableEnvironment() {
        return this.innerIntp.getBatchTableEnvironment("blink");
    }

    JobManager getJobManager() {
        return this.innerIntp.getJobManager();
    }

    int getDefaultParallelism() {
        return this.innerIntp.getDefaultParallelism();
    }

    int getDefaultSqlParallelism() {
        return this.innerIntp.getDefaultSqlParallelism();
    }

    public void createPlannerAgain() {
        this.innerIntp.createPlannerAgain();
    }

    public ClassLoader getFlinkScalaShellLoader() {
        return this.innerIntp.getFlinkScalaShellLoader();
    }

    ZeppelinContext getZeppelinContext() {
        return this.z;
    }

    Configuration getFlinkConfiguration() {
        return this.innerIntp.getFlinkConfiguration();
    }

    public FlinkShims getFlinkShims() {
        return this.innerIntp.getFlinkShims();
    }

    public void setSavepointPathIfNecessary(InterpreterContext context) {
        this.innerIntp.setSavepointPathIfNecessary(context);
    }

    public void setParallelismIfNecessary(InterpreterContext context) {
        this.innerIntp.setParallelismIfNecessary(context);
    }

    public FlinkVersion getFlinkVersion() {
        return this.innerIntp.getFlinkVersion();
    }
}

