/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zeppelin.flink;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.flink.api.common.JobExecutionResult;
import org.apache.flink.api.common.JobStatus;
import org.apache.flink.api.java.ExecutionEnvironment;
import org.apache.flink.configuration.PipelineOptions;
import org.apache.flink.core.execution.JobClient;
import org.apache.flink.core.execution.JobListener;
import org.apache.flink.streaming.api.environment.StreamExecutionEnvironment;
import org.apache.flink.table.api.SqlParserException;
import org.apache.flink.table.api.Table;
import org.apache.flink.table.api.TableEnvironment;
import org.apache.flink.table.api.TableResult;
import org.apache.flink.table.api.internal.TableEnvironmentInternal;
import org.apache.flink.table.api.internal.TableResultInternal;
import org.apache.flink.table.delegation.Parser;
import org.apache.flink.table.operations.BeginStatementSetOperation;
import org.apache.flink.table.operations.CreateTableASOperation;
import org.apache.flink.table.operations.DescribeTableOperation;
import org.apache.flink.table.operations.EndStatementSetOperation;
import org.apache.flink.table.operations.ExplainOperation;
import org.apache.flink.table.operations.ModifyOperation;
import org.apache.flink.table.operations.Operation;
import org.apache.flink.table.operations.QueryOperation;
import org.apache.flink.table.operations.ShowCatalogsOperation;
import org.apache.flink.table.operations.ShowCreateTableOperation;
import org.apache.flink.table.operations.ShowCurrentCatalogOperation;
import org.apache.flink.table.operations.ShowCurrentDatabaseOperation;
import org.apache.flink.table.operations.ShowDatabasesOperation;
import org.apache.flink.table.operations.ShowFunctionsOperation;
import org.apache.flink.table.operations.ShowModulesOperation;
import org.apache.flink.table.operations.ShowPartitionsOperation;
import org.apache.flink.table.operations.ShowTablesOperation;
import org.apache.flink.table.operations.UseCatalogOperation;
import org.apache.flink.table.operations.UseDatabaseOperation;
import org.apache.flink.table.operations.command.HelpOperation;
import org.apache.flink.table.operations.command.SetOperation;
import org.apache.flink.table.operations.ddl.AlterCatalogFunctionOperation;
import org.apache.flink.table.operations.ddl.AlterDatabaseOperation;
import org.apache.flink.table.operations.ddl.AlterTableOperation;
import org.apache.flink.table.operations.ddl.AlterViewOperation;
import org.apache.flink.table.operations.ddl.CreateCatalogFunctionOperation;
import org.apache.flink.table.operations.ddl.CreateCatalogOperation;
import org.apache.flink.table.operations.ddl.CreateDatabaseOperation;
import org.apache.flink.table.operations.ddl.CreateTableOperation;
import org.apache.flink.table.operations.ddl.CreateTempSystemFunctionOperation;
import org.apache.flink.table.operations.ddl.CreateViewOperation;
import org.apache.flink.table.operations.ddl.DropCatalogFunctionOperation;
import org.apache.flink.table.operations.ddl.DropCatalogOperation;
import org.apache.flink.table.operations.ddl.DropDatabaseOperation;
import org.apache.flink.table.operations.ddl.DropTableOperation;
import org.apache.flink.table.operations.ddl.DropTempSystemFunctionOperation;
import org.apache.flink.table.operations.ddl.DropViewOperation;
import org.apache.flink.table.utils.EncodingUtils;
import org.apache.flink.types.Row;
import org.apache.flink.util.CloseableIterator;
import org.apache.flink.util.CollectionUtil;
import org.apache.flink.util.Preconditions;
import org.apache.zeppelin.flink.FlinkSqlContext;
import org.apache.zeppelin.interpreter.InterpreterContext;
import org.apache.zeppelin.interpreter.InterpreterResult;
import org.apache.zeppelin.interpreter.ZeppelinContext;
import org.apache.zeppelin.interpreter.util.SqlSplitter;
import org.jline.utils.AttributedString;
import org.jline.utils.AttributedStringBuilder;
import org.jline.utils.AttributedStyle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Flink117SqlInterpreter {
    private static final Logger LOGGER = LoggerFactory.getLogger(Flink117SqlInterpreter.class);
    private static final String CMD_DESC_DELIMITER = "\t\t";
    private static final AttributedString SQL_CLI_COMMANDS_DESCRIPTIONS = new SQLCliCommandsDescriptions().commandDescription("HELP", "Prints the available commands.").commandDescription("SET", "Sets a session configuration property. Syntax: \"SET '<key>'='<value>';\". Use \"SET;\" for listing all properties.").commandDescription("RESET", "Resets a session configuration property. Syntax: \"RESET '<key>';\". Use \"RESET;\" for reset all session properties.").commandDescription("INSERT INTO", "Inserts the results of a SQL SELECT query into a declared table sink.").commandDescription("INSERT OVERWRITE", "Inserts the results of a SQL SELECT query into a declared table sink and overwrite existing data.").commandDescription("SELECT", "Executes a SQL SELECT query on the Flink cluster.").commandDescription("EXPLAIN", "Describes the execution plan of a query or table with the given name.").commandDescription("BEGIN STATEMENT SET", "Begins a statement set. Syntax: \"BEGIN STATEMENT SET;\"").commandDescription("END", "Ends a statement set. Syntax: \"END;\"").build();
    public static final AttributedString MESSAGE_HELP = new AttributedStringBuilder().append("The following commands are available:\n\n").append(SQL_CLI_COMMANDS_DESCRIPTIONS).style(AttributedStyle.DEFAULT.underline()).append("\nHint").style(AttributedStyle.DEFAULT).append(": Make sure that a statement ends with \";\" for finalizing (multi-line) statements.").style(AttributedStyle.DEFAULT).append("\nYou can also type any Flink SQL statement, please visit https://nightlies.apache.org/flink/flink-docs-stable/docs/dev/table/sql/overview/ for more details.").toAttributedString();
    private static final String MESSAGE_NO_STATEMENT_IN_STATEMENT_SET = "No statement in the statement set, skip submit.";
    private FlinkSqlContext flinkSqlContext;
    private TableEnvironment tbenv;
    private ZeppelinContext z;
    private Parser sqlParser;
    private SqlSplitter sqlSplitter;
    private Map<String, List<ModifyOperation>> statementOperationsMap = new HashMap<String, List<ModifyOperation>>();
    private boolean isBatch;
    private ReentrantReadWriteLock.WriteLock lock = new ReentrantReadWriteLock().writeLock();

    public Flink117SqlInterpreter(FlinkSqlContext flinkSqlContext, boolean isBatch) {
        this.flinkSqlContext = flinkSqlContext;
        this.isBatch = isBatch;
        this.tbenv = isBatch ? (TableEnvironment)flinkSqlContext.getBtenv() : (TableEnvironment)flinkSqlContext.getStenv();
        this.z = (ZeppelinContext)flinkSqlContext.getZeppelinContext();
        this.sqlParser = ((TableEnvironmentInternal)this.tbenv).getParser();
        this.sqlSplitter = new SqlSplitter();
        JobListener jobListener = new JobListener(){

            public void onJobSubmitted(@Nullable JobClient jobClient, @Nullable Throwable throwable) {
                if (Flink117SqlInterpreter.this.lock.isHeldByCurrentThread()) {
                    Flink117SqlInterpreter.this.lock.unlock();
                    LOGGER.info("UnLock JobSubmitLock");
                }
            }

            public void onJobExecuted(@Nullable JobExecutionResult jobExecutionResult, @Nullable Throwable throwable) {
            }
        };
        ((ExecutionEnvironment)flinkSqlContext.getBenv()).registerJobListener(jobListener);
        ((StreamExecutionEnvironment)flinkSqlContext.getSenv()).registerJobListener(jobListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public InterpreterResult runSqlList(String st, InterpreterContext context) {
        try {
            String jobName;
            boolean runAsOne = Boolean.parseBoolean(context.getStringLocalProperty("runAsOne", "false"));
            if (runAsOne) {
                this.statementOperationsMap.put(context.getParagraphId(), new ArrayList());
            }
            if (StringUtils.isNotBlank(jobName = (String)context.getLocalProperties().get("jobName"))) {
                this.tbenv.getConfig().getConfiguration().set(PipelineOptions.NAME, (Object)jobName);
            }
            List sqls = this.sqlSplitter.splitSql(st).stream().map(String::trim).collect(Collectors.toList());
            for (String sql : sqls) {
                List operations = null;
                try {
                    operations = this.sqlParser.parse(sql);
                }
                catch (SqlParserException e) {
                    context.out.write("%text Invalid Sql statement: " + sql + "\n");
                    context.out.write(MESSAGE_HELP.toString());
                    InterpreterResult interpreterResult = new InterpreterResult(InterpreterResult.Code.ERROR, e.toString());
                    this.statementOperationsMap.remove(context.getParagraphId());
                    return interpreterResult;
                }
                try {
                    this.callOperation(sql, (Operation)operations.get(0), context);
                    context.out.flush();
                }
                catch (Throwable e) {
                    LOGGER.error("Fail to run sql:" + sql, e);
                    try {
                        context.out.write("%text Fail to run sql command: " + sql + "\n" + ExceptionUtils.getStackTrace(e) + "\n");
                    }
                    catch (IOException ex) {
                        LOGGER.warn("Unexpected exception:", ex);
                        InterpreterResult interpreterResult = new InterpreterResult(InterpreterResult.Code.ERROR, ExceptionUtils.getStackTrace(e));
                        this.statementOperationsMap.remove(context.getParagraphId());
                        return interpreterResult;
                    }
                    InterpreterResult interpreterResult = new InterpreterResult(InterpreterResult.Code.ERROR);
                    this.statementOperationsMap.remove(context.getParagraphId());
                    return interpreterResult;
                }
            }
            if (!runAsOne || ((List)this.statementOperationsMap.getOrDefault(context.getParagraphId(), new ArrayList())).isEmpty()) return new InterpreterResult(InterpreterResult.Code.SUCCESS);
            try {
                this.lock.lock();
                List modifyOperations = this.statementOperationsMap.getOrDefault(context.getParagraphId(), new ArrayList());
                if (!modifyOperations.isEmpty()) {
                    this.callInserts(modifyOperations, context);
                }
                if (!this.lock.isHeldByCurrentThread()) return new InterpreterResult(InterpreterResult.Code.SUCCESS);
                this.lock.unlock();
                return new InterpreterResult(InterpreterResult.Code.SUCCESS);
            }
            catch (Exception e) {
                InterpreterResult interpreterResult;
                try {
                    LOGGER.error("Fail to execute sql as one job", e);
                    interpreterResult = new InterpreterResult(InterpreterResult.Code.ERROR, ExceptionUtils.getStackTrace(e));
                    if (this.lock.isHeldByCurrentThread()) {
                        this.lock.unlock();
                    }
                    this.statementOperationsMap.remove(context.getParagraphId());
                }
                catch (Throwable throwable) {
                    if (!this.lock.isHeldByCurrentThread()) throw throwable;
                    this.lock.unlock();
                    throw throwable;
                    {
                        catch (Exception e2) {
                            LOGGER.error("Fail to execute sql", e2);
                            InterpreterResult interpreterResult2 = new InterpreterResult(InterpreterResult.Code.ERROR, ExceptionUtils.getStackTrace(e2));
                            return interpreterResult2;
                        }
                        catch (Throwable throwable2) {
                            throw throwable2;
                        }
                    }
                    finally {
                    }
                }
                return interpreterResult;
            }
        }
        finally {
            this.statementOperationsMap.remove(context.getParagraphId());
        }
    }

    private void callOperation(String sql, Operation operation, InterpreterContext context) throws IOException {
        if (operation instanceof HelpOperation) {
            this.callHelp(context);
        } else if (operation instanceof SetOperation) {
            this.callSet((SetOperation)operation, context);
        } else if (operation instanceof ModifyOperation) {
            this.callInsert((ModifyOperation)operation, context);
        } else if (operation instanceof QueryOperation) {
            this.callSelect(sql, (QueryOperation)operation, context);
        } else if (operation instanceof ExplainOperation) {
            this.callExplain((ExplainOperation)operation, context);
        } else if (operation instanceof BeginStatementSetOperation) {
            this.callBeginStatementSet(context);
        } else if (operation instanceof EndStatementSetOperation) {
            this.callEndStatementSet(context);
        } else if (operation instanceof ShowCreateTableOperation) {
            this.callShowCreateTable((ShowCreateTableOperation)operation, context);
        } else if (operation instanceof ShowCatalogsOperation) {
            this.callShowCatalogs(context);
        } else if (operation instanceof ShowCurrentCatalogOperation) {
            this.callShowCurrentCatalog(context);
        } else if (operation instanceof UseCatalogOperation) {
            this.callUseCatalog(((UseCatalogOperation)operation).getCatalogName(), context);
        } else if (operation instanceof CreateCatalogOperation) {
            this.callDDL(sql, context, "Catalog has been created.");
        } else if (operation instanceof DropCatalogOperation) {
            this.callDDL(sql, context, "Catalog has been dropped.");
        } else if (operation instanceof UseDatabaseOperation) {
            UseDatabaseOperation useDBOperation = (UseDatabaseOperation)operation;
            this.callUseDatabase(useDBOperation.getDatabaseName(), context);
        } else if (operation instanceof CreateDatabaseOperation) {
            this.callDDL(sql, context, "Database has been created.");
        } else if (operation instanceof DropDatabaseOperation) {
            this.callDDL(sql, context, "Database has been removed.");
        } else if (operation instanceof AlterDatabaseOperation) {
            this.callDDL(sql, context, "Alter database succeeded!");
        } else if (operation instanceof ShowDatabasesOperation) {
            this.callShowDatabases(context);
        } else if (operation instanceof ShowCurrentDatabaseOperation) {
            this.callShowCurrentDatabase(context);
        } else if (operation instanceof CreateTableOperation || operation instanceof CreateTableASOperation) {
            this.callDDL(sql, context, "Table has been created.");
        } else if (operation instanceof AlterTableOperation) {
            this.callDDL(sql, context, "Alter table succeeded!");
        } else if (operation instanceof DropTableOperation) {
            this.callDDL(sql, context, "Table has been dropped.");
        } else if (operation instanceof DescribeTableOperation) {
            DescribeTableOperation describeTableOperation = (DescribeTableOperation)operation;
            this.callDescribe(describeTableOperation.getSqlIdentifier().getObjectName(), context);
        } else if (operation instanceof ShowTablesOperation) {
            this.callShowTables(context);
        } else if (operation instanceof CreateViewOperation) {
            this.callDDL(sql, context, "View has been created.");
        } else if (operation instanceof DropViewOperation) {
            this.callDDL(sql, context, "View has been dropped.");
        } else if (operation instanceof AlterViewOperation) {
            this.callDDL(sql, context, "Alter view succeeded!");
        } else if (operation instanceof CreateCatalogFunctionOperation || operation instanceof CreateTempSystemFunctionOperation) {
            this.callDDL(sql, context, "Function has been created.");
        } else if (operation instanceof DropCatalogFunctionOperation || operation instanceof DropTempSystemFunctionOperation) {
            this.callDDL(sql, context, "Function has been removed.");
        } else if (operation instanceof AlterCatalogFunctionOperation) {
            this.callDDL(sql, context, "Alter function succeeded!");
        } else if (operation instanceof ShowFunctionsOperation) {
            this.callShowFunctions(context);
        } else if (operation instanceof ShowModulesOperation) {
            this.callShowModules(context);
        } else if (operation instanceof ShowPartitionsOperation) {
            ShowPartitionsOperation showPartitionsOperation = (ShowPartitionsOperation)operation;
            this.callShowPartitions(showPartitionsOperation.asSummaryString(), context);
        } else {
            throw new IOException(operation.getClass().getName() + " is not supported");
        }
    }

    private void callHelp(InterpreterContext context) throws IOException {
        context.out.write(MESSAGE_HELP.toString() + "\n");
    }

    private void callInsert(ModifyOperation operation, InterpreterContext context) throws IOException {
        if (this.statementOperationsMap.containsKey(context.getParagraphId())) {
            List<ModifyOperation> modifyOperations = this.statementOperationsMap.get(context.getParagraphId());
            modifyOperations.add(operation);
        } else {
            this.callInserts(Collections.singletonList(operation), context);
        }
    }

    private void callInserts(List<ModifyOperation> operations, InterpreterContext context) throws IOException {
        if (!this.isBatch) {
            context.getLocalProperties().put("flink.streaming.insert_into", "true");
        }
        TableResultInternal tableResult = ((TableEnvironmentInternal)this.tbenv).executeInternal(operations);
        Preconditions.checkState((boolean)tableResult.getJobClient().isPresent());
        try {
            tableResult.await();
            JobClient jobClient = (JobClient)tableResult.getJobClient().get();
            if (jobClient.getJobStatus().get() != JobStatus.FINISHED) {
                throw new IOException("Job is failed, " + ((JobExecutionResult)jobClient.getJobExecutionResult().get()).toString());
            }
            context.out.write("Insertion successfully.\n");
        }
        catch (InterruptedException e) {
            throw new IOException("Flink job is interrupted", e);
        }
        catch (ExecutionException e) {
            throw new IOException("Flink job is failed", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void callShowCreateTable(ShowCreateTableOperation showCreateTableOperation, InterpreterContext context) throws IOException {
        try {
            this.lock.lock();
            TableResultInternal tableResult = ((TableEnvironmentInternal)this.tbenv).executeInternal((Operation)showCreateTableOperation);
            String explanation = Objects.requireNonNull(((Row)tableResult.collect().next()).getField(0)).toString();
            context.out.write(explanation + "\n");
        }
        finally {
            if (this.lock.isHeldByCurrentThread()) {
                this.lock.unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void callExplain(ExplainOperation explainOperation, InterpreterContext context) throws IOException {
        try {
            this.lock.lock();
            TableResultInternal tableResult = ((TableEnvironmentInternal)this.tbenv).executeInternal((Operation)explainOperation);
            String explanation = Objects.requireNonNull(((Row)tableResult.collect().next()).getField(0)).toString();
            context.out.write(explanation + "\n");
        }
        finally {
            if (this.lock.isHeldByCurrentThread()) {
                this.lock.unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void callSelect(String sql, QueryOperation queryOperation, InterpreterContext context) throws IOException {
        try {
            this.lock.lock();
            if (this.isBatch) {
                this.callBatchInnerSelect(sql, context);
            } else {
                this.callStreamInnerSelect(sql, context);
            }
        }
        finally {
            if (this.lock.isHeldByCurrentThread()) {
                this.lock.unlock();
            }
        }
    }

    public void callBatchInnerSelect(String sql, InterpreterContext context) throws IOException {
        Table table = this.tbenv.sqlQuery(sql);
        String result = this.z.showData((Object)table);
        context.out.write(result);
    }

    public void callStreamInnerSelect(String sql, InterpreterContext context) throws IOException {
        this.flinkSqlContext.getStreamSqlSelectConsumer().accept(sql);
    }

    public void callSet(SetOperation setOperation, InterpreterContext context) throws IOException {
        if (setOperation.getKey().isPresent() && setOperation.getValue().isPresent()) {
            String key = ((String)setOperation.getKey().get()).trim();
            String value = ((String)setOperation.getValue().get()).trim();
            this.tbenv.getConfig().getConfiguration().setString(key, value);
            LOGGER.info("Set table config: {}={}", (Object)key, (Object)value);
        } else {
            Map properties = this.tbenv.getConfig().getConfiguration().toMap();
            ArrayList<String> prettyEntries = new ArrayList<String>();
            for (String key : properties.keySet()) {
                prettyEntries.add(String.format("'%s' = '%s'", EncodingUtils.escapeSingleQuotes((String)key), EncodingUtils.escapeSingleQuotes((String)((String)properties.get(key)))));
            }
            prettyEntries.sort(String::compareTo);
            prettyEntries.forEach(entry -> {
                try {
                    context.out.write(entry + "\n");
                }
                catch (IOException e) {
                    LOGGER.warn("Fail to write output", e);
                }
            });
        }
    }

    private void callBeginStatementSet(InterpreterContext context) throws IOException {
        this.statementOperationsMap.put(context.getParagraphId(), new ArrayList());
    }

    private void callEndStatementSet(InterpreterContext context) throws IOException {
        List<ModifyOperation> modifyOperations = this.statementOperationsMap.get(context.getParagraphId());
        if (modifyOperations != null && !modifyOperations.isEmpty()) {
            this.callInserts(modifyOperations, context);
        } else {
            context.out.write(MESSAGE_NO_STATEMENT_IN_STATEMENT_SET);
        }
    }

    private void callUseCatalog(String catalog, InterpreterContext context) throws IOException {
        this.tbenv.executeSql("USE CATALOG `" + catalog + "`");
    }

    private void callUseDatabase(String databaseName, InterpreterContext context) throws IOException {
        this.tbenv.executeSql("USE `" + databaseName + "`");
    }

    private void callShowCatalogs(InterpreterContext context) throws IOException {
        TableResult tableResult = this.tbenv.executeSql("SHOW Catalogs");
        List catalogs = CollectionUtil.iteratorToList((Iterator)tableResult.collect()).stream().map(r -> Preconditions.checkNotNull((Object)r.getField(0)).toString()).collect(Collectors.toList());
        context.out.write("%table catalog\n" + StringUtils.join(catalogs, "\n") + "\n");
    }

    private void callShowCurrentCatalog(InterpreterContext context) throws IOException {
        TableResult tableResult = this.tbenv.executeSql("SHOW Current Catalog");
        String catalog = ((Row)tableResult.collect().next()).getField(0).toString();
        context.out.write("%text current catalog: " + catalog + "\n");
    }

    private void callShowDatabases(InterpreterContext context) throws IOException {
        TableResult tableResult = this.tbenv.executeSql("SHOW Databases");
        List databases = CollectionUtil.iteratorToList((Iterator)tableResult.collect()).stream().map(r -> Preconditions.checkNotNull((Object)r.getField(0)).toString()).collect(Collectors.toList());
        context.out.write("%table database\n" + StringUtils.join(databases, "\n") + "\n");
    }

    private void callShowCurrentDatabase(InterpreterContext context) throws IOException {
        TableResult tableResult = this.tbenv.executeSql("SHOW Current Database");
        String database = ((Row)tableResult.collect().next()).getField(0).toString();
        context.out.write("%text current database: " + database + "\n");
    }

    private void callShowTables(InterpreterContext context) throws IOException {
        TableResult tableResult = this.tbenv.executeSql("SHOW Tables");
        List tables = CollectionUtil.iteratorToList((Iterator)tableResult.collect()).stream().map(r -> Preconditions.checkNotNull((Object)r.getField(0)).toString()).filter(tbl -> !tbl.startsWith("UnnamedTable")).collect(Collectors.toList());
        context.out.write("%table table\n" + StringUtils.join(tables, "\n") + "\n");
    }

    private void callShowFunctions(InterpreterContext context) throws IOException {
        TableResult tableResult = this.tbenv.executeSql("SHOW Functions");
        List functions = CollectionUtil.iteratorToList((Iterator)tableResult.collect()).stream().map(r -> Preconditions.checkNotNull((Object)r.getField(0)).toString()).collect(Collectors.toList());
        context.out.write("%table function\n" + StringUtils.join(functions, "\n") + "\n");
    }

    private void callShowModules(InterpreterContext context) throws IOException {
        Object[] modules = this.tbenv.listModules();
        context.out.write("%table modules\n" + StringUtils.join(modules, "\n") + "\n");
    }

    private void callShowPartitions(String sql, InterpreterContext context) throws IOException {
        TableResult tableResult = this.tbenv.executeSql(sql);
        List partions = CollectionUtil.iteratorToList((Iterator)tableResult.collect()).stream().map(r -> Preconditions.checkNotNull((Object)r.getField(0)).toString()).collect(Collectors.toList());
        context.out.write("%table partitions\n" + StringUtils.join(partions, "\n") + "\n");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void callDDL(String sql, InterpreterContext context, String message) throws IOException {
        try {
            this.lock.lock();
            this.tbenv.executeSql(sql);
        }
        finally {
            if (this.lock.isHeldByCurrentThread()) {
                this.lock.unlock();
            }
        }
        context.out.write(message + "\n");
    }

    private void callDescribe(String name, InterpreterContext context) throws IOException {
        TableResult tableResult = null;
        try {
            tableResult = this.tbenv.executeSql("DESCRIBE " + name);
        }
        catch (Exception e) {
            throw new IOException("Fail to describe table: " + name, e);
        }
        CloseableIterator result = tableResult.collect();
        StringBuilder builder = new StringBuilder();
        builder.append("Column\tType\n");
        while (result.hasNext()) {
            Row row = (Row)result.next();
            builder.append(row.getField(0) + "\t" + row.getField(1) + "\n");
        }
        context.out.write("%table\n" + builder.toString());
    }

    private static final class SQLCliCommandsDescriptions {
        private int commandMaxLength = -1;
        private final Map<String, String> commandsDescriptions = new LinkedHashMap<String, String>();

        public SQLCliCommandsDescriptions commandDescription(String command, String description) {
            Preconditions.checkState((boolean)StringUtils.isNotBlank(command), (Object)"content of command must not be empty.");
            Preconditions.checkState((boolean)StringUtils.isNotBlank(description), (Object)"content of command's description must not be empty.");
            this.updateMaxCommandLength(command.length());
            this.commandsDescriptions.put(command, description);
            return this;
        }

        private void updateMaxCommandLength(int newLength) {
            Preconditions.checkState((newLength > 0 ? 1 : 0) != 0);
            if (this.commandMaxLength < newLength) {
                this.commandMaxLength = newLength;
            }
        }

        public AttributedString build() {
            AttributedStringBuilder attributedStringBuilder = new AttributedStringBuilder();
            if (!this.commandsDescriptions.isEmpty()) {
                this.commandsDescriptions.forEach((cmd, cmdDesc) -> attributedStringBuilder.style(AttributedStyle.DEFAULT.bold()).append(String.format(String.format("%%-%ds", this.commandMaxLength), cmd)).append(Flink117SqlInterpreter.CMD_DESC_DELIMITER).style(AttributedStyle.DEFAULT).append((CharSequence)cmdDesc).append('\n'));
            }
            return attributedStringBuilder.toAttributedString();
        }
    }
}

