/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zeppelin.interpreter.launcher;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.apache.commons.io.FileUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.FileUtil;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.mapreduce.MRJobConfig;
import org.apache.hadoop.util.StringUtils;
import org.apache.hadoop.yarn.api.ApplicationConstants;
import org.apache.hadoop.yarn.api.protocolrecords.GetNewApplicationResponse;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.ApplicationReport;
import org.apache.hadoop.yarn.api.records.ApplicationSubmissionContext;
import org.apache.hadoop.yarn.api.records.ContainerLaunchContext;
import org.apache.hadoop.yarn.api.records.LocalResource;
import org.apache.hadoop.yarn.api.records.LocalResourceType;
import org.apache.hadoop.yarn.api.records.LocalResourceVisibility;
import org.apache.hadoop.yarn.api.records.Priority;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.api.records.YarnApplicationState;
import org.apache.hadoop.yarn.client.api.YarnClient;
import org.apache.hadoop.yarn.client.api.YarnClientApplication;
import org.apache.hadoop.yarn.conf.YarnConfiguration;
import org.apache.hadoop.yarn.exceptions.ApplicationNotFoundException;
import org.apache.hadoop.yarn.exceptions.YarnException;
import org.apache.hadoop.yarn.util.ConverterUtils;
import org.apache.hadoop.yarn.util.Records;
import org.apache.zeppelin.conf.ZeppelinConfiguration;
import org.apache.zeppelin.interpreter.launcher.InterpreterLaunchContext;
import org.apache.zeppelin.interpreter.remote.RemoteInterpreterProcess;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class YarnRemoteInterpreterProcess
extends RemoteInterpreterProcess {
    private static final Logger LOGGER = LoggerFactory.getLogger(YarnRemoteInterpreterProcess.class);
    private String host;
    private int port = -1;
    private final ZeppelinConfiguration zConf;
    private final InterpreterLaunchContext launchContext;
    private final Properties properties;
    private final Map<String, String> envs;
    private AtomicBoolean isYarnAppRunning = new AtomicBoolean(false);
    private String errorMessage;
    private Configuration hadoopConf;
    private FileSystem fs;
    private FileSystem localFs;
    private YarnClient yarnClient;
    private ApplicationId appId;
    private Path stagingDir;
    private static final FsPermission APP_FILE_PERMISSION = FsPermission.createImmutable((short)Short.parseShort("644", 8));

    public YarnRemoteInterpreterProcess(InterpreterLaunchContext launchContext, Properties properties, Map<String, String> envs, int connectTimeout, int connectionPoolSize, ZeppelinConfiguration zConf) {
        super(connectTimeout, connectionPoolSize, launchContext.getIntpEventServerHost(), launchContext.getIntpEventServerPort());
        this.zConf = zConf;
        this.launchContext = launchContext;
        this.properties = properties;
        this.envs = envs;
        this.hadoopConf = new YarnConfiguration();
        if (properties.containsKey("HADOOP_CONF_DIR") && !org.apache.commons.lang3.StringUtils.isBlank((CharSequence)properties.getProperty("HADOOP_CONF_DIR"))) {
            File hadoopConfDir = new File(properties.getProperty("HADOOP_CONF_DIR"));
            if (hadoopConfDir.exists() && hadoopConfDir.isDirectory()) {
                File coreSite = new File(hadoopConfDir, "core-site.xml");
                try {
                    LOGGER.info("Adding resource: {}", (Object)coreSite.getAbsolutePath());
                    this.hadoopConf.addResource(coreSite.toURI().toURL());
                }
                catch (MalformedURLException e) {
                    LOGGER.warn("Fail to add core-site.xml: {}", (Object)coreSite.getAbsolutePath(), (Object)e);
                }
                File yarnSite = new File(hadoopConfDir, "yarn-site.xml");
                try {
                    LOGGER.info("Adding resource: {}", (Object)yarnSite.getAbsolutePath());
                    this.hadoopConf.addResource(yarnSite.toURI().toURL());
                }
                catch (MalformedURLException e) {
                    LOGGER.warn("Fail to add yarn-site.xml: {}", (Object)yarnSite.getAbsolutePath(), (Object)e);
                }
            } else {
                throw new RuntimeException("HADOOP_CONF_DIR: " + hadoopConfDir.getAbsolutePath() + " doesn't exist or is not a directory");
            }
        }
        this.yarnClient = YarnClient.createYarnClient();
        this.yarnClient.init(this.hadoopConf);
        this.yarnClient.start();
        try {
            this.fs = FileSystem.get((Configuration)this.hadoopConf);
            this.localFs = FileSystem.getLocal((Configuration)this.hadoopConf);
        }
        catch (IOException e) {
            throw new RuntimeException("Fail to create FileSystem", e);
        }
    }

    public void processStarted(int port, String host) {
        this.port = port;
        this.host = host;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public String getInterpreterGroupId() {
        return this.launchContext.getInterpreterGroupId();
    }

    public String getInterpreterSettingName() {
        return this.launchContext.getInterpreterSettingName();
    }

    public void start(String userName) throws IOException {
        try {
            LOGGER.info("Submitting zeppelin-interpreter app to yarn");
            YarnClientApplication yarnApplication = this.yarnClient.createApplication();
            GetNewApplicationResponse appResponse = yarnApplication.getNewApplicationResponse();
            this.appId = appResponse.getApplicationId();
            ApplicationSubmissionContext appContext = yarnApplication.getApplicationSubmissionContext();
            appContext = this.createApplicationSubmissionContext(appContext);
            String YARN_NODE_LABEL_EXPRESSION = "zeppelin.interpreter.yarn.node.label.expression";
            if (org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)this.properties.getProperty(YARN_NODE_LABEL_EXPRESSION, ""))) {
                appContext.setNodeLabelExpression(this.properties.getProperty(YARN_NODE_LABEL_EXPRESSION));
            }
            this.yarnClient.submitApplication(appContext);
            long start = System.currentTimeMillis();
            ApplicationReport appReport = this.getApplicationReport(this.appId);
            while (appReport.getYarnApplicationState() != YarnApplicationState.FAILED && appReport.getYarnApplicationState() != YarnApplicationState.FINISHED && appReport.getYarnApplicationState() != YarnApplicationState.KILLED && appReport.getYarnApplicationState() != YarnApplicationState.RUNNING) {
                LOGGER.info("Wait for zeppelin interpreter yarn app to be started");
                Thread.sleep(2000L);
                if (System.currentTimeMillis() - start > (long)this.getConnectTimeout()) {
                    this.yarnClient.killApplication(this.appId);
                    throw new IOException("Launching zeppelin interpreter in yarn is time out, kill it now");
                }
                appReport = this.getApplicationReport(this.appId);
            }
            if (appReport.getYarnApplicationState() != YarnApplicationState.RUNNING) {
                this.errorMessage = appReport.getDiagnostics();
                throw new Exception("Failed to submit application to YARN, applicationId=" + this.appId + ", diagnostics=" + appReport.getDiagnostics());
            }
            this.isYarnAppRunning.set(true);
        }
        catch (Exception e) {
            LOGGER.error("Fail to launch yarn interpreter process", (Throwable)e);
            throw new IOException(e);
        }
        finally {
            if (this.stagingDir != null) {
                this.fs.delete(this.stagingDir, true);
            }
        }
    }

    private ApplicationReport getApplicationReport(ApplicationId appId) throws YarnException, IOException {
        ApplicationReport report = this.yarnClient.getApplicationReport(appId);
        if (report.getYarnApplicationState() == null) {
            throw new ApplicationNotFoundException("YARN reports no state for application " + appId);
        }
        return report;
    }

    private ApplicationSubmissionContext createApplicationSubmissionContext(ApplicationSubmissionContext appContext) throws Exception {
        this.setResources(appContext);
        this.setPriority(appContext);
        this.setQueue(appContext);
        appContext.setApplicationId(this.appId);
        this.setApplicationName(appContext);
        appContext.setApplicationType("Zeppelin Interpreter");
        appContext.setMaxAppAttempts(1);
        ContainerLaunchContext amContainer = this.setUpAMLaunchContext();
        appContext.setAMContainerSpec(amContainer);
        appContext.setCancelTokensWhenComplete(true);
        return appContext;
    }

    private ContainerLaunchContext setUpAMLaunchContext() throws IOException {
        String string;
        String yarnDistArchives;
        ContainerLaunchContext amContainer = (ContainerLaunchContext)Records.newRecord(ContainerLaunchContext.class);
        this.stagingDir = new Path(this.fs.getHomeDirectory() + "/.zeppelinStaging", this.appId.toString());
        LOGGER.info("Use staging directory: {}", (Object)this.stagingDir);
        HashMap<String, LocalResource> localResources = new HashMap<String, LocalResource>();
        File interpreterZip = this.createInterpreterZip();
        Path srcPath = this.localFs.makeQualified(new Path(interpreterZip.toURI()));
        Path destPath = this.copyFileToRemote(this.stagingDir, srcPath, (short)1);
        this.addResource(this.fs, destPath, localResources, LocalResourceType.ARCHIVE, "zeppelin");
        LOGGER.info("Add zeppelin archive: {}", (Object)destPath);
        FileUtils.forceDelete((File)interpreterZip);
        if (this.launchContext.getInterpreterSettingGroup().equals("flink")) {
            File flinkZip = this.createFlinkZip();
            srcPath = this.localFs.makeQualified(new Path(flinkZip.toURI()));
            destPath = this.copyFileToRemote(this.stagingDir, srcPath, (short)1);
            this.addResource(this.fs, destPath, localResources, LocalResourceType.ARCHIVE, "flink");
            FileUtils.forceDelete((File)flinkZip);
            String string2 = this.launchContext.getProperties().getProperty("HIVE_CONF_DIR");
            if (!org.apache.commons.lang3.StringUtils.isBlank((CharSequence)string2)) {
                File hiveConfZipFile = this.createHiveConfZip(new File(string2));
                srcPath = this.localFs.makeQualified(new Path(hiveConfZipFile.toURI()));
                destPath = this.copyFileToRemote(this.stagingDir, srcPath, (short)1);
                this.addResource(this.fs, destPath, localResources, LocalResourceType.ARCHIVE, "hive_conf");
            }
        }
        if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)(yarnDistArchives = this.launchContext.getProperties().getProperty("zeppelin.yarn.dist.archives")))) {
            for (String distArchive : yarnDistArchives.split(",")) {
                URI distArchiveURI = null;
                try {
                    distArchiveURI = new URI(distArchive);
                }
                catch (URISyntaxException e) {
                    throw new IOException("Invalid uri: " + distArchive, e);
                }
                if ("file".equals(distArchiveURI.getScheme())) {
                    srcPath = this.localFs.makeQualified(new Path(distArchiveURI));
                    destPath = this.copyFileToRemote(this.stagingDir, srcPath, (short)1);
                } else {
                    destPath = new Path(this.removeFragment(distArchive));
                }
                String linkName = srcPath.getName();
                if (distArchiveURI.getFragment() != null) {
                    linkName = distArchiveURI.getFragment();
                }
                this.addResource(this.fs, destPath, localResources, LocalResourceType.ARCHIVE, linkName);
            }
        }
        if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)(string = this.launchContext.getProperties().getProperty("zeppelin.yarn.dist.files")))) {
            for (String localFile : string.split(",")) {
                srcPath = this.localFs.makeQualified(new Path(localFile));
                destPath = this.copyFileToRemote(this.stagingDir, srcPath, (short)1);
                this.addResource(this.fs, destPath, localResources, LocalResourceType.FILE, srcPath.getName());
                LOGGER.info("Add dist file: {}", (Object)destPath);
            }
        }
        amContainer.setLocalResources(localResources);
        ArrayList<Object> vargs = new ArrayList<Object>();
        vargs.add(ApplicationConstants.Environment.PWD.$() + "/zeppelin/bin/interpreter.sh");
        vargs.add("-d");
        vargs.add(ApplicationConstants.Environment.PWD.$() + "/zeppelin/interpreter/" + this.launchContext.getInterpreterSettingGroup());
        vargs.add("-c");
        vargs.add(this.launchContext.getIntpEventServerHost());
        vargs.add("-p");
        vargs.add("" + this.launchContext.getIntpEventServerPort());
        vargs.add("-r");
        vargs.add(this.zConf.getInterpreterPortRange());
        vargs.add("-i");
        vargs.add(this.launchContext.getInterpreterGroupId());
        vargs.add("-l");
        vargs.add(ApplicationConstants.Environment.PWD.$() + "/zeppelin/" + ZeppelinConfiguration.ConfVars.ZEPPELIN_INTERPRETER_LOCALREPO.getStringValue() + "/" + this.launchContext.getInterpreterSettingName());
        vargs.add("-g");
        vargs.add(this.launchContext.getInterpreterSettingName());
        vargs.add("1><LOG_DIR>" + File.separator + "stdout");
        vargs.add("2><LOG_DIR>" + File.separator + "stderr");
        amContainer.setCommands(vargs);
        this.populateHadoopClasspath(this.envs);
        if (this.launchContext.getInterpreterSettingGroup().equals("flink")) {
            this.envs.put("FLINK_HOME", ApplicationConstants.Environment.PWD.$() + "/flink");
            this.envs.put("FLINK_CONF_DIR", ApplicationConstants.Environment.PWD.$() + "/flink/conf");
            this.envs.put("FLINK_LIB_DIR", ApplicationConstants.Environment.PWD.$() + "/flink/lib");
            this.envs.put("FLINK_PLUGINS_DIR", ApplicationConstants.Environment.PWD.$() + "/flink/plugins");
            this.envs.put("HIVE_CONF_DIR", ApplicationConstants.Environment.PWD.$() + "/hive_conf");
        }
        int memory = Integer.parseInt(this.properties.getProperty("zeppelin.interpreter.yarn.resource.memory", "1024"));
        this.envs.put("ZEPPELIN_INTP_MEM", "-Xmx" + memory + "m");
        amContainer.setEnvironment(this.envs);
        return amContainer;
    }

    private String removeFragment(String path) {
        int pos = path.lastIndexOf("#");
        if (pos != -1) {
            return path.substring(0, pos);
        }
        return path;
    }

    private void populateHadoopClasspath(Map<String, String> envs) {
        ArrayList<String> yarnClassPath = new ArrayList<String>(Arrays.asList(this.getYarnAppClasspath()));
        List<String> mrClassPath = Arrays.asList(this.getMRAppClasspath());
        yarnClassPath.addAll(mrClassPath);
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info("Adding hadoop classpath: {}", (Object)String.join((CharSequence)":", yarnClassPath));
        }
        for (String path : yarnClassPath) {
            Object newValue = path;
            if (envs.containsKey(ApplicationConstants.Environment.CLASSPATH.name())) {
                newValue = envs.get(ApplicationConstants.Environment.CLASSPATH.name()) + "<CPS>" + (String)newValue;
            }
            envs.put(ApplicationConstants.Environment.CLASSPATH.name(), (String)newValue);
        }
        this.envs.put("HADOOP_MAPRED_HOME", "${HADOOP_HOME}");
    }

    private String[] getYarnAppClasspath() {
        String[] classpaths = this.hadoopConf.getStrings("yarn.application.classpath");
        if (classpaths == null || classpaths.length == 0) {
            return this.getDefaultYarnApplicationClasspath();
        }
        return classpaths;
    }

    private String[] getMRAppClasspath() {
        String[] classpaths = this.hadoopConf.getStrings("mapreduce.application.classpath");
        if (classpaths == null || classpaths.length == 0) {
            return this.getDefaultMRApplicationClasspath();
        }
        return classpaths;
    }

    private String[] getDefaultYarnApplicationClasspath() {
        return YarnConfiguration.DEFAULT_YARN_APPLICATION_CLASSPATH;
    }

    private String[] getDefaultMRApplicationClasspath() {
        return StringUtils.getStrings((String)MRJobConfig.DEFAULT_MAPREDUCE_APPLICATION_CLASSPATH);
    }

    private void setResources(ApplicationSubmissionContext appContext) {
        int memory = Integer.parseInt(this.properties.getProperty("zeppelin.interpreter.yarn.resource.memory", "1024"));
        int memoryOverHead = Integer.parseInt(this.properties.getProperty("zeppelin.interpreter.yarn.resource.memoryOverhead", "384"));
        if ((double)memoryOverHead < (double)memory * 0.1) {
            memoryOverHead = 384;
        }
        int cores = Integer.parseInt(this.properties.getProperty("zeppelin.interpreter.yarn.resource.cores", "1"));
        Resource resource = Resource.newInstance((int)(memory + memoryOverHead), (int)cores);
        appContext.setResource(resource);
    }

    private void setPriority(ApplicationSubmissionContext appContext) {
        Priority pri = (Priority)Records.newRecord(Priority.class);
        pri.setPriority(1);
        appContext.setPriority(pri);
    }

    private void setQueue(ApplicationSubmissionContext appContext) {
        String queue = this.properties.getProperty("zeppelin.interpreter.yarn.queue", "default");
        appContext.setQueue(queue);
    }

    private void setApplicationName(ApplicationSubmissionContext appContext) {
        appContext.setApplicationName("Zeppelin Interpreter " + this.launchContext.getInterpreterGroupId());
    }

    private void addFileToZipStream(ZipOutputStream zos, File srcFile, String parentDirectoryName) throws IOException {
        if (srcFile == null || !srcFile.exists()) {
            return;
        }
        Object zipEntryName = srcFile.getName();
        if (parentDirectoryName != null && !parentDirectoryName.isEmpty()) {
            zipEntryName = parentDirectoryName + "/" + srcFile.getName();
        }
        if (srcFile.isDirectory()) {
            for (File file : srcFile.listFiles()) {
                this.addFileToZipStream(zos, file, (String)zipEntryName);
            }
        } else {
            zos.putNextEntry(new ZipEntry((String)zipEntryName));
            Files.copy(srcFile.toPath(), zos);
            zos.closeEntry();
        }
    }

    private File createInterpreterZip() throws IOException {
        File interpreterArchive = File.createTempFile("zeppelin_interpreter_", ".zip", Files.createTempDirectory("yarn_interpreter", new FileAttribute[0]).toFile());
        try (ZipOutputStream interpreterZipStream = new ZipOutputStream(new FileOutputStream(interpreterArchive));){
            File[] interpreterShadedFiles;
            interpreterZipStream.setLevel(0);
            String zeppelinHomeEnv = this.zConf.getZeppelinHome();
            if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)zeppelinHomeEnv)) {
                throw new IOException("ZEPPELIN_HOME is not specified");
            }
            File zeppelinHome = new File(zeppelinHomeEnv);
            File binDir = new File(zeppelinHome, "bin");
            this.addFileToZipStream(interpreterZipStream, binDir, null);
            File confDir = new File(zeppelinHome, "conf");
            this.addFileToZipStream(interpreterZipStream, confDir, null);
            File interpreterDir = new File(zeppelinHome, "interpreter/" + this.launchContext.getInterpreterSettingGroup());
            this.addFileToZipStream(interpreterZipStream, interpreterDir, "interpreter");
            File localRepoDir = new File(this.zConf.getInterpreterLocalRepoPath() + File.separator + this.launchContext.getInterpreterSettingName());
            if (localRepoDir.exists() && localRepoDir.isDirectory()) {
                LOGGER.debug("Adding localRepoDir {} to interpreter zip: ", (Object)localRepoDir.getAbsolutePath());
                this.addFileToZipStream(interpreterZipStream, localRepoDir, "local-repo");
            }
            if ((interpreterShadedFiles = new File(zeppelinHome, "interpreter").listFiles(file -> file.getName().startsWith("zeppelin-interpreter-shaded") && file.getName().endsWith(".jar"))).length == 0) {
                throw new IOException("No zeppelin-interpreter-shaded jar found under " + zeppelinHome.getAbsolutePath() + "/interpreter");
            }
            if (interpreterShadedFiles.length > 1) {
                throw new IOException("More than 1 zeppelin-interpreter-shaded jars found under " + zeppelinHome.getAbsolutePath() + "/interpreter");
            }
            this.addFileToZipStream(interpreterZipStream, interpreterShadedFiles[0], "interpreter");
            interpreterZipStream.flush();
        }
        return interpreterArchive;
    }

    private File createFlinkZip() throws IOException {
        File flinkArchive = File.createTempFile("flink_", ".zip", Files.createTempDirectory("yarn_interpreter", new FileAttribute[0]).toFile());
        try (ZipOutputStream flinkZipStream = new ZipOutputStream(new FileOutputStream(flinkArchive));){
            flinkZipStream.setLevel(0);
            String flinkHomeEnv = this.envs.get("FLINK_HOME");
            File flinkHome = new File(flinkHomeEnv);
            if (!flinkHome.exists() || !flinkHome.isDirectory()) {
                throw new IOException("FLINK_HOME " + flinkHome.getAbsolutePath() + " doesn't exist or is not a directory.");
            }
            for (File file : flinkHome.listFiles()) {
                this.addFileToZipStream(flinkZipStream, file, null);
            }
            flinkZipStream.flush();
        }
        return flinkArchive;
    }

    private File createHiveConfZip(File hiveConfDir) throws IOException {
        File hiveConfArchive = File.createTempFile("hive_conf", ".zip", Files.createTempDirectory("yarn_interpreter", new FileAttribute[0]).toFile());
        try (ZipOutputStream hiveConfZipStream = new ZipOutputStream(new FileOutputStream(hiveConfArchive));){
            hiveConfZipStream.setLevel(0);
            if (!hiveConfDir.exists()) {
                throw new IOException("HIVE_CONF_DIR " + hiveConfDir.getAbsolutePath() + " doesn't exist");
            }
            for (File file : hiveConfDir.listFiles()) {
                this.addFileToZipStream(hiveConfZipStream, file, null);
            }
            hiveConfZipStream.flush();
        }
        return hiveConfArchive;
    }

    private Path copyFileToRemote(Path destDir, Path srcPath, Short replication) throws IOException {
        FileSystem destFs = destDir.getFileSystem(this.hadoopConf);
        FileSystem srcFs = srcPath.getFileSystem(this.hadoopConf);
        Path destPath = new Path(destDir, srcPath.getName());
        LOGGER.info("Uploading resource {} to {}", (Object)srcPath, (Object)destPath);
        FileUtil.copy((FileSystem)srcFs, (Path)srcPath, (FileSystem)destFs, (Path)destPath, (boolean)false, (Configuration)this.hadoopConf);
        destFs.setReplication(destPath, replication.shortValue());
        destFs.setPermission(destPath, APP_FILE_PERMISSION);
        return destPath;
    }

    private void addResource(FileSystem fs, Path destPath, Map<String, LocalResource> localResources, LocalResourceType resourceType, String link) throws IOException {
        LOGGER.info("Add resource: {}, type: {}, link: {}", new Object[]{destPath, resourceType, link});
        FileStatus destStatus = fs.getFileStatus(destPath);
        LocalResource amJarRsrc = (LocalResource)Records.newRecord(LocalResource.class);
        amJarRsrc.setType(resourceType);
        amJarRsrc.setVisibility(LocalResourceVisibility.PUBLIC);
        amJarRsrc.setResource(ConverterUtils.getYarnUrlFromPath((Path)destPath));
        amJarRsrc.setTimestamp(destStatus.getModificationTime());
        amJarRsrc.setSize(destStatus.getLen());
        localResources.put(link, amJarRsrc);
    }

    public void stop() {
        if (this.isRunning()) {
            LOGGER.info("Kill interpreter process");
            try {
                this.callRemoteFunction(client -> {
                    client.shutdown();
                    return null;
                });
            }
            catch (Exception e) {
                LOGGER.warn("ignore the exception when shutting down", (Throwable)e);
            }
            super.close();
        }
        this.yarnClient.stop();
        LOGGER.info("Remote process terminated");
    }

    public String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }

    public boolean isAlive() {
        return this.isRunning();
    }

    public boolean isRunning() {
        return this.isYarnAppRunning.get();
    }
}

