/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zeppelin.utils;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Files;
import java.security.GeneralSecurityException;
import java.security.KeyPair;
import java.security.KeyStore;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.Security;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.List;
import javax.security.auth.x500.X500Principal;
import org.bouncycastle.asn1.pkcs.PrivateKeyInfo;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.openssl.PEMDecryptorProvider;
import org.bouncycastle.openssl.PEMEncryptedKeyPair;
import org.bouncycastle.openssl.PEMKeyPair;
import org.bouncycastle.openssl.PEMParser;
import org.bouncycastle.openssl.jcajce.JcaPEMKeyConverter;
import org.bouncycastle.openssl.jcajce.JceOpenSSLPKCS8DecryptorProviderBuilder;
import org.bouncycastle.openssl.jcajce.JcePEMDecryptorProviderBuilder;
import org.bouncycastle.operator.InputDecryptorProvider;
import org.bouncycastle.operator.OperatorCreationException;
import org.bouncycastle.pkcs.PKCS8EncryptedPrivateKeyInfo;
import org.bouncycastle.pkcs.PKCSException;
import org.bouncycastle.util.io.pem.PemObject;
import org.bouncycastle.util.io.pem.PemReader;

public class PEMImporter {
    private PEMImporter() {
    }

    public static KeyStore loadTrustStore(File certificateChainFile) throws IOException, GeneralSecurityException {
        KeyStore keyStore = KeyStore.getInstance("JKS");
        keyStore.load(null, null);
        List<X509Certificate> certificateChain = PEMImporter.readCertificateChain(certificateChainFile);
        for (X509Certificate certificate : certificateChain) {
            X500Principal principal = certificate.getSubjectX500Principal();
            keyStore.setCertificateEntry(principal.getName("RFC2253"), certificate);
        }
        return keyStore;
    }

    public static KeyStore loadKeyStore(File certificateChainFile, File privateKeyFile, String keyPassword) throws IOException, GeneralSecurityException {
        PrivateKey key;
        try {
            key = PEMImporter.createPrivateKey(privateKeyFile, keyPassword);
        }
        catch (IOException | GeneralSecurityException | OperatorCreationException | PKCSException e) {
            throw new GeneralSecurityException("Private Key issues", e);
        }
        List<X509Certificate> certificateChain = PEMImporter.readCertificateChain(certificateChainFile);
        if (certificateChain.isEmpty()) {
            throw new CertificateException("Certificate file does not contain any certificates: " + certificateChainFile);
        }
        KeyStore keyStore = KeyStore.getInstance("JKS");
        keyStore.load(null, null);
        keyStore.setKeyEntry("key", key, keyPassword.toCharArray(), (Certificate[])certificateChain.stream().toArray(Certificate[]::new));
        return keyStore;
    }

    private static List<X509Certificate> readCertificateChain(File certificateChainFile) throws IOException, GeneralSecurityException {
        ArrayList<X509Certificate> certs = new ArrayList<X509Certificate>();
        try (PemReader pemReader = new PemReader((Reader)Files.newBufferedReader(certificateChainFile.toPath()));){
            PemObject pemObject = pemReader.readPemObject();
            CertificateFactory certificateFactory = CertificateFactory.getInstance("X509");
            ByteArrayInputStream bais = new ByteArrayInputStream(pemObject.getContent());
            for (Certificate certificate : certificateFactory.generateCertificates(bais)) {
                if (!(certificate instanceof X509Certificate)) continue;
                certs.add((X509Certificate)certificate);
            }
            if (certs.isEmpty()) {
                throw new IllegalStateException("Unable to decode certificate chain");
            }
        }
        return certs;
    }

    private static PrivateKey createPrivateKey(File privateKeyPem, String keyPassword) throws IOException, GeneralSecurityException, OperatorCreationException, PKCSException {
        if (Security.getProvider("BC") == null) {
            Security.addProvider((Provider)new BouncyCastleProvider());
        }
        try (PEMParser parser = new PEMParser((Reader)Files.newBufferedReader(privateKeyPem.toPath()));){
            KeyPair kp;
            Object privateKeyObject = parser.readObject();
            JcaPEMKeyConverter converter = new JcaPEMKeyConverter().setProvider("BC");
            if (privateKeyObject instanceof PEMEncryptedKeyPair) {
                PEMEncryptedKeyPair ckp = (PEMEncryptedKeyPair)privateKeyObject;
                PEMDecryptorProvider decProv = new JcePEMDecryptorProviderBuilder().build(keyPassword.toCharArray());
                kp = converter.getKeyPair(ckp.decryptKeyPair(decProv));
            } else if (privateKeyObject instanceof PEMKeyPair) {
                PEMKeyPair ukp = (PEMKeyPair)privateKeyObject;
                kp = converter.getKeyPair(ukp);
            } else {
                if (privateKeyObject instanceof PrivateKeyInfo) {
                    PrivateKeyInfo pki = (PrivateKeyInfo)privateKeyObject;
                    PrivateKey decProv = converter.getPrivateKey(pki);
                    return decProv;
                }
                if (privateKeyObject instanceof PKCS8EncryptedPrivateKeyInfo) {
                    PKCS8EncryptedPrivateKeyInfo ckp = (PKCS8EncryptedPrivateKeyInfo)privateKeyObject;
                    InputDecryptorProvider devProv = new JceOpenSSLPKCS8DecryptorProviderBuilder().build(keyPassword.toCharArray());
                    PrivateKey privateKey = converter.getPrivateKey(ckp.decryptPrivateKeyInfo(devProv));
                    return privateKey;
                }
                throw new GeneralSecurityException("Unsupported key type: " + privateKeyObject.getClass());
            }
            PrivateKey privateKey = kp.getPrivate();
            return privateKey;
        }
    }
}

