/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zeppelin.socket;

import java.io.IOException;
import java.util.Map;
import javax.websocket.Session;
import org.apache.zeppelin.utils.ServerUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NotebookSocket {
    private static final Logger LOGGER = LoggerFactory.getLogger(NotebookSocket.class);
    private Session session;
    private Map<String, Object> headers;
    private String user;

    public NotebookSocket(Session session, Map<String, Object> headers) {
        this.session = session;
        this.headers = headers;
        this.user = "";
        LOGGER.debug("NotebookSocket created for session: {}", (Object)session.getId());
    }

    public String getHeader(String key) {
        return String.valueOf(this.headers.get(key));
    }

    public void send(String serializeMessage) throws IOException {
        this.session.getAsyncRemote().sendText(serializeMessage, result -> {
            if (result.getException() != null) {
                LOGGER.error("Failed to send async message for User {} in Session {}: {}", new Object[]{this.user, this.session.getId(), result.getException()});
            }
        });
    }

    public String getUser() {
        return this.user;
    }

    public void setUser(String user) {
        LOGGER.debug("Setting user: {}", (Object)user);
        this.user = user;
    }

    public String toString() {
        return ServerUtils.getRemoteAddress(this.session);
    }
}

