/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zeppelin.socket;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.reflect.TypeToken;
import io.micrometer.core.instrument.Metrics;
import io.micrometer.core.instrument.Tags;
import java.io.IOException;
import java.lang.reflect.Type;
import java.net.SocketTimeoutException;
import java.net.URISyntaxException;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicReference;
import javax.inject.Inject;
import javax.inject.Provider;
import javax.websocket.CloseReason;
import javax.websocket.EndpointConfig;
import javax.websocket.OnClose;
import javax.websocket.OnError;
import javax.websocket.OnMessage;
import javax.websocket.OnOpen;
import javax.websocket.Session;
import javax.websocket.server.ServerEndpoint;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.thrift.TException;
import org.apache.zeppelin.common.Message;
import org.apache.zeppelin.conf.ZeppelinConfiguration;
import org.apache.zeppelin.display.AngularObject;
import org.apache.zeppelin.display.AngularObjectRegistry;
import org.apache.zeppelin.display.AngularObjectRegistryListener;
import org.apache.zeppelin.display.GUI;
import org.apache.zeppelin.display.Input;
import org.apache.zeppelin.helium.ApplicationEventListener;
import org.apache.zeppelin.helium.HeliumPackage;
import org.apache.zeppelin.interpreter.InterpreterGroup;
import org.apache.zeppelin.interpreter.InterpreterResult;
import org.apache.zeppelin.interpreter.InterpreterSetting;
import org.apache.zeppelin.interpreter.remote.RemoteAngularObjectRegistry;
import org.apache.zeppelin.interpreter.remote.RemoteInterpreterProcessListener;
import org.apache.zeppelin.interpreter.thrift.InterpreterCompletion;
import org.apache.zeppelin.interpreter.thrift.ParagraphInfo;
import org.apache.zeppelin.interpreter.thrift.ServiceException;
import org.apache.zeppelin.jupyter.JupyterUtil;
import org.apache.zeppelin.notebook.AuthorizationService;
import org.apache.zeppelin.notebook.Note;
import org.apache.zeppelin.notebook.NoteEventListener;
import org.apache.zeppelin.notebook.NoteInfo;
import org.apache.zeppelin.notebook.NoteParser;
import org.apache.zeppelin.notebook.Notebook;
import org.apache.zeppelin.notebook.NotebookImportDeserializer;
import org.apache.zeppelin.notebook.Paragraph;
import org.apache.zeppelin.notebook.ParagraphJobListener;
import org.apache.zeppelin.notebook.repo.NotebookRepoWithVersionControl;
import org.apache.zeppelin.rest.exception.ForbiddenException;
import org.apache.zeppelin.scheduler.Job;
import org.apache.zeppelin.service.ConfigurationService;
import org.apache.zeppelin.service.JobManagerService;
import org.apache.zeppelin.service.NotebookService;
import org.apache.zeppelin.service.ServiceCallback;
import org.apache.zeppelin.service.ServiceContext;
import org.apache.zeppelin.service.SimpleServiceCallback;
import org.apache.zeppelin.socket.ConnectionManager;
import org.apache.zeppelin.socket.NotebookSocket;
import org.apache.zeppelin.ticket.TicketContainer;
import org.apache.zeppelin.types.InterpreterSettingsList;
import org.apache.zeppelin.user.AuthenticationInfo;
import org.apache.zeppelin.util.IdHashes;
import org.apache.zeppelin.utils.CorsUtils;
import org.apache.zeppelin.utils.ServerUtils;
import org.eclipse.jetty.util.annotation.ManagedAttribute;
import org.eclipse.jetty.util.annotation.ManagedObject;
import org.eclipse.jetty.util.annotation.ManagedOperation;
import org.glassfish.hk2.api.ServiceLocator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ManagedObject
@ServerEndpoint(value="/ws")
public class NotebookServer
implements AngularObjectRegistryListener,
RemoteInterpreterProcessListener,
ApplicationEventListener,
ParagraphJobListener,
NoteEventListener {
    private static final Logger LOGGER = LoggerFactory.getLogger(NotebookServer.class);
    private static final Gson gson = new GsonBuilder().setDateFormat("yyyy-MM-dd'T'HH:mm:ssZ").registerTypeAdapter(Date.class, (Object)new NotebookImportDeserializer()).setPrettyPrinting().registerTypeAdapterFactory((TypeAdapterFactory)Input.TypeAdapterFactory).create();
    private static final AtomicReference<NotebookServer> self = new AtomicReference();
    private final ExecutorService executorService = Executors.newFixedThreadPool(10);
    private final Map<String, NotebookSocket> sessionIdNotebookSocketMap = Metrics.gaugeMapSize((String)"zeppelin_session_id_notebook_sockets", (Iterable)Tags.empty(), new ConcurrentHashMap());
    private ConnectionManager connectionManager;
    private ZeppelinConfiguration zConf;
    private Provider<Notebook> notebookProvider;
    private Provider<NoteParser> noteParser;
    private Provider<NotebookService> notebookServiceProvider;
    private AuthorizationService authorizationService;
    private Provider<ConfigurationService> configurationServiceProvider;
    private Provider<JobManagerService> jobManagerServiceProvider;

    public NotebookServer() {
        self.set(this);
        LOGGER.info("NotebookServer instantiated: {}", (Object)this);
    }

    @Inject
    public void setZeppelinConfiguration(ZeppelinConfiguration zConf) {
        this.zConf = zConf;
    }

    @Inject
    public void setNoteParser(Provider<NoteParser> noteParser) {
        this.noteParser = noteParser;
        LOGGER.info("Injected NoteParser");
    }

    @Inject
    public void setServiceLocator(ServiceLocator serviceLocator) {
        LOGGER.info("Injected ServiceLocator: {}", (Object)serviceLocator);
    }

    @Inject
    public void setNotebook(Provider<Notebook> notebookProvider) {
        this.notebookProvider = notebookProvider;
        LOGGER.info("Injected NotebookProvider");
    }

    @Inject
    public void setNotebookService(Provider<NotebookService> notebookServiceProvider) {
        this.notebookServiceProvider = notebookServiceProvider;
        LOGGER.info("Injected NotebookServiceProvider");
    }

    @Inject
    public void setAuthorizationService(AuthorizationService authorizationService) {
        this.authorizationService = authorizationService;
        LOGGER.info("Injected NotebookAuthorizationService");
    }

    @Inject
    public void setConnectionManager(ConnectionManager connectionManager) {
        this.connectionManager = connectionManager;
    }

    public ConnectionManager getConnectionManager() {
        return this.connectionManager;
    }

    @Inject
    public void setConfigurationService(Provider<ConfigurationService> configurationServiceProvider) {
        this.configurationServiceProvider = configurationServiceProvider;
    }

    @Inject
    public void setJobManagerService(Provider<JobManagerService> jobManagerServiceProvider) {
        this.jobManagerServiceProvider = jobManagerServiceProvider;
    }

    public Notebook getNotebook() {
        return (Notebook)this.notebookProvider.get();
    }

    public NotebookService getNotebookService() {
        return (NotebookService)this.notebookServiceProvider.get();
    }

    public ConfigurationService getConfigurationService() {
        return (ConfigurationService)this.configurationServiceProvider.get();
    }

    public synchronized JobManagerService getJobManagerService() {
        return (JobManagerService)this.jobManagerServiceProvider.get();
    }

    public boolean checkOrigin(String origin) {
        try {
            return CorsUtils.isValidOrigin(origin, this.zConf);
        }
        catch (URISyntaxException | UnknownHostException e) {
            LOGGER.error(e.toString(), (Throwable)e);
            return false;
        }
    }

    @OnOpen
    public void onOpen(Session session, EndpointConfig endpointConfig) throws IOException {
        LOGGER.info("Open connection to {} with Session: {}, config: {}", new Object[]{ServerUtils.getRemoteAddress(session), session, endpointConfig.getUserProperties().keySet()});
        Map headers = endpointConfig.getUserProperties();
        String origin = String.valueOf(headers.get("Origin"));
        if (this.checkOrigin(origin)) {
            NotebookSocket notebookSocket = this.sessionIdNotebookSocketMap.computeIfAbsent(session.getId(), unused -> new NotebookSocket(session, headers));
            this.onOpen(notebookSocket);
        } else {
            LOGGER.error("Websocket request is not allowed by {} settings. Origin: {}", (Object)ZeppelinConfiguration.ConfVars.ZEPPELIN_ALLOWED_ORIGINS, (Object)origin);
            session.close();
        }
    }

    public void onOpen(NotebookSocket conn) {
        this.connectionManager.addConnection(conn);
    }

    @OnMessage
    public void onMessage(Session session, String msg) {
        NotebookSocket conn = this.sessionIdNotebookSocketMap.get(session.getId());
        this.onMessage(conn, msg);
    }

    public void onMessage(NotebookSocket conn, String msg) {
        try {
            boolean noteRunning;
            TicketContainer.Entry ticketEntry;
            Message receivedMessage = this.deserializeMessage(msg);
            if (receivedMessage.op != Message.OP.PING) {
                LOGGER.debug("RECEIVE: " + receivedMessage.op + ", RECEIVE PRINCIPAL: " + receivedMessage.principal + ", RECEIVE TICKET: " + receivedMessage.ticket + ", RECEIVE ROLES: " + receivedMessage.roles + ", RECEIVE DATA: " + receivedMessage.data);
            }
            if (LOGGER.isTraceEnabled()) {
                LOGGER.trace("RECEIVE MSG = " + receivedMessage);
            }
            if ((ticketEntry = TicketContainer.instance.getTicketEntry(receivedMessage.principal)) == null || StringUtils.isEmpty((CharSequence)ticketEntry.getTicket())) {
                LOGGER.debug("{} message: invalid ticket {}", (Object)receivedMessage.op, (Object)receivedMessage.ticket);
                return;
            }
            if (!ticketEntry.getTicket().equals(receivedMessage.ticket)) {
                LOGGER.debug("{} message: invalid ticket {} != {}", new Object[]{receivedMessage.op, receivedMessage.ticket, ticketEntry.getTicket()});
                if (!receivedMessage.op.equals((Object)Message.OP.PING)) {
                    conn.send(this.serializeMessage(new Message(Message.OP.SESSION_LOGOUT).put("info", (Object)"Your ticket is invalid possibly due to server restart. Please login again.")));
                }
                return;
            }
            boolean allowAnonymous = this.zConf.isAnonymousAllowed();
            if (!allowAnonymous && receivedMessage.principal.equals("anonymous")) {
                LOGGER.warn("Anonymous access not allowed.");
                return;
            }
            if (Message.isDisabledForRunningNotes((Message.OP)receivedMessage.op) && (noteRunning = ((Boolean)this.getNotebook().processNote((String)receivedMessage.get("noteId"), note -> note != null && note.isRunning())).booleanValue())) {
                throw new Exception("Note is now running sequentially. Can not be performed: " + receivedMessage.op);
            }
            if (StringUtils.isEmpty((CharSequence)conn.getUser())) {
                this.connectionManager.addUserConnection(receivedMessage.principal, conn);
            }
            ServiceContext context = this.getServiceContext(ticketEntry);
            switch (receivedMessage.op) {
                case LIST_NOTES: {
                    this.listNotesInfo(conn, context);
                    break;
                }
                case RELOAD_NOTES_FROM_REPO: {
                    this.broadcastReloadedNoteList(context);
                    break;
                }
                case GET_HOME_NOTE: {
                    this.getHomeNote(conn, context);
                    break;
                }
                case GET_NOTE: {
                    this.getNote(conn, context, receivedMessage);
                    break;
                }
                case RELOAD_NOTE: {
                    this.reloadNote(conn, context, receivedMessage);
                    break;
                }
                case NEW_NOTE: {
                    this.createNote(conn, context, receivedMessage);
                    break;
                }
                case DEL_NOTE: {
                    this.deleteNote(conn, context, receivedMessage);
                    break;
                }
                case REMOVE_FOLDER: {
                    this.removeFolder(conn, context, receivedMessage);
                    break;
                }
                case MOVE_NOTE_TO_TRASH: {
                    this.moveNoteToTrash(conn, context, receivedMessage);
                    break;
                }
                case MOVE_FOLDER_TO_TRASH: {
                    this.moveFolderToTrash(conn, context, receivedMessage);
                    break;
                }
                case EMPTY_TRASH: {
                    this.emptyTrash(conn, context);
                    break;
                }
                case RESTORE_FOLDER: {
                    this.restoreFolder(conn, context, receivedMessage);
                    break;
                }
                case RESTORE_NOTE: {
                    this.restoreNote(conn, context, receivedMessage);
                    break;
                }
                case RESTORE_ALL: {
                    this.restoreAll(conn, context, receivedMessage);
                    break;
                }
                case CLONE_NOTE: {
                    this.cloneNote(conn, context, receivedMessage);
                    break;
                }
                case IMPORT_NOTE: {
                    this.importNote(conn, context, receivedMessage);
                    break;
                }
                case CONVERT_NOTE_NBFORMAT: {
                    this.convertNote(conn, receivedMessage);
                    break;
                }
                case COMMIT_PARAGRAPH: {
                    this.updateParagraph(conn, context, receivedMessage);
                    break;
                }
                case RUN_PARAGRAPH: {
                    this.runParagraph(conn, context, receivedMessage);
                    break;
                }
                case PARAGRAPH_EXECUTED_BY_SPELL: {
                    this.broadcastSpellExecution(conn, context, receivedMessage);
                    break;
                }
                case RUN_ALL_PARAGRAPHS: {
                    this.runAllParagraphs(conn, context, receivedMessage);
                    break;
                }
                case CANCEL_PARAGRAPH: {
                    this.cancelParagraph(conn, context, receivedMessage);
                    break;
                }
                case MOVE_PARAGRAPH: {
                    this.moveParagraph(conn, context, receivedMessage);
                    break;
                }
                case INSERT_PARAGRAPH: {
                    this.insertParagraph(conn, context, receivedMessage);
                    break;
                }
                case COPY_PARAGRAPH: {
                    this.copyParagraph(conn, context, receivedMessage);
                    break;
                }
                case PARAGRAPH_REMOVE: {
                    this.removeParagraph(conn, context, receivedMessage);
                    break;
                }
                case PARAGRAPH_CLEAR_OUTPUT: {
                    this.clearParagraphOutput(conn, context, receivedMessage);
                    break;
                }
                case PARAGRAPH_CLEAR_ALL_OUTPUT: {
                    this.clearAllParagraphOutput(conn, context, receivedMessage);
                    break;
                }
                case NOTE_UPDATE: {
                    this.updateNote(conn, context, receivedMessage);
                    break;
                }
                case NOTE_RENAME: {
                    this.renameNote(conn, context, receivedMessage);
                    break;
                }
                case FOLDER_RENAME: {
                    this.renameFolder(conn, context, receivedMessage);
                    break;
                }
                case UPDATE_PERSONALIZED_MODE: {
                    this.updatePersonalizedMode(conn, context, receivedMessage);
                    break;
                }
                case COMPLETION: {
                    this.completion(conn, context, receivedMessage);
                    break;
                }
                case PING: {
                    break;
                }
                case ANGULAR_OBJECT_UPDATED: {
                    this.angularObjectUpdated(conn, context, receivedMessage);
                    break;
                }
                case ANGULAR_OBJECT_CLIENT_BIND: {
                    this.angularObjectClientBind(conn, receivedMessage);
                    break;
                }
                case ANGULAR_OBJECT_CLIENT_UNBIND: {
                    this.angularObjectClientUnbind(conn, receivedMessage);
                    break;
                }
                case LIST_CONFIGURATIONS: {
                    this.sendAllConfigurations(conn, context, receivedMessage);
                    break;
                }
                case CHECKPOINT_NOTE: {
                    this.checkpointNote(conn, context, receivedMessage);
                    break;
                }
                case LIST_REVISION_HISTORY: {
                    this.listRevisionHistory(conn, context, receivedMessage);
                    break;
                }
                case SET_NOTE_REVISION: {
                    this.setNoteRevision(conn, context, receivedMessage);
                    break;
                }
                case NOTE_REVISION: {
                    this.getNoteByRevision(conn, context, receivedMessage);
                    break;
                }
                case NOTE_REVISION_FOR_COMPARE: {
                    this.getNoteByRevisionForCompare(conn, context, receivedMessage);
                    break;
                }
                case LIST_NOTE_JOBS: {
                    this.unicastNoteJobInfo(conn, context, receivedMessage);
                    break;
                }
                case UNSUBSCRIBE_UPDATE_NOTE_JOBS: {
                    this.unsubscribeNoteJobInfo(conn);
                    break;
                }
                case GET_INTERPRETER_BINDINGS: {
                    this.getInterpreterBindings(conn, context, receivedMessage);
                    break;
                }
                case SAVE_INTERPRETER_BINDINGS: {
                    this.saveInterpreterBindings(conn, context, receivedMessage);
                    break;
                }
                case EDITOR_SETTING: {
                    this.getEditorSetting(conn, context, receivedMessage);
                    break;
                }
                case GET_INTERPRETER_SETTINGS: {
                    this.getInterpreterSettings(conn, context, receivedMessage);
                    break;
                }
                case WATCHER: {
                    this.connectionManager.switchConnectionToWatcher(conn);
                    break;
                }
                case SAVE_NOTE_FORMS: {
                    this.saveNoteForms(conn, context, receivedMessage);
                    break;
                }
                case REMOVE_NOTE_FORMS: {
                    this.removeNoteForms(conn, context, receivedMessage);
                    break;
                }
                case PATCH_PARAGRAPH: {
                    this.patchParagraph(conn, context, receivedMessage);
                    break;
                }
            }
        }
        catch (Exception e) {
            LOGGER.error("Can't handle message: {}", (Object)msg, (Object)e);
            try {
                conn.send(this.serializeMessage(new Message(Message.OP.ERROR_INFO).put("info", (Object)e.getMessage())));
            }
            catch (IOException iox) {
                LOGGER.error("Fail to send error info", (Throwable)iox);
            }
        }
    }

    @OnClose
    public void onClose(Session session, CloseReason closeReason) {
        NotebookSocket notebookSocket = this.sessionIdNotebookSocketMap.remove(session.getId());
        if (notebookSocket != null) {
            LOGGER.info("Closed connection to {} ({}) {}", new Object[]{ServerUtils.getRemoteAddress(session), closeReason.getCloseCode().getCode(), closeReason.getReasonPhrase()});
            this.removeConnection(notebookSocket);
        }
    }

    private void removeConnection(NotebookSocket notebookSocket) {
        this.connectionManager.removeConnection(notebookSocket);
        this.connectionManager.removeConnectionFromAllNote(notebookSocket);
        this.connectionManager.removeUserConnection(notebookSocket.getUser(), notebookSocket);
    }

    private boolean sendParagraphStatusToFrontend() {
        return this.zConf.getBoolean(ZeppelinConfiguration.ConfVars.ZEPPELIN_WEBSOCKET_PARAGRAPH_STATUS_PROGRESS);
    }

    @OnError
    public void onError(Session session, Throwable error) {
        NotebookSocket notebookSocket;
        if (session != null && (notebookSocket = this.sessionIdNotebookSocketMap.remove(session.getId())) != null) {
            this.removeConnection(notebookSocket);
        }
        if (error instanceof SocketTimeoutException) {
            LOGGER.warn("Socket Session to {} timed out", (Object)ServerUtils.getRemoteAddress(session));
            LOGGER.debug("SocketTimeoutException", error);
        } else if (error instanceof IOException) {
            LOGGER.warn("Client {} is gone", (Object)ServerUtils.getRemoteAddress(session));
            LOGGER.debug("IOException", error);
        } else {
            LOGGER.error("Error in WebSocket Session to {}", (Object)ServerUtils.getRemoteAddress(session), (Object)error);
        }
    }

    protected Message deserializeMessage(String msg) {
        return (Message)gson.fromJson(msg, Message.class);
    }

    protected String serializeMessage(Message m) {
        return gson.toJson((Object)m);
    }

    public void broadcast(Message m) {
        this.connectionManager.broadcast(m);
    }

    public void unicastNoteJobInfo(final NotebookSocket conn, ServiceContext context, Message fromMessage) throws IOException {
        this.connectionManager.addNoteConnection(JobManagerServiceType.JOB_MANAGER_PAGE.getKey(), conn);
        this.getJobManagerService().getNoteJobInfoByUnixTime(0L, context, (ServiceCallback<List<JobManagerService.NoteJobInfo>>)new WebSocketServiceCallback<List<JobManagerService.NoteJobInfo>>(conn){

            @Override
            public void onSuccess(List<JobManagerService.NoteJobInfo> notesJobInfo, ServiceContext context) throws IOException {
                super.onSuccess(notesJobInfo, context);
                HashMap<String, Object> response = new HashMap<String, Object>();
                response.put("lastResponseUnixTime", System.currentTimeMillis());
                response.put("jobs", notesJobInfo);
                conn.send(NotebookServer.this.serializeMessage(new Message(Message.OP.LIST_NOTE_JOBS).put("noteJobs", response)));
            }

            @Override
            public void onFailure(Exception ex, ServiceContext context) throws IOException {
                LOGGER.warn(ex.getMessage());
            }
        });
    }

    public void broadcastUpdateNoteJobInfo(Note note, long lastUpdateUnixTime) throws IOException {
        ServiceContext context = new ServiceContext(new AuthenticationInfo(), this.authorizationService.getOwners(note.getId()));
        this.getJobManagerService().getNoteJobInfoByUnixTime(lastUpdateUnixTime, context, (ServiceCallback<List<JobManagerService.NoteJobInfo>>)new WebSocketServiceCallback<List<JobManagerService.NoteJobInfo>>(null){

            @Override
            public void onSuccess(List<JobManagerService.NoteJobInfo> notesJobInfo, ServiceContext context) throws IOException {
                super.onSuccess(notesJobInfo, context);
                HashMap<String, Object> response = new HashMap<String, Object>();
                response.put("lastResponseUnixTime", System.currentTimeMillis());
                response.put("jobs", notesJobInfo);
                NotebookServer.this.connectionManager.broadcast(JobManagerServiceType.JOB_MANAGER_PAGE.getKey(), new Message(Message.OP.LIST_UPDATE_NOTE_JOBS).put("noteRunningJobs", response));
            }

            @Override
            public void onFailure(Exception ex, ServiceContext context) throws IOException {
                LOGGER.warn(ex.getMessage());
            }
        });
    }

    public void unsubscribeNoteJobInfo(NotebookSocket conn) {
        this.connectionManager.removeNoteConnection(JobManagerServiceType.JOB_MANAGER_PAGE.getKey(), conn);
    }

    public void getInterpreterBindings(NotebookSocket conn, ServiceContext context, Message fromMessage) throws IOException {
        ArrayList settingList = new ArrayList();
        String noteId = (String)fromMessage.data.get("noteId");
        this.getNotebook().processNote(noteId, note -> {
            if (note != null) {
                List bindedSettings = note.getBindedInterpreterSettings(new ArrayList<String>(context.getUserAndRoles()));
                for (InterpreterSetting setting : bindedSettings) {
                    settingList.add(new InterpreterSettingsList(setting.getId(), setting.getName(), setting.getInterpreterInfos(), true));
                }
            }
            conn.send(this.serializeMessage(new Message(Message.OP.INTERPRETER_BINDINGS).put("interpreterBindings", (Object)settingList)));
            return null;
        });
    }

    public void saveInterpreterBindings(NotebookSocket conn, ServiceContext context, Message fromMessage) throws IOException {
        ArrayList settingList = new ArrayList();
        String noteId = (String)fromMessage.data.get("noteId");
        this.getNotebook().processNote(noteId, note -> {
            if (note != null) {
                List settingIdList = (List)gson.fromJson(String.valueOf(fromMessage.data.get("selectedSettingIds")), new TypeToken<ArrayList<String>>(){}.getType());
                if (!settingIdList.isEmpty()) {
                    note.setDefaultInterpreterGroup((String)settingIdList.get(0));
                    this.getNotebook().saveNote(note, context.getAutheInfo());
                }
                List bindedSettings = note.getBindedInterpreterSettings(new ArrayList<String>(context.getUserAndRoles()));
                for (InterpreterSetting setting : bindedSettings) {
                    settingList.add(new InterpreterSettingsList(setting.getId(), setting.getName(), setting.getInterpreterInfos(), true));
                }
            }
            return null;
        });
        conn.send(this.serializeMessage(new Message(Message.OP.INTERPRETER_BINDINGS).put("interpreterBindings", settingList)));
    }

    public void broadcastNote(Note note) {
        this.inlineBroadcastNote(note);
    }

    private void inlineBroadcastNote(Note note) {
        Message message = new Message(Message.OP.NOTE).put("note", (Object)note);
        this.connectionManager.broadcast(note.getId(), message);
    }

    private void inlineBroadcastParagraph(Note note, Paragraph p, String msgId) {
        this.broadcastNoteForms(note);
        if (note.isPersonalizedMode()) {
            this.broadcastParagraphs(p.getUserParagraphMap(), p, msgId);
        } else {
            Message message = new Message(Message.OP.PARAGRAPH).withMsgId(msgId).put("paragraph", (Object)p);
            this.connectionManager.broadcast(note.getId(), message);
        }
    }

    public void broadcastParagraph(Note note, Paragraph p, String msgId) {
        this.inlineBroadcastParagraph(note, p, msgId);
    }

    private void inlineBroadcastParagraphs(Map<String, Paragraph> userParagraphMap, String msgId) {
        if (null != userParagraphMap) {
            for (String user : userParagraphMap.keySet()) {
                Message message = new Message(Message.OP.PARAGRAPH).withMsgId(msgId).put("paragraph", (Object)userParagraphMap.get(user));
                this.connectionManager.multicastToUser(user, message);
            }
        }
    }

    private void broadcastParagraphs(Map<String, Paragraph> userParagraphMap, Paragraph defaultParagraph, String msgId) {
        this.inlineBroadcastParagraphs(userParagraphMap, msgId);
    }

    private void inlineBroadcastNewParagraph(Note note, Paragraph para) {
        LOGGER.info("Broadcasting paragraph on run call instead of note.");
        int paraIndex = note.getParagraphs().indexOf(para);
        Message message = new Message(Message.OP.PARAGRAPH_ADDED).put("paragraph", (Object)para).put("index", (Object)paraIndex);
        this.connectionManager.broadcast(note.getId(), message);
    }

    private void broadcastNewParagraph(Note note, Paragraph para) {
        this.inlineBroadcastNewParagraph(note, para);
    }

    private void inlineBroadcastNoteList() {
        this.broadcastNoteListUpdate();
    }

    public void broadcastNoteListUpdate() {
        this.connectionManager.forAllUsers((user, userAndRoles) -> {
            List notesInfo = this.getNotebook().getNotesInfo(noteId -> this.authorizationService.isReader(noteId, userAndRoles));
            this.connectionManager.multicastToUser(user, new Message(Message.OP.NOTES_INFO).put("notes", (Object)notesInfo));
        });
    }

    public void broadcastNoteList(AuthenticationInfo subject, Set<String> userAndRoles) {
        this.inlineBroadcastNoteList();
    }

    public void listNotesInfo(final NotebookSocket conn, ServiceContext context) throws IOException {
        this.getNotebookService().listNotesInfo(false, context, (ServiceCallback<List<NoteInfo>>)new WebSocketServiceCallback<List<NoteInfo>>(conn){

            @Override
            public void onSuccess(List<NoteInfo> notesInfo, ServiceContext context) throws IOException {
                super.onSuccess(notesInfo, context);
                NotebookServer.this.connectionManager.unicast(new Message(Message.OP.NOTES_INFO).put("notes", notesInfo), conn);
            }
        });
    }

    public void broadcastReloadedNoteList(ServiceContext context) throws IOException {
        this.getNotebook().reloadAllNotes(context.getAutheInfo());
        this.broadcastNoteListUpdate();
    }

    void permissionError(NotebookSocket conn, String op, String userName, Set<String> userAndRoles, Set<String> allowed) throws IOException {
        LOGGER.info("Cannot {}. Connection readers {}. Allowed readers {}", new Object[]{op, userAndRoles, allowed});
        conn.send(this.serializeMessage(new Message(Message.OP.AUTH_INFO).put("info", (Object)("Insufficient privileges to " + op + " note.\n\nAllowed users or roles: " + allowed.toString() + "\n\nBut the user " + userName + " belongs to: " + userAndRoles.toString()))));
    }

    private boolean hasParagraphWriterPermission(NotebookSocket conn, Notebook notebook, String noteId, Set<String> userAndRoles, String principal, String op) throws IOException {
        if (!this.authorizationService.isWriter(noteId, userAndRoles)) {
            this.permissionError(conn, op, principal, userAndRoles, this.authorizationService.getOwners(noteId));
            return false;
        }
        return true;
    }

    private void getNote(final NotebookSocket conn, ServiceContext context, Message fromMessage) throws IOException {
        String noteId = (String)fromMessage.get("id");
        if (noteId == null) {
            return;
        }
        this.getNotebookService().getNote(noteId, context, (ServiceCallback<Note>)new WebSocketServiceCallback<Note>(conn){

            @Override
            public void onSuccess(Note note, ServiceContext context) throws IOException {
                NotebookServer.this.connectionManager.addNoteConnection(note.getId(), conn);
                conn.send(NotebookServer.this.serializeMessage(new Message(Message.OP.NOTE).put("note", (Object)note)));
                NotebookServer.this.updateAngularObjectRegistry(conn, note);
                NotebookServer.this.sendAllAngularObjects(note, context.getAutheInfo().getUser(), conn);
            }
        }, null);
    }

    private void reloadNote(final NotebookSocket conn, ServiceContext context, Message fromMessage) throws IOException {
        String noteId = (String)fromMessage.get("id");
        if (noteId == null) {
            return;
        }
        this.getNotebookService().getNote(noteId, true, context, (ServiceCallback<Note>)new WebSocketServiceCallback<Note>(conn){

            @Override
            public void onSuccess(Note note, ServiceContext context) throws IOException {
                NotebookServer.this.connectionManager.addNoteConnection(note.getId(), conn);
                conn.send(NotebookServer.this.serializeMessage(new Message(Message.OP.NOTE).put("note", (Object)note)));
                NotebookServer.this.updateAngularObjectRegistry(conn, note);
                NotebookServer.this.sendAllAngularObjects(note, context.getAutheInfo().getUser(), conn);
            }
        }, null);
    }

    private void updateAngularObjectRegistry(NotebookSocket conn, Note note) {
        for (Paragraph paragraph : note.getParagraphs()) {
            InterpreterGroup interpreterGroup = null;
            try {
                interpreterGroup = this.findInterpreterGroupForParagraph(note, paragraph.getId());
            }
            catch (Exception e) {
                LOGGER.warn(e.getMessage(), (Throwable)e);
            }
            if (null == interpreterGroup) {
                return;
            }
            RemoteAngularObjectRegistry registry = (RemoteAngularObjectRegistry)interpreterGroup.getAngularObjectRegistry();
            List angularObjects = note.getAngularObjects(interpreterGroup.getId());
            for (AngularObject ao : angularObjects) {
                if (!StringUtils.equals((CharSequence)ao.getNoteId(), (CharSequence)note.getId()) || !StringUtils.equals((CharSequence)ao.getParagraphId(), (CharSequence)paragraph.getId())) continue;
                this.pushAngularObjectToRemoteRegistry(ao.getNoteId(), ao.getParagraphId(), ao.getName(), ao.get(), registry, interpreterGroup.getId(), conn);
            }
        }
    }

    private void getHomeNote(final NotebookSocket conn, ServiceContext context) throws IOException {
        this.getNotebookService().getHomeNote(context, (ServiceCallback<Note>)new WebSocketServiceCallback<Note>(conn){

            @Override
            public void onSuccess(Note note, ServiceContext context) throws IOException {
                super.onSuccess(note, context);
                if (note != null) {
                    NotebookServer.this.connectionManager.addNoteConnection(note.getId(), conn);
                    conn.send(NotebookServer.this.serializeMessage(new Message(Message.OP.NOTE).put("note", (Object)note)));
                    NotebookServer.this.sendAllAngularObjects(note, context.getAutheInfo().getUser(), conn);
                } else {
                    NotebookServer.this.connectionManager.removeConnectionFromAllNote(conn);
                    conn.send(NotebookServer.this.serializeMessage(new Message(Message.OP.NOTE).put("note", null)));
                }
            }
        });
    }

    private void updateNote(NotebookSocket conn, ServiceContext context, Message fromMessage) throws IOException {
        String noteId = (String)fromMessage.get("id");
        final String name = (String)fromMessage.get("name");
        final Map config = (Map)fromMessage.get("config");
        if (noteId == null) {
            return;
        }
        if (config == null) {
            return;
        }
        this.getNotebookService().updateNote(noteId, name, config, context, (ServiceCallback<Note>)new WebSocketServiceCallback<Note>(conn){

            @Override
            public void onSuccess(Note note, ServiceContext context) throws IOException {
                NotebookServer.this.connectionManager.broadcast(note.getId(), new Message(Message.OP.NOTE_UPDATED).put("name", (Object)name).put("config", (Object)config).put("info", (Object)note.getInfo()));
                NotebookServer.this.broadcastNoteList(context.getAutheInfo(), context.getUserAndRoles());
            }
        });
    }

    private void updatePersonalizedMode(NotebookSocket conn, ServiceContext context, Message fromMessage) throws IOException {
        String noteId = (String)fromMessage.get("id");
        String personalized = (String)fromMessage.get("personalized");
        boolean isPersonalized = personalized.equals("true");
        this.getNotebookService().updatePersonalizedMode(noteId, isPersonalized, context, (ServiceCallback<Note>)new WebSocketServiceCallback<Note>(conn){

            @Override
            public void onSuccess(Note note, ServiceContext context) throws IOException {
                super.onSuccess(note, context);
                NotebookServer.this.connectionManager.broadcastNote(note);
            }
        });
    }

    private void renameNote(NotebookSocket conn, ServiceContext context, Message fromMessage) throws IOException {
        final String noteId = (String)fromMessage.get("id");
        String name = (String)fromMessage.get("name");
        boolean isRelativePath = false;
        if (fromMessage.get("relative") != null) {
            isRelativePath = (Boolean)fromMessage.get("relative");
        }
        if (noteId == null) {
            return;
        }
        this.getNotebookService().renameNote(noteId, name, isRelativePath, context, (ServiceCallback<Note>)new WebSocketServiceCallback<Note>(conn){

            @Override
            public void onSuccess(Note note, ServiceContext context) throws IOException {
                super.onSuccess(note, context);
                NotebookServer.this.broadcastNote(note);
                NotebookServer.this.broadcastNoteList(context.getAutheInfo(), context.getUserAndRoles());
            }

            @Override
            public void onFailure(Exception ex, ServiceContext context) throws IOException {
                super.onFailure(ex, context);
                NotebookServer.this.getNotebook().processNote(noteId, note -> {
                    NotebookServer.this.broadcastNote(note);
                    return null;
                });
            }
        });
    }

    private void renameFolder(NotebookSocket conn, ServiceContext context, Message fromMessage) throws IOException {
        String oldFolderId = (String)fromMessage.get("id");
        String newFolderId = (String)fromMessage.get("name");
        this.getNotebookService().renameFolder(oldFolderId, newFolderId, context, (ServiceCallback<List<NoteInfo>>)new WebSocketServiceCallback<List<NoteInfo>>(conn){

            @Override
            public void onSuccess(List<NoteInfo> result, ServiceContext context) throws IOException {
                super.onSuccess(result, context);
                NotebookServer.this.broadcastNoteList(context.getAutheInfo(), context.getUserAndRoles());
            }
        });
    }

    private void createNote(final NotebookSocket conn, ServiceContext context, Message message) throws IOException {
        String noteName = (String)message.get("name");
        String defaultInterpreterGroup = (String)message.get("defaultInterpreterGroup");
        this.getNotebookService().createNote(noteName, defaultInterpreterGroup, true, context, (ServiceCallback<Note>)new WebSocketServiceCallback<Note>(conn){

            @Override
            public void onSuccess(Note note, ServiceContext context) throws IOException {
                super.onSuccess(note, context);
                NotebookServer.this.connectionManager.addNoteConnection(note.getId(), conn);
                conn.send(NotebookServer.this.serializeMessage(new Message(Message.OP.NEW_NOTE).put("note", (Object)note)));
                NotebookServer.this.broadcastNoteList(context.getAutheInfo(), context.getUserAndRoles());
            }

            @Override
            public void onFailure(Exception ex, ServiceContext context) throws IOException {
                super.onFailure(ex, context);
                conn.send(NotebookServer.this.serializeMessage(new Message(Message.OP.ERROR_INFO).put("info", (Object)("Failed to create note.\n" + ExceptionUtils.getMessage((Throwable)ex)))));
            }
        });
    }

    private void deleteNote(NotebookSocket conn, ServiceContext context, Message fromMessage) throws IOException {
        final String noteId = (String)fromMessage.get("id");
        this.getNotebookService().removeNote(noteId, context, (ServiceCallback<String>)new WebSocketServiceCallback<String>(conn){

            @Override
            public void onSuccess(String message, ServiceContext context) throws IOException {
                super.onSuccess(message, context);
                NotebookServer.this.connectionManager.removeNoteConnection(noteId);
                NotebookServer.this.broadcastNoteList(context.getAutheInfo(), context.getUserAndRoles());
            }
        });
    }

    private void removeFolder(NotebookSocket conn, ServiceContext context, Message fromMessage) throws IOException {
        Object folderPath = (String)fromMessage.get("id");
        folderPath = "/" + (String)folderPath;
        this.getNotebookService().removeFolder((String)folderPath, context, (ServiceCallback<List<NoteInfo>>)new WebSocketServiceCallback<List<NoteInfo>>(conn){

            @Override
            public void onSuccess(List<NoteInfo> notesInfo, ServiceContext context) throws IOException {
                super.onSuccess(notesInfo, context);
                for (NoteInfo noteInfo : notesInfo) {
                    NotebookServer.this.connectionManager.removeNoteConnection(noteInfo.getId());
                }
                NotebookServer.this.broadcastNoteList(context.getAutheInfo(), context.getUserAndRoles());
            }
        });
    }

    private void moveNoteToTrash(NotebookSocket conn, ServiceContext context, Message fromMessage) throws IOException {
        String noteId = (String)fromMessage.get("id");
        this.getNotebookService().moveNoteToTrash(noteId, context, (ServiceCallback<Note>)new WebSocketServiceCallback<Note>(conn){

            @Override
            public void onSuccess(Note note, ServiceContext context) throws IOException {
                super.onSuccess(note, context);
                NotebookServer.this.broadcastNote(note);
                NotebookServer.this.broadcastNoteList(context.getAutheInfo(), context.getUserAndRoles());
            }
        });
    }

    private void moveFolderToTrash(NotebookSocket conn, ServiceContext context, Message fromMessage) throws IOException {
        String folderPath = (String)fromMessage.get("id");
        this.getNotebookService().moveFolderToTrash(folderPath, context, (ServiceCallback<Void>)new WebSocketServiceCallback<Void>(conn){

            @Override
            public void onSuccess(Void result, ServiceContext context) throws IOException {
                super.onSuccess(result, context);
                NotebookServer.this.broadcastNoteList(context.getAutheInfo(), context.getUserAndRoles());
            }
        });
    }

    private void restoreNote(NotebookSocket conn, ServiceContext context, Message fromMessage) throws IOException {
        String noteId = (String)fromMessage.get("id");
        this.getNotebookService().restoreNote(noteId, context, (ServiceCallback<Note>)new WebSocketServiceCallback<Note>(conn){

            @Override
            public void onSuccess(Note note, ServiceContext context) throws IOException {
                super.onSuccess(note, context);
                NotebookServer.this.broadcastNote(note);
                NotebookServer.this.broadcastNoteList(context.getAutheInfo(), context.getUserAndRoles());
            }
        });
    }

    private void restoreFolder(NotebookSocket conn, ServiceContext context, Message fromMessage) throws IOException {
        Object folderPath = (String)fromMessage.get("id");
        folderPath = "/" + (String)folderPath;
        this.getNotebookService().restoreFolder((String)folderPath, context, (ServiceCallback<Void>)new WebSocketServiceCallback<Void>(conn){

            @Override
            public void onSuccess(Void result, ServiceContext context) throws IOException {
                super.onSuccess(result, context);
                NotebookServer.this.broadcastNoteList(context.getAutheInfo(), context.getUserAndRoles());
            }
        });
    }

    private void restoreAll(NotebookSocket conn, ServiceContext context, Message fromMessage) throws IOException {
        this.getNotebookService().restoreAll(context, (ServiceCallback<Void>)new WebSocketServiceCallback<Void>(conn){

            @Override
            public void onSuccess(Void result, ServiceContext context) throws IOException {
                super.onSuccess(result, context);
                NotebookServer.this.broadcastNoteList(context.getAutheInfo(), context.getUserAndRoles());
            }
        });
    }

    private void emptyTrash(NotebookSocket conn, ServiceContext context) throws IOException {
        this.getNotebookService().emptyTrash(context, (ServiceCallback<Void>)new WebSocketServiceCallback<Void>(conn){

            @Override
            public void onSuccess(Void result, ServiceContext context) throws IOException {
                super.onSuccess(result, context);
                NotebookServer.this.broadcastNoteList(context.getAutheInfo(), context.getUserAndRoles());
            }
        });
    }

    private void updateParagraph(NotebookSocket conn, ServiceContext context, final Message fromMessage) throws IOException {
        final String paragraphId = (String)fromMessage.get("id");
        String noteId = this.connectionManager.getAssociatedNoteId(conn);
        if (noteId == null) {
            noteId = (String)fromMessage.get("noteId");
        }
        String title = (String)fromMessage.get("title");
        String text = (String)fromMessage.get("paragraph");
        Map params = (Map)fromMessage.get("params");
        Map config = (Map)fromMessage.get("config");
        this.getNotebookService().updateParagraph(noteId, paragraphId, title, text, params, config, context, (ServiceCallback<Paragraph>)new WebSocketServiceCallback<Paragraph>(conn){

            @Override
            public void onSuccess(Paragraph p, ServiceContext context) throws IOException {
                super.onSuccess(p, context);
                if (p.getNote().isPersonalizedMode()) {
                    Map userParagraphMap = p.getNote().getParagraph(paragraphId).getUserParagraphMap();
                    NotebookServer.this.broadcastParagraphs(userParagraphMap, p, fromMessage.msgId);
                } else {
                    NotebookServer.this.broadcastParagraph(p.getNote(), p, fromMessage.msgId);
                }
            }
        });
    }

    private void patchParagraph(final NotebookSocket conn, ServiceContext context, Message fromMessage) throws IOException {
        if (!this.zConf.isZeppelinNotebookCollaborativeModeEnable()) {
            return;
        }
        final String paragraphId = (String)fromMessage.getType("id", LOGGER);
        if (paragraphId == null) {
            return;
        }
        String noteId = this.connectionManager.getAssociatedNoteId(conn);
        if (noteId == null && (noteId = (String)fromMessage.getType("noteId", LOGGER)) == null) {
            return;
        }
        final String noteId2 = noteId;
        String patchText = (String)fromMessage.getType("patch", LOGGER);
        if (patchText == null) {
            return;
        }
        this.getNotebookService().patchParagraph(noteId, paragraphId, patchText, context, (ServiceCallback<String>)new WebSocketServiceCallback<String>(conn){

            @Override
            public void onSuccess(String result, ServiceContext context) throws IOException {
                super.onSuccess(result, context);
                Message message = new Message(Message.OP.PATCH_PARAGRAPH).put("patch", (Object)result).put("paragraphId", (Object)paragraphId);
                NotebookServer.this.connectionManager.broadcastExcept(noteId2, message, conn);
            }
        });
    }

    private void cloneNote(final NotebookSocket conn, ServiceContext context, Message fromMessage) throws IOException {
        String noteId = this.connectionManager.getAssociatedNoteId(conn);
        String name = (String)fromMessage.get("name");
        this.getNotebookService().cloneNote(noteId, name, context, (ServiceCallback<Note>)new WebSocketServiceCallback<Note>(conn){

            @Override
            public void onSuccess(Note newNote, ServiceContext context) throws IOException {
                super.onSuccess(newNote, context);
                NotebookServer.this.connectionManager.addNoteConnection(newNote.getId(), conn);
                conn.send(NotebookServer.this.serializeMessage(new Message(Message.OP.NEW_NOTE).put("note", (Object)newNote)));
                NotebookServer.this.broadcastNoteList(context.getAutheInfo(), context.getUserAndRoles());
            }
        });
    }

    private void clearAllParagraphOutput(NotebookSocket conn, ServiceContext context, Message fromMessage) throws IOException {
        String noteId = (String)fromMessage.get("id");
        this.getNotebookService().clearAllParagraphOutput(noteId, context, (ServiceCallback<Note>)new WebSocketServiceCallback<Note>(conn){

            @Override
            public void onSuccess(Note note, ServiceContext context) throws IOException {
                super.onSuccess(note, context);
                NotebookServer.this.broadcastNote(note);
            }
        });
    }

    protected void convertNote(NotebookSocket conn, Message fromMessage) throws IOException {
        String noteId = fromMessage.get("noteId").toString();
        this.getNotebook().processNote(noteId, note -> {
            if (note == null) {
                throw new IOException("No such note: " + noteId);
            }
            Message resp = new Message(Message.OP.CONVERTED_NOTE_NBFORMAT).put("nbformat", (Object)new JupyterUtil().getNbformat(note.toJson())).put("noteName", fromMessage.get("noteName"));
            conn.send(this.serializeMessage(resp));
            return null;
        });
    }

    protected String importNote(NotebookSocket conn, ServiceContext context, Message fromMessage) throws IOException {
        String noteJson = null;
        String noteName = (String)((Map)fromMessage.get("note")).get("name");
        noteJson = ((Map)fromMessage.get("note")).get("cells") == null ? gson.toJson(fromMessage.get("note")) : new JupyterUtil().getJson(gson.toJson(fromMessage.get("note")), IdHashes.generateId(), "%python", "%md");
        return this.getNotebookService().importNote(noteName, noteJson, context, (ServiceCallback<Note>)new WebSocketServiceCallback<Note>(conn){

            @Override
            public void onSuccess(Note note, ServiceContext context) throws IOException {
                super.onSuccess(note, context);
                try {
                    NotebookServer.this.broadcastNote(note);
                    NotebookServer.this.broadcastNoteList(context.getAutheInfo(), context.getUserAndRoles());
                }
                catch (NullPointerException nullPointerException) {
                    // empty catch block
                }
            }
        });
    }

    private void removeParagraph(NotebookSocket conn, ServiceContext context, Message fromMessage) throws IOException {
        String paragraphId = (String)fromMessage.get("id");
        String noteId = this.connectionManager.getAssociatedNoteId(conn);
        this.getNotebookService().removeParagraph(noteId, paragraphId, context, (ServiceCallback<Paragraph>)new WebSocketServiceCallback<Paragraph>(conn){

            @Override
            public void onSuccess(Paragraph p, ServiceContext context) throws IOException {
                super.onSuccess(p, context);
                NotebookServer.this.connectionManager.broadcast(p.getNote().getId(), new Message(Message.OP.PARAGRAPH_REMOVED).put("id", (Object)p.getId()));
            }
        });
    }

    private void clearParagraphOutput(NotebookSocket conn, ServiceContext context, final Message fromMessage) throws IOException {
        String paragraphId = (String)fromMessage.get("id");
        String noteId = this.connectionManager.getAssociatedNoteId(conn);
        this.getNotebookService().clearParagraphOutput(noteId, paragraphId, context, (ServiceCallback<Paragraph>)new WebSocketServiceCallback<Paragraph>(conn){

            @Override
            public void onSuccess(Paragraph p, ServiceContext context) throws IOException {
                super.onSuccess(p, context);
                if (p.getNote().isPersonalizedMode()) {
                    NotebookServer.this.connectionManager.unicastParagraph(p.getNote(), p, context.getAutheInfo().getUser(), fromMessage.msgId);
                } else {
                    NotebookServer.this.broadcastParagraph(p.getNote(), p, fromMessage.msgId);
                }
            }
        });
    }

    private void completion(final NotebookSocket conn, ServiceContext context, Message fromMessage) throws IOException {
        String noteId = this.connectionManager.getAssociatedNoteId(conn);
        final String paragraphId = (String)fromMessage.get("id");
        String buffer = (String)fromMessage.get("buf");
        int cursor = (int)Double.parseDouble(fromMessage.get("cursor").toString());
        this.getNotebookService().completion(noteId, paragraphId, buffer, cursor, context, (ServiceCallback<List<InterpreterCompletion>>)new WebSocketServiceCallback<List<InterpreterCompletion>>(conn){

            @Override
            public void onSuccess(List<InterpreterCompletion> completions, ServiceContext context) throws IOException {
                super.onSuccess(completions, context);
                Message resp = new Message(Message.OP.COMPLETION_LIST).put("id", (Object)paragraphId);
                resp.put("completions", completions);
                conn.send(NotebookServer.this.serializeMessage(resp));
            }

            @Override
            public void onFailure(Exception ex, ServiceContext context) throws IOException {
                super.onFailure(ex, context);
                Message resp = new Message(Message.OP.COMPLETION_LIST).put("id", (Object)paragraphId);
                resp.put("completions", new ArrayList());
                conn.send(NotebookServer.this.serializeMessage(resp));
            }
        });
    }

    private void angularObjectUpdated(final NotebookSocket conn, ServiceContext context, Message fromMessage) throws IOException {
        final String noteId = (String)fromMessage.get("noteId");
        String paragraphId = (String)fromMessage.get("paragraphId");
        final String interpreterGroupId = (String)fromMessage.get("interpreterGroupId");
        String varName = (String)fromMessage.get("name");
        Object varValue = fromMessage.get("value");
        String user = fromMessage.principal;
        this.getNotebookService().updateAngularObject(noteId, paragraphId, interpreterGroupId, varName, varValue, context, (ServiceCallback<AngularObject>)new WebSocketServiceCallback<AngularObject>(conn){

            @Override
            public void onSuccess(AngularObject ao, ServiceContext context) throws IOException {
                super.onSuccess(ao, context);
                NotebookServer.this.connectionManager.broadcastExcept(noteId, new Message(Message.OP.ANGULAR_OBJECT_UPDATE).put("angularObject", (Object)ao).put("interpreterGroupId", (Object)interpreterGroupId).put("noteId", (Object)noteId).put("paragraphId", (Object)ao.getParagraphId()), conn);
                NotebookServer.this.getNotebook().processNote(noteId, note -> {
                    note.addOrUpdateAngularObject(interpreterGroupId, ao);
                    return null;
                });
            }
        });
    }

    protected void angularObjectClientBind(NotebookSocket conn, Message fromMessage) throws Exception {
        String noteId = (String)fromMessage.getType("noteId");
        String varName = (String)fromMessage.getType("name");
        Object varValue = fromMessage.get("value");
        String paragraphId = (String)fromMessage.getType("paragraphId");
        if (paragraphId == null) {
            throw new IllegalArgumentException("target paragraph not specified for angular value bind");
        }
        this.getNotebook().processNote(noteId, note -> {
            if (note != null) {
                InterpreterGroup interpreterGroup;
                try {
                    interpreterGroup = this.findInterpreterGroupForParagraph(note, paragraphId);
                }
                catch (Exception e) {
                    LOGGER.error("No interpreter group found for noteId {} and paragraphId {}", new Object[]{noteId, paragraphId, e});
                    return null;
                }
                RemoteAngularObjectRegistry registry = (RemoteAngularObjectRegistry)interpreterGroup.getAngularObjectRegistry();
                AngularObject ao = this.pushAngularObjectToRemoteRegistry(noteId, paragraphId, varName, varValue, registry, interpreterGroup.getId(), conn);
                note.addOrUpdateAngularObject(interpreterGroup.getId(), ao);
            }
            return null;
        });
    }

    protected void angularObjectClientUnbind(NotebookSocket conn, Message fromMessage) throws Exception {
        String noteId = (String)fromMessage.getType("noteId");
        String varName = (String)fromMessage.getType("name");
        String paragraphId = (String)fromMessage.getType("paragraphId");
        if (paragraphId == null) {
            throw new IllegalArgumentException("target paragraph not specified for angular value unBind");
        }
        this.getNotebook().processNote(noteId, note -> {
            if (note != null) {
                InterpreterGroup interpreterGroup;
                try {
                    interpreterGroup = this.findInterpreterGroupForParagraph(note, paragraphId);
                }
                catch (Exception e) {
                    LOGGER.error("No interpreter group found for noteId {} and paragraphId {}", new Object[]{noteId, paragraphId, e});
                    return null;
                }
                RemoteAngularObjectRegistry registry = (RemoteAngularObjectRegistry)interpreterGroup.getAngularObjectRegistry();
                AngularObject ao = this.removeAngularFromRemoteRegistry(noteId, paragraphId, varName, registry, interpreterGroup.getId(), conn);
                note.deleteAngularObject(interpreterGroup.getId(), noteId, paragraphId, varName);
            }
            return null;
        });
    }

    private InterpreterGroup findInterpreterGroupForParagraph(Note note, String paragraphId) throws Exception {
        Paragraph paragraph = note.getParagraph(paragraphId);
        if (paragraph == null) {
            throw new IllegalArgumentException("Unknown paragraph with id : " + paragraphId);
        }
        return paragraph.getBindedInterpreter().getInterpreterGroup();
    }

    private AngularObject pushAngularObjectToRemoteRegistry(String noteId, String paragraphId, String varName, Object varValue, RemoteAngularObjectRegistry remoteRegistry, String interpreterGroupId, NotebookSocket conn) {
        AngularObject ao = remoteRegistry.addAndNotifyRemoteProcess(varName, varValue, noteId, paragraphId);
        this.connectionManager.broadcastExcept(noteId, new Message(Message.OP.ANGULAR_OBJECT_UPDATE).put("angularObject", (Object)ao).put("interpreterGroupId", (Object)interpreterGroupId).put("noteId", (Object)noteId).put("paragraphId", (Object)paragraphId), conn);
        return ao;
    }

    private AngularObject removeAngularFromRemoteRegistry(String noteId, String paragraphId, String varName, RemoteAngularObjectRegistry remoteRegistry, String interpreterGroupId, NotebookSocket conn) {
        AngularObject ao = remoteRegistry.removeAndNotifyRemoteProcess(varName, noteId, paragraphId);
        this.connectionManager.broadcastExcept(noteId, new Message(Message.OP.ANGULAR_OBJECT_REMOVE).put("angularObject", (Object)ao).put("interpreterGroupId", (Object)interpreterGroupId).put("noteId", (Object)noteId).put("paragraphId", (Object)paragraphId), conn);
        return ao;
    }

    private void moveParagraph(NotebookSocket conn, ServiceContext context, Message fromMessage) throws IOException {
        final String paragraphId = (String)fromMessage.get("id");
        final int newIndex = (int)Double.parseDouble(fromMessage.get("index").toString());
        String noteId = this.connectionManager.getAssociatedNoteId(conn);
        this.getNotebookService().moveParagraph(noteId, paragraphId, newIndex, context, (ServiceCallback<Paragraph>)new WebSocketServiceCallback<Paragraph>(conn){

            @Override
            public void onSuccess(Paragraph result, ServiceContext context) throws IOException {
                super.onSuccess(result, context);
                NotebookServer.this.connectionManager.broadcast(result.getNote().getId(), new Message(Message.OP.PARAGRAPH_MOVED).put("id", (Object)paragraphId).put("index", (Object)newIndex));
            }
        });
    }

    private String insertParagraph(NotebookSocket conn, ServiceContext context, Message fromMessage) throws IOException {
        int index = (int)Double.parseDouble(fromMessage.get("index").toString());
        String noteId = this.connectionManager.getAssociatedNoteId(conn);
        Map config = fromMessage.get("config") != null ? (Map)fromMessage.get("config") : new HashMap();
        Paragraph newPara = this.getNotebookService().insertParagraph(noteId, index, config, context, (ServiceCallback<Paragraph>)new WebSocketServiceCallback<Paragraph>(conn){

            @Override
            public void onSuccess(Paragraph p, ServiceContext context) throws IOException {
                super.onSuccess(p, context);
                NotebookServer.this.broadcastNewParagraph(p.getNote(), p);
            }
        });
        return newPara.getId();
    }

    private void copyParagraph(NotebookSocket conn, ServiceContext context, Message fromMessage) throws IOException {
        String newParaId = this.insertParagraph(conn, context, fromMessage);
        if (newParaId == null) {
            return;
        }
        fromMessage.put("id", (Object)newParaId);
        this.updateParagraph(conn, context, fromMessage);
    }

    private void cancelParagraph(NotebookSocket conn, ServiceContext context, Message fromMessage) throws IOException {
        String paragraphId = (String)fromMessage.get("id");
        String noteId = this.connectionManager.getAssociatedNoteId(conn);
        this.getNotebookService().cancelParagraph(noteId, paragraphId, context, new WebSocketServiceCallback<Paragraph>(conn));
    }

    private void runAllParagraphs(NotebookSocket conn, ServiceContext context, Message fromMessage) throws IOException {
        String noteId = (String)fromMessage.get("noteId");
        List paragraphs = (List)gson.fromJson(String.valueOf(fromMessage.data.get("paragraphs")), new TypeToken<List<Map<String, Object>>>(){}.getType());
        this.executorService.submit(() -> {
            try {
                if (!this.getNotebookService().runAllParagraphs(noteId, paragraphs, context, new WebSocketServiceCallback<Paragraph>(conn))) {
                    this.getNotebookService().getNote(noteId, context, new SimpleServiceCallback<Note>(), note -> {
                        if (note != null) {
                            for (Paragraph p : note.getParagraphs()) {
                                this.broadcastParagraph(note, p, null);
                            }
                        }
                        return null;
                    });
                }
            }
            catch (Throwable t) {
                LOGGER.error("Error in running all paragraphs", t);
            }
        });
    }

    private void broadcastSpellExecution(final NotebookSocket conn, ServiceContext context, Message fromMessage) throws IOException {
        String noteId = this.connectionManager.getAssociatedNoteId(conn);
        this.getNotebookService().spell(noteId, fromMessage, context, (ServiceCallback<Paragraph>)new WebSocketServiceCallback<Paragraph>(conn){

            @Override
            public void onSuccess(Paragraph p, ServiceContext context) throws IOException {
                super.onSuccess(p, context);
                NotebookServer.this.connectionManager.broadcastExcept(p.getNote().getId(), new Message(Message.OP.RUN_PARAGRAPH_USING_SPELL).put("paragraph", (Object)p), conn);
            }
        });
    }

    private void runParagraph(NotebookSocket conn, ServiceContext context, final Message fromMessage) throws IOException {
        final String paragraphId = (String)fromMessage.get("id");
        String noteId = this.connectionManager.getAssociatedNoteId(conn);
        String text = (String)fromMessage.get("paragraph");
        String title = (String)fromMessage.get("title");
        Map params = (Map)fromMessage.get("params");
        Map config = (Map)fromMessage.get("config");
        this.getNotebook().processNote(noteId, note -> {
            this.getNotebookService().runParagraph(note, paragraphId, title, text, params, config, null, false, false, context, (ServiceCallback<Paragraph>)new WebSocketServiceCallback<Paragraph>(conn){

                @Override
                public void onSuccess(Paragraph p, ServiceContext context) throws IOException {
                    super.onSuccess(p, context);
                    if (p.getNote().isPersonalizedMode()) {
                        Paragraph p2 = p.getNote().clearPersonalizedParagraphOutput(paragraphId, context.getAutheInfo().getUser());
                        NotebookServer.this.connectionManager.unicastParagraph(p.getNote(), p2, context.getAutheInfo().getUser(), fromMessage.msgId);
                    }
                    boolean isTheLastParagraph = p.getNote().isLastParagraph(paragraphId);
                    if (!StringUtils.isEmpty((CharSequence)p.getText()) && !StringUtils.isEmpty((CharSequence)p.getScriptText()) && isTheLastParagraph) {
                        Paragraph newPara = p.getNote().addNewParagraph(p.getAuthenticationInfo());
                        NotebookServer.this.broadcastNewParagraph(p.getNote(), newPara);
                    }
                }
            });
            return null;
        });
    }

    private void sendAllConfigurations(final NotebookSocket conn, ServiceContext context, Message message) throws IOException {
        this.getConfigurationService().getAllProperties(context, (ServiceCallback<Map<String, String>>)new WebSocketServiceCallback<Map<String, String>>(conn){

            @Override
            public void onSuccess(Map<String, String> properties, ServiceContext context) throws IOException {
                super.onSuccess(properties, context);
                properties.put("isRevisionSupported", String.valueOf(NotebookServer.this.getNotebook().isRevisionSupported()));
                conn.send(NotebookServer.this.serializeMessage(new Message(Message.OP.CONFIGURATIONS_INFO).put("configurations", properties)));
            }
        });
    }

    private void checkpointNote(final NotebookSocket conn, ServiceContext context, Message fromMessage) throws IOException {
        final String noteId = (String)fromMessage.get("noteId");
        String commitMessage = (String)fromMessage.get("commitMessage");
        this.getNotebookService().checkpointNote(noteId, commitMessage, context, (ServiceCallback<NotebookRepoWithVersionControl.Revision>)new WebSocketServiceCallback<NotebookRepoWithVersionControl.Revision>(conn){

            @Override
            public void onSuccess(NotebookRepoWithVersionControl.Revision revision, ServiceContext context) throws IOException {
                super.onSuccess(revision, context);
                if (!NotebookRepoWithVersionControl.Revision.isEmpty((NotebookRepoWithVersionControl.Revision)revision)) {
                    List revisions = (List)NotebookServer.this.getNotebook().processNote(noteId, note -> NotebookServer.this.getNotebook().listRevisionHistory(noteId, note.getPath(), context.getAutheInfo()));
                    conn.send(NotebookServer.this.serializeMessage(new Message(Message.OP.LIST_REVISION_HISTORY).put("revisionList", (Object)revisions)));
                } else {
                    conn.send(NotebookServer.this.serializeMessage(new Message(Message.OP.ERROR_INFO).put("info", (Object)"Couldn't checkpoint note revision: possibly no changes found or storage doesn't support versioning. Please check the logs for more details.")));
                }
            }
        });
    }

    private void listRevisionHistory(final NotebookSocket conn, ServiceContext context, Message fromMessage) throws IOException {
        String noteId = (String)fromMessage.get("noteId");
        this.getNotebookService().listRevisionHistory(noteId, context, (ServiceCallback<List<NotebookRepoWithVersionControl.Revision>>)new WebSocketServiceCallback<List<NotebookRepoWithVersionControl.Revision>>(conn){

            @Override
            public void onSuccess(List<NotebookRepoWithVersionControl.Revision> revisions, ServiceContext context) throws IOException {
                super.onSuccess(revisions, context);
                conn.send(NotebookServer.this.serializeMessage(new Message(Message.OP.LIST_REVISION_HISTORY).put("revisionList", revisions)));
            }
        });
    }

    private void setNoteRevision(final NotebookSocket conn, ServiceContext context, Message fromMessage) throws IOException {
        final String noteId = (String)fromMessage.get("noteId");
        String revisionId = (String)fromMessage.get("revisionId");
        this.getNotebookService().setNoteRevision(noteId, revisionId, context, (ServiceCallback<Note>)new WebSocketServiceCallback<Note>(conn){

            @Override
            public void onSuccess(Note note, ServiceContext context) throws IOException {
                super.onSuccess(note, context);
                Note reloadedNote = NotebookServer.this.getNotebook().loadNoteFromRepo(noteId, context.getAutheInfo());
                conn.send(NotebookServer.this.serializeMessage(new Message(Message.OP.SET_NOTE_REVISION).put("status", (Object)true)));
                NotebookServer.this.broadcastNote(reloadedNote);
            }
        });
    }

    private void getNoteByRevision(final NotebookSocket conn, ServiceContext context, Message fromMessage) throws IOException {
        final String noteId = (String)fromMessage.get("noteId");
        final String revisionId = (String)fromMessage.get("revisionId");
        this.getNotebookService().getNotebyRevision(noteId, revisionId, context, (ServiceCallback<Note>)new WebSocketServiceCallback<Note>(conn){

            @Override
            public void onSuccess(Note note, ServiceContext context) throws IOException {
                super.onSuccess(note, context);
                conn.send(NotebookServer.this.serializeMessage(new Message(Message.OP.NOTE_REVISION).put("noteId", (Object)noteId).put("revisionId", (Object)revisionId).put("note", (Object)note)));
            }
        });
    }

    private void getNoteByRevisionForCompare(final NotebookSocket conn, ServiceContext context, Message fromMessage) throws IOException {
        final String noteId = (String)fromMessage.get("noteId");
        final String revisionId = (String)fromMessage.get("revisionId");
        final String position = (String)fromMessage.get("position");
        this.getNotebookService().getNoteByRevisionForCompare(noteId, revisionId, context, (ServiceCallback<Note>)new WebSocketServiceCallback<Note>(conn){

            @Override
            public void onSuccess(Note note, ServiceContext context) throws IOException {
                super.onSuccess(note, context);
                conn.send(NotebookServer.this.serializeMessage(new Message(Message.OP.NOTE_REVISION_FOR_COMPARE).put("noteId", (Object)noteId).put("revisionId", (Object)revisionId).put("position", (Object)position).put("note", (Object)note)));
            }
        });
    }

    public void onOutputAppend(String noteId, String paragraphId, int index, String output) {
        if (!this.sendParagraphStatusToFrontend()) {
            return;
        }
        Message msg = new Message(Message.OP.PARAGRAPH_APPEND_OUTPUT).put("noteId", (Object)noteId).put("paragraphId", (Object)paragraphId).put("index", (Object)index).put("data", (Object)output);
        this.connectionManager.broadcast(noteId, msg);
    }

    public void onOutputUpdated(String noteId, String paragraphId, int index, InterpreterResult.Type type, String output) {
        if (!this.sendParagraphStatusToFrontend()) {
            return;
        }
        Message msg = new Message(Message.OP.PARAGRAPH_UPDATE_OUTPUT).put("noteId", (Object)noteId).put("paragraphId", (Object)paragraphId).put("index", (Object)index).put("type", (Object)type).put("data", (Object)output);
        try {
            this.getNotebook().processNote(noteId, note -> {
                if (note == null) {
                    LOGGER.warn("Note {} not found", (Object)noteId);
                    return null;
                }
                Paragraph paragraph = note.getParagraph(paragraphId);
                paragraph.updateOutputBuffer(index, type, output);
                if (note.isPersonalizedMode()) {
                    String user = note.getParagraph(paragraphId).getUser();
                    if (null != user) {
                        this.connectionManager.multicastToUser(user, msg);
                    }
                } else {
                    this.connectionManager.broadcast(noteId, msg);
                }
                return null;
            });
        }
        catch (IOException e) {
            LOGGER.warn("Fail to call onOutputUpdated", (Throwable)e);
        }
    }

    public void onOutputClear(String noteId, String paragraphId) {
        if (!this.sendParagraphStatusToFrontend()) {
            return;
        }
        try {
            this.getNotebook().processNote(noteId, note -> {
                if (note == null) {
                    LOGGER.warn("Note {} doesn't existed, it maybe deleted.", (Object)noteId);
                } else {
                    note.clearParagraphOutput(paragraphId);
                    Paragraph paragraph = note.getParagraph(paragraphId);
                    this.broadcastParagraph(note, paragraph, Message.MSG_ID_NOT_DEFINED);
                }
                return null;
            });
        }
        catch (IOException e) {
            LOGGER.warn("Fail to call onOutputClear", (Throwable)e);
        }
    }

    public void onOutputAppend(String noteId, String paragraphId, int index, String appId, String output) {
        Message msg = new Message(Message.OP.APP_APPEND_OUTPUT).put("noteId", (Object)noteId).put("paragraphId", (Object)paragraphId).put("index", (Object)index).put("appId", (Object)appId).put("data", (Object)output);
        this.connectionManager.broadcast(noteId, msg);
    }

    public void onOutputUpdated(String noteId, String paragraphId, int index, String appId, InterpreterResult.Type type, String output) {
        Message msg = new Message(Message.OP.APP_UPDATE_OUTPUT).put("noteId", (Object)noteId).put("paragraphId", (Object)paragraphId).put("index", (Object)index).put("type", (Object)type).put("appId", (Object)appId).put("data", (Object)output);
        this.connectionManager.broadcast(noteId, msg);
    }

    public void onLoad(String noteId, String paragraphId, String appId, HeliumPackage pkg) {
        Message msg = new Message(Message.OP.APP_LOAD).put("noteId", (Object)noteId).put("paragraphId", (Object)paragraphId).put("appId", (Object)appId).put("pkg", (Object)pkg);
        this.connectionManager.broadcast(noteId, msg);
    }

    public void onStatusChange(String noteId, String paragraphId, String appId, String status) {
        Message msg = new Message(Message.OP.APP_STATUS_CHANGE).put("noteId", (Object)noteId).put("paragraphId", (Object)paragraphId).put("appId", (Object)appId).put("status", (Object)status);
        this.connectionManager.broadcast(noteId, msg);
    }

    public void runParagraphs(String noteId, List<Integer> paragraphIndices, List<String> paragraphIds, String curParagraphId) throws IOException {
        this.getNotebook().processNote(noteId, note -> {
            final ArrayList<String> toBeRunParagraphIds = new ArrayList<String>();
            if (note == null) {
                throw new IOException("Not existed noteId: " + noteId);
            }
            if (!paragraphIds.isEmpty() && !paragraphIndices.isEmpty()) {
                throw new IOException("Can not specify paragraphIds and paragraphIndices together");
            }
            if (paragraphIds != null && !paragraphIds.isEmpty()) {
                for (String paragraphId : paragraphIds) {
                    if (note.getParagraph(paragraphId) == null) {
                        throw new IOException("Not existed paragraphId: " + paragraphId);
                    }
                    if (paragraphId.equals(curParagraphId)) continue;
                    toBeRunParagraphIds.add(paragraphId);
                }
            }
            if (paragraphIndices != null && !paragraphIndices.isEmpty()) {
                Iterator iterator = paragraphIndices.iterator();
                while (iterator.hasNext()) {
                    int paragraphIndex = (Integer)iterator.next();
                    if (note.getParagraph(paragraphIndex) == null) {
                        throw new IOException("Not existed paragraphIndex: " + paragraphIndex);
                    }
                    if (note.getParagraph(paragraphIndex).getId().equals(curParagraphId)) continue;
                    toBeRunParagraphIds.add(note.getParagraph(paragraphIndex).getId());
                }
            }
            if (paragraphIds.isEmpty() && paragraphIndices.isEmpty()) {
                for (Paragraph paragraph : note.getParagraphs()) {
                    if (paragraph.getId().equals(curParagraphId)) continue;
                    toBeRunParagraphIds.add(paragraph.getId());
                }
            }
            Runnable runThread = new Runnable(){

                @Override
                public void run() {
                    for (String paragraphId : toBeRunParagraphIds) {
                        note.run(paragraphId, true);
                    }
                }
            };
            this.executorService.submit(runThread);
            return null;
        });
    }

    public void onParagraphRemove(Paragraph p) {
        try {
            ServiceContext context = new ServiceContext(new AuthenticationInfo(), this.authorizationService.getOwners(p.getNote().getId()));
            this.getJobManagerService().getNoteJobInfoByUnixTime(System.currentTimeMillis() - 5000L, context, new JobManagerServiceCallback());
        }
        catch (IOException e) {
            LOGGER.warn("can not broadcast for job manager: {}", (Object)e.getMessage(), (Object)e);
        }
    }

    public void onNoteRemove(Note note, AuthenticationInfo subject) {
        try {
            this.broadcastUpdateNoteJobInfo(note, System.currentTimeMillis() - 5000L);
        }
        catch (IOException e) {
            LOGGER.warn("can not broadcast for job manager: {}", (Object)e.getMessage(), (Object)e);
        }
        try {
            this.getJobManagerService().removeNoteJobInfo(note.getId(), null, new JobManagerServiceCallback());
        }
        catch (IOException e) {
            LOGGER.warn("can not broadcast for job manager: {}", (Object)e.getMessage(), (Object)e);
        }
    }

    public void onParagraphCreate(Paragraph p) {
        try {
            this.getJobManagerService().getNoteJobInfo(p.getNote().getId(), null, new JobManagerServiceCallback());
        }
        catch (IOException e) {
            LOGGER.warn("can not broadcast for job manager: {}", (Object)e.getMessage(), (Object)e);
        }
    }

    public void onParagraphUpdate(Paragraph p) {
    }

    public void onNoteCreate(Note note, AuthenticationInfo subject) {
        try {
            this.getJobManagerService().getNoteJobInfo(note.getId(), null, new JobManagerServiceCallback());
        }
        catch (IOException e) {
            LOGGER.warn("can not broadcast for job manager: {}", (Object)e.getMessage(), (Object)e);
        }
    }

    public void onNoteUpdate(Note note, AuthenticationInfo subject) {
    }

    public void onParagraphStatusChange(Paragraph p, Job.Status status) {
        try {
            this.getJobManagerService().getNoteJobInfo(p.getNote().getId(), null, new JobManagerServiceCallback());
        }
        catch (IOException e) {
            LOGGER.warn("can not broadcast for job manager: {}", (Object)e.getMessage(), (Object)e);
        }
    }

    public void onProgressUpdate(Job<?> job, int progress) {
        if (job instanceof Paragraph) {
            Paragraph p = (Paragraph)job;
            if (!this.sendParagraphStatusToFrontend()) {
                return;
            }
            this.connectionManager.broadcast(p.getNote().getId(), new Message(Message.OP.PROGRESS).put("id", (Object)p.getId()).put("progress", (Object)progress));
        }
    }

    public void onStatusChange(Job<?> job, Job.Status before, Job.Status after) {
        if (job instanceof Paragraph) {
            Paragraph p = (Paragraph)job;
            if (after == Job.Status.ERROR && p.getException() != null) {
                LOGGER.error("Error", p.getException());
            }
            if (p.isTerminated() || after == Job.Status.RUNNING) {
                if (p.getStatus() == Job.Status.FINISHED) {
                    LOGGER.info("Job {} is finished successfully, status: {}", (Object)p.getId(), (Object)p.getStatus());
                } else if (p.isTerminated()) {
                    LOGGER.warn("Job {} is finished, status: {}, exception: {}, result: {}", new Object[]{p.getId(), p.getStatus(), p.getException(), p.getReturn()});
                } else {
                    LOGGER.info("Job {} starts to RUNNING", (Object)p.getId());
                }
                try {
                    String noteId = p.getNote().getId();
                    this.getNotebook().processNote(noteId, note -> {
                        if (note == null) {
                            LOGGER.warn("Note {} doesn't existed.", (Object)noteId);
                            return null;
                        }
                        this.getNotebook().saveNote(p.getNote(), p.getAuthenticationInfo());
                        return null;
                    });
                }
                catch (IOException e) {
                    LOGGER.error(e.toString(), (Throwable)e);
                }
            }
            p.setStatusToUserParagraph(p.getStatus());
            this.broadcastParagraph(p.getNote(), p, Message.MSG_ID_NOT_DEFINED);
            try {
                this.broadcastUpdateNoteJobInfo(p.getNote(), System.currentTimeMillis() - 5000L);
            }
            catch (IOException e) {
                LOGGER.error("can not broadcast for job manager", (Throwable)e);
            }
        }
    }

    public void checkpointOutput(String noteId, String paragraphId) {
        try {
            this.getNotebook().processNote(noteId, note -> {
                note.getParagraph(paragraphId).checkpointOutput();
                this.getNotebook().saveNote(note, AuthenticationInfo.ANONYMOUS);
                return null;
            });
        }
        catch (IOException e) {
            LOGGER.warn("Fail to save note: {}", (Object)noteId, (Object)e);
        }
    }

    public void noteRunningStatusChange(String noteId, boolean newStatus) {
        this.connectionManager.broadcast(noteId, new Message(Message.OP.NOTE_RUNNING_STATUS).put("status", (Object)newStatus));
    }

    private void sendAllAngularObjects(Note note, String user, NotebookSocket conn) throws IOException {
        List settings = this.getNotebook().getBindedInterpreterSettings(note.getId());
        if (settings == null || settings.isEmpty()) {
            return;
        }
        for (InterpreterSetting intpSetting : settings) {
            if (intpSetting.getInterpreterGroup(user, note.getId()) == null) continue;
            AngularObjectRegistry registry = intpSetting.getInterpreterGroup(user, note.getId()).getAngularObjectRegistry();
            List objects = registry.getAllWithGlobal(note.getId());
            for (AngularObject object : objects) {
                conn.send(this.serializeMessage(new Message(Message.OP.ANGULAR_OBJECT_UPDATE).put("angularObject", (Object)object).put("interpreterGroupId", (Object)intpSetting.getInterpreterGroup(user, note.getId()).getId()).put("noteId", (Object)note.getId()).put("paragraphId", (Object)object.getParagraphId())));
            }
        }
    }

    public void onAddAngularObject(String interpreterGroupId, AngularObject angularObject) {
        this.onUpdateAngularObject(interpreterGroupId, angularObject);
    }

    public void onUpdateAngularObject(String interpreterGroupId, AngularObject angularObject) {
        if (this.getNotebook() == null) {
            return;
        }
        if (angularObject.getNoteId() != null) {
            try {
                this.updateNoteAngularObject(angularObject.getNoteId(), angularObject, interpreterGroupId);
            }
            catch (IOException e) {
                LOGGER.error("AngularObject's note: {} is not found", (Object)angularObject.getNoteId(), (Object)e);
            }
        } else {
            this.getNotebook().getNotesInfo().stream().forEach(noteInfo -> {
                if (angularObject.getNoteId() != null && !noteInfo.getId().equals(angularObject.getNoteId())) {
                    return;
                }
                try {
                    this.updateNoteAngularObject(noteInfo.getId(), angularObject, interpreterGroupId);
                }
                catch (IOException e) {
                    LOGGER.error("AngularObject's note: {} is not found", (Object)angularObject.getNoteId(), (Object)e);
                }
            });
        }
    }

    private void updateNoteAngularObject(String noteId, AngularObject angularObject, String interpreterGroupId) throws IOException {
        List intpSettings = (List)this.getNotebook().processNote(noteId, note -> note.getBindedInterpreterSettings(new ArrayList(this.authorizationService.getOwners(note.getId()))));
        if (intpSettings.isEmpty()) {
            return;
        }
        this.connectionManager.broadcast(noteId, new Message(Message.OP.ANGULAR_OBJECT_UPDATE).put("angularObject", (Object)angularObject).put("interpreterGroupId", (Object)interpreterGroupId).put("noteId", (Object)noteId).put("paragraphId", (Object)angularObject.getParagraphId()));
    }

    public void onRemoveAngularObject(String interpreterGroupId, AngularObject angularObject) {
        if (angularObject.getNoteId() != null) {
            String noteId = angularObject.getNoteId();
            this.removeNoteAngularObject(noteId, angularObject, interpreterGroupId);
        } else {
            this.getNotebook().getNotesInfo().forEach(noteInfo -> {
                if (angularObject.getNoteId() != null && !noteInfo.getId().equals(angularObject.getNoteId())) {
                    return;
                }
                this.removeNoteAngularObject(noteInfo.getId(), angularObject, interpreterGroupId);
            });
        }
    }

    private void removeNoteAngularObject(String noteId, AngularObject angularObject, String interpreterGroupId) {
        List settingIds = this.getNotebook().getInterpreterSettingManager().getSettingIds();
        for (String id : settingIds) {
            if (!interpreterGroupId.contains(id)) continue;
            this.connectionManager.broadcast(noteId, new Message(Message.OP.ANGULAR_OBJECT_REMOVE).put("name", (Object)angularObject.getName()).put("noteId", (Object)angularObject.getNoteId()).put("paragraphId", (Object)angularObject.getParagraphId()));
            break;
        }
    }

    private void getEditorSetting(final NotebookSocket conn, ServiceContext context, Message fromMessage) throws IOException {
        final String paragraphId = (String)fromMessage.get("paragraphId");
        String paragraphText = (String)fromMessage.get("paragraphText");
        String noteId = this.connectionManager.getAssociatedNoteId(conn);
        this.getNotebookService().getEditorSetting(noteId, paragraphText, context, (ServiceCallback<Map<String, Object>>)new WebSocketServiceCallback<Map<String, Object>>(conn){

            @Override
            public void onSuccess(Map<String, Object> settings, ServiceContext context) throws IOException {
                super.onSuccess(settings, context);
                Message resp = new Message(Message.OP.EDITOR_SETTING);
                resp.put("paragraphId", (Object)paragraphId);
                resp.put("editor", settings);
                conn.send(NotebookServer.this.serializeMessage(resp));
            }

            @Override
            public void onFailure(Exception ex, ServiceContext context) {
                LOGGER.warn(ex.getMessage());
            }
        });
    }

    private void getInterpreterSettings(NotebookSocket conn, ServiceContext context, Message message) throws IOException {
        List allSettings = this.getNotebook().getInterpreterSettingManager().get();
        ArrayList<InterpreterSetting> result = new ArrayList<InterpreterSetting>();
        for (InterpreterSetting setting : allSettings) {
            if (!setting.isUserAuthorized(new ArrayList<String>(context.getUserAndRoles()))) continue;
            result.add(setting);
        }
        conn.send(this.serializeMessage(new Message(Message.OP.INTERPRETER_SETTINGS).put("interpreterSettings", result)));
    }

    public void onParaInfosReceived(String noteId, String paragraphId, String interpreterSettingId, Map<String, String> metaInfos) {
        try {
            this.getNotebook().processNote(noteId, note -> {
                Paragraph paragraph;
                if (note != null && (paragraph = note.getParagraph(paragraphId)) != null) {
                    InterpreterSetting setting = this.getNotebook().getInterpreterSettingManager().get(interpreterSettingId);
                    String label = (String)metaInfos.get("label");
                    String tooltip = (String)metaInfos.get("tooltip");
                    List<String> keysToRemove = Arrays.asList("noteId", "paraId", "label", "tooltip");
                    for (String removeKey : keysToRemove) {
                        metaInfos.remove(removeKey);
                    }
                    paragraph.updateRuntimeInfos(label, tooltip, metaInfos, setting.getGroup(), setting.getId());
                    this.getNotebook().saveNote(note, AuthenticationInfo.ANONYMOUS);
                    this.connectionManager.broadcast(note.getId(), new Message(Message.OP.PARAS_INFO).put("id", (Object)paragraphId).put("infos", (Object)paragraph.getRuntimeInfos()));
                }
                return null;
            });
        }
        catch (IOException e) {
            LOGGER.warn("Fail to call onParaInfosReceived", (Throwable)e);
        }
    }

    public List<ParagraphInfo> getParagraphList(String user, String noteId) throws IOException, TException, ServiceException {
        HashSet<String> userAndRoles = new HashSet<String>();
        userAndRoles.add(user);
        boolean isAllowed = this.authorizationService.isReader(noteId, userAndRoles);
        Set allowed = this.authorizationService.getReaders(noteId);
        if (!isAllowed) {
            String errorMsg = "Insufficient privileges to READER note. Allowed users or roles: " + allowed;
            throw new ServiceException(errorMsg);
        }
        return (List)this.getNotebook().processNote(noteId, note -> {
            if (null == note) {
                throw new IOException("Not found this note : " + noteId);
            }
            ArrayList<ParagraphInfo> paragraphInfos = new ArrayList<ParagraphInfo>();
            List paragraphs = note.getParagraphs();
            for (Paragraph paragraph : paragraphs) {
                ParagraphInfo paraInfo = new ParagraphInfo();
                paraInfo.setNoteId(noteId);
                paraInfo.setParagraphId(paragraph.getId());
                paraInfo.setParagraphTitle(paragraph.getTitle());
                paraInfo.setParagraphText(paragraph.getText());
                paragraphInfos.add(paraInfo);
            }
            return paragraphInfos;
        });
    }

    private void broadcastNoteForms(Note note) {
        GUI formsSettings = new GUI();
        formsSettings.setForms(note.getNoteForms());
        formsSettings.setParams(note.getNoteParams());
        this.connectionManager.broadcast(note.getId(), new Message(Message.OP.SAVE_NOTE_FORMS).put("formsData", (Object)formsSettings));
    }

    private void saveNoteForms(NotebookSocket conn, ServiceContext context, Message fromMessage) throws IOException {
        String noteId = (String)fromMessage.get("noteId");
        Map noteParams = (Map)fromMessage.get("noteParams");
        this.getNotebookService().saveNoteForms(noteId, noteParams, context, (ServiceCallback<Note>)new WebSocketServiceCallback<Note>(conn){

            @Override
            public void onSuccess(Note note, ServiceContext context) {
                NotebookServer.this.broadcastNoteForms(note);
            }
        });
    }

    private void removeNoteForms(NotebookSocket conn, ServiceContext context, Message fromMessage) throws IOException {
        String noteId = (String)fromMessage.get("noteId");
        String formName = (String)fromMessage.get("formName");
        this.getNotebookService().removeNoteForms(noteId, formName, context, (ServiceCallback<Note>)new WebSocketServiceCallback<Note>(conn){

            @Override
            public void onSuccess(Note note, ServiceContext context) {
                NotebookServer.this.broadcastNoteForms(note);
            }
        });
    }

    @ManagedAttribute
    public Set<String> getConnectedUsers() {
        return this.connectionManager.getConnectedUsers();
    }

    @ManagedOperation
    public void sendMessage(String message) {
        Message m = new Message(Message.OP.NOTICE);
        m.data.put("notice", message);
        this.connectionManager.broadcast(m);
    }

    private ServiceContext getServiceContext(TicketContainer.Entry ticketEntry) {
        AuthenticationInfo authInfo = new AuthenticationInfo(ticketEntry.getPrincipal(), ticketEntry.getRoles(), ticketEntry.getTicket());
        HashSet<String> userAndRoles = new HashSet<String>();
        userAndRoles.add(authInfo.getUser());
        userAndRoles.addAll(authInfo.getRoles());
        return new ServiceContext(authInfo, userAndRoles);
    }

    public class WebSocketServiceCallback<T>
    extends SimpleServiceCallback<T> {
        private final NotebookSocket conn;

        WebSocketServiceCallback(NotebookSocket conn) {
            this.conn = conn;
        }

        @Override
        public void onFailure(Exception ex, ServiceContext context) throws IOException {
            super.onFailure(ex, context);
            if (ex instanceof ForbiddenException) {
                Type type = new TypeToken<Map<String, String>>(){}.getType();
                Map jsonObject = (Map)gson.fromJson(((ForbiddenException)((Object)ex)).getResponse().getEntity().toString(), type);
                this.conn.send(NotebookServer.this.serializeMessage(new Message(Message.OP.AUTH_INFO).put("info", jsonObject.get("message"))));
            } else {
                Object message = ex.getMessage();
                if (ex.getCause() != null) {
                    message = (String)message + ", cause: " + ex.getCause().getMessage();
                }
                this.conn.send(NotebookServer.this.serializeMessage(new Message(Message.OP.ERROR_INFO).put("info", message)));
            }
        }
    }

    private class JobManagerServiceCallback
    extends SimpleServiceCallback<List<JobManagerService.NoteJobInfo>> {
        private JobManagerServiceCallback() {
        }

        @Override
        public void onSuccess(List<JobManagerService.NoteJobInfo> notesJobInfo, ServiceContext context) throws IOException {
            super.onSuccess(notesJobInfo, context);
            HashMap<String, Object> response = new HashMap<String, Object>();
            response.put("lastResponseUnixTime", System.currentTimeMillis());
            response.put("jobs", notesJobInfo);
            NotebookServer.this.connectionManager.broadcast(JobManagerServiceType.JOB_MANAGER_PAGE.getKey(), new Message(Message.OP.LIST_UPDATE_NOTE_JOBS).put("noteRunningJobs", response));
        }
    }

    protected static enum JobManagerServiceType {
        JOB_MANAGER_PAGE("JOB_MANAGER_PAGE");

        private final String serviceTypeKey;

        private JobManagerServiceType(String serviceType) {
            this.serviceTypeKey = serviceType;
        }

        String getKey() {
            return this.serviceTypeKey;
        }
    }
}

