/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zeppelin.flink.internal;

import java.lang.reflect.Field;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import org.apache.flink.configuration.ConfigOption;
import org.apache.flink.configuration.ConfigUtils;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.PipelineOptions;
import org.apache.flink.configuration.WritableConfig;
import org.apache.flink.core.execution.JobClient;
import org.apache.flink.streaming.api.environment.StreamExecutionEnvironment;
import org.apache.flink.streaming.api.graph.StreamGraph;
import org.apache.flink.util.JarUtils;
import org.apache.flink.util.Preconditions;
import org.apache.zeppelin.flink.FlinkVersion;
import org.apache.zeppelin.flink.internal.FlinkILoop;

public class ScalaShellStreamEnvironment
extends StreamExecutionEnvironment {
    private final List<URL> jarFiles;
    private final FlinkILoop flinkILoop;
    private final FlinkVersion flinkVersion;

    public ScalaShellStreamEnvironment(Configuration configuration, FlinkILoop flinkILoop, FlinkVersion flinkVersion, ClassLoader classLoader, String ... jarFiles) {
        super(configuration);
        this.flinkILoop = (FlinkILoop)((Object)Preconditions.checkNotNull((Object)((Object)flinkILoop)));
        this.flinkVersion = (FlinkVersion)Preconditions.checkNotNull((Object)flinkVersion);
        this.jarFiles = (List)Preconditions.checkNotNull((Object)JarUtils.getJarFiles((String[])jarFiles));
        if (flinkVersion.newerThanOrEqual(FlinkVersion.fromVersionString("1.16"))) {
            try {
                Field field = StreamExecutionEnvironment.class.getDeclaredField("userClassloader");
                field.setAccessible(true);
                field.set((Object)this, classLoader);
            }
            catch (IllegalAccessException | NoSuchFieldException e) {
                throw new RuntimeException("Unable to set userClassLoader", e);
            }
        }
    }

    public JobClient executeAsync(StreamGraph streamGraph) throws Exception {
        this.updateDependencies();
        return super.executeAsync(streamGraph);
    }

    private void updateDependencies() throws Exception {
        List<URL> updatedJarFiles = this.getUpdatedJarFiles();
        ConfigUtils.encodeCollectionToConfig((WritableConfig)((Configuration)this.getFlinkConfiguration()), (ConfigOption)PipelineOptions.JARS, updatedJarFiles, URL::toString);
    }

    public Object getFlinkConfiguration() {
        try {
            Field configurationField = StreamExecutionEnvironment.class.getDeclaredField("configuration");
            configurationField.setAccessible(true);
            return configurationField.get((Object)this);
        }
        catch (Exception e) {
            throw new RuntimeException("Fail to get configuration from StreamExecutionEnvironment", e);
        }
    }

    private List<URL> getUpdatedJarFiles() throws MalformedURLException {
        URL jarUrl = this.flinkILoop.writeFilesToDisk().getAbsoluteFile().toURI().toURL();
        ArrayList<URL> allJarFiles = new ArrayList<URL>(this.jarFiles);
        allJarFiles.add(jarUrl);
        return allJarFiles;
    }

    public static void resetContextEnvironments() {
        StreamExecutionEnvironment.resetContextEnvironment();
    }
}

