/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zeppelin.flink;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.LinkedList;
import java.util.Map;
import java.util.Properties;
import org.apache.flink.api.java.ExecutionEnvironment;
import org.apache.flink.streaming.api.environment.StreamExecutionEnvironment;
import org.apache.flink.table.api.TableEnvironment;
import org.apache.zeppelin.flink.FlinkInterpreter;
import org.apache.zeppelin.flink.IPyFlinkInterpreter;
import org.apache.zeppelin.interpreter.InterpreterContext;
import org.apache.zeppelin.interpreter.InterpreterException;
import org.apache.zeppelin.interpreter.InterpreterResult;
import org.apache.zeppelin.interpreter.ZeppelinContext;
import org.apache.zeppelin.python.IPythonInterpreter;
import org.apache.zeppelin.python.PythonInterpreter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PyFlinkInterpreter
extends PythonInterpreter {
    private static final Logger LOGGER = LoggerFactory.getLogger(PyFlinkInterpreter.class);
    private FlinkInterpreter flinkInterpreter;
    private InterpreterContext curInterpreterContext;
    private boolean isOpened = false;
    private ClassLoader originalClassLoader;

    public PyFlinkInterpreter(Properties properties) {
        super(properties);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void open() throws InterpreterException {
        File[] files;
        File localRepoDir;
        this.flinkInterpreter = (FlinkInterpreter)((Object)this.getInterpreterInTheSameSessionByClassName(FlinkInterpreter.class));
        this.setProperty("zeppelin.python", this.getProperty("zeppelin.pyflink.python", "python"));
        this.setProperty("zeppelin.python.useIPython", this.getProperty("zeppelin.pyflink.useIPython", "true"));
        URL[] urls = new URL[]{};
        LinkedList<URL> urlList = new LinkedList<URL>();
        String localRepo = this.getProperty("zeppelin.interpreter.localRepo");
        if (localRepo != null && (localRepoDir = new File(localRepo)).exists() && (files = localRepoDir.listFiles()) != null) {
            for (File f : files) {
                try {
                    urlList.add(f.toURI().toURL());
                }
                catch (MalformedURLException e) {
                    LOGGER.error("Error", e);
                }
            }
        }
        urls = urlList.toArray(urls);
        ClassLoader oldCl = Thread.currentThread().getContextClassLoader();
        try {
            URLClassLoader newCl = new URLClassLoader(urls, oldCl);
            Thread.currentThread().setContextClassLoader(newCl);
            this.flinkInterpreter = (FlinkInterpreter)((Object)this.getInterpreterInTheSameSessionByClassName(FlinkInterpreter.class));
            super.open();
        }
        finally {
            Thread.currentThread().setContextClassLoader(oldCl);
        }
        if (!this.useIPython()) {
            try {
                this.bootstrapInterpreter("python/zeppelin_pyflink.py");
            }
            catch (IOException e) {
                throw new InterpreterException("Fail to bootstrap pyflink", (Throwable)e);
            }
        }
        this.isOpened = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public InterpreterResult interpret(String st, InterpreterContext context) throws InterpreterException {
        try {
            if (!this.useIPython()) {
                if (this.isOpened) {
                    this.curInterpreterContext = context;
                    InterpreterResult result = super.interpret("intp.initJavaThread()", context);
                    if (result.code() != InterpreterResult.Code.SUCCESS) {
                        throw new InterpreterException("Fail to initJavaThread: " + result.toString());
                    }
                }
                this.flinkInterpreter.setSavepointPathIfNecessary(context);
                this.flinkInterpreter.setParallelismIfNecessary(context);
            }
            InterpreterResult interpreterResult = super.interpret(st, context);
            return interpreterResult;
        }
        finally {
            InterpreterResult result;
            if ((this.useIPython() || !this.useIPython() && this.getPythonProcessLauncher().isRunning()) && (result = super.interpret("intp.resetClassLoaderInPythonThread()", context)).code() != InterpreterResult.Code.SUCCESS) {
                LOGGER.warn("Fail to resetClassLoaderInPythonThread: {}", (Object)result);
            }
        }
    }

    public void initJavaThread() {
        InterpreterContext.set((InterpreterContext)this.curInterpreterContext);
        this.originalClassLoader = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(this.flinkInterpreter.getFlinkScalaShellLoader());
        this.flinkInterpreter.createPlannerAgain();
    }

    public void resetClassLoaderInPythonThread() {
        if (this.originalClassLoader != null) {
            Thread.currentThread().setContextClassLoader(this.originalClassLoader);
        }
    }

    @Override
    public void cancel(InterpreterContext context) throws InterpreterException {
        this.flinkInterpreter.cancel(context);
        if (this.useIPython()) {
            super.cancel(context);
        }
    }

    @Override
    protected Map<String, String> setupPythonEnv() throws IOException {
        Map<String, String> envs = super.setupPythonEnv();
        String pythonPath = envs.getOrDefault("PYTHONPATH", "");
        String pyflinkPythonPath = this.flinkInterpreter.getFlinkShims().getPyFlinkPythonPath(this.properties);
        envs.put("PYTHONPATH", pythonPath + ":" + pyflinkPythonPath);
        return envs;
    }

    @Override
    protected IPythonInterpreter getIPythonInterpreter() throws InterpreterException {
        return (IPythonInterpreter)((Object)this.getInterpreterInTheSameSessionByClassName(IPyFlinkInterpreter.class, false));
    }

    @Override
    public ZeppelinContext getZeppelinContext() {
        return this.flinkInterpreter.getZeppelinContext();
    }

    @Override
    public int getProgress(InterpreterContext context) throws InterpreterException {
        return this.flinkInterpreter.getProgress(context);
    }

    public boolean isAfterFlink114() {
        return this.flinkInterpreter.getFlinkVersion().isAfterFlink114();
    }

    public ExecutionEnvironment getJavaExecutionEnvironment() {
        return this.flinkInterpreter.getExecutionEnvironment().getJavaEnv();
    }

    public StreamExecutionEnvironment getJavaStreamExecutionEnvironment() {
        return this.flinkInterpreter.getStreamExecutionEnvironment().getJavaEnv();
    }

    public TableEnvironment getJavaBatchTableEnvironment(String planner) {
        return this.flinkInterpreter.getJavaBatchTableEnvironment(planner);
    }

    public TableEnvironment getJavaStreamTableEnvironment() {
        return this.flinkInterpreter.getJavaStreamTableEnvironment();
    }
}

