/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zeppelin.flink;

import java.io.IOException;
import java.util.Map;
import java.util.Properties;
import org.apache.flink.api.java.ExecutionEnvironment;
import org.apache.flink.streaming.api.environment.StreamExecutionEnvironment;
import org.apache.flink.table.api.TableEnvironment;
import org.apache.zeppelin.flink.FlinkInterpreter;
import org.apache.zeppelin.interpreter.InterpreterContext;
import org.apache.zeppelin.interpreter.InterpreterException;
import org.apache.zeppelin.interpreter.InterpreterResult;
import org.apache.zeppelin.interpreter.ZeppelinContext;
import org.apache.zeppelin.python.IPythonInterpreter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IPyFlinkInterpreter
extends IPythonInterpreter {
    private static final Logger LOGGER = LoggerFactory.getLogger(IPyFlinkInterpreter.class);
    private FlinkInterpreter flinkInterpreter;
    private InterpreterContext curInterpreterContext;
    private boolean opened = false;
    private ClassLoader originalClassLoader;

    public IPyFlinkInterpreter(Properties property) {
        super(property);
    }

    @Override
    public synchronized void open() throws InterpreterException {
        if (this.opened) {
            return;
        }
        FlinkInterpreter pyFlinkInterpreter = (FlinkInterpreter)((Object)this.getInterpreterInTheSameSessionByClassName(FlinkInterpreter.class, false));
        this.setProperty("zeppelin.python", pyFlinkInterpreter.getProperty("zeppelin.pyflink.python", "python"));
        this.flinkInterpreter = (FlinkInterpreter)((Object)this.getInterpreterInTheSameSessionByClassName(FlinkInterpreter.class));
        this.setAdditionalPythonInitFile("python/zeppelin_ipyflink.py");
        super.open();
        this.opened = true;
    }

    public boolean isAfterFlink114() {
        return this.flinkInterpreter.getFlinkVersion().isAfterFlink114();
    }

    @Override
    public ZeppelinContext buildZeppelinContext() {
        return this.flinkInterpreter.getZeppelinContext();
    }

    @Override
    protected Map<String, String> setupKernelEnv() throws IOException {
        Map<String, String> envs = super.setupKernelEnv();
        String pythonPath = envs.getOrDefault("PYTHONPATH", "");
        String pyflinkPythonPath = this.flinkInterpreter.getFlinkShims().getPyFlinkPythonPath(this.properties);
        envs.put("PYTHONPATH", pythonPath + ":" + pyflinkPythonPath);
        return envs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public InterpreterResult internalInterpret(String st, InterpreterContext context) throws InterpreterException {
        try {
            this.curInterpreterContext = context;
            InterpreterResult result = super.internalInterpret("intp.initJavaThread()", context);
            if (result.code() != InterpreterResult.Code.SUCCESS) {
                throw new InterpreterException("Fail to initJavaThread: " + result.toString());
            }
            this.flinkInterpreter.setSavepointPathIfNecessary(context);
            this.flinkInterpreter.setParallelismIfNecessary(context);
            InterpreterResult interpreterResult = super.internalInterpret(st, context);
            return interpreterResult;
        }
        finally {
            InterpreterResult result;
            if (this.getKernelProcessLauncher().isRunning() && (result = super.internalInterpret("intp.resetClassLoaderInPythonThread()", context)).code() != InterpreterResult.Code.SUCCESS) {
                LOGGER.warn("Fail to resetClassLoaderInPythonThread: {}", (Object)result);
            }
        }
    }

    @Override
    public void cancel(InterpreterContext context) throws InterpreterException {
        this.flinkInterpreter.cancel(context);
        super.cancel(context);
    }

    public void initJavaThread() {
        InterpreterContext.set((InterpreterContext)this.curInterpreterContext);
        this.originalClassLoader = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(this.flinkInterpreter.getFlinkScalaShellLoader());
        this.flinkInterpreter.createPlannerAgain();
    }

    public void resetClassLoaderInPythonThread() {
        if (this.originalClassLoader != null) {
            Thread.currentThread().setContextClassLoader(this.originalClassLoader);
        }
    }

    @Override
    public int getProgress(InterpreterContext context) throws InterpreterException {
        return this.flinkInterpreter.getProgress(context);
    }

    public ExecutionEnvironment getJavaExecutionEnvironment() {
        return this.flinkInterpreter.getExecutionEnvironment().getJavaEnv();
    }

    public StreamExecutionEnvironment getJavaStreamExecutionEnvironment() {
        return this.flinkInterpreter.getStreamExecutionEnvironment().getJavaEnv();
    }

    public TableEnvironment getJavaBatchTableEnvironment(String planner) {
        return this.flinkInterpreter.getJavaBatchTableEnvironment(planner);
    }

    public TableEnvironment getJavaStreamTableEnvironment() {
        return this.flinkInterpreter.getJavaStreamTableEnvironment();
    }
}

