/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zeppelin.flink;

import java.util.Properties;
import org.apache.zeppelin.flink.FlinkInterpreter;
import org.apache.zeppelin.flink.FlinkShims;
import org.apache.zeppelin.interpreter.AbstractInterpreter;
import org.apache.zeppelin.interpreter.Interpreter;
import org.apache.zeppelin.interpreter.InterpreterContext;
import org.apache.zeppelin.interpreter.InterpreterException;
import org.apache.zeppelin.interpreter.InterpreterResult;
import org.apache.zeppelin.interpreter.ZeppelinContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class FlinkSqlInterpreter
extends AbstractInterpreter {
    private static final Logger LOGGER = LoggerFactory.getLogger(FlinkSqlInterpreter.class);
    protected FlinkInterpreter flinkInterpreter;
    protected FlinkShims flinkShims;
    protected ZeppelinContext z;

    public FlinkSqlInterpreter(Properties properties) {
        super(properties);
    }

    public void open() throws InterpreterException {
        this.flinkInterpreter = (FlinkInterpreter)((Object)this.getInterpreterInTheSameSessionByClassName(FlinkInterpreter.class));
        this.flinkShims = this.flinkInterpreter.getFlinkShims();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected InterpreterResult internalInterpret(String st, InterpreterContext context) throws InterpreterException {
        LOGGER.debug("Interpret code: {}", (Object)st);
        ClassLoader originClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(this.flinkInterpreter.getFlinkScalaShellLoader());
            this.flinkInterpreter.createPlannerAgain();
            this.flinkInterpreter.setParallelismIfNecessary(context);
            this.flinkInterpreter.setSavepointPathIfNecessary(context);
            InterpreterResult interpreterResult = this.runSqlList(st, context);
            return interpreterResult;
        }
        finally {
            Thread.currentThread().setContextClassLoader(originClassLoader);
        }
    }

    public ZeppelinContext getZeppelinContext() {
        if (this.flinkInterpreter != null) {
            return this.flinkInterpreter.getZeppelinContext();
        }
        return null;
    }

    public abstract InterpreterResult runSqlList(String var1, InterpreterContext var2);

    public void cancel(InterpreterContext context) throws InterpreterException {
        this.flinkInterpreter.cancel(context);
    }

    public Interpreter.FormType getFormType() throws InterpreterException {
        return Interpreter.FormType.SIMPLE;
    }

    public void close() throws InterpreterException {
    }
}

