/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zeppelin.flink;

import java.util.Properties;
import org.apache.zeppelin.flink.FlinkSqlContext;
import org.apache.zeppelin.flink.FlinkSqlInterpreter;
import org.apache.zeppelin.interpreter.InterpreterContext;
import org.apache.zeppelin.interpreter.InterpreterException;
import org.apache.zeppelin.interpreter.InterpreterResult;
import org.apache.zeppelin.scheduler.Scheduler;
import org.apache.zeppelin.scheduler.SchedulerFactory;

public class FlinkBatchSqlInterpreter
extends FlinkSqlInterpreter {
    public FlinkBatchSqlInterpreter(Properties properties) {
        super(properties);
    }

    @Override
    public void open() throws InterpreterException {
        super.open();
        FlinkSqlContext flinkSqlContext = new FlinkSqlContext(this.flinkInterpreter.getExecutionEnvironment().getJavaEnv(), this.flinkInterpreter.getStreamExecutionEnvironment().getJavaEnv(), this.flinkInterpreter.getJavaBatchTableEnvironment("blink"), this.flinkInterpreter.getJavaStreamTableEnvironment(), this.flinkInterpreter.getZeppelinContext(), null);
        this.flinkInterpreter.getFlinkShims().initInnerBatchSqlInterpreter(flinkSqlContext);
    }

    @Override
    public InterpreterResult runSqlList(String st, InterpreterContext context) {
        return this.flinkShims.runSqlList(st, context, true);
    }

    public int getProgress(InterpreterContext context) throws InterpreterException {
        return this.flinkInterpreter.getProgress(context);
    }

    public Scheduler getScheduler() {
        int maxConcurrency = Integer.parseInt(this.properties.getProperty("zeppelin.flink.concurrentBatchSql.max", "10"));
        return SchedulerFactory.singleton().createOrGetParallelScheduler(FlinkBatchSqlInterpreter.class.getName(), maxConcurrency);
    }
}

