/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zeppelin.flink;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import org.apache.flink.api.common.JobExecutionResult;
import org.apache.flink.api.java.ExecutionEnvironment;
import org.apache.flink.configuration.ConfigOption;
import org.apache.flink.configuration.ConfigUtils;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.DeploymentOptions;
import org.apache.flink.configuration.PipelineOptions;
import org.apache.flink.configuration.WritableConfig;
import org.apache.flink.core.execution.JobClient;
import org.apache.flink.core.execution.PipelineExecutorServiceLoader;
import org.apache.flink.util.Preconditions;
import org.apache.zeppelin.flink.FlinkScalaInterpreter;
import org.apache.zeppelin.flink.internal.FlinkILoop;

public class ApplicationModeExecutionEnvironment
extends ExecutionEnvironment {
    private FlinkILoop flinkILoop;
    private FlinkScalaInterpreter flinkScalaInterpreter;

    public ApplicationModeExecutionEnvironment(PipelineExecutorServiceLoader executorServiceLoader, Configuration configuration, ClassLoader userClassloader, FlinkILoop flinkILoop, FlinkScalaInterpreter flinkScalaInterpreter) {
        super(executorServiceLoader, configuration, userClassloader);
        this.flinkILoop = flinkILoop;
        this.flinkScalaInterpreter = flinkScalaInterpreter;
    }

    public JobClient executeAsync(String jobName) throws Exception {
        this.updateDependencies();
        return super.executeAsync(jobName);
    }

    public JobExecutionResult execute() throws Exception {
        this.updateDependencies();
        return super.execute();
    }

    public JobExecutionResult execute(String jobName) throws Exception {
        this.updateDependencies();
        return super.execute(jobName);
    }

    private void updateDependencies() throws Exception {
        Configuration configuration = this.getConfiguration();
        Preconditions.checkState((boolean)configuration.getBoolean(DeploymentOptions.ATTACHED), (Object)"Only ATTACHED mode is supported by the scala shell.");
        List<URL> updatedJarFiles = this.getUpdatedJarFiles();
        ConfigUtils.encodeCollectionToConfig((WritableConfig)configuration, (ConfigOption)PipelineOptions.JARS, updatedJarFiles, URL::toString);
    }

    private List<URL> getUpdatedJarFiles() throws MalformedURLException {
        URL jarUrl = this.flinkILoop.writeFilesToDisk().getAbsoluteFile().toURI().toURL();
        ArrayList<URL> allJarFiles = new ArrayList<URL>();
        allJarFiles.add(jarUrl);
        for (String jar : this.flinkScalaInterpreter.getUserJars()) {
            allJarFiles.add(new File(jar).toURI().toURL());
        }
        return allJarFiles;
    }
}

