/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zeppelin.mongodb;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Scanner;
import org.apache.commons.exec.CommandLine;
import org.apache.commons.exec.DefaultExecutor;
import org.apache.commons.exec.ExecuteException;
import org.apache.commons.exec.ExecuteWatchdog;
import org.apache.commons.exec.Executor;
import org.apache.commons.exec.PumpStreamHandler;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.zeppelin.interpreter.Interpreter;
import org.apache.zeppelin.interpreter.InterpreterContext;
import org.apache.zeppelin.interpreter.InterpreterResult;
import org.apache.zeppelin.scheduler.Scheduler;
import org.apache.zeppelin.scheduler.SchedulerFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MongoDbInterpreter
extends Interpreter {
    private static final Logger LOGGER = LoggerFactory.getLogger(MongoDbInterpreter.class);
    private String shellExtension = "";
    private static final int SIGTERM_CODE = 143;
    private long commandTimeout = 60000L;
    private String dbAddress;
    private int maxConcurrency = 10;
    private Map<String, Executor> runningProcesses = new HashMap<String, Executor>();

    public MongoDbInterpreter(Properties property) {
        super(property);
    }

    public void open() {
        try (Scanner scanner = new Scanner(MongoDbInterpreter.class.getResourceAsStream("/shell_extension.js"), "UTF-8").useDelimiter("\\A");){
            this.shellExtension = scanner.next();
        }
        this.commandTimeout = Long.parseLong(this.getProperty("mongo.shell.command.timeout"));
        this.maxConcurrency = Integer.parseInt(this.getProperty("mongo.interpreter.concurrency.max"));
        this.dbAddress = this.getProperty("mongo.server.host") + ":" + this.getProperty("mongo.server.port");
        this.prepareShellExtension();
    }

    public void close() {
        this.runningProcesses.clear();
        this.runningProcesses = null;
    }

    public Interpreter.FormType getFormType() {
        return Interpreter.FormType.SIMPLE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InterpreterResult interpret(String script, InterpreterContext context) {
        LOGGER.debug("Run MongoDB script: {}", (Object)script);
        if (StringUtils.isEmpty(script)) {
            return new InterpreterResult(InterpreterResult.Code.SUCCESS);
        }
        String paragraphId = context.getParagraphId();
        File scriptFile = new File(this.getScriptFileName(paragraphId));
        try {
            FileUtils.write(scriptFile, this.shellExtension + script);
        }
        catch (IOException e) {
            LOGGER.error("Can not write script in temp file", e);
            return new InterpreterResult(InterpreterResult.Code.ERROR, e.getMessage());
        }
        InterpreterResult result = new InterpreterResult(InterpreterResult.Code.SUCCESS);
        DefaultExecutor executor = new DefaultExecutor();
        ByteArrayOutputStream errorStream = new ByteArrayOutputStream();
        executor.setStreamHandler(new PumpStreamHandler((OutputStream)context.out, errorStream));
        executor.setWatchdog(new ExecuteWatchdog(this.commandTimeout));
        CommandLine cmdLine = CommandLine.parse(this.getProperty("mongo.shell.path"));
        cmdLine.addArgument("--quiet", false);
        cmdLine.addArgument(this.dbAddress, false);
        cmdLine.addArgument(scriptFile.getAbsolutePath(), false);
        try {
            executor.execute(cmdLine);
            this.runningProcesses.put(paragraphId, executor);
        }
        catch (ExecuteException e) {
            LOGGER.error("Can not run script in paragraph {}", (Object)paragraphId, (Object)e);
            int exitValue = e.getExitValue();
            InterpreterResult.Code code = InterpreterResult.Code.ERROR;
            Object msg = errorStream.toString();
            if (exitValue == 143) {
                code = InterpreterResult.Code.INCOMPLETE;
                msg = (String)msg + "Paragraph received a SIGTERM.\n";
                LOGGER.info("The paragraph {} stopped executing: {}", (Object)paragraphId, msg);
            }
            msg = (String)msg + "ExitValue: " + exitValue;
            result = new InterpreterResult(code, (String)msg);
        }
        catch (IOException e) {
            LOGGER.error("Can not run script in paragraph {}", (Object)paragraphId, (Object)e);
            result = new InterpreterResult(InterpreterResult.Code.ERROR, e.getMessage());
        }
        finally {
            FileUtils.deleteQuietly(scriptFile);
            this.stopProcess(paragraphId);
        }
        return result;
    }

    public int getProgress(InterpreterContext context) {
        return 0;
    }

    public void cancel(InterpreterContext context) {
        this.stopProcess(context.getParagraphId());
        FileUtils.deleteQuietly(new File(this.getScriptFileName(context.getParagraphId())));
    }

    public Scheduler getScheduler() {
        LOGGER.info("maxConcurrency is {}", (Object)this.maxConcurrency);
        return SchedulerFactory.singleton().createOrGetParallelScheduler(MongoDbInterpreter.class.getName() + ((Object)((Object)this)).hashCode(), this.maxConcurrency);
    }

    private String getScriptFileName(String paragraphId) {
        return String.format("%s%s.js", this.getScriptDir(), paragraphId);
    }

    private String getScriptDir() {
        Object tmpProperty = System.getProperty("java.io.tmpdir");
        if (!((String)tmpProperty).endsWith(File.separator)) {
            tmpProperty = (String)tmpProperty + File.separator;
        }
        return (String)tmpProperty + "zeppelin-mongo-scripts" + File.separator;
    }

    private void stopProcess(String paragraphId) {
        if (this.runningProcesses.containsKey(paragraphId)) {
            Executor executor = this.runningProcesses.get(paragraphId);
            ExecuteWatchdog watchdog = executor.getWatchdog();
            watchdog.destroyProcess();
            this.runningProcesses.remove(paragraphId);
        }
    }

    private void prepareShellExtension() {
        this.shellExtension = this.shellExtension.replace("TABLE_LIMIT_PLACEHOLDER", this.getProperty("mongo.shell.command.table.limit")).replace("TARGET_DB_PLACEHOLDER", this.getProperty("mongo.server.database")).replace("USER_NAME_PLACEHOLDER", this.getProperty("mongo.server.username", "")).replace("PASSWORD_PLACEHOLDER", this.getProperty("mongo.server.password", "")).replace("AUTH_DB_PLACEHOLDER", this.getProperty("mongo.server.authenticationDatabase", ""));
    }
}

