/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.transport;

import com.google.common.collect.ImmutableMap;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.atomic.AtomicLong;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.collect.MapBuilder;
import org.elasticsearch.common.component.AbstractLifecycleComponent;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.logging.ESLogger;
import org.elasticsearch.common.logging.Loggers;
import org.elasticsearch.common.metrics.MeanMetric;
import org.elasticsearch.common.regex.Regex;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.transport.BoundTransportAddress;
import org.elasticsearch.common.transport.TransportAddress;
import org.elasticsearch.common.util.concurrent.AbstractRunnable;
import org.elasticsearch.common.util.concurrent.ConcurrentCollections;
import org.elasticsearch.common.util.concurrent.ConcurrentMapLong;
import org.elasticsearch.common.util.concurrent.EsRejectedExecutionException;
import org.elasticsearch.common.util.concurrent.FutureUtils;
import org.elasticsearch.node.settings.NodeSettingsService;
import org.elasticsearch.tasks.TaskManager;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.ActionNotFoundTransportException;
import org.elasticsearch.transport.ConnectTransportException;
import org.elasticsearch.transport.NodeDisconnectedException;
import org.elasticsearch.transport.PlainTransportFuture;
import org.elasticsearch.transport.ReceiveTimeoutTransportException;
import org.elasticsearch.transport.RemoteTransportException;
import org.elasticsearch.transport.RequestHandlerRegistry;
import org.elasticsearch.transport.ResponseHandlerFailureTransportException;
import org.elasticsearch.transport.SendRequestTransportException;
import org.elasticsearch.transport.Transport;
import org.elasticsearch.transport.TransportChannel;
import org.elasticsearch.transport.TransportConnectionListener;
import org.elasticsearch.transport.TransportException;
import org.elasticsearch.transport.TransportFuture;
import org.elasticsearch.transport.TransportInfo;
import org.elasticsearch.transport.TransportRequest;
import org.elasticsearch.transport.TransportRequestHandler;
import org.elasticsearch.transport.TransportRequestOptions;
import org.elasticsearch.transport.TransportResponse;
import org.elasticsearch.transport.TransportResponseHandler;
import org.elasticsearch.transport.TransportResponseOptions;
import org.elasticsearch.transport.TransportServiceAdapter;
import org.elasticsearch.transport.TransportStats;

public class TransportService
extends AbstractLifecycleComponent<TransportService> {
    public static final String DIRECT_RESPONSE_PROFILE = ".direct";
    private final CountDownLatch blockIncomingRequestsLatch = new CountDownLatch(1);
    protected final Transport transport;
    protected final ThreadPool threadPool;
    protected final TaskManager taskManager;
    volatile ImmutableMap<String, RequestHandlerRegistry> requestHandlers = ImmutableMap.of();
    final Object requestHandlerMutex = new Object();
    final ConcurrentMapLong<RequestHolder> clientHandlers = ConcurrentCollections.newConcurrentMapLongWithAggressiveConcurrency();
    final AtomicLong requestIds = new AtomicLong();
    final CopyOnWriteArrayList<TransportConnectionListener> connectionListeners = new CopyOnWriteArrayList();
    final Map<Long, TimeoutInfoHolder> timeoutInfoHandlers = Collections.synchronizedMap(new LinkedHashMap<Long, TimeoutInfoHolder>(100, 0.75f, true){

        @Override
        protected boolean removeEldestEntry(Map.Entry eldest) {
            return this.size() > 100;
        }
    });
    private final Adapter adapter;
    public static final String SETTING_TRACE_LOG_INCLUDE = "transport.tracer.include";
    public static final String SETTING_TRACE_LOG_EXCLUDE = "transport.tracer.exclude";
    private final ESLogger tracerLog;
    volatile String[] tracerLogInclude;
    volatile String[] tracelLogExclude;
    private final ApplySettings settingsListener = new ApplySettings();
    volatile DiscoveryNode localNode = null;

    public TransportService(Transport transport, ThreadPool threadPool) {
        this(Settings.Builder.EMPTY_SETTINGS, transport, threadPool);
    }

    @Inject
    public TransportService(Settings settings, Transport transport, ThreadPool threadPool) {
        super(settings);
        this.transport = transport;
        this.threadPool = threadPool;
        this.tracerLogInclude = settings.getAsArray(SETTING_TRACE_LOG_INCLUDE, Strings.EMPTY_ARRAY, true);
        this.tracelLogExclude = settings.getAsArray(SETTING_TRACE_LOG_EXCLUDE, new String[]{"internal:discovery/zen/fd*", "cluster:monitor/nodes/liveness"}, true);
        this.tracerLog = Loggers.getLogger(this.logger, ".tracer");
        this.adapter = this.createAdapter();
        this.taskManager = this.createTaskManager();
    }

    public void setLocalNode(DiscoveryNode localNode) {
        this.localNode = localNode;
    }

    DiscoveryNode getLocalNode() {
        return this.localNode;
    }

    public TaskManager getTaskManager() {
        return this.taskManager;
    }

    protected Adapter createAdapter() {
        return new Adapter();
    }

    protected TaskManager createTaskManager() {
        return new TaskManager(this.settings);
    }

    @Inject(optional=true)
    public void setDynamicSettings(NodeSettingsService nodeSettingsService) {
        nodeSettingsService.addListener(this.settingsListener);
    }

    public void applySettings(Settings settings) {
        this.settingsListener.onRefreshSettings(settings);
    }

    @Override
    protected void doStart() {
        this.adapter.rxMetric.clear();
        this.adapter.txMetric.clear();
        this.transport.transportServiceAdapter(this.adapter);
        this.transport.start();
        if (this.transport.boundAddress() != null && this.logger.isInfoEnabled()) {
            this.logger.info("{}", this.transport.boundAddress());
            for (Map.Entry<String, BoundTransportAddress> entry : this.transport.profileBoundAddresses().entrySet()) {
                this.logger.info("profile [{}]: {}", entry.getKey(), entry.getValue());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void doStop() {
        try {
            this.transport.stop();
        }
        catch (Throwable throwable) {
            for (Map.Entry entry : this.clientHandlers.entrySet()) {
                RequestHolder holderToNotify = (RequestHolder)this.clientHandlers.remove(entry.getKey());
                if (holderToNotify == null) continue;
                this.threadPool.generic().execute(new Runnable(holderToNotify){
                    final /* synthetic */ RequestHolder val$holderToNotify;
                    {
                        this.val$holderToNotify = requestHolder;
                    }

                    @Override
                    public void run() {
                        this.val$holderToNotify.handler().handleException(new TransportException("transport stopped, action: " + this.val$holderToNotify.action()));
                    }
                });
            }
            throw throwable;
        }
        for (Map.Entry entry : this.clientHandlers.entrySet()) {
            RequestHolder holderToNotify = (RequestHolder)this.clientHandlers.remove(entry.getKey());
            if (holderToNotify == null) continue;
            this.threadPool.generic().execute(new /* invalid duplicate definition of identical inner class */);
        }
    }

    @Override
    protected void doClose() {
        this.transport.close();
    }

    public void acceptIncomingRequests() {
        this.blockIncomingRequestsLatch.countDown();
    }

    public boolean addressSupported(Class<? extends TransportAddress> address) {
        return this.transport.addressSupported(address);
    }

    public TransportInfo info() {
        BoundTransportAddress boundTransportAddress = this.boundAddress();
        if (boundTransportAddress == null) {
            return null;
        }
        return new TransportInfo(boundTransportAddress, this.transport.profileBoundAddresses());
    }

    public TransportStats stats() {
        return new TransportStats(this.transport.serverOpen(), this.adapter.rxMetric.count(), this.adapter.rxMetric.sum(), this.adapter.txMetric.count(), this.adapter.txMetric.sum());
    }

    public BoundTransportAddress boundAddress() {
        return this.transport.boundAddress();
    }

    public List<String> getLocalAddresses() {
        return this.transport.getLocalAddresses();
    }

    public boolean nodeConnected(DiscoveryNode node) {
        return node.equals(this.localNode) || this.transport.nodeConnected(node);
    }

    public void connectToNode(DiscoveryNode node) throws ConnectTransportException {
        if (node.equals(this.localNode)) {
            return;
        }
        this.transport.connectToNode(node);
    }

    public void connectToNodeLight(DiscoveryNode node) throws ConnectTransportException {
        if (node.equals(this.localNode)) {
            return;
        }
        this.transport.connectToNodeLight(node);
    }

    public void disconnectFromNode(DiscoveryNode node) {
        if (node.equals(this.localNode)) {
            return;
        }
        this.transport.disconnectFromNode(node);
    }

    public void addConnectionListener(TransportConnectionListener listener) {
        this.connectionListeners.add(listener);
    }

    public void removeConnectionListener(TransportConnectionListener listener) {
        this.connectionListeners.remove(listener);
    }

    public <T extends TransportResponse> TransportFuture<T> submitRequest(DiscoveryNode node, String action, TransportRequest request, TransportResponseHandler<T> handler) throws TransportException {
        return this.submitRequest(node, action, request, TransportRequestOptions.EMPTY, handler);
    }

    public <T extends TransportResponse> TransportFuture<T> submitRequest(DiscoveryNode node, String action, TransportRequest request, TransportRequestOptions options, TransportResponseHandler<T> handler) throws TransportException {
        PlainTransportFuture<T> futureHandler = new PlainTransportFuture<T>(handler);
        this.sendRequest(node, action, request, options, futureHandler);
        return futureHandler;
    }

    public <T extends TransportResponse> void sendRequest(DiscoveryNode node, String action, TransportRequest request, TransportResponseHandler<T> handler) {
        this.sendRequest(node, action, request, TransportRequestOptions.EMPTY, handler);
    }

    public <T extends TransportResponse> void sendRequest(DiscoveryNode node, String action, TransportRequest request, TransportRequestOptions options, TransportResponseHandler<T> handler) {
        if (node == null) {
            throw new IllegalStateException("can't send request to a null node");
        }
        long requestId = this.newRequestId();
        try {
            TimeoutHandler timeoutHandler = options.timeout() == null ? null : new TimeoutHandler(requestId);
            this.clientHandlers.put(requestId, new RequestHolder<T>(handler, node, action, timeoutHandler));
            if (this.lifecycle.stoppedOrClosed()) {
                throw new TransportException("TransportService is closed stopped can't send request");
            }
            if (timeoutHandler != null) {
                assert (options.timeout() != null);
                timeoutHandler.future = this.threadPool.schedule(options.timeout(), "generic", timeoutHandler);
            }
            if (node.equals(this.localNode)) {
                this.sendLocalRequest(requestId, action, request);
            } else {
                this.transport.sendRequest(node, requestId, action, request, options);
            }
        }
        catch (Throwable e) {
            final RequestHolder holderToNotify = this.clientHandlers.remove(requestId);
            if (holderToNotify != null) {
                holderToNotify.cancelTimeout();
                final SendRequestTransportException sendRequestException = new SendRequestTransportException(node, action, e);
                this.threadPool.executor("generic").execute(new AbstractRunnable(){

                    @Override
                    public void onRejection(Throwable t) {
                        TransportService.this.logger.debug("failed to notify response handler on rejection", t, new Object[0]);
                    }

                    @Override
                    public void onFailure(Throwable t) {
                        TransportService.this.logger.warn("failed to notify response handler on exception", t, new Object[0]);
                    }

                    @Override
                    protected void doRun() throws Exception {
                        holderToNotify.handler().handleException(sendRequestException);
                    }
                });
            }
            this.logger.debug("Exception while sending request, handler likely already notified due to timeout", e, new Object[0]);
        }
    }

    private void sendLocalRequest(long requestId, final String action, final TransportRequest request) {
        final DirectResponseChannel channel = new DirectResponseChannel(this.logger, this.localNode, action, requestId, this.adapter, this.threadPool);
        try {
            final RequestHandlerRegistry reg = this.adapter.getRequestHandler(action);
            if (reg == null) {
                throw new ActionNotFoundTransportException("Action [" + action + "] not found");
            }
            String executor = reg.getExecutor();
            if ("same".equals(executor)) {
                reg.processMessageReceived(request, channel);
            } else {
                this.threadPool.executor(executor).execute(new AbstractRunnable(){

                    @Override
                    protected void doRun() throws Exception {
                        reg.processMessageReceived(request, channel);
                    }

                    @Override
                    public boolean isForceExecution() {
                        return reg.isForceExecution();
                    }

                    @Override
                    public void onFailure(Throwable e) {
                        try {
                            channel.sendResponse(e);
                        }
                        catch (Throwable e1) {
                            TransportService.this.logger.warn("failed to notify channel of error message for action [" + action + "]", e1, new Object[0]);
                            TransportService.this.logger.warn("actual exception", e, new Object[0]);
                        }
                    }
                });
            }
        }
        catch (Throwable e) {
            try {
                channel.sendResponse(e);
            }
            catch (Throwable e1) {
                this.logger.warn("failed to notify channel of error message for action [" + action + "]", e1, new Object[0]);
                this.logger.warn("actual exception", e1, new Object[0]);
            }
        }
    }

    private boolean shouldTraceAction(String action) {
        if (this.tracerLogInclude.length > 0 && !Regex.simpleMatch(this.tracerLogInclude, action)) {
            return false;
        }
        if (this.tracelLogExclude.length > 0) {
            return !Regex.simpleMatch(this.tracelLogExclude, action);
        }
        return true;
    }

    private long newRequestId() {
        return this.requestIds.getAndIncrement();
    }

    public TransportAddress[] addressesFromString(String address, int perAddressLimit) throws Exception {
        return this.transport.addressesFromString(address, perAddressLimit);
    }

    public final <Request extends TransportRequest> void registerRequestHandler(String action, Class<Request> request, String executor, TransportRequestHandler<Request> handler) {
        this.registerRequestHandler(action, request, executor, false, true, handler);
    }

    public <Request extends TransportRequest> void registerRequestHandler(String action, Callable<Request> requestFactory, String executor, TransportRequestHandler<Request> handler) {
        RequestHandlerRegistry<Request> reg = new RequestHandlerRegistry<Request>(action, requestFactory, this.taskManager, handler, executor, false, true);
        this.registerRequestHandler(reg);
    }

    public <Request extends TransportRequest> void registerRequestHandler(String action, Callable<Request> requestFactory, String executor, boolean forceExecution, boolean canTripCircuitBreaker, TransportRequestHandler<Request> handler) {
        RequestHandlerRegistry<Request> reg = new RequestHandlerRegistry<Request>(action, requestFactory, this.taskManager, handler, executor, forceExecution, canTripCircuitBreaker);
        this.registerRequestHandler(reg);
    }

    public <Request extends TransportRequest> void registerRequestHandler(String action, Class<Request> request, String executor, boolean forceExecution, boolean canTripCircuitBreaker, TransportRequestHandler<Request> handler) {
        RequestHandlerRegistry<Request> reg = new RequestHandlerRegistry<Request>(action, request, this.taskManager, handler, executor, forceExecution, canTripCircuitBreaker);
        this.registerRequestHandler(reg);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected <Request extends TransportRequest> void registerRequestHandler(RequestHandlerRegistry<Request> reg) {
        Object object = this.requestHandlerMutex;
        synchronized (object) {
            RequestHandlerRegistry replaced = this.requestHandlers.get(reg.getAction());
            this.requestHandlers = MapBuilder.newMapBuilder(this.requestHandlers).put(reg.getAction(), reg).immutableMap();
            if (replaced != null) {
                this.logger.warn("registered two transport handlers for action {}, handlers: {}, {}", reg.getAction(), reg, replaced);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeHandler(String action) {
        Object object = this.requestHandlerMutex;
        synchronized (object) {
            this.requestHandlers = MapBuilder.newMapBuilder(this.requestHandlers).remove(action).immutableMap();
        }
    }

    protected RequestHandlerRegistry getRequestHandler(String action) {
        return this.requestHandlers.get(action);
    }

    static class DirectResponseChannel
    implements TransportChannel {
        final ESLogger logger;
        final DiscoveryNode localNode;
        private final String action;
        private final long requestId;
        final TransportServiceAdapter adapter;
        final ThreadPool threadPool;

        public DirectResponseChannel(ESLogger logger, DiscoveryNode localNode, String action, long requestId, TransportServiceAdapter adapter, ThreadPool threadPool) {
            this.logger = logger;
            this.localNode = localNode;
            this.action = action;
            this.requestId = requestId;
            this.adapter = adapter;
            this.threadPool = threadPool;
        }

        @Override
        public String action() {
            return this.action;
        }

        @Override
        public String getProfileName() {
            return TransportService.DIRECT_RESPONSE_PROFILE;
        }

        @Override
        public void sendResponse(TransportResponse response) throws IOException {
            this.sendResponse(response, TransportResponseOptions.EMPTY);
        }

        @Override
        public void sendResponse(final TransportResponse response, TransportResponseOptions options) throws IOException {
            final TransportResponseHandler handler = this.adapter.onResponseReceived(this.requestId);
            if (handler != null) {
                String executor = handler.executor();
                if ("same".equals(executor)) {
                    this.processResponse(handler, response);
                } else {
                    this.threadPool.executor(executor).execute(new Runnable(){

                        @Override
                        public void run() {
                            DirectResponseChannel.this.processResponse(handler, response);
                        }
                    });
                }
            }
        }

        protected void processResponse(TransportResponseHandler handler, TransportResponse response) {
            try {
                handler.handleResponse(response);
            }
            catch (Throwable e) {
                this.processException(handler, this.wrapInRemote(new ResponseHandlerFailureTransportException(e)));
            }
        }

        @Override
        public void sendResponse(Throwable error) throws IOException {
            final TransportResponseHandler handler = this.adapter.onResponseReceived(this.requestId);
            if (handler != null) {
                final RemoteTransportException rtx = this.wrapInRemote(error);
                String executor = handler.executor();
                if ("same".equals(executor)) {
                    this.processException(handler, rtx);
                } else {
                    this.threadPool.executor(handler.executor()).execute(new Runnable(){

                        @Override
                        public void run() {
                            DirectResponseChannel.this.processException(handler, rtx);
                        }
                    });
                }
            }
        }

        protected RemoteTransportException wrapInRemote(Throwable t) {
            if (t instanceof RemoteTransportException) {
                return (RemoteTransportException)t;
            }
            return new RemoteTransportException(this.localNode.name(), this.localNode.getAddress(), this.action, t);
        }

        protected void processException(TransportResponseHandler handler, RemoteTransportException rtx) {
            try {
                handler.handleException(rtx);
            }
            catch (Throwable e) {
                this.logger.error("failed to handle exception for action [{}], handler [{}]", e, this.action, handler);
            }
        }

        @Override
        public long getRequestId() {
            return this.requestId;
        }

        @Override
        public String getChannelType() {
            return "direct";
        }
    }

    static class RequestHolder<T extends TransportResponse> {
        private final TransportResponseHandler<T> handler;
        private final DiscoveryNode node;
        private final String action;
        private final TimeoutHandler timeoutHandler;

        RequestHolder(TransportResponseHandler<T> handler, DiscoveryNode node, String action, TimeoutHandler timeoutHandler) {
            this.handler = handler;
            this.node = node;
            this.action = action;
            this.timeoutHandler = timeoutHandler;
        }

        public TransportResponseHandler<T> handler() {
            return this.handler;
        }

        public DiscoveryNode node() {
            return this.node;
        }

        public String action() {
            return this.action;
        }

        public void cancelTimeout() {
            if (this.timeoutHandler != null) {
                this.timeoutHandler.cancel();
            }
        }
    }

    static class TimeoutInfoHolder {
        private final DiscoveryNode node;
        private final String action;
        private final long sentTime;
        private final long timeoutTime;

        TimeoutInfoHolder(DiscoveryNode node, String action, long sentTime, long timeoutTime) {
            this.node = node;
            this.action = action;
            this.sentTime = sentTime;
            this.timeoutTime = timeoutTime;
        }

        public DiscoveryNode node() {
            return this.node;
        }

        public String action() {
            return this.action;
        }

        public long sentTime() {
            return this.sentTime;
        }

        public long timeoutTime() {
            return this.timeoutTime;
        }
    }

    class TimeoutHandler
    implements Runnable {
        private final long requestId;
        private final long sentTime = System.currentTimeMillis();
        volatile ScheduledFuture future;

        TimeoutHandler(long requestId) {
            this.requestId = requestId;
        }

        @Override
        public void run() {
            RequestHolder holder = TransportService.this.clientHandlers.get(this.requestId);
            if (holder != null) {
                long timeoutTime = System.currentTimeMillis();
                TransportService.this.timeoutInfoHandlers.put(this.requestId, new TimeoutInfoHolder(holder.node(), holder.action(), this.sentTime, timeoutTime));
                RequestHolder removedHolder = TransportService.this.clientHandlers.remove(this.requestId);
                if (removedHolder != null) {
                    assert (removedHolder == holder) : "two different holder instances for request [" + this.requestId + "]";
                    removedHolder.handler().handleException(new ReceiveTimeoutTransportException(holder.node(), holder.action(), "request_id [" + this.requestId + "] timed out after [" + (timeoutTime - this.sentTime) + "ms]"));
                } else {
                    TransportService.this.timeoutInfoHandlers.remove(this.requestId);
                }
            }
        }

        public void cancel() {
            assert (TransportService.this.clientHandlers.get(this.requestId) == null) : "cancel must be called after the requestId [" + this.requestId + "] has been removed from clientHandlers";
            FutureUtils.cancel(this.future);
        }
    }

    protected class Adapter
    implements TransportServiceAdapter {
        final MeanMetric rxMetric = new MeanMetric();
        final MeanMetric txMetric = new MeanMetric();

        protected Adapter() {
        }

        @Override
        public void received(long size) {
            this.rxMetric.inc(size);
        }

        @Override
        public void sent(long size) {
            this.txMetric.inc(size);
        }

        @Override
        public void onRequestSent(DiscoveryNode node, long requestId, String action, TransportRequest request, TransportRequestOptions options) {
            if (this.traceEnabled() && TransportService.this.shouldTraceAction(action)) {
                this.traceRequestSent(node, requestId, action, options);
            }
        }

        protected boolean traceEnabled() {
            return TransportService.this.tracerLog.isTraceEnabled();
        }

        @Override
        public void onResponseSent(long requestId, String action, TransportResponse response, TransportResponseOptions options) {
            if (this.traceEnabled() && TransportService.this.shouldTraceAction(action)) {
                this.traceResponseSent(requestId, action);
            }
        }

        @Override
        public void onResponseSent(long requestId, String action, Throwable t) {
            if (this.traceEnabled() && TransportService.this.shouldTraceAction(action)) {
                this.traceResponseSent(requestId, action, t);
            }
        }

        protected void traceResponseSent(long requestId, String action, Throwable t) {
            TransportService.this.tracerLog.trace("[{}][{}] sent error response (error: [{}])", requestId, action, t.getMessage());
        }

        @Override
        public void onRequestReceived(long requestId, String action) {
            try {
                TransportService.this.blockIncomingRequestsLatch.await();
            }
            catch (InterruptedException e) {
                TransportService.this.logger.trace("interrupted while waiting for incoming requests block to be removed", new Object[0]);
            }
            if (this.traceEnabled() && TransportService.this.shouldTraceAction(action)) {
                this.traceReceivedRequest(requestId, action);
            }
        }

        @Override
        public RequestHandlerRegistry getRequestHandler(String action) {
            return TransportService.this.requestHandlers.get(action);
        }

        @Override
        public TransportResponseHandler onResponseReceived(long requestId) {
            RequestHolder holder = TransportService.this.clientHandlers.remove(requestId);
            if (holder == null) {
                this.checkForTimeout(requestId);
                return null;
            }
            holder.cancelTimeout();
            if (this.traceEnabled() && TransportService.this.shouldTraceAction(holder.action())) {
                this.traceReceivedResponse(requestId, holder.node(), holder.action());
            }
            return holder.handler();
        }

        protected void checkForTimeout(long requestId) {
            DiscoveryNode sourceNode;
            String action;
            assert (TransportService.this.clientHandlers.get(requestId) == null);
            TimeoutInfoHolder timeoutInfoHolder = TransportService.this.timeoutInfoHandlers.remove(requestId);
            if (timeoutInfoHolder != null) {
                long time = System.currentTimeMillis();
                TransportService.this.logger.warn("Received response for a request that has timed out, sent [{}ms] ago, timed out [{}ms] ago, action [{}], node [{}], id [{}]", time - timeoutInfoHolder.sentTime(), time - timeoutInfoHolder.timeoutTime(), timeoutInfoHolder.action(), timeoutInfoHolder.node(), requestId);
                action = timeoutInfoHolder.action();
                sourceNode = timeoutInfoHolder.node();
            } else {
                TransportService.this.logger.warn("Transport response handler not found of id [{}]", requestId);
                action = null;
                sourceNode = null;
            }
            if (!this.traceEnabled()) {
                return;
            }
            if (action == null) {
                assert (sourceNode == null);
                this.traceUnresolvedResponse(requestId);
            } else if (TransportService.this.shouldTraceAction(action)) {
                this.traceReceivedResponse(requestId, sourceNode, action);
            }
        }

        @Override
        public void raiseNodeConnected(final DiscoveryNode node) {
            TransportService.this.threadPool.generic().execute(new Runnable(){

                @Override
                public void run() {
                    for (TransportConnectionListener connectionListener : TransportService.this.connectionListeners) {
                        connectionListener.onNodeConnected(node);
                    }
                }
            });
        }

        @Override
        public void raiseNodeDisconnected(final DiscoveryNode node) {
            try {
                for (final TransportConnectionListener transportConnectionListener : TransportService.this.connectionListeners) {
                    TransportService.this.threadPool.generic().execute(new Runnable(){

                        @Override
                        public void run() {
                            transportConnectionListener.onNodeDisconnected(node);
                        }
                    });
                }
                for (Map.Entry entry : TransportService.this.clientHandlers.entrySet()) {
                    RequestHolder holderToNotify;
                    RequestHolder holder = (RequestHolder)entry.getValue();
                    if (!holder.node().equals(node) || (holderToNotify = (RequestHolder)TransportService.this.clientHandlers.remove(entry.getKey())) == null) continue;
                    TransportService.this.threadPool.generic().execute(new Runnable(){

                        @Override
                        public void run() {
                            holderToNotify.handler().handleException(new NodeDisconnectedException(node, holderToNotify.action()));
                        }
                    });
                }
            }
            catch (EsRejectedExecutionException ex) {
                TransportService.this.logger.debug("Rejected execution on NodeDisconnected", ex, new Object[0]);
            }
        }

        protected void traceReceivedRequest(long requestId, String action) {
            TransportService.this.tracerLog.trace("[{}][{}] received request", requestId, action);
        }

        protected void traceResponseSent(long requestId, String action) {
            TransportService.this.tracerLog.trace("[{}][{}] sent response", requestId, action);
        }

        protected void traceReceivedResponse(long requestId, DiscoveryNode sourceNode, String action) {
            TransportService.this.tracerLog.trace("[{}][{}] received response from [{}]", requestId, action, sourceNode);
        }

        protected void traceUnresolvedResponse(long requestId) {
            TransportService.this.tracerLog.trace("[{}] received response but can't resolve it to a request", requestId);
        }

        protected void traceRequestSent(DiscoveryNode node, long requestId, String action, TransportRequestOptions options) {
            TransportService.this.tracerLog.trace("[{}][{}] sent to [{}] (timeout: [{}])", requestId, action, node, options.timeout());
        }
    }

    class ApplySettings
    implements NodeSettingsService.Listener {
        ApplySettings() {
        }

        @Override
        public void onRefreshSettings(Settings settings) {
            Object[] newTracerLogInclude = settings.getAsArray(TransportService.SETTING_TRACE_LOG_INCLUDE, TransportService.this.tracerLogInclude, true);
            Object[] newTracerLogExclude = settings.getAsArray(TransportService.SETTING_TRACE_LOG_EXCLUDE, TransportService.this.tracelLogExclude, true);
            if (newTracerLogInclude == TransportService.this.tracerLogInclude && newTracerLogExclude == TransportService.this.tracelLogExclude) {
                return;
            }
            if (Arrays.equals(newTracerLogInclude, TransportService.this.tracerLogInclude) && Arrays.equals(newTracerLogExclude, TransportService.this.tracelLogExclude)) {
                return;
            }
            TransportService.this.tracerLogInclude = newTracerLogInclude;
            TransportService.this.tracelLogExclude = newTracerLogExclude;
            TransportService.this.logger.info("tracer log updated to use include: {}, exclude: {}", newTracerLogInclude, newTracerLogExclude);
        }
    }
}

