/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.aggregations.pipeline.bucketscript;

import com.google.common.base.Function;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.util.CollectionUtils;
import org.elasticsearch.script.CompiledScript;
import org.elasticsearch.script.ExecutableScript;
import org.elasticsearch.script.Script;
import org.elasticsearch.script.ScriptContext;
import org.elasticsearch.search.aggregations.Aggregation;
import org.elasticsearch.search.aggregations.AggregationExecutionException;
import org.elasticsearch.search.aggregations.InternalAggregation;
import org.elasticsearch.search.aggregations.InternalAggregations;
import org.elasticsearch.search.aggregations.InternalMultiBucketAggregation;
import org.elasticsearch.search.aggregations.bucket.MultiBucketsAggregation;
import org.elasticsearch.search.aggregations.pipeline.BucketHelpers;
import org.elasticsearch.search.aggregations.pipeline.InternalSimpleValue;
import org.elasticsearch.search.aggregations.pipeline.PipelineAggregator;
import org.elasticsearch.search.aggregations.pipeline.PipelineAggregatorFactory;
import org.elasticsearch.search.aggregations.pipeline.PipelineAggregatorStreams;
import org.elasticsearch.search.aggregations.support.format.ValueFormatter;
import org.elasticsearch.search.aggregations.support.format.ValueFormatterStreams;

public class BucketScriptPipelineAggregator
extends PipelineAggregator {
    public static final InternalAggregation.Type TYPE = new InternalAggregation.Type("bucket_script");
    public static final PipelineAggregatorStreams.Stream STREAM = new PipelineAggregatorStreams.Stream(){

        @Override
        public BucketScriptPipelineAggregator readResult(StreamInput in) throws IOException {
            BucketScriptPipelineAggregator result = new BucketScriptPipelineAggregator();
            result.readFrom(in);
            return result;
        }
    };
    private static final Function<Aggregation, InternalAggregation> FUNCTION = new Function<Aggregation, InternalAggregation>(){

        @Override
        public InternalAggregation apply(Aggregation input) {
            return (InternalAggregation)input;
        }
    };
    private ValueFormatter formatter;
    private BucketHelpers.GapPolicy gapPolicy;
    private Script script;
    private Map<String, String> bucketsPathsMap;

    public static void registerStreams() {
        PipelineAggregatorStreams.registerStream(STREAM, TYPE.stream());
    }

    public BucketScriptPipelineAggregator() {
    }

    public BucketScriptPipelineAggregator(String name, Map<String, String> bucketsPathsMap, Script script, ValueFormatter formatter, BucketHelpers.GapPolicy gapPolicy, Map<String, Object> metadata) {
        super(name, bucketsPathsMap.values().toArray(new String[bucketsPathsMap.size()]), metadata);
        this.bucketsPathsMap = bucketsPathsMap;
        this.script = script;
        this.formatter = formatter;
        this.gapPolicy = gapPolicy;
    }

    @Override
    public InternalAggregation.Type type() {
        return TYPE;
    }

    @Override
    public InternalAggregation reduce(InternalAggregation aggregation, InternalAggregation.ReduceContext reduceContext) {
        InternalMultiBucketAggregation originalAgg = (InternalMultiBucketAggregation)aggregation;
        List<? extends MultiBucketsAggregation.Bucket> buckets = originalAgg.getBuckets();
        CompiledScript compiledScript = reduceContext.scriptService().compile(this.script, ScriptContext.Standard.AGGS, reduceContext, Collections.emptyMap());
        ArrayList<MultiBucketsAggregation.Bucket> newBuckets = new ArrayList<MultiBucketsAggregation.Bucket>();
        for (MultiBucketsAggregation.Bucket bucket : buckets) {
            HashMap<String, Object> vars = new HashMap<String, Object>();
            if (this.script.getParams() != null) {
                vars.putAll(this.script.getParams());
            }
            boolean skipBucket = false;
            for (Map.Entry<String, String> entry : this.bucketsPathsMap.entrySet()) {
                String varName = entry.getKey();
                String bucketsPath = entry.getValue();
                Double value = BucketHelpers.resolveBucketValue(originalAgg, bucket, bucketsPath, this.gapPolicy);
                if (BucketHelpers.GapPolicy.SKIP == this.gapPolicy && (value == null || Double.isNaN(value))) {
                    skipBucket = true;
                    break;
                }
                vars.put(varName, value);
            }
            if (skipBucket) {
                newBuckets.add(bucket);
                continue;
            }
            ExecutableScript executableScript = reduceContext.scriptService().executable(compiledScript, vars);
            Object returned = executableScript.run();
            if (returned == null) {
                newBuckets.add(bucket);
                continue;
            }
            if (!(returned instanceof Number)) {
                throw new AggregationExecutionException("series_arithmetic script for reducer [" + this.name() + "] must return a Number");
            }
            ArrayList<InternalAggregation> aggs = new ArrayList<InternalAggregation>(CollectionUtils.eagerTransform(bucket.getAggregations().asList(), FUNCTION));
            aggs.add(new InternalSimpleValue(this.name(), ((Number)returned).doubleValue(), this.formatter, new ArrayList<PipelineAggregator>(), this.metaData()));
            InternalMultiBucketAggregation.InternalBucket newBucket = originalAgg.createBucket(new InternalAggregations(aggs), (InternalMultiBucketAggregation.InternalBucket)bucket);
            newBuckets.add(newBucket);
        }
        return originalAgg.create(newBuckets);
    }

    @Override
    protected void doWriteTo(StreamOutput out) throws IOException {
        this.script.writeTo(out);
        ValueFormatterStreams.writeOptional(this.formatter, out);
        this.gapPolicy.writeTo(out);
        out.writeGenericValue(this.bucketsPathsMap);
    }

    @Override
    protected void doReadFrom(StreamInput in) throws IOException {
        this.script = Script.readScript(in);
        this.formatter = ValueFormatterStreams.readOptional(in);
        this.gapPolicy = BucketHelpers.GapPolicy.readFrom(in);
        this.bucketsPathsMap = (Map)in.readGenericValue();
    }

    public static class Factory
    extends PipelineAggregatorFactory {
        private Script script;
        private final ValueFormatter formatter;
        private BucketHelpers.GapPolicy gapPolicy;
        private Map<String, String> bucketsPathsMap;

        public Factory(String name, Map<String, String> bucketsPathsMap, Script script, ValueFormatter formatter, BucketHelpers.GapPolicy gapPolicy) {
            super(name, TYPE.name(), bucketsPathsMap.values().toArray(new String[bucketsPathsMap.size()]));
            this.bucketsPathsMap = bucketsPathsMap;
            this.script = script;
            this.formatter = formatter;
            this.gapPolicy = gapPolicy;
        }

        @Override
        protected PipelineAggregator createInternal(Map<String, Object> metaData) throws IOException {
            return new BucketScriptPipelineAggregator(this.name, this.bucketsPathsMap, this.script, this.formatter, this.gapPolicy, metaData);
        }
    }
}

