/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.aggregations.bucket.significant;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.lucene.util.BytesRef;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.search.aggregations.AggregationStreams;
import org.elasticsearch.search.aggregations.InternalAggregation;
import org.elasticsearch.search.aggregations.InternalAggregations;
import org.elasticsearch.search.aggregations.bucket.BucketStreamContext;
import org.elasticsearch.search.aggregations.bucket.BucketStreams;
import org.elasticsearch.search.aggregations.bucket.significant.InternalSignificantTerms;
import org.elasticsearch.search.aggregations.bucket.significant.SignificantTerms;
import org.elasticsearch.search.aggregations.bucket.significant.heuristics.SignificanceHeuristic;
import org.elasticsearch.search.aggregations.bucket.significant.heuristics.SignificanceHeuristicStreams;
import org.elasticsearch.search.aggregations.pipeline.PipelineAggregator;

public class SignificantStringTerms
extends InternalSignificantTerms<SignificantStringTerms, Bucket> {
    public static final InternalAggregation.Type TYPE = new InternalAggregation.Type("significant_terms", "sigsterms");
    public static final AggregationStreams.Stream STREAM = new AggregationStreams.Stream(){

        @Override
        public SignificantStringTerms readResult(StreamInput in) throws IOException {
            SignificantStringTerms buckets = new SignificantStringTerms();
            buckets.readFrom(in);
            return buckets;
        }
    };
    private static final BucketStreams.Stream<Bucket> BUCKET_STREAM = new BucketStreams.Stream<Bucket>(){

        @Override
        public Bucket readResult(StreamInput in, BucketStreamContext context) throws IOException {
            Bucket buckets = new Bucket((Long)context.attributes().get("subsetSize"), (Long)context.attributes().get("supersetSize"));
            buckets.readFrom(in);
            return buckets;
        }

        @Override
        public BucketStreamContext getBucketStreamContext(Bucket bucket) {
            BucketStreamContext context = new BucketStreamContext();
            HashMap<String, Object> attributes = new HashMap<String, Object>();
            attributes.put("subsetSize", bucket.subsetSize);
            attributes.put("supersetSize", bucket.supersetSize);
            context.attributes(attributes);
            return context;
        }
    };

    public static void registerStream() {
        AggregationStreams.registerStream(STREAM, TYPE.stream());
        BucketStreams.registerStream(BUCKET_STREAM, TYPE.stream());
    }

    public static void registerStreams() {
        AggregationStreams.registerStream(STREAM, TYPE.stream());
    }

    SignificantStringTerms() {
    }

    public SignificantStringTerms(long subsetSize, long supersetSize, String name, int requiredSize, long minDocCount, SignificanceHeuristic significanceHeuristic, List<? extends InternalSignificantTerms.Bucket> buckets, List<PipelineAggregator> pipelineAggregators, Map<String, Object> metaData) {
        super(subsetSize, supersetSize, name, requiredSize, minDocCount, significanceHeuristic, buckets, pipelineAggregators, metaData);
    }

    @Override
    public InternalAggregation.Type type() {
        return TYPE;
    }

    @Override
    public SignificantStringTerms create(List<Bucket> buckets) {
        return new SignificantStringTerms(this.subsetSize, this.supersetSize, this.name, this.requiredSize, this.minDocCount, this.significanceHeuristic, buckets, this.pipelineAggregators(), this.metaData);
    }

    @Override
    public Bucket createBucket(InternalAggregations aggregations, Bucket prototype) {
        return new Bucket(prototype.termBytes, prototype.subsetDf, prototype.subsetSize, prototype.supersetDf, prototype.supersetSize, aggregations);
    }

    @Override
    protected SignificantStringTerms create(long subsetSize, long supersetSize, List<InternalSignificantTerms.Bucket> buckets, InternalSignificantTerms prototype) {
        return new SignificantStringTerms(subsetSize, supersetSize, prototype.getName(), prototype.requiredSize, prototype.minDocCount, prototype.significanceHeuristic, buckets, prototype.pipelineAggregators(), prototype.getMetaData());
    }

    @Override
    protected void doReadFrom(StreamInput in) throws IOException {
        this.requiredSize = SignificantStringTerms.readSize(in);
        this.minDocCount = in.readVLong();
        this.subsetSize = in.readVLong();
        this.supersetSize = in.readVLong();
        this.significanceHeuristic = SignificanceHeuristicStreams.read(in);
        int size = in.readVInt();
        ArrayList<Bucket> buckets = new ArrayList<Bucket>(size);
        for (int i = 0; i < size; ++i) {
            Bucket bucket = new Bucket(this.subsetSize, this.supersetSize);
            bucket.readFrom(in);
            buckets.add(bucket);
        }
        this.buckets = buckets;
        this.bucketMap = null;
    }

    @Override
    protected void doWriteTo(StreamOutput out) throws IOException {
        SignificantStringTerms.writeSize(this.requiredSize, out);
        out.writeVLong(this.minDocCount);
        out.writeVLong(this.subsetSize);
        out.writeVLong(this.supersetSize);
        this.significanceHeuristic.writeTo(out);
        out.writeVInt(this.buckets.size());
        for (InternalSignificantTerms.Bucket bucket : this.buckets) {
            bucket.writeTo(out);
        }
    }

    @Override
    public XContentBuilder doXContentBody(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.field("doc_count", this.subsetSize);
        builder.startArray(InternalAggregation.CommonFields.BUCKETS);
        for (InternalSignificantTerms.Bucket bucket : this.buckets) {
            if (bucket.subsetDf < this.minDocCount) continue;
            bucket.toXContent(builder, params);
        }
        builder.endArray();
        return builder;
    }

    public static class Bucket
    extends InternalSignificantTerms.Bucket {
        BytesRef termBytes;

        public Bucket(long subsetSize, long supersetSize) {
            super(subsetSize, supersetSize);
        }

        public Bucket(BytesRef term, long subsetDf, long subsetSize, long supersetDf, long supersetSize, InternalAggregations aggregations) {
            super(subsetDf, subsetSize, supersetDf, supersetSize, aggregations);
            this.termBytes = term;
        }

        public Bucket(BytesRef term, long subsetDf, long subsetSize, long supersetDf, long supersetSize, InternalAggregations aggregations, double score) {
            this(term, subsetDf, subsetSize, supersetDf, supersetSize, aggregations);
            this.score = score;
        }

        @Override
        public Number getKeyAsNumber() {
            return Double.parseDouble(this.termBytes.utf8ToString());
        }

        @Override
        int compareTerm(SignificantTerms.Bucket other) {
            return BytesRef.getUTF8SortedAsUnicodeComparator().compare(this.termBytes, ((Bucket)other).termBytes);
        }

        @Override
        public String getKeyAsString() {
            return this.termBytes.utf8ToString();
        }

        @Override
        public String getKey() {
            return this.getKeyAsString();
        }

        @Override
        Bucket newBucket(long subsetDf, long subsetSize, long supersetDf, long supersetSize, InternalAggregations aggregations) {
            return new Bucket(this.termBytes, subsetDf, subsetSize, supersetDf, supersetSize, aggregations);
        }

        @Override
        public void readFrom(StreamInput in) throws IOException {
            this.termBytes = in.readBytesRef();
            this.subsetDf = in.readVLong();
            this.supersetDf = in.readVLong();
            this.score = in.readDouble();
            this.aggregations = InternalAggregations.readAggregations(in);
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            out.writeBytesRef(this.termBytes);
            out.writeVLong(this.subsetDf);
            out.writeVLong(this.supersetDf);
            out.writeDouble(this.getSignificanceScore());
            this.aggregations.writeTo(out);
        }

        @Override
        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startObject();
            builder.utf8Field(InternalAggregation.CommonFields.KEY, this.termBytes);
            builder.field(InternalAggregation.CommonFields.DOC_COUNT, this.getDocCount());
            builder.field("score", this.score);
            builder.field("bg_count", this.supersetDf);
            this.aggregations.toXContentInternal(builder, params);
            builder.endObject();
            return builder;
        }
    }
}

