/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.aggregations.bucket.range.geodistance;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.search.aggregations.AggregationStreams;
import org.elasticsearch.search.aggregations.InternalAggregation;
import org.elasticsearch.search.aggregations.InternalAggregations;
import org.elasticsearch.search.aggregations.bucket.BucketStreamContext;
import org.elasticsearch.search.aggregations.bucket.BucketStreams;
import org.elasticsearch.search.aggregations.bucket.range.InternalRange;
import org.elasticsearch.search.aggregations.pipeline.PipelineAggregator;
import org.elasticsearch.search.aggregations.support.format.ValueFormatter;

public class InternalGeoDistance
extends InternalRange<Bucket, InternalGeoDistance> {
    public static final InternalAggregation.Type TYPE = new InternalAggregation.Type("geo_distance", "gdist");
    public static final AggregationStreams.Stream STREAM = new AggregationStreams.Stream(){

        @Override
        public InternalGeoDistance readResult(StreamInput in) throws IOException {
            InternalGeoDistance geoDistance = new InternalGeoDistance();
            geoDistance.readFrom(in);
            return geoDistance;
        }
    };
    private static final BucketStreams.Stream<Bucket> BUCKET_STREAM = new BucketStreams.Stream<Bucket>(){

        @Override
        public Bucket readResult(StreamInput in, BucketStreamContext context) throws IOException {
            Bucket buckets = new Bucket(context.keyed(), context.formatter());
            buckets.readFrom(in);
            return buckets;
        }

        @Override
        public BucketStreamContext getBucketStreamContext(Bucket bucket) {
            BucketStreamContext context = new BucketStreamContext();
            context.formatter(bucket.formatter());
            context.keyed(bucket.keyed());
            return context;
        }
    };
    public static final Factory FACTORY = new Factory();

    public static void registerStream() {
        AggregationStreams.registerStream(STREAM, TYPE.stream());
        BucketStreams.registerStream(BUCKET_STREAM, TYPE.stream());
    }

    InternalGeoDistance() {
    }

    public InternalGeoDistance(String name, List<Bucket> ranges, ValueFormatter formatter, boolean keyed, List<PipelineAggregator> pipelineAggregators, Map<String, Object> metaData) {
        super(name, ranges, formatter, keyed, pipelineAggregators, metaData);
    }

    @Override
    public InternalAggregation.Type type() {
        return TYPE;
    }

    @Override
    public InternalRange.Factory<Bucket, InternalGeoDistance> getFactory() {
        return FACTORY;
    }

    public static class Factory
    extends InternalRange.Factory<Bucket, InternalGeoDistance> {
        @Override
        public String type() {
            return TYPE.name();
        }

        @Override
        public InternalGeoDistance create(String name, List<Bucket> ranges, ValueFormatter formatter, boolean keyed, List<PipelineAggregator> pipelineAggregators, Map<String, Object> metaData) {
            return new InternalGeoDistance(name, ranges, formatter, keyed, pipelineAggregators, metaData);
        }

        @Override
        public InternalGeoDistance create(List<Bucket> ranges, InternalGeoDistance prototype) {
            return new InternalGeoDistance(prototype.name, ranges, prototype.formatter, prototype.keyed, prototype.pipelineAggregators(), (Map<String, Object>)prototype.metaData);
        }

        @Override
        public Bucket createBucket(String key, double from, double to, long docCount, InternalAggregations aggregations, boolean keyed, ValueFormatter formatter) {
            return new Bucket(key, from, to, docCount, aggregations, keyed, formatter);
        }

        @Override
        public Bucket createBucket(InternalAggregations aggregations, Bucket prototype) {
            return new Bucket(prototype.getKey(), ((Number)prototype.getFrom()).doubleValue(), ((Number)prototype.getTo()).doubleValue(), prototype.getDocCount(), aggregations, prototype.getKeyed(), prototype.getFormatter());
        }
    }

    static class Bucket
    extends InternalRange.Bucket {
        Bucket(boolean keyed, ValueFormatter formatter) {
            super(keyed, formatter);
        }

        Bucket(String key, double from, double to, long docCount, List<InternalAggregation> aggregations, boolean keyed, ValueFormatter formatter) {
            this(key, from, to, docCount, new InternalAggregations(aggregations), keyed, formatter);
        }

        Bucket(String key, double from, double to, long docCount, InternalAggregations aggregations, boolean keyed, ValueFormatter formatter) {
            super(key, from, to, docCount, aggregations, keyed, formatter);
        }

        protected InternalRange.Factory<Bucket, ?> getFactory() {
            return FACTORY;
        }

        boolean keyed() {
            return this.keyed;
        }

        ValueFormatter formatter() {
            return this.formatter;
        }
    }
}

