/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.aggregations.bucket;

import com.google.common.collect.ImmutableMap;
import java.io.IOException;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.collect.MapBuilder;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.search.aggregations.bucket.BucketStreamContext;
import org.elasticsearch.search.aggregations.bucket.MultiBucketsAggregation;

public class BucketStreams {
    private static ImmutableMap<BytesReference, Stream> STREAMS = ImmutableMap.of();

    public static synchronized void registerStream(Stream stream, BytesReference ... types) {
        MapBuilder<BytesReference, Stream> uStreams = MapBuilder.newMapBuilder(STREAMS);
        for (BytesReference type : types) {
            uStreams.put(type, stream);
        }
        STREAMS = uStreams.immutableMap();
    }

    public static Stream stream(BytesReference type) {
        return STREAMS.get(type);
    }

    public static interface Stream<B extends MultiBucketsAggregation.Bucket> {
        public B readResult(StreamInput var1, BucketStreamContext var2) throws IOException;

        public BucketStreamContext getBucketStreamContext(B var1);
    }
}

