/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.indices.analysis;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.util.concurrent.UncheckedExecutionException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Locale;
import java.util.Map;
import org.apache.lucene.analysis.hunspell.Dictionary;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.common.component.AbstractComponent;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.io.FileSystemUtils;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.env.Environment;

public class HunspellService
extends AbstractComponent {
    public static final String HUNSPELL_LAZY_LOAD = "indices.analysis.hunspell.dictionary.lazy";
    public static final String HUNSPELL_IGNORE_CASE = "indices.analysis.hunspell.dictionary.ignore_case";
    private static final String OLD_HUNSPELL_LOCATION = "indices.analysis.hunspell.dictionary.location";
    private final LoadingCache<String, Dictionary> dictionaries;
    private final Map<String, Dictionary> knownDictionaries;
    private final boolean defaultIgnoreCase;
    private final Path hunspellDir;

    public HunspellService(Settings settings, Environment env) throws IOException {
        this(settings, env, Collections.emptyMap());
    }

    @Inject
    public HunspellService(final Settings settings, final Environment env, final Map<String, Dictionary> knownDictionaries) throws IOException {
        super(settings);
        this.knownDictionaries = knownDictionaries;
        this.hunspellDir = this.resolveHunspellDirectory(settings, env);
        this.defaultIgnoreCase = settings.getAsBoolean(HUNSPELL_IGNORE_CASE, (Boolean)false);
        this.dictionaries = CacheBuilder.newBuilder().build(new CacheLoader<String, Dictionary>(){

            @Override
            public Dictionary load(String locale) throws Exception {
                Dictionary dictionary = (Dictionary)knownDictionaries.get(locale);
                if (dictionary == null) {
                    dictionary = HunspellService.this.loadDictionary(locale, settings, env);
                }
                return dictionary;
            }
        });
        if (!settings.getAsBoolean(HUNSPELL_LAZY_LOAD, (Boolean)false).booleanValue()) {
            this.scanAndLoadDictionaries();
        }
    }

    public Dictionary getDictionary(String locale) {
        return this.dictionaries.getUnchecked(locale);
    }

    private Path resolveHunspellDirectory(Settings settings, Environment env) {
        String location = settings.get(OLD_HUNSPELL_LOCATION, null);
        if (location != null) {
            throw new IllegalArgumentException("please, put your hunspell dictionaries under config/hunspell !");
        }
        return env.configFile().resolve("hunspell");
    }

    private void scanAndLoadDictionaries() throws IOException {
        if (Files.isDirectory(this.hunspellDir, new LinkOption[0])) {
            try (DirectoryStream<Path> stream = Files.newDirectoryStream(this.hunspellDir);){
                for (Path file : stream) {
                    if (!Files.isDirectory(file, new LinkOption[0])) continue;
                    DirectoryStream<Path> inner = Files.newDirectoryStream(this.hunspellDir.resolve(file), "*.dic");
                    Throwable throwable = null;
                    try {
                        if (!inner.iterator().hasNext()) continue;
                        try {
                            this.dictionaries.getUnchecked(file.getFileName().toString());
                        }
                        catch (UncheckedExecutionException e) {
                            this.logger.error("exception while loading dictionary {}", file.getFileName(), e);
                        }
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        if (inner == null) continue;
                        if (throwable != null) {
                            try {
                                inner.close();
                            }
                            catch (Throwable x2) {
                                throwable.addSuppressed(x2);
                            }
                            continue;
                        }
                        inner.close();
                    }
                }
            }
        }
    }

    private Dictionary loadDictionary(String locale, Settings nodeSettings, Environment env) throws Exception {
        Path dicDir;
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Loading hunspell dictionary [{}]...", locale);
        }
        if (!FileSystemUtils.isAccessibleDirectory(dicDir = this.hunspellDir.resolve(locale), this.logger)) {
            throw new ElasticsearchException(String.format(Locale.ROOT, "Could not find hunspell dictionary [%s]", locale), new Object[0]);
        }
        nodeSettings = HunspellService.loadDictionarySettings(dicDir, nodeSettings.getByPrefix("indices.analysis.hunspell.dictionary." + locale + "."));
        boolean ignoreCase = nodeSettings.getAsBoolean("ignore_case", (Boolean)this.defaultIgnoreCase);
        Path[] affixFiles = FileSystemUtils.files(dicDir, "*.aff");
        if (affixFiles.length == 0) {
            throw new ElasticsearchException(String.format(Locale.ROOT, "Missing affix file for hunspell dictionary [%s]", locale), new Object[0]);
        }
        if (affixFiles.length != 1) {
            throw new ElasticsearchException(String.format(Locale.ROOT, "Too many affix files exist for hunspell dictionary [%s]", locale), new Object[0]);
        }
        InputStream affixStream = null;
        Path[] dicFiles = FileSystemUtils.files(dicDir, "*.dic");
        ArrayList<InputStream> dicStreams = new ArrayList<InputStream>(dicFiles.length);
        try {
            for (int i = 0; i < dicFiles.length; ++i) {
                dicStreams.add(Files.newInputStream(dicFiles[i], new OpenOption[0]));
            }
            affixStream = Files.newInputStream(affixFiles[0], new OpenOption[0]);
            Dictionary i = new Dictionary(affixStream, dicStreams, ignoreCase);
            return i;
        }
        catch (Exception e) {
            this.logger.error("Could not load hunspell dictionary [{}]", e, locale);
            throw e;
        }
        finally {
            if (affixStream != null) {
                try {
                    affixStream.close();
                }
                catch (IOException iOException) {}
            }
            for (InputStream in : dicStreams) {
                if (in == null) continue;
                try {
                    in.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    private static Settings loadDictionarySettings(Path dir, Settings defaults) {
        Path file = dir.resolve("settings.yml");
        if (Files.exists(file, new LinkOption[0])) {
            return Settings.settingsBuilder().loadFromPath(file).put(defaults).build();
        }
        file = dir.resolve("settings.json");
        if (Files.exists(file, new LinkOption[0])) {
            return Settings.settingsBuilder().loadFromPath(file).put(defaults).build();
        }
        return defaults;
    }
}

