/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.translog;

import java.io.Closeable;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.FileChannel;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.lucene.codecs.CodecUtil;
import org.apache.lucene.index.CorruptIndexException;
import org.apache.lucene.index.IndexFormatTooNewException;
import org.apache.lucene.index.IndexFormatTooOldException;
import org.apache.lucene.store.AlreadyClosedException;
import org.apache.lucene.store.InputStreamDataInput;
import org.apache.lucene.util.BytesRef;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.common.io.stream.ByteBufferStreamInput;
import org.elasticsearch.common.io.stream.InputStreamStreamInput;
import org.elasticsearch.index.translog.BufferedChecksumStreamInput;
import org.elasticsearch.index.translog.ChannelReference;
import org.elasticsearch.index.translog.Checkpoint;
import org.elasticsearch.index.translog.ImmutableTranslogReader;
import org.elasticsearch.index.translog.LegacyTranslogReader;
import org.elasticsearch.index.translog.LegacyTranslogReaderBase;
import org.elasticsearch.index.translog.Translog;
import org.elasticsearch.index.translog.TranslogCorruptedException;

public abstract class TranslogReader
implements Closeable,
Comparable<TranslogReader> {
    public static final int UNKNOWN_OP_COUNT = -1;
    private static final byte LUCENE_CODEC_HEADER_BYTE = 63;
    private static final byte UNVERSIONED_TRANSLOG_HEADER_BYTE = 0;
    protected final long generation;
    protected final ChannelReference channelReference;
    protected final FileChannel channel;
    protected final AtomicBoolean closed = new AtomicBoolean(false);
    protected final long firstOperationOffset;

    public TranslogReader(long generation, ChannelReference channelReference, long firstOperationOffset) {
        this.generation = generation;
        this.channelReference = channelReference;
        this.channel = channelReference.getChannel();
        this.firstOperationOffset = firstOperationOffset;
    }

    public long getGeneration() {
        return this.generation;
    }

    public abstract long sizeInBytes();

    public abstract int totalOperations();

    public final long getFirstOperationOffset() {
        return this.firstOperationOffset;
    }

    public Translog.Operation read(Translog.Location location) throws IOException {
        assert (location.generation == this.generation) : "read location's translog generation [" + location.generation + "] is not [" + this.generation + "]";
        ByteBuffer buffer = ByteBuffer.allocate(location.size);
        try (BufferedChecksumStreamInput checksumStreamInput = this.checksummedStream(buffer, location.translogLocation, location.size, null);){
            Translog.Operation operation = this.read(checksumStreamInput);
            return operation;
        }
    }

    private final int readSize(ByteBuffer reusableBuffer, long position) {
        assert (reusableBuffer.capacity() >= 4) : "reusable buffer must have capacity >=4 when reading opSize. got [" + reusableBuffer.capacity() + "]";
        try {
            reusableBuffer.clear();
            reusableBuffer.limit(4);
            this.readBytes(reusableBuffer, position);
            reusableBuffer.flip();
            int size = reusableBuffer.getInt() + 4;
            long maxSize = this.sizeInBytes() - position;
            if (size < 0 || (long)size > maxSize) {
                throw new TranslogCorruptedException("operation size is corrupted must be [0.." + maxSize + "] but was: " + size);
            }
            return size;
        }
        catch (IOException e) {
            throw new ElasticsearchException("unexpected exception reading from translog snapshot of " + this.channelReference.getPath(), (Throwable)e, new Object[0]);
        }
    }

    public Translog.Snapshot newSnapshot() {
        ByteBuffer reusableBuffer = ByteBuffer.allocate(1024);
        int totalOperations = this.totalOperations();
        this.channelReference.incRef();
        return this.newReaderSnapshot(totalOperations, reusableBuffer);
    }

    private final BufferedChecksumStreamInput checksummedStream(ByteBuffer reusableBuffer, long position, int opSize, BufferedChecksumStreamInput reuse) throws IOException {
        ByteBuffer buffer = reusableBuffer.capacity() >= opSize ? reusableBuffer : ByteBuffer.allocate(opSize);
        buffer.clear();
        buffer.limit(opSize);
        this.readBytes(buffer, position);
        buffer.flip();
        return new BufferedChecksumStreamInput(new ByteBufferStreamInput(buffer), reuse);
    }

    protected Translog.Operation read(BufferedChecksumStreamInput inStream) throws IOException {
        return Translog.readOperation(inStream);
    }

    protected abstract void readBytes(ByteBuffer var1, long var2) throws IOException;

    @Override
    public final void close() throws IOException {
        if (this.closed.compareAndSet(false, true)) {
            this.channelReference.decRef();
        }
    }

    protected final boolean isClosed() {
        return this.closed.get();
    }

    protected void ensureOpen() {
        if (this.isClosed()) {
            throw new AlreadyClosedException("translog [" + this.getGeneration() + "] is already closed");
        }
    }

    public String toString() {
        return "translog [" + this.generation + "][" + this.channelReference.getPath() + "]";
    }

    @Override
    public int compareTo(TranslogReader o) {
        return Long.compare(this.getGeneration(), o.getGeneration());
    }

    public static ImmutableTranslogReader open(ChannelReference channelReference, Checkpoint checkpoint, String translogUUID) throws IOException {
        FileChannel channel = channelReference.getChannel();
        Path path = channelReference.getPath();
        assert (channelReference.getGeneration() == checkpoint.generation) : "expected generation: " + channelReference.getGeneration() + " but got: " + checkpoint.generation;
        try {
            if (checkpoint.offset == 0L && checkpoint.numOps == -1) {
                return new LegacyTranslogReader(channelReference.getGeneration(), channelReference, 0L);
            }
            InputStreamStreamInput headerStream = new InputStreamStreamInput(Channels.newInputStream(channel));
            byte b1 = headerStream.readByte();
            if (b1 == 63) {
                byte b4;
                byte b3;
                byte b2 = headerStream.readByte();
                int header = ((b1 & 0xFF) << 24) + ((b2 & 0xFF) << 16) + (((b3 = headerStream.readByte()) & 0xFF) << 8) + (((b4 = headerStream.readByte()) & 0xFF) << 0);
                if (header != 1071082519) {
                    throw new TranslogCorruptedException("translog looks like version 1 or later, but has corrupted header");
                }
                int version = CodecUtil.checkHeaderNoMagic(new InputStreamDataInput(headerStream), "translog", 1, Integer.MAX_VALUE);
                switch (version) {
                    case 1: {
                        assert (checkpoint.numOps == -1) : "expected unknown op count but got: " + checkpoint.numOps;
                        assert (checkpoint.offset == Files.size(path)) : "offset(" + checkpoint.offset + ") != file_size(" + Files.size(path) + ") for: " + path;
                        return new LegacyTranslogReaderBase(channelReference.getGeneration(), channelReference, CodecUtil.headerLength("translog"), checkpoint.offset);
                    }
                    case 2: {
                        assert (path.getFileName().toString().endsWith(".tlog")) : "new file ends with old suffix: " + path;
                        assert (checkpoint.numOps > -1) : "expected at least 0 operatin but got: " + checkpoint.numOps;
                        assert (checkpoint.offset <= channel.size()) : "checkpoint is inconsistent with channel length: " + channel.size() + " " + checkpoint;
                        int len = headerStream.readInt();
                        if ((long)len > channel.size()) {
                            throw new TranslogCorruptedException("uuid length can't be larger than the translog");
                        }
                        BytesRef ref = new BytesRef(len);
                        ref.length = len;
                        headerStream.read(ref.bytes, ref.offset, ref.length);
                        BytesRef uuidBytes = new BytesRef(translogUUID);
                        if (!uuidBytes.bytesEquals(ref)) {
                            throw new TranslogCorruptedException("expected shard UUID [" + uuidBytes + "] but got: [" + ref + "] this translog file belongs to a different translog");
                        }
                        return new ImmutableTranslogReader(channelReference.getGeneration(), channelReference, ref.length + CodecUtil.headerLength("translog") + 4, checkpoint.offset, checkpoint.numOps);
                    }
                }
                throw new TranslogCorruptedException("No known translog stream version: " + version + " path:" + path);
            }
            if (b1 == 0) {
                assert (checkpoint.numOps == -1) : "expected unknown op count but got: " + checkpoint.numOps;
                assert (checkpoint.offset == Files.size(path)) : "offset(" + checkpoint.offset + ") != file_size(" + Files.size(path) + ") for: " + path;
                return new LegacyTranslogReader(channelReference.getGeneration(), channelReference, checkpoint.offset);
            }
            throw new TranslogCorruptedException("Invalid first byte in translog file, got: " + Long.toHexString(b1) + ", expected 0x00 or 0x3f");
        }
        catch (CorruptIndexException | IndexFormatTooNewException | IndexFormatTooOldException e) {
            throw new TranslogCorruptedException("Translog header corrupted", e);
        }
    }

    public Path path() {
        return this.channelReference.getPath();
    }

    protected Translog.Snapshot newReaderSnapshot(int totalOperations, ByteBuffer reusableBuffer) {
        return new ReaderSnapshot(totalOperations, reusableBuffer);
    }

    class ReaderSnapshot
    implements Translog.Snapshot {
        private final AtomicBoolean closed;
        private final int totalOperations;
        private final ByteBuffer reusableBuffer;
        long position;
        int readOperations;
        private BufferedChecksumStreamInput reuse;

        public ReaderSnapshot(int totalOperations, ByteBuffer reusableBuffer) {
            this.totalOperations = totalOperations;
            this.reusableBuffer = reusableBuffer;
            this.closed = new AtomicBoolean(false);
            this.position = TranslogReader.this.firstOperationOffset;
            this.readOperations = 0;
            this.reuse = null;
        }

        @Override
        public final int estimatedTotalOperations() {
            return this.totalOperations;
        }

        @Override
        public Translog.Operation next() throws IOException {
            if (this.readOperations < this.totalOperations) {
                assert (this.readOperations < this.totalOperations) : "readOpeartions must be less than totalOperations";
                return this.readOperation();
            }
            return null;
        }

        protected final Translog.Operation readOperation() throws IOException {
            int opSize = TranslogReader.this.readSize(this.reusableBuffer, this.position);
            this.reuse = TranslogReader.this.checksummedStream(this.reusableBuffer, this.position, opSize, this.reuse);
            Translog.Operation op = TranslogReader.this.read(this.reuse);
            this.position += (long)opSize;
            ++this.readOperations;
            return op;
        }

        @Override
        public void close() {
            if (this.closed.compareAndSet(false, true)) {
                TranslogReader.this.channelReference.decRef();
            }
        }
    }
}

