/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.query;

import java.io.IOException;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.util.BytesRef;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.index.mapper.DocumentMapper;
import org.elasticsearch.index.query.QueryParseContext;
import org.elasticsearch.index.query.QueryParser;
import org.elasticsearch.index.query.QueryParsingException;

public class TypeQueryParser
implements QueryParser {
    public static final String NAME = "type";

    @Inject
    public TypeQueryParser() {
    }

    @Override
    public String[] names() {
        return new String[]{NAME};
    }

    @Override
    public Query parse(QueryParseContext parseContext) throws IOException, QueryParsingException {
        XContentParser parser = parseContext.parser();
        XContentParser.Token token = parser.nextToken();
        if (token != XContentParser.Token.FIELD_NAME) {
            throw new QueryParsingException(parseContext, "[type] filter should have a value field, and the type name", new Object[0]);
        }
        String fieldName = parser.currentName();
        if (!fieldName.equals("value")) {
            throw new QueryParsingException(parseContext, "[type] filter should have a value field, and the type name", new Object[0]);
        }
        token = parser.nextToken();
        if (token != XContentParser.Token.VALUE_STRING) {
            throw new QueryParsingException(parseContext, "[type] filter should have a value field, and the type name", new Object[0]);
        }
        BytesRef type = parser.utf8Bytes();
        parser.nextToken();
        DocumentMapper documentMapper = parseContext.mapperService().documentMapper(type.utf8ToString());
        Query filter = documentMapper == null ? new TermQuery(new Term("_type", type)) : documentMapper.typeFilter();
        return filter;
    }
}

