/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.mapper.internal;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.apache.lucene.document.BinaryDocValuesField;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.FieldType;
import org.apache.lucene.index.IndexOptions;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.index.Term;
import org.apache.lucene.util.BytesRef;
import org.elasticsearch.Version;
import org.elasticsearch.common.lucene.Lucene;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.index.fielddata.FieldDataType;
import org.elasticsearch.index.mapper.MappedFieldType;
import org.elasticsearch.index.mapper.Mapper;
import org.elasticsearch.index.mapper.MapperParsingException;
import org.elasticsearch.index.mapper.MetadataFieldMapper;
import org.elasticsearch.index.mapper.ParseContext;
import org.elasticsearch.index.mapper.Uid;
import org.elasticsearch.index.mapper.core.TypeParsers;

public class UidFieldMapper
extends MetadataFieldMapper {
    public static final String NAME = "_uid";
    public static final String CONTENT_TYPE = "_uid";

    private UidFieldMapper(Settings indexSettings, MappedFieldType existing) {
        this(existing == null ? Defaults.FIELD_TYPE.clone() : existing, Defaults.FIELD_TYPE, indexSettings);
    }

    private UidFieldMapper(MappedFieldType fieldType, MappedFieldType defaultFieldType, Settings indexSettings) {
        super("_uid", fieldType, defaultFieldType, indexSettings);
    }

    @Override
    public void preParse(ParseContext context) throws IOException {
        if (context.sourceToParse().id() != null) {
            context.id(context.sourceToParse().id());
            super.parse(context);
        }
    }

    @Override
    public void postParse(ParseContext context) throws IOException {
        if (context.id() == null && !context.sourceToParse().flyweight()) {
            throw new MapperParsingException("No id found while parsing the content source");
        }
        if (context.sourceToParse().id() == null) {
            super.parse(context);
            if (context.docs().size() > 1) {
                IndexableField uidField = context.rootDoc().getField("_uid");
                assert (uidField != null);
                for (int i = 1; i < context.docs().size(); ++i) {
                    ParseContext.Document doc = context.docs().get(i);
                    doc.add(new Field("_uid", uidField.stringValue(), (FieldType)Defaults.NESTED_FIELD_TYPE));
                }
            }
        }
    }

    @Override
    public Mapper parse(ParseContext context) throws IOException {
        return null;
    }

    @Override
    protected void parseCreateField(ParseContext context, List<Field> fields) throws IOException {
        Field uid = new Field("_uid", Uid.createUid(context.stringBuilder(), context.type(), context.id()), (FieldType)Defaults.FIELD_TYPE);
        context.uid(uid);
        fields.add(uid);
        if (this.fieldType().hasDocValues()) {
            fields.add(new BinaryDocValuesField("_uid", new BytesRef(uid.stringValue())));
        }
    }

    public Term term(String uid) {
        return new Term(this.fieldType().names().indexName(), this.fieldType().indexedValueForSearch(uid));
    }

    @Override
    protected String contentType() {
        return "_uid";
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        if (!this.indexCreatedBefore2x) {
            return builder;
        }
        boolean includeDefaults = params.paramAsBoolean("include_defaults", false);
        if (!includeDefaults && !this.hasCustomFieldDataSettings()) {
            return builder;
        }
        builder.startObject("_uid");
        if (includeDefaults || this.hasCustomFieldDataSettings()) {
            builder.field("fielddata", this.fieldType().fieldDataType().getSettings().getAsMap());
        }
        builder.endObject();
        return builder;
    }

    @Override
    protected void doMerge(Mapper mergeWith, boolean updateAllTypes) {
    }

    static final class UidFieldType
    extends MappedFieldType {
        public UidFieldType() {
            this.setFieldDataType(new FieldDataType("string"));
        }

        protected UidFieldType(UidFieldType ref) {
            super(ref);
        }

        @Override
        public MappedFieldType clone() {
            return new UidFieldType(this);
        }

        @Override
        public String typeName() {
            return "_uid";
        }

        @Override
        public Uid value(Object value) {
            if (value == null) {
                return null;
            }
            return Uid.createUid(value.toString());
        }
    }

    public static class TypeParser
    implements MetadataFieldMapper.TypeParser {
        @Override
        public MetadataFieldMapper.Builder<?, ?> parse(String name, Map<String, Object> node, Mapper.TypeParser.ParserContext parserContext) throws MapperParsingException {
            if (parserContext.indexVersionCreated().onOrAfter(Version.V_2_0_0_beta1)) {
                throw new MapperParsingException("_uid is not configurable");
            }
            Builder builder = new Builder(parserContext.mapperService().fullName("_uid"));
            TypeParsers.parseField(builder, builder.name, node, parserContext);
            return builder;
        }

        @Override
        public MetadataFieldMapper getDefault(Settings indexSettings, MappedFieldType fieldType, String typeName) {
            return new UidFieldMapper(indexSettings, fieldType);
        }
    }

    public static class Builder
    extends MetadataFieldMapper.Builder<Builder, UidFieldMapper> {
        public Builder(MappedFieldType existing) {
            super("_uid", existing == null ? Defaults.FIELD_TYPE : existing, Defaults.FIELD_TYPE);
            this.indexName = "_uid";
        }

        @Override
        public UidFieldMapper build(Mapper.BuilderContext context) {
            this.setupFieldType(context);
            this.fieldType.setHasDocValues(context.indexCreatedVersion().before(Version.V_2_0_0_beta1));
            return new UidFieldMapper(this.fieldType, this.defaultFieldType, context.indexSettings());
        }
    }

    public static class Defaults {
        public static final String NAME = "_uid";
        public static final MappedFieldType FIELD_TYPE = new UidFieldType();
        public static final MappedFieldType NESTED_FIELD_TYPE;

        static {
            FIELD_TYPE.setIndexOptions(IndexOptions.DOCS);
            FIELD_TYPE.setTokenized(false);
            FIELD_TYPE.setStored(true);
            FIELD_TYPE.setOmitNorms(true);
            FIELD_TYPE.setIndexAnalyzer(Lucene.KEYWORD_ANALYZER);
            FIELD_TYPE.setSearchAnalyzer(Lucene.KEYWORD_ANALYZER);
            FIELD_TYPE.setNames(new MappedFieldType.Names("_uid"));
            FIELD_TYPE.freeze();
            NESTED_FIELD_TYPE = FIELD_TYPE.clone();
            NESTED_FIELD_TYPE.setStored(false);
            NESTED_FIELD_TYPE.freeze();
        }
    }
}

