/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.codec;

import org.apache.lucene.codecs.Codec;
import org.apache.lucene.codecs.PostingsFormat;
import org.apache.lucene.codecs.lucene50.Lucene50StoredFieldsFormat;
import org.apache.lucene.codecs.lucene54.Lucene54Codec;
import org.elasticsearch.common.logging.ESLogger;
import org.elasticsearch.index.mapper.MappedFieldType;
import org.elasticsearch.index.mapper.MapperService;
import org.elasticsearch.index.mapper.core.CompletionFieldMapper;

public class PerFieldMappingPostingFormatCodec
extends Lucene54Codec {
    private final ESLogger logger;
    private final MapperService mapperService;
    static final /* synthetic */ boolean $assertionsDisabled;

    public PerFieldMappingPostingFormatCodec(Lucene50StoredFieldsFormat.Mode compressionMode, MapperService mapperService, ESLogger logger) {
        super(compressionMode);
        this.mapperService = mapperService;
        this.logger = logger;
    }

    @Override
    public PostingsFormat getPostingsFormatForField(String field) {
        MappedFieldType indexName = this.mapperService.indexName(field);
        if (indexName == null) {
            this.logger.warn("no index mapper found for field: [{}] returning default postings format", field);
        } else if (indexName instanceof CompletionFieldMapper.CompletionFieldType) {
            CompletionFieldMapper.CompletionFieldType fieldType = (CompletionFieldMapper.CompletionFieldType)indexName;
            PostingsFormat defaultFormat = super.getPostingsFormatForField(field);
            return fieldType.postingsFormat(defaultFormat);
        }
        return super.getPostingsFormatForField(field);
    }

    static {
        boolean bl = $assertionsDisabled = !PerFieldMappingPostingFormatCodec.class.desiredAssertionStatus();
        if (!$assertionsDisabled && !Codec.forName("Lucene54").getClass().isAssignableFrom(PerFieldMappingPostingFormatCodec.class)) {
            throw new AssertionError((Object)"PerFieldMappingPostingFormatCodec must subclass the latest lucene codec: Lucene54");
        }
    }
}

