/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.analysis;

import com.carrotsearch.hppc.IntObjectHashMap;
import com.google.common.collect.Maps;
import java.io.IOException;
import java.util.Map;
import org.elasticsearch.common.joda.FormatDateTimeFormatter;
import org.elasticsearch.index.analysis.AnalyzerScope;
import org.elasticsearch.index.analysis.NamedAnalyzer;
import org.elasticsearch.index.analysis.NumericAnalyzer;
import org.elasticsearch.index.analysis.NumericDateTokenizer;
import org.joda.time.format.DateTimeFormatter;

public class NumericDateAnalyzer
extends NumericAnalyzer<NumericDateTokenizer> {
    private static final Map<String, IntObjectHashMap<NamedAnalyzer>> globalAnalyzers = Maps.newHashMap();
    private final int precisionStep;
    private final DateTimeFormatter dateTimeFormatter;

    public static synchronized NamedAnalyzer buildNamedAnalyzer(FormatDateTimeFormatter formatter, int precisionStep) {
        NamedAnalyzer namedAnalyzer;
        IntObjectHashMap<NamedAnalyzer> precisionMap = globalAnalyzers.get(formatter.format());
        if (precisionMap == null) {
            precisionMap = new IntObjectHashMap();
            globalAnalyzers.put(formatter.format(), precisionMap);
        }
        if ((namedAnalyzer = precisionMap.get(precisionStep)) == null) {
            String name = "_date/" + (precisionStep == Integer.MAX_VALUE ? "max" : Integer.valueOf(precisionStep));
            namedAnalyzer = new NamedAnalyzer(name, AnalyzerScope.GLOBAL, new NumericDateAnalyzer(precisionStep, formatter.parser()));
            precisionMap.put(precisionStep, namedAnalyzer);
        }
        return namedAnalyzer;
    }

    public NumericDateAnalyzer(int precisionStep, DateTimeFormatter dateTimeFormatter) {
        this.precisionStep = precisionStep;
        this.dateTimeFormatter = dateTimeFormatter;
    }

    @Override
    protected NumericDateTokenizer createNumericTokenizer(char[] buffer) throws IOException {
        return new NumericDateTokenizer(this.precisionStep, buffer, this.dateTimeFormatter);
    }
}

